<div class="x_panel">
  <div class="x_title"><h2>{{ mt._('_common.edit') }} {{ catalog.cdcata }} - {{ catalog.dscata }}</h2><div class="clearfix"></div></div>
  <div class="x_content">
    <form class="form-horizontal form-label-left" >
      <!-- Catalog Header -->
      <div class="row">
        <div class="form-group col-md-3" style="line-height:34px">
          <label for="input-code" class="control-label col-md-4 col-sm-4 col-xs-12 text-right p-0">{{ mt._('_common.code') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12">
            <input type="text" disabled id="input-code" name="input-code" class="form-control" maxlength="10" size="10" value="{{ catalog.cdcata }}">
          </div>
        </div>
        <div class="form-group col-md-5" style="line-height:34px">
          <label for="input-description" class="control-label col-md-3 col-sm-3 col-xs-12 text-right p-0">{{ mt._('_common.description') }}</label>
          <div class="col-md-9 col-sm-9 col-xs-12">
            <input type="text" id="input-description" name="input-description" class="form-control" maxlength="40" size="40" value="{{ catalog.dscata }}">
          </div>
        </div>
        <div class="form-group col-md-4" style="line-height:34px">
          <label for="input-seqrap" class="control-label col-md-4 col-sm-4 col-xs-12 text-right p-0">{{ mt._('admin.seqrap') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12">
            <input type="text" id="input-seqrap" name="input-seqrap" class="form-control" maxlength="6" size="6" value="{{ catalog.seqrap }}">
          </div>
        </div>
      </div>
      <div class="row spacer"></div>
      <div class="row">
        <div class="form-group col-md-3" style="line-height:34px">
          <label for="validity" class="control-label col-md-4 col-sm-4 col-xs-12 text-right p-0">{{ mt._('_common.validity') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12">
            <fieldset>
              <div class="control-group">
                <div class="controls">
                  <div class="input-prepend input-group">
                    <span class="add-on input-group-addon"><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></span>
                    <input type="text" style="width:197px" name="validity" id="validity"
                      class="form-control" value="{{ date('d/m/Y', strtotime(catalog.dtiniz)) }} - {{ date('d/m/Y', strtotime(catalog.dtfine)) }}" />
                  </div>
                </div>
              </div>
            </fieldset>
          </div>
        </div>
        <div class="form-group col-md-5" style="line-height:34px">
          <label for="input-description" class="control-label col-md-3 col-sm-3 col-xs-12 text-right p-0">{{ mt._('_common.seasons') }}</label>
          <div class="col-md-6 col-sm-6 col-xs-12 form-element form-select">
            <select class="form-control" id="select-cdstag">
              <option value="" {{ catalog.cdstag == '' ? 'selected' : '' }}></option>
            {% if seasons|length > 0 %}
              {% for season in seasons %}
              <option value="{{ season.cdstag }}" {{ catalog.cdstag == season.cdstag ? 'selected' : '' }}>{{ season.dsstag }}</option>
              {% endfor %}
            {% endif %}
            </select>
          </div>
        </div>
        <div class="form-group col-md-4" style="line-height:34px">
          <label for="input-description" class="control-label col-md-4 col-sm-4 col-xs-12 text-right p-0">{{ mt._('_common.type') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12 form-element form-select">
            <select class="form-control" id="select-fltipo">
              <option value="0" {{ catalog.fltipo == 0 ? 'selected' : '' }}>{{ mt._('order.type.0') }}</option>
              <option value="1" {{ catalog.fltipo == 1 ? 'selected' : '' }}>{{ mt._('order.type.1') }}</option>
              <option value="2" {{ catalog.fltipo == 2 ? 'selected' : '' }}>{{ mt._('order.type.2') }}</option>
            </select>
          </div>
        </div>
      </div>
      <div class="row spacer"></div>
      {% if enableCustomFamily %}
      <div class="row">
        <div class="form-group col-md-7" style="line-height:34px">
          <label for="input-description" class="control-label col-md-3 col-sm-3 col-xs-12 text-right p-0">{{ mt._('admin.customfamily.groups') }}</label>
          <div class="col-md-6 col-sm-6 col-xs-12 form-element form-select">
            <select class="form-control" id="select-cdregv">
              <option value="" {{ catalog.cdregv == 0 ? 'selected' : '' }}></option>
            {% if familyGroups is defined and familyGroups|length > 0 %}
              {% for group in familyGroups %}
              <option value="{{ group.cdregv }}" {{ group.cdregv == catalog.cdregv ? 'selected' : '' }}>{{ group.dsregv }}</option>
              {% endfor %}
            {% endif %}
            </select>
          </div>
        </div>
      </div>
      <div class="row spacer"></div>
      {% endif %}

      <div class="row catalog-buttons">
        <!-- Load articles -->
        <div class="fl" style="width:15%;padding:0 12px">
          <button type="button" class="btn btn-default w-100" id="btn-load-articles" data-toggle="modal" data-target=".modal-load-articles">
            {{ mt._('admin.catalog.loadarticles') }}
          </button>
        </div>
        <!-- Load models -->
        <div class="fl" style="width:15%;padding:0 12px">
          <button type="button" class="btn btn-default w-100" id="btn-load-models" data-toggle="modal" data-target=".modal-load-models">
            {{ mt._('admin.catalog.loadmodels') }}
          </button>
        </div>
        <!-- Load lines -->
        <div class="fl" style="width:15%;padding:0 12px">
          <button type="button" class="btn btn-default w-100" id="btn-load-lines" data-toggle="modal" data-target=".modal-load-lines">
            {{ mt._('admin.catalog.loadlines') }}
          </button>
        </div>
        <!-- Load seasons -->
        <div class="fl" style="width:15%;padding:0 12px">
          <button type="button" class="btn btn-default w-100" id="btn-load-seasons" data-toggle="modal" data-target=".modal-load-seasons">
            {{ mt._('admin.catalog.loadseasons') }}
          </button>
        </div>

        <!-- Assign images -->
        <div class="fl" style="width:20%;padding:0 12px">
          <button type="button" class="btn btn-success w-100" id="btn-reassign-images">
            {{ mt._('admin.catalog.assignimageautore') }}
          </button>
        </div>
        <div class="fl" style="width:20%;padding:0 12px">
          <button type="button" class="btn btn-success w-100" id="btn-assign-images">
            {{ mt._('admin.catalog.assignimageauto') }}
          </button>
        </div>
      </div>

      <!-- Save -->
      <div class="row catalog-buttons">
        {% if syncImageType == 1 %}
        <div class="col-md-2 fl mt-30x">
          <button type="button" class="btn btn-success btn-download-img-xls w-100">{{ mt._('_common.download.xls.img') }}</button>
        </div>
        <div class="col-md-2 fl mt-30x">
          <button type="button" class="btn btn-success btn-upload-img-xls w-100" data-toggle="modal" data-target=".modal-img-xls-upload">{{ mt._('_common.load.xls.img') }}</button>
        </div>
        {% endif %}
        <div class="col-md-2 fr mt-30x">
          <button type="button" class="btn btn-primary btn-save w-100">{{ mt._('_common.save') }}</button>
        </div>
        {% if enableSorting %}
        <div class="col-md-2 fr mt-30x">
          <a href="{{ url('gomanagement/catalogSorting/' ~ catalog.cdcata)}}" class="btn btn-primary w-100">{{ mt._('_common.sorting') }}</a>
        </div>
        {% endif %}
      </div>
      <div class="row catalog-buttons">
        <div class="col-md-12">
          <div class="msg-error">{{ mt._('_common.update.error') }}</div>
          <div class="msg-success">{{ mt._('_common.update.success') }}</div>
        </div>
      </div>
      <div class='loader text-center' style="display:none">{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
    </form>
  </div>
</div>

<!-- Articles -->
<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('_common.articles') }}</h2>
    <div class="clearfix"></div>
  </div>
  <div class="x_content">
    <table id="datatable-articles" class="table table-striped table-bordered nowrap" cellspacing="0" width="100%">
      <thead>
        <tr class="text-capitalize">
          <th>{{ mt._('_common.type') }}</th>
          <th>{{ mt._('statistics.group.brandlineserie') }}</th>
          <th>{{ mt._('_common.code.model') }}</th>
          <th>{{ mt._('_common.description') }}</th>
          <th>{{ mt._('_common.notes') }}</th>
          <th>{{ mt._('_common.variations') }}</th>
          <th>{{ mt._('_common.image') }}</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        {{ mainTableHtml }}
      </tbody>
    </table>
    <div class='loader' id="catalog-articles-content-loader text-center" style="display:none">
      {{ image("assets/img/loading.gif", "alt": "Preloader") }}
    </div>
    <div class="spacer"></div>
    <div class="row catalog-buttons">
      <div class="col-md-6">
        <a href="{{ url('gomanagement/catalogManager') }}" type="button" class="btn btn-default left-btn">{{ mt._('_common.close') }}</a>
      </div>
      <div class="col-md-6">
        <button type="button" class="btn btn-primary btn-save right-btn mr-0">{{ mt._('_common.save') }}</button>
      </div>
    </div>
    <div class="row catalog-buttons">
      <div class="col-md-12">
        <div class="msg-error">{{ mt._('_common.update.error') }}</div>
        <div class="msg-success">{{ mt._('_common.update.success') }}</div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for load articles -->
<div class="modal fade modal-load-articles" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-80">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.catalog.loadarticles') }}</h4>
        <div class="modal-close" data-dismiss="modal" id="close-update-table1">
          {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
        </div>
      </div>
      <div class="modal-body">
        <div class="row">
          <label class="control-label col-md-4 col-sm-4 col-xs-12 text-right pt-10x" style="width:35%">{{ mt._('admin.analysis.selectseason') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12" style="width:35%">
            <select id="select-modal-art-seasoncode" class="select2_single form-control" tabindex="-1">
              <option></option>
            {% if seasons|length > 0 %}
              {% for season in seasons %}
              <option value="{{ season.cdstag }}">{{ season.cdstag }} - {{ season.dsstag }}</option>
              {% endfor %}
            {% endif %}
            </select>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 add-to-catalog-container text-right">
            <button type="button" class="btn btn-primary add-to-catalog" data-mode="1">{{ mt._('admin.catalog.add') }}</button>
            <div class='loader'>{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
          </div>
        </div>
        <div class='loader center' id="table-articles-loader" style="display:none">{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
        <table id='table-loadarticles'></table>
      </div>
      <div class="modal-footer add-to-catalog-container text-right">
        <button type="button" class="btn btn-primary add-to-catalog" data-mode="1">{{ mt._('admin.catalog.add') }}</button>
        <div class='loader'>{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for load models -->
<div class="modal fade modal-load-models" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-80">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.catalog.loadmodels') }}</h4>
        <div class="modal-close" data-dismiss="modal" id="close-update-table2">
          {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
        </div>
      </div>
      <div class="modal-body">
        <div class="row">
          <label class="control-label col-md-4 col-sm-4 col-xs-12 text-right pt-10x" style="width:35%">{{ mt._('admin.analysis.selectseason') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12" style="width:35%">
            <select id="select-modal-mod-seasoncode" class="select2_single form-control" tabindex="-1">
              <option></option>
            {% if seasons|length > 0 %}
              {% for season in seasons %}
              <option value="{{ season.cdstag }}">{{ season.cdstag }} - {{ season.dsstag }}</option>
              {% endfor %}
            {% endif %}
            </select>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 add-to-catalog-container text-right">
            <button type="button" class="btn btn-primary add-to-catalog" data-mode="2">{{ mt._('admin.catalog.add') }}</button>
            <div class='loader'>{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
          </div>
        </div>
        <div class='loader center' id="table-models-loader" style="display:none">{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
        <table id='table-loadmodels'></table>
      </div>
      <div class="modal-footer add-to-catalog-container text-right">
        <button type="button" class="btn btn-primary add-to-catalog" data-mode="2">{{ mt._('admin.catalog.add') }}</button>
        <div class='loader'>{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for load lines -->
<div class="modal fade modal-load-lines" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-80">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.catalog.loadlines') }}</h4>
        <div class="modal-close" data-dismiss="modal" id="close-update-table3">
          {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
        </div>
      </div>
      <div class="modal-body">
        <div class="row">
          <label class="control-label col-md-4 col-sm-4 col-xs-12 text-right pt-10x" style="width:35%">{{ mt._('admin.analysis.selectseason') }}</label>
          <div class="col-md-8 col-sm-8 col-xs-12" style="width:35%">
            <select id="select-modal-lin-seasoncode" class="select2_single form-control" tabindex="-1">
              <option></option>
            {% if seasons|length > 0 %}
              {% for season in seasons %}
              <option value="{{ season.cdstag }}">{{ season.cdstag }} - {{ season.dsstag }}</option>
              {% endfor %}
            {% endif %}
            </select>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 add-to-catalog-container text-right">
            <button type="button" class="btn btn-primary add-to-catalog" data-mode="3">{{ mt._('admin.catalog.add') }}</button>
            <div class='loader'>{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
          </div>
        </div>
        <div class='loader center' id="table-lines-loader" style="display:none">{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
        <table id='table-loadlines'></table>
      </div>
      <div class="modal-footer add-to-catalog-container text-right">
        <button type="button" class="btn btn-primary add-to-catalog" data-mode="3">{{ mt._('admin.catalog.add') }}</button>
        <div class='loader'>{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for load seasons -->
<div class="modal fade modal-load-seasons" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-80">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.catalog.loadseasons') }}</h4>
        <div class="modal-close" data-dismiss="modal" id="close-update-table4">
          {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
        </div>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12 add-to-catalog-container text-right">
            <button type="button" class="btn btn-primary add-to-catalog" data-mode="4">{{ mt._('admin.catalog.add') }}</button>
            <div class='loader'>{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
          </div>
        </div>
        <div class='loader center' id="table-seasons-loader" style="display:none">{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
        <table id='table-loadseasons'></table>
      </div>
      <div class="modal-footer add-to-catalog-container text-right">
        <button type="button" class="btn btn-primary add-to-catalog" data-mode="4">{{ mt._('admin.catalog.add') }}</button>
        <div class='loader'>{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete article from catalog -->
<div class="modal fade modal-article" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.catalog.delete.article') }}</h4>
        <div class="modal-close" data-dismiss="modal">
          {{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
        </div>
      </div>
      <div class="modal-body">
        <div class="py-10x">{{ mt._('admin.catalog.delete.article.conf') }}</div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn delete-from-catalog w-50">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete model from catalog -->
<div class="modal fade modal-model" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.catalog.delete.model') }}</h4>
      </div>
      <div class="modal-body"><p>{{ mt._('admin.catalog.delete.model.conf') }}</p></div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn" style="width:70%" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn delete-from-catalog" style="width:70%">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete series from catalog -->
<div class="modal fade modal-series" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.catalog.delete.series') }}</h4>
      </div>
      <div class="modal-body"><p>{{ mt._('admin.catalog.delete.series.conf') }}</p></div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn" style="width:70%" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn delete-from-catalog" style="width:70%">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for edit series from catalog -->
<div class="modal fade modal-series-edit" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" style="width:80%">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.catalog.img.series') }} <span id="code-serm" data-codic2=""></span></h4>
      </div>
      <div class="modal-body">
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn" style="width:70%" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn save-img-series" style="width:70%">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete line from catalog -->
<div class="modal fade modal-line" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.catalog.delete.line') }}</h4>
      </div>
      <div class="modal-body"><p>{{ mt._('admin.catalog.delete.line.conf') }}</p></div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn" style="width:70%" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn delete-from-catalog" style="width:70%">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for edit line from catalog -->
<div class="modal fade modal-line-edit" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" style="width:80%">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.catalog.img.line') }} <span id="code-linm"></span></h4>
      </div>
      <div class="modal-body">
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6"><button type="button" class="btn btn-default left-btn" style="width:70%" data-dismiss="modal">{{ mt._('_common.close') }}</button></div>
          <div class="col-md-6"><button type="button" class="btn btn-primary right-btn save-img-line" style="width:70%">{{ mt._('_common.save') }}</button></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete brand from catalog -->
<div class="modal fade modal-brand" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.catalog.delete.brand') }}</h4>
      </div>
      <div class="modal-body"><p>{{ mt._('admin.catalog.delete.brand.conf') }}</p></div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn" style="width:70%" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn delete-from-catalog" style="width:70%">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for edit brand from catalog -->
<div class="modal fade modal-brand-edit" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" style="width:80%">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.catalog.img.brand') }} <span id="code-titl"></span></h4>
      </div>
      <div class="modal-body">
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn" style="width:70%" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn save-img-brand" style="width:70%">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for edit model -->
<div class="modal fade modal-edit-model" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" style="width:80%">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close close-modal-edit" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" id="modal-title-edit-model"></h4>
      </div>
      <input type="hidden" value="" id="edit-cdartn" />
      <input type="hidden" value="" id="position-cdartn" />
      <div class="modal-body">
        <div class="modal-edit-model-section">
          <div class="x_title">
            <h5>{{ mt._('admin.catalog.img.models') }}</h5>
            <i class="fa fa-caret-down modal-section-opener" data-target=".images-section"></i>
          </div>
          <div class="x_content images-section" style="display:none">
            <div class="row">
              <div class="col-md-3">
                <div class="col-md-12">{{ mt._('admin.catalog.img.preview') }}</div>
                <div class="col-md-12">
                  <form action="{{ url('admin/uploadImage') }}" class="dropzone" id="dropzone-default-img"
                    style="width:160px;min-height:160px"></form>
                </div>
              </div>
              <div class="col-md-9">
                <div class="col-md-12">{{ mt._('admin.catalog.img.gallery') }}</div>
                <div class="col-md-12">
                  <form action="{{ url('admin/uploadImage') }}" class="dropzone" id="dropzone-gallery-img"
                    style="min-height:160px"></form>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-edit-model-section">
          <div class="x_title">
            <h5 style="text-transform:capitalize">{{ mt._('_common.notes') }}</h5>
            <i class="fa fa-caret-down modal-section-opener" data-target=".notes-section"></i>
          </div>
          <div class="x_content notes-section" style="display:none">
            <div class="row lang">
              <div class="col-md-1">{{ mt._('_common.info.comm') }}</div>
              <div class="col-md-5"><span style="float:left;width:8%">It </span><span style="float:left;width:92%"><input type="text" id="comm-it" name="comm-it" class="form-control"></span></div>
              <div class="col-md-1">{{ mt._('_common.info.tecn') }}</div>
              <div class="col-md-5"><span style="float:left;width:8%">It </span><span style="float:left;width:92%"><input type="text" id="tecn-it" name="tecn-it" class="form-control"></span></div>
            </div>
            <div class="row lang">
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">En </span><span style="float:left;width:92%"><input type="text" id="comm-en" name="comm-en" class="form-control"></span></div>
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">En </span><span style="float:left;width:92%"><input type="text" id="tecn-en" name="tecn-en" class="form-control"></span></div>
            </div>
            <div class="row lang">
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">Fr </span><span style="float:left;width:92%"><input type="text" id="comm-fr" name="comm-fr" class="form-control"></span></div>
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">Fr </span><span style="float:left;width:92%"><input type="text" id="tecn-fr" name="tecn-fr" class="form-control"></span></div>
            </div>
            <div class="row lang">
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">De </span><span style="float:left;width:92%"><input type="text" id="comm-de" name="comm-de" class="form-control"></span></div>
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">De </span><span style="float:left;width:92%"><input type="text" id="tecn-de" name="tecn-de" class="form-control"></span></div>
            </div>
            <div class="row lang">
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">Es </span><span style="float:left;width:92%"><input type="text" id="comm-es" name="comm-es" class="form-control"></span></div>
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">Es </span><span style="float:left;width:92%"><input type="text" id="tecn-es" name="tecn-es" class="form-control"></span></div>
            </div>
          </div>
        </div>
        <div class="modal-edit-model-section">
          <div class="x_title">
            <h5>{{ mt._('_common.variations') }}</h5>
            <i class="fa fa-caret-down modal-section-opener" data-target=".variants-section"></i>
          </div>
          <div class="x_content variants-section" style="display:none">
            <div class="row" style="border-bottom:1px solid #e6e9ed;padding:10px 0">
              <div class="col-md-3">{{ mt._("_common.code.article") }}</div>
              <div class="col-md-5">{{ mt._("_common.description.article") }}</div>
              <div class="col-md-4">{{ mt._("_common.image") }}</div>
            </div>
            <div id='table-modal-edit-model'>

            </div>
          </div>
        </div>
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn close-modal-edit" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn" {# data-dismiss="modal" #} id="edit-model">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="msg-error">{{ mt._('_common.update.error') }}</div>
            <div class="msg-success">{{ mt._('_common.update.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for edit article -->
<div class="modal fade modal-edit-article" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" style="width:80%">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close close-modal-edit-article" data-dismiss="modal" aria-label="{{ mt._('_common.close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title" id="modal-title-edit-article"></h4>
      </div>
      <input type="hidden" value="" id="edit-cdarti" />
      <input type="hidden" value="" id="position-cdarti" />
      <div class="modal-body">
        <div class="modal-edit-article-section">
          <div class="x_title">
            <h5>{{ mt._('admin.catalog.img.article') }}</h5>
            <i class="fa fa-caret-down modal-section-opener" data-target=".images-section"></i>
          </div>
          <div class="x_content images-section" style="display:none">
            <div class="row">
              <div class="col-md-3">
                <div class="col-md-12">{{ mt._('admin.catalog.img.preview') }}</div>
                <div class="col-md-12">
                  <form action="{{ url('admin/uploadImage') }}" class="dropzone" id="dropzone-default-arti-img"
                    style="width:160px;min-height:160px"></form>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-edit-article-section">
          <div class="x_title">
            <h5 style="text-transform:capitalize">{{ mt._('_common.notes') }}</h5>
            <i class="fa fa-caret-down modal-section-opener" data-target=".notes-section"></i>
          </div>
          <div class="x_content notes-section" style="display:none">
            <div class="row lang">
              <div class="col-md-1">{{ mt._('_common.info.comm') }}</div>
              <div class="col-md-5"><span style="float:left;width:8%">It </span><span style="float:left;width:92%"><input type="text" id="comm-arti-it" name="comm-arti-it" class="form-control"></span></div>
              <div class="col-md-1">{{ mt._('_common.info.tecn') }}</div>
              <div class="col-md-5"><span style="float:left;width:8%">It </span><span style="float:left;width:92%"><input type="text" id="tecn-arti-it" name="tecn-arti-it" class="form-control"></span></div>
            </div>
            <div class="row lang">
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">En </span><span style="float:left;width:92%"><input type="text" id="comm-arti-en" name="comm-arti-en" class="form-control"></span></div>
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">En </span><span style="float:left;width:92%"><input type="text" id="tecn-arti-en" name="tecn-arti-en" class="form-control"></span></div>
            </div>
            <div class="row lang">
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">Fr </span><span style="float:left;width:92%"><input type="text" id="comm-arti-fr" name="comm-arti-fr" class="form-control"></span></div>
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">Fr </span><span style="float:left;width:92%"><input type="text" id="tecn-arti-fr" name="tecn-arti-fr" class="form-control"></span></div>
            </div>
            <div class="row lang">
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">De </span><span style="float:left;width:92%"><input type="text" id="comm-arti-de" name="comm-arti-de" class="form-control"></span></div>
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">De </span><span style="float:left;width:92%"><input type="text" id="tecn-arti-de" name="tecn-arti-de" class="form-control"></span></div>
            </div>
            <div class="row lang">
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">Es </span><span style="float:left;width:92%"><input type="text" id="comm-arti-es" name="comm-arti-es" class="form-control"></span></div>
              <div class="col-md-1"> </div>
              <div class="col-md-5"><span style="float:left;width:8%">Es </span><span style="float:left;width:92%"><input type="text" id="tecn-arti-es" name="tecn-arti-es" class="form-control"></span></div>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn close-modal-edit-article" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn" {# data-dismiss="modal" #} id="edit-article">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="msg-error">{{ mt._('_common.update.error') }}</div>
            <div class="msg-success">{{ mt._('_common.update.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for upload img xls -->
<div class="modal fade modal-img-xls-upload px-0" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px">
  <div class="modal-dialog modal-sm" style="width:40%">
    <div class="modal-content" >
      <div class="modal-header">
        <h4 class="xls-order-title">{{ mt._('_common.template.upload') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body modal-body-xls-order">
        <div class="row xls-upload-info">
          <div class="col-md-12" style="font-size:13px">
            <form action="{{ url('excel/uploadImageXlsTemplate') }}" method="post" enctype="multipart/form-data" id="load-xls-template">
              <input type="file" name="file" id="xls_file">
            </form>
          </div>
        </div>
      </div>

      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary left-btn w-50" id="xls-load">{{ mt._('_common.upload') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
