<div class="x_panel">
	<div class="x_title">
		<h2>{{ mt._('_common.brand') }}</h2>
		<div class="clearfix"></div>
	</div>

	<div class="x_content">
		<div class="row">
      <div class="col-sm-6 col-md-6 col-xs-6">
				<button type="button" class="btn btn-primary waves-effect waves-light left-btn" data-toggle='modal' data-target='#modal-insert-brand'>
					{{ mt._('admin.brands.new') }}
				</button>
			</div>
		</div>

		<div class="row py-10x">
			<div class="col-sm-12 col-md-12 col-xs-12">
			{% if brands|length > 0 %}
				<table id="table-brands" class="table table-striped table-bordered">
					<thead>
						<tr>
							<th>{{ mt._('_common.code') }}</th>
							<th>{{ mt._('_common.description') }}</th>
							<th>{{ mt._('admin.seqrap') }}</th>
							<th></th>
						</tr>
					</thead>
					<tbody>
					{% for brand in brands %}
						<tr data-cdtitl="{{ brand.cdtitl }}" data-dstitl="{{ brand.dstitl }}" data-seqrap="{{ brand.seqrap }}">
							<td>{{ brand.cdtitl }}</td>
							<td>{{ brand.dstitl }}</td>
							<td>{{ brand.seqrap }}</td>
							<td class="center" style="vertical-align:middle">
								<a href="#" class="open-edit-brand" title="{{ mt._('admin.brands.edit') }}"
									data-toggle='modal' data-target='#modal-edit-brand'>
									<span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
								</a>
								<a href="#" class="open-delete-brand pl-10x" title="{{ mt._('admin.brands.delete') }}"
									data-toggle='modal' data-target='#modal-delete-brand'>
									<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
								</a>
							</td>
						</tr>
					{% endfor %}
					</tbody>
				</table>
			{% else %}
			{{ mt._('admin.brands.no') }}
			{% endif %}
			</div>
		</div>
	</div>
</div>

<!-- Modal for insert brand -->
<div id="modal-insert-brand" class="modal fade" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.brands.new') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<div class="msg-error"></div>
				<div class="py-10x">
					<label for="cdtitl" class="control-label">{{ mt._('_common.code.brand') }}</label>
					<input type="text" id="cdtitl" name="cdtitl" maxlength="4" class="form-control" title="{{ mt._('_common.code') }}">
				</div>
				<div class="py-10x">
					<label for="dstitl" class="control-label">{{ mt._('_common.description') }}</label>
					<input type="text" id="dstitl" name="dstitl" class="form-control" title="{{ mt._('_common.description') }}">
				</div>
				<div class="py-10x">
					<label for="seqrap" class="control-label">{{ mt._('admin.seqrap') }}</label>
					<input type="number" id="seqrap" name="seqrap" class="form-control" value="0" min="0" title="{{ mt._('admin.seqrap') }}">
				</div>
			</div>

			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="insert-brand" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal for edit brand -->
<div id="modal-edit-brand" class="modal fade" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.brands.edit') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body px-20x">
				<input type="hidden" id="edit-cdtitl">
				<div class="py-10x">
					<label for="edit-dstitl" class="control-label">{{ mt._('_common.description') }}</label>
					<input type="text" id="edit-dstitl" name="dstitl" class="form-control" title="{{ mt._('_common.description') }}">
				</div>
				<div class="py-10x">
					<label for="seqrap" class="control-label">{{ mt._('admin.seqrap') }}</label>
					<input type="number" id="edit-seqrap" name="seqrap" class="form-control" min="0" title="{{ mt._('admin.seqrap') }}">
				</div>
			</div>

			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="edit-brand" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.save') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal for delete brand -->
<div class="modal fade" id="modal-delete-brand" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ mt._('admin.brands.delete') }}</h4>
				<div class="modal-close" data-dismiss="modal">
					{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}
				</div>
			</div>
			<div class="modal-body">
				<input type="hidden" id="delete-cdtitl">
				<div class="py-10x">{{ mt._('admin.brands.warning') }}</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button type="button" class="btn btn-default left-btn" data-dismiss="modal">{{ mt._('_common.close') }}</button>
					</div>
					<div class="col-md-6 col-sm-6 col-xs-6">
						<button id="delete-brand" type="button" class="btn btn-primary right-btn capitalize">{{ mt._('_common.confirm') }}</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
