{% set totProducts = 0 %}
{% for product in products %}
    {% if not common['isOrder'] or common['order_info'].tpordc != 0 or common['shownotavailable'] == 1 or product.is_available %}
        {% set totProducts = totProducts + 1 %}
    {% endif %}
{% endfor %}

<div id="visual-mode">
    <div class="models-block">
        <div class="row">
            <div id="results-counter" class="col-8 col-lg-4 title-model-block"
                    {{ common['navbarBgColor'] is not empty ? 'style="background-color:' ~ common['navbarBgColor'] ~ ';"' : '' }}>
                {{ totProducts }} {{ totProducts == 1 ? mt._('_common.searchresult') : mt._('_common.searchresults') }}
            </div>
        </div>

        <div class="row articles-container">

            {% set i = 12 %}
            {% for product in products %}
                {% if not common['isOrder'] or common['order_info'].tpordc != 0 or common['shownotavailable'] == 1 or product.is_available %}

                    {# SET PRICE #}
                    {% set currentPrice = '' %}
                    {#    {% set cust_disc = 0 %} #}
                    {% set cust_disc = baseDiscount %}
                    {% if common['showCatalogPrice'] == 1 %}
                        {% set withDiscount = false %}
                        {% set currentPrice = product.catalogPrice %}
                        {% if currentPrice < 0 %}
                            {% set currentPrice = mt._('quantity.priceforsize.short') %}

                        {% elseif currentPrice == 0 %}
                            {% set currentPrice = '-' %}
                        {% else %}
                            {% set real_price = currentPrice %}
                            {#        {% set cust_disc = product.cust_disc > 0 ? product.cust_disc : 0 %} #}
                            {% set cust_disc = product.cust_disc > 0 ? product.cust_disc : baseDiscount %}
                            {% set cust_disc = product.art_cust_disc > 0 ? product.art_cust_disc : cust_disc %}
                            {% set disc_price = real_price * (1 - cust_disc / 100) %}
                            {% set withDiscount = disc_price != real_price %}
                            {% set currentPrice = disc_price|currency ~ ' ' ~ common['currency'] %}
                        {% endif %}
                    {% endif %}

                    {# SET IMAGES #}

                    {# {% set imgurl1 = "img/model/"  ~ product.flimag %} #}
                    {% set imgurl1 = utility.getImageModelLink(product.flimag, ['w': '350']) %}
                    {# {% set imgurl2 = "img/model/"  ~ product.flimg2 %} #}
                    {% set imgurl2 = utility.getImageModelLink(product.flimg2, ['w': '350']) %}

                    <?php $exist1 = $product->flimag != ''; ?>
                    <?php $exist2 = $product->flimg2 != ''; ?>
                    {% if not exist1 %}{% set imgurl1 = "/assets/img/default_model.jpg" %}{% endif %}

                    {% if common['catalogProductType'] == 0 %}
                        {% set productCode = product.cdartn %}
                        {% set productDes = product.dsartn %}
                        {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
                            {% set detailUrl = url('model/' ~ product.cdartn) %}
                        {% else %}
                            {% set detailUrl = url('model/wizard/' ~ product.cdartn) %}
                        {% endif %}
                    {% elseif common['catalogProductType'] == 1 %}
                        {% set productCode = product.cdarti %}
                        {% set productDes = product.dsarti %}
                        {% set detailUrl = url('model/' ~ product.cdarti) %}
                    {% elseif common['catalogProductType'] == 2 %}
                        {% set productCode = product.cdarti ~ ' ' ~ product.color %}
                        {% set productDes = product.dsarti %}
                        {% set detailUrl = url('model/' ~ product.cdarti ~ '?COL=' ~ product.color) %}
                    {% endif %}

                    {% set lg = 'col-lg-3' %}
                    {% if common['ItemsPerRow'] == 1 %}
                        {% set lg = 'col-lg-4' %}
                    {% elseif common['ItemsPerRow'] == 2 %}
                        {% set lg = 'col-lg-6' %}
                    {% endif %}

                    {# Samuele - Visto che non c'è la barra di default su questa pagina forza gli articoli a 4 su una riga #}
                    {% set lg = 'col-lg-3' %}

                    <div class="col-12 col-md-8 {{ lg }} model-box" id="{{ productCode }}"
                         data-code="{{ productCode }}" data-price="{{ currentPrice }}"
                         data-descr="{{ productDes }}">

                        <div class='shop-item'>
                            <div class='image-model-box shop-thumbnail'>
                                {# {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
              {% set detailUrl = url('model/' ~ (common['catalogProductType'] == 0 ? product.cdartn : product.cdarti)) %}
            {% else %}
              {% set detailUrl = url('model/wizard/' ~ product.cdartn) %}
            {% endif %} #}
                                <a href="{{ detailUrl }}" class='no-deco'>
                                    {% if i > 0 %}
                                <img class='lazy' src='../assets/img/blank.gif' data-src='{{ imgurl1 }}'
                                     alt="{{ productDes }}"
                                        {% if exist2 %}
                                    onmouseover="this.src='{{ imgurl2 }}';"
                                    onmouseout="this.src='{{ imgurl1 }}';"
                                        {% endif %}/>
                                    <noscript>
                                        {% endif %}
                                        <img src='{{ imgurl1 }}' alt="{{ productDes }}"
                                                {% if exist2 %}
                                            onmouseover="this.src='{{ imgurl2 }}';"
                                            onmouseout="this.src='{{ imgurl1 }}';"
                                                {% endif %}/>
                                        {% if i > 0 %}
                                    </noscript>
                                    {% endif %}
                                </a>

                                {# getPriceDiv ne stampagia gia uno di questi quindi l'ho spostato solo nell'altra condizione #}
                                {#                                {% if cust_disc > 0 %} #}
                                {#                                    <span class='product-ribbon product-ribbon-right product-ribbon--style-1 text-uppercase'> #}
                                {#                                        {{ cust_disc }}% #}
                                {#                                    </span> #}
                                {#                                {% endif %} #}


                                <div class='shop-item-tools'>
                                    <div class="w-50 float-left text-right">
                                        {# {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
                  {% set detailUrl = url('model/' ~ (common['catalogProductType'] == 0 ? product.cdartn : product.cdarti)) %}
                {% else %}
                  {% set detailUrl = url('model/wizard/' ~ product.cdartn) %}
                {% endif %} #}
                                        {# <a href="{{ detailUrl }}" class="btn-product-sheet">
                  <span>{{ mt._('_common.seemore') }}</span>
                  {{ image("assets/img/product-sheet.jpg", "alt": mt._('_common.productsheet')) }}
                </a> #}
                                    </div>
                                    {% if (common['modelDetailStyle'] == 1 or common['modelDetailStyle'] == 6 or common['modelDetailStyle'] == 8) and common['isOrder'] %}
                                        <div class='w-50 float-left text-left'>
                                            <a href='#' class='d-none d-md-block btn-quick-shop'>
                                                {{ image("assets/img/quick-shop.jpg", "alt": mt._('_common.buy')) }}
                                                <span>{{ mt._('_common.buy') }}</span>
                                            </a>
                                        </div>
                                    {% endif %}
                                </div>
                            </div>

                            <div class='descr-model-box'>{{ productDes }}</div>
                            <div class='code-model-box'>
                                {{ product.hasAvailabilityFlag is defined and product.hasAvailabilityFlag > 0 ? '<span class="model-code {{ elements.getHighlightClass() }}">': '' }}
                                {{ productCode }}
                                {{ product.hasAvailabilityFlag is defined and product.hasAvailabilityFlag > 0 ? '</span>' : '' }}
                            </div>
                            {% if common['showCatalogPrice'] == 1 %}
                                {% if common['modelDetailStyle'] != 3 or not common['isOrder'] %}
                                    {{ elements.getPriceDiv(product.catalogPrice, cust_disc, common['currency'], common['cdvalu'], "center", detailUrl, product.cdartn) }}
                                {% else %}
                                    {% if cust_disc > 0 %}
                                        <span class='product-ribbon product-ribbon-right product-ribbon--style-1 text-uppercase'>
                                            {{ cust_disc }}%
                                        </span>
                                    {% endif %}
                                    {{ elements.getPriceDivWithRetail(product.catalogPrice, common['order_info'].nulist, product.retailPrice, common['order_info'].rulist, cust_disc) }}
                                {% endif %}
                            {% endif %}

                            {% if common['isOrder'] and common['order_info'].tpordc == 0 %}
                                <div class='availability-model-box text-center'>
                                    {{ not product.is_available ? mt._('_common.notavailable') : "&nbsp;" }}
                                </div>
                            {% endif %}

                        </div>
                    </div>
                {% endif %}

                {% set i = i - 1 %}

            {% endfor %}
        </div>

    </div>
</div>
