<div class="quickBuyModal" x-cloak x-show="open" x-transition.opacity @click="closeModal">
    <div class="quickBuyModal__inner" @click.stop>
        <div class="quickBuyModal__header">
            <button @click="closeModal()" class="quickBuyModal__close"><i class="fa fa-times"></i></button>
            <div class="d-flex align-items-center">
                <div class="col-2">
                    <img :src="selectedModel?.flimag" :alt="selectedModel?.cdartn">
                </div>
                <div class="flex-grow-1">
                    <div>
                        {{ mt._('listing.model') }}: <strong x-text="selectedModel?.cdartn"></strong>
                    </div>
                    <template x-if="visualizationType === '1'">
                        <ul class="d-flex sizes-bar">
                            <template x-for="size in selectedModel?.articles[0]?.sizes">
                                <template x-if="isSizeVisible(size)">
                                    <li class="d-flex flex-column text-center">
                                        <span x-text="size.taglia"></span>
                                        <input type="number" x-model="bulkValues[size.taglia]" min="0"
                                               @input="handleBulkInput(size.taglia)">
                                    </li>
                                </template>
                            </template>
                        </ul>
                        <div>
                            <p>{{ mt._('listing.insertBulk') }}</p>
                        </div>
                    </template>
                </div>
                <template x-if="visualizationType === '1'">
                    <div>
                        <button class="btn btn-link" type="button" @click="applyBulkValues">
                            {{ mt._('listing.apply') }}
                        </button>
                    </div>
                </template>
            </div>
        </div>

        <div class="quickBuyModal__content">
            <template x-if="visualizationType === '1'">
                <template x-for="child in selectedModel?.articles">
                    <div x-data="article(child)">
                        <div class="d-flex align-items-center">
                            <div class="col-2 d-flex flex-column inner-img">
                                <img :src="article.flimag" :alt="article.cdartn">
                            </div>
                            <div class="flex-grow-1">
                                <div class="d-flex mb-2">
                                    <span x-text="article.dscolo" class="m-2"></span>
                                    <strong x-text="article.cdcolo" class="m-2"></strong>
                                </div>
                                <ul class="d-flex sizes-bar text-center">
                                    <template :key="`${article.cdcolo}-${articleSize.taglia}`"
                                              x-for="articleSize in article.sizes">
                                        <template x-if="isSizeVisible(articleSize)">
                                            <li x-data="size(articleSize)"
                                                class="d-flex flex-column">
                                                <span x-text="size.taglia"></span>
                                                <input :id="`size-${size.taglia}-${article.cdcolo}`" @keydown.space.prevent="fillNext" x-bind:disabled="size.flbloc !== 0 || (orderType === '0' && !size.available) || !!article.orderWithoutQuantity"
                                                       type="number" x-model="size.quantity" @input="handleInput">
                                                <template x-if="orderType === '0'">
                                                    <input type="number" x-model="size.availability" class="p-0-15x mt-2 text-center" readonly x-bind:disabled="size.flbloc !== 0 || (orderType === '0' && !size.available) || !!article.orderWithoutQuantity"
                                                           type="number" x-model="size.quantity" tabindex="-1">
                                                </template>
                                                <!-- TODO decidere se dobbiamo controllare il parametro per mostrare il parametro invece del numero -->
                                                <template x-if="onSale">
                                                    <del><span x-text="getPrice()"></span></del>
                                                </template>
                                                <span :class="onSale ? 'color-red' : ''" x-text="getPrice(onSale)"></span>
                                            </li>
                                        </template>
                                    </template>
                                </ul>
                            </div>
                            <div class="flex-grow-1">
                                <label class="d-flex align-items-center justify-content-end">
                                    <input class="mr-2" type="checkbox" x-model="article.orderWithoutQuantity" @change="toggleOrderWithoutQuantity">
                                    <span>{{ mt._('listing.orderNoQty') }}</span>
                                </label>
                            </div>
                        </div>
                        <template x-if="rowDateMode > 0 || rowNoteMode > 0">
                            <div class="d-flex info-form">
                                <template x-if="rowDateMode > 0">
                                    <div class="p-4 d-flex align-items-center">
                                        <span class="flex-shrink-1 mr-2">Data di consegna</span>
                                        {# TODO gestire il campo in base al valore di rowDateMode? oppure a quello generico? #}
                                        <input class="form-control m-0" x-model="article.date" type="text">
                                    </div>
                                </template>
                                <template x-if="rowNoteMode > 0">
                                    <div class="p-4 d-flex flex-grow-1 align-items-center">
                                        <span class="flex-shrink-1 mr-2">Note articolo</span>
                                        <input class="form-control flex-grow-1 m-0" x-model="article.notes" type="text">
                                    </div>
                                </template>
                            </div>
                        </template>
                    </div>
                </template>
            </template>

            <template x-if="visualizationType === '0'">
                <div>
                    <div class="d-flex overflow-x-auto">
                        <template x-for="child in selectedModel?.articles">
                            <div x-data="article(child)" class="d-flex align-items-center">
                                <button @click="setSelectedArticle(article)"
                                        class="d-flex flex-column inner-img p-4">
                                    <img :src="article.flimag" :alt="article.cdartn">
                                    <strong x-text="article.cdcolo"></strong>
                                    <span :class="article?.cdcolo === selectedArticle?.cdcolo && 'selected'"
                                          x-text="article?.dscolo"
                                          class="inner-img--vert d-block w-100 text-left"></span>
                                </button>
                            </div>
                        </template>
                    </div>
                    <div>
                        <span x-text="selectedArticle?.cdarti"></span>
                    </div>
                    <div class="table-responsive mt-5">
                        <table class="table table-borderless table-even-odd">
                            <thead>
                            <tr>
                                <th class="col-4 text-center">{{ mt._('listing.sizes') }}</th>
                                <th class="col-4 text-center">{{ mt._('listing.price') }}</th>
                                <th class="col-4 text-center">{{ mt._('listing.qty') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            <template :key="`${selectedArticle.cdcolo}-${articleSize.taglia}`"
                                      x-for="articleSize in selectedArticle?.sizes">
                                <tr x-data="size(articleSize)" :class="(size.flbloc !== 0 || (parseInt(selectedModel?.tglini) > 0 && parseInt(size.postgl) < parseInt(selectedModel?.tglini)) || (parseInt(selectedModel?.tglfin) > 0 && parseInt(size.postgl) > parseInt(selectedModel?.tglfin)) || (orderType === '0' && !size.available)) ? 'disabled' : ''">
                                    <td class="col-4 text-center" x-text="size.taglia"></td>
                                    <td class="col-4 text-center">
                                        <template x-if="onSale">
                                            <del><span x-text="getPrice()"></span></del>
                                        </template>
                                        <span :class="onSale ? 'color-red' : ''" x-text="getPrice(onSale)"></span>
                                    </td>
                                    <td class="col-4 text-center">
                                            <span class="d-flex justify-content-center sizes-bar">
                                                <button @click="decrement" type="button" x-bind:disabled="(size.flbloc !== 0 || (parseInt(selectedModel?.tglini) > 0 && parseInt(size.postgl) < parseInt(selectedModel?.tglini)) || (parseInt(selectedModel?.tglfin) > 0 && parseInt(size.postgl) > parseInt(selectedModel?.tglfin)) || (orderType === '0' && !size.available))">-</button>
                                                <input :id="`size-${size.taglia}-${selectedArticle.cdcolo}`" @keydown.space.prevent="fillNext" class="no-spin" x-bind:disabled="(size.flbloc !== 0 || (parseInt(selectedModel?.tglini) > 0 && parseInt(size.postgl) < parseInt(selectedModel?.tglini)) || (parseInt(selectedModel?.tglfin) > 0 && parseInt(size.postgl) > parseInt(selectedModel?.tglfin)) || (orderType === '0' && !size.available))"
                                                       type="number" x-model="size.quantity" @input="handleInput" min="0">
                                                <button @click="increment" type="button" x-bind:disabled="(size.flbloc !== 0 || (parseInt(selectedModel?.tglini) > 0 && parseInt(size.postgl) < parseInt(selectedModel?.tglini)) || (parseInt(selectedModel?.tglfin) > 0 && parseInt(size.postgl) > parseInt(selectedModel?.tglfin)) || (orderType === '0' && !size.available))">+</button>
                                            </span>
                                    </td>
                                </tr>
                            </template>
                            </tbody>
                        </table>
                    </div>
                </div>
            </template>
        </div>

        <div class="quickBuyModal__footer">
            <button type="button" @click="submit" class="btn btn-main w-100">{{ mt._('listing.addToCart') }}</button>
        </div>
    </div>
</div>
