{% include "macros.volt" %}

{% if showDetails %}

<div class="row m-0 mt-20x">
  <div class="col-12 text-center"><a href="#" data-toggle="modal" data-target=".modal-show-all-looks">{{ mt._('_common.look.seeall') }}</a></div>
</div>

<div class="row m-0 mt-40x" id="look-container" data-max-index="{{ lktest['lkcorp']|length - 1}}">

  <div class="col-2 text-center look-arrow"><i class="fa fa-chevron-left" style="margin-top:250px"></i></div>

  {% for lkcorp in lktest['lkcorp'] %}

  <div class="col-8 look-page" data-index="{{ loop.index0 }}" {{ loop.index0 > 0 ? 'style="display:none"' : '' }}>

    <div class="row text-uppercase mb-20x">
      <div class="col-12">{{ lktest['dslkbk'] }} - {{ lkcorp['dslook'] }}</div>
    </div>

    {% set imgurl = '' %}
    {% if lkcorp and lkcorp['filimg'] is not empty %}
      {% set imgurl = getLookbookFileUrl(lkcorp['filimg']) %}
    {% endif %}

    {% if imgurl is not empty %}
      {% set lbImageSize = getimagesize(diskManager.normalizePathInApp('public/' ~ imgurl)) %}
      {% set md = lbImageSize[0] > lbImageSize[1] ? 12 : 6 %}
    {% else %}
      {% set imgurl = "assets/img/default_look.jpg" %}
      {% set md = 6 %}
    {% endif %}

    <div class="row">
      <div class="col-{{ md }} mb-40x">{{ image(imgurl, "class": "m-0-auto img-look", "alt": lkcorp['dslook']) }}</div>
      <div class="col-{{ md == 6 ? '6' : '12' }} col-lg-{{ md == 6 ? '6' : '12' }}">
        <div class="row">
        {% for item in lkcorp['items'] %}
          {% if lktest['fltipo'] == 0 %}
            {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
              {% set link = url('model/' ~ item.cdartn) %}
            {% else %}
              {% set link = url('model/wizard/' ~ item.cdartn ~ '&lb=' ~ cdlkbk ~ '&lk=' ~ lkcorp['cdlook']) %}
            {% endif %}
            {% set code = item.cdartn %}
            {% set description = item.dsartn %}
            {% set flimag = item.flimag %}
          {% else %}
            {% if item.flimag_look != '' %}
              {% set flimag = item.flimag_look %}
            {% elseif item.flimag_arti != '' %}
              {% set flimag = item.flimag_arti %}
            {% elseif item.flimag_artn != '' %}
              {% set flimag = item.flimag_artn %}
            {% endif %}
            {% if lktest['fltipo'] == 1 %}
              {% set link = '#' %}
              {% set code = item.cdarti %}
              {% set description = item.dsarti %}
              {% set flimag = item.flimag %}
            {% else %}
              {% if (not common['hasWizard']) or (common['isOrder'] and common['order_info'].tpordc == 0) %}
                {% set link = url('model/' ~ item.cdartn) %}
              {% else %}
                {% set link = url('model/wizard/' ~ item.cdartn ~ '/' ~ item.cdpers ~ '&lb=' ~ cdlkbk ~ '&lk=' ~ lkcorp['cdlook'] ~ '&cl=' ~ item.cdcolo) %}
              {% endif %}
              {% set code = item.cdarti %}
              {% set description = item.dsarti %}
            {% endif %}
          {% endif %}
          <div class="col-{{ md == 6 ? '6' : '3' }} col-lg-{{ md == 6 ? '6' : '3' }} mb-20x py-0 px-40x fs11">
            <a href="{{ link }}" class="no-deco">
              <div class="image-model-box">{{ elements.getLookImgOrDefaultFromImgurl(flimag, description, ['title' : description]) }}</div>
              <div class="descr-model-box">{{ code }}</div>
              <div class="code-model-box">{{ description }}</div>
              {% if common['showCatalogPrice'] == 1 %}
                {# {{ elements.getPriceDiv(item.catalogPrice, item.cust_disc, common['currency'], common['cdvalu']) }} #}
                 {{ elements.getPriceDiv(item.catalogPrice, item.cust_disc, common['currency'], common['cdvalu'], "center", link,  item.cdartn ) }}
              {% endif %}
            </a>
          </div>
        {% endfor %}
        </div>
      </div>
    </div>

  </div>

  {% endfor %}

  <div class="col-2 text-center look-arrow"><i class="fa fa-chevron-right" style="margin-top:250px"></i></div>

</div>

<div class="modal fade modal-show-all-looks" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg" style="max-width:80%">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ lktest['dslkbk'] }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">
        <div class="row">
        {% for lkcorp in lktest['lkcorp'] %}
          {% set imgurl = '' %}
          {% if lkcorp and lkcorp['filimg'] is not empty %}
            {% set imgurl = getLookbookFileUrl(lkcorp['filimg']) %}
          {% endif %}

          {% if imgurl is empty %}
            {% set imgurl = "assets/img/default_look.jpg" %}
          {% endif %}
          <div class="col-2 mb-10x">
            <a href="#" class="jump-look" data-index="{{ loop.index0 }}">{{ image(imgurl, "class": "m-0-auto", "alt": lkcorp['dslook']) }}</a>
          </div>
        {% endfor %}
        </div>
      </div>
    </div>
  </div>
</div>

{% else %}

<div class="row text-uppercase my-20x mx-0">
  <div class="col-12">{{ lktest['dslkbk'] }}</div>
</div>

<div class="row m-0">

  {% set float = 'right' %}
  {% for lkcorp in lktest['lkcorp'] %}
    {% set md = 6 %}
    {% set imgurl = '' %}
    {% if lkcorp and lkcorp['filimg'] is not empty %}
      {% set imgurl = getLookbookFileUrl(lkcorp['filimg']) %}
    {% endif %}

    {% if imgurl is not empty %}
      {% set lbImageSize = getimagesize(diskManager.normalizePathInApp('public/' ~ imgurl)) %}
      {% set md = lbImageSize[0] > lbImageSize[1] ? 12 : 6 %}
    {% else %}
      {% set imgurl = "assets/img/default_look.jpg" %}
      {% set md = 6 %}
    {% endif %}

  <div class="col-{{ md }} py-20x mb-50x">
    <div class="img_wrap position-relative m-0-auto" style="{% if md == 6 %}float:{{ float }};{% endif %}width:{{ getimagesize(imgurl)[0] }}px;height:auto;max-width:100%;">
      <a href="{{ url('catalog/look/' ~ cdlkbk ~ '/' ~ lkcorp.cdlook) }}">
        {{ image(imgurl, "class": "m-0-auto", "alt": lkcorp.dslook) }}
        <p class='img_description'>
          <span class='font-weight-bold fs13'>{{ lkcorp.dslook}}</span><br/>
          <span class='fs11'>{{ lkcorp.num_items }} {{
            lktest['fltipo'] == 0
              ? (lkcorp.num_items != 1 ? mt._('_common.models') : mt._('_common.model'))
              : (lkcorp.num_items != 1 ? mt._('_common.articles') : mt._('_common.article'))
          }}
          </span>
        </p>
      </a>
    </div>
  </div>

    {% set float = md == 12 or float == 'left' ? 'right' : 'left' %}
  {% endfor %}

</div>

{% endif %}
