{% if homepage['hptest'] != null and homepage['hptest'].flimg1 is defined and homepage['hptest'].flimg1 != '' %}
<!-- Hero Slider -->
<section class="hero-slider" data-loop="true" data-autoplay="true" data-interval="7000">
  <div class="inner">
	{% if substr(homepage['hptest'].flimg1, -3) != 'mp4' %}
		{{ elements.getImageSlide(homepage['hptest'].flimg1, common['catalogAccessType'], buttonPosition) }}
  {% else %}
		{{ elements.getVideoSlide(homepage['hptest'].flimg1, common['catalogAccessType'], buttonPosition) }}
  {% endif %}
  {% if homepage['hptest'].flimg2 != "" %}
  	{% if substr(homepage['hptest'].flimg2, -3) != 'mp4' %}
  		{{ elements.getImageSlide(homepage['hptest'].flimg2, common['catalogAccessType'], buttonPosition) }}
  	{% else %}
  		{{ elements.getVideoSlide(homepage['hptest'].flimg2, common['catalogAccessType'], buttonPosition) }}
  	{% endif %}
  {% endif %}
  {% if homepage['hptest'].flimg3 != "" %}
	  {% if substr(homepage['hptest'].flimg3, -3) != 'mp4' %}
	  	{{ elements.getImageSlide(homepage['hptest'].flimg3, common['catalogAccessType'], buttonPosition) }}
	  {% else %}
	  	{{ elements.getVideoSlide(homepage['hptest'].flimg3, common['catalogAccessType'], buttonPosition) }}
	  {% endif %}
  {% endif %}
  </div><!-- .inner -->
</section><!-- .hero-slider -->
{% endif %}

{% set videoIsPresent = false %}

{% if homepage['blocks']|length != 0 %}
  {% for hpBlock in homepage['blocks'] %}
<div class="row hp-ctl-row">

    {% for box in hpBlock['boxes'] %}
      {% if box.blsize == 0 %}
        {% if box.seqrap == 1 %}
          {% set size = 12 %}
          {% set flex = 1 %}
        {% endif %}
      {% elseif box.blsize == 1 %}
        {% if box.seqrap == 1 %}
          {% set size = 6 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 2 %}
          {% set size = 6 %}
          {% set flex = 1 %}
        {% endif %}
      {% elseif box.blsize == 2 %}
        {% if box.seqrap == 1 %}
          {% set size = 4 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 2 %}
          {% set size = 4 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 3 %}
          {% set size = 4 %}
          {% set flex = 1 %}
        {% endif %}
      {% elseif box.blsize == 3 %}
        {% if box.seqrap == 1 %}
          {% set size = 4 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 2 %}
          {% set size = 8 %}
          {% set flex = 1 %}
        {% endif %}
      {% elseif box.blsize == 4 %}
        {% if box.seqrap == 1 %}
          {% set size = 8 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 2 %}
          {% set size = 4 %}
          {% set flex = 1 %}
        {% endif %}
      {% elseif box.blsize == 5 %}
        {% if box.seqrap == 1 %}
          {% set size = 3 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 2 %}
          {% set size = 3 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 3 %}
          {% set size = 3 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 4 %}
          {% set size = 3 %}
          {% set flex = 1 %}
        {% endif %}
      {% elseif box.blsize == 6 %}
        {% if box.seqrap == 1 %}
          {% set size = 3 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 2 %}
          {% set size = 9 %}
          {% set flex = 1 %}
        {% endif %}
      {% elseif box.blsize == 7 %}
        {% if box.seqrap == 1 %}
          {% set size = 9 %}
          {% set flex = 1 %}
        {% elseif box.seqrap == 2 %}
          {% set size = 3 %}
          {% set flex = 1 %}
        {% endif %}
      {% endif %}

      {% set linkAttributes = '' %}
      {% if box.tpbloc == 'SL' %}
        {% set boxUrl = url('catalog/sales') %}
      {% elseif box.tpbloc == 'TG' %}
        {% set boxUrl = url('catalog/tag/' ~ box.codice) %}
      {% elseif box.tpbloc == 'DL' %}
        {% set boxUrl = url('upload/media/' ~ box.codice) %}
        {% set linkAttributes = 'download target="_blank"' %}
      {% elseif box.tpbloc == 'VD' %}
        {% set videoIsPresent = true %}
        {% set videoLink = url('upload/media/' ~ box.codice) %}
        {% set boxUrl = '#' %}
        {% set linkAttributes = 'data-toggle="modal" data-target=".modal-watch-video" data-src="' ~ videoLink  ~ '"' %}
      {% elseif box.tpbloc == 'UR' %}
        {% set boxUrl = substr(box.codice, 0, 4) == 'http' ? box.codice : 'https://' ~ box.codice %}
        {% set linkAttributes = 'target="_blank"' %}
      {% else %}
        {% set boxUrl = url('catalog/setFilterFromHomepage/' ~ box.tpbloc ~ '/' ~ box.codice) %}
      {% endif %}

  <div class="col-{{ size }}" style="flex:{{ flex }}">
    {% if box.tpbloc != '' and box.tpbloc != 'NO' %}
    <a href="{{ boxUrl }}" class="homepage-link" {{ linkAttributes }}>
      {% if box.flimag != "" %}
      <div class="hp-img-{{ size }} no-effects">
        {% if box.nubloc == 1 %}
          {{ image("/upload/" ~ box.flimag) }}
        {% else %}
          {{ image("/assets/img/blank.gif", 'class': 'lazy', 'data-src': config.application.baseUri ~ 'upload/' ~ box.flimag) }}
        {% endif %}
      </div>
      <div class="hp-lbl-{{ size }}">
        <div class="hp-sb-lbl">
          {%     if session.get('language') == 'it' %}{{ box.des_it }}
          {% elseif session.get('language') == 'es' %}{{ box.des_es }}
          {% elseif session.get('language') == 'de' %}{{ box.des_de }}
          {% elseif session.get('language') == 'fr' %}{{ box.des_fr }}
          {%                                   else %}{{ box.des_en }}{% endif %}
        </div>
        <div class="hp-ln-lbl">{{ mt._('_common.seemore') }}</div>
      </div>
      {% endif %}
    </a>
    {% else %}
    &nbsp;
    {% endif %}
  </div>

    {% endfor %}
</div>
  {% endfor %}
{% endif %}

{% if videoIsPresent %}
  {% include "modal/catalog_video.volt" %}
{% endif %}
