<!-- jQuery -->
{{ javascript_include("js/jquery.min.js") }}
{{ javascript_include("vendors/jquery-ui-1.12.1.custom/jquery-ui.min.js") }}
{{ javascript_include("js/go2b.js") }}
{{ javascript_include("vendors/toastify-js/toastify.js") }}

{% if not (router.getControllerName() in ["admin", "gomanagement", "session"]) %}
{{ javascript_include("js/vendor/velocity.min.js") }}
{{ javascript_include("js/header_lines.js") }}
{{ javascript_include("js/sliiide.min.js") }}
{{ javascript_include("vendors/jquery-ui-1.12.1.custom/datepicker-" ~ session.get('language') ~ ".js") }}

<!-- Bootstrap -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.0/umd/popper.min.js" integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.0/js/bootstrap.min.js" integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm" crossorigin="anonymous"></script>
{{ javascript_include("js/web/bootstrap-select.min.js") }}
<!-- (Optional) Latest compiled and minified JavaScript translation files -->
{% if session.get('language') == 'it' %}{% set lang = 'it_IT' %}
{% elseif session.get('language') == 'en' %}{% set lang = 'en_US' %}
{% elseif session.get('language') == 'fr' %}{% set lang = 'fr_FR' %}
{% elseif session.get('language') == 'es' %}{% set lang = 'es_ES' %}
{% elseif session.get('language') == 'de' %}{% set lang = 'de_DE' %}{% endif %}
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.14/js/i18n/defaults-{{ lang }}.min.js"></script>

<!-- DateRangePicker -->
{{ javascript_include("js/moment/moment.min.js") }}
{{ javascript_include("vendors/bootstrap-daterangepicker/daterangepicker.js") }}

{% else %}

{{ javascript_include("vendors/bootstrap/dist/js/bootstrap.min.js") }}

{% endif %}

{% include "macros.volt" %}

{% if router.getRewriteUri() == "/session/login" or
      router.getRewriteUri() == "/session/register" or
     (router.getRewriteUri() == "/" and session.get('auth')['role'] != 'Admin') or
      router.getRewriteUri() == "/session/end" %}
    {% include "scripts/session/login.volt" %}
{% elseif router.getRewriteUri() == "/session/start" or
          router.getRewriteUri() == "/admin/agents" or
         (router.getRewriteUri() == "/" and session.get('auth')['role'] == 'Admin') %}
  {% include "scripts/admin/agents.volt" %}
{% elseif (router.getControllerName() in ["admin", "account", "cart", "catalog", "gomanagement", "info", "model", "statistics"]) %}
  {{ partial("scripts/" ~ router.getControllerName()) }}
{% endif %}
