<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('admin.specialselections.selection') }}: {{ code }} - {{ description }}</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row">
      <div class="form-group col-md-4" style="line-height:34px">
        <label for="input-code" class="control-label col-md-4 col-sm-4 col-xs-12" style="text-align:right;padding-top:0">{{ mt._('_common.code') }}</label>
        <div class="col-md-8 col-sm-8 col-xs-12"><input type="text" id="cdspsl" disabled class="form-control" value="{{ code }}"></div>
      </div>
      <div class="form-group col-md-4" style="line-height:34px">
        <label for="input-description" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize" style="text-align:right;padding-top:0">{{ mt._('_common.lang.it') }}</label>
        <div class="col-md-8 col-sm-8 col-xs-12"><input type="text" id="des-it" name="des-it" class="form-control" maxlength="60" size="60" value="{{ selection.des_it }}"></div>
      </div>
      <div class="form-group col-md-4" style="line-height:34px">
        <label for="input-description" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize" style="text-align:right;padding-top:0">{{ mt._('_common.lang.en') }}</label>
        <div class="col-md-8 col-sm-8 col-xs-12"><input type="text" id="des-en" name="des-en" class="form-control" maxlength="60" size="60" value="{{ selection.des_en }}"></div>
      </div>
      <div class="form-group col-md-4" style="line-height:34px">
        <label for="input-description" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize" style="text-align:right;padding-top:0">{{ mt._('_common.lang.es') }}</label>
        <div class="col-md-8 col-sm-8 col-xs-12"><input type="text" id="des-es" name="des-es" class="form-control" maxlength="60" size="60" value="{{ selection.des_es }}"></div>
      </div>
      <div class="form-group col-md-4" style="line-height:34px">
        <label for="input-description" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize" style="text-align:right;padding-top:0">{{ mt._('_common.lang.fr') }}</label>
        <div class="col-md-8 col-sm-8 col-xs-12"><input type="text" id="des-fr" name="des-fr" class="form-control" maxlength="60" size="60" value="{{ selection.des_fr }}"></div>
      </div>
      <div class="form-group col-md-4" style="line-height:34px">
        <label for="input-description" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize" style="text-align:right;padding-top:0">{{ mt._('_common.lang.de') }}</label>
        <div class="col-md-8 col-sm-8 col-xs-12"><input type="text" id="des-de" name="des-de" class="form-control" maxlength="60" size="60" value="{{ selection.des_de }}"></div>
      </div>
      <div class="form-group col-md-4" style="line-height:34px">
        <label for="input-description" class="control-label col-md-4 col-sm-4 col-xs-12 capitalize" style="text-align:right;padding-top:0">{{ mt._('admin.enabled') }}</label>
        <div class="col-md-8 col-sm-8 col-xs-12">
          <span class="checkbox-container">
            <input type="checkbox" id="flbloc" {{ selection.flbloc == 0 ? 'checked' : '' }}>
            <span class="checkbox-checkmark"></span>
          </span>
        </div>
      </div>
    </div>
    <div class="row mt-20x">
      <div class="col-md-3"><a href="{{ url('admin/specialSelections') }}" class="btn btn-default w-60 left-btn">{{ mt._('_common.close') }}</a></div>
      <div class="col-md-3"><button class="btn btn-primary w-60 left-btn" data-toggle="modal" data-target=".modal-load-xls">{{ mt._('_common.load.xls') }}</button></div>
      <div class="col-md-6"><button class="btn btn-primary w-30 right-btn save-selection">{{ mt._('_common.save') }}</button></div>
    </div>
    <div class="row">
      <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
        <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
      </div>
    </div>
  </div>
</div>

<div class="x_panel">
  <div class="x_title">
    <h2>{{ mt._('_common.products') }} (<span id="num-products">{{ products|length }}</span>)</h2>
    <div class="clearfix"></div>
  </div>

  <div class="x_content">
    <div class="row mt-20x">
      <div class="col-md-6"><button class="btn btn-primary w-30 left-btn" data-toggle="modal" data-target=".modal-add-product">{{ mt._('admin.specialselections.add') }}</button></div>
      <div class="col-md-6"><button class="btn btn-primary w-30 right-btn save-selection">{{ mt._('_common.save') }}</button></div>
    </div>
    <div class="row">
      <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
        <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
      </div>
    </div>

    <div class="row mt-20x" id="products-container">
      {% for product in products %}
      <div class="{{ colspan }} special-selection-box card draggable-card" draggable="true" id="product-{{ product.codice }}" data-code="{{ product.codice }}">
        <div class="inner-container">
          <button type="button" class="close" title="{{ mt._('_common.delete') }}"><span aria-hidden="true">×</span></button>
          <input type="hidden" class="default-image-path" value="../../public/img/model/{{ product.default_flimag }}"/>
          <div><a href="#" class="change-image" data-toggle="modal" data-target=".modal-change-image">{{ mt._('_common.image.change') }}</a></div>
          {% set url = product.custom_flimag != '' ? "../../public/upload/" ~ product.custom_flimag : "../../public/img/model/" ~ product.default_flimag %}
          <div><img src="{{ url }}" style="width:100%;margin-bottom:10px" title="{{ product.codice }}" data-iscustom="{{ product.custom_flimag != '' ? 1 : 0 }}"/></div>
          <div style="font-weight:bold">{{ product.codice }}</div>
          <div>{{ product.descri }}</div>
        </div>
      </div>
      {% endfor %}
    </div>

    <div class="row mt-20x">
      <div class="col-md-6"><button class="btn btn-primary w-30 left-btn" data-toggle="modal" data-target=".modal-add-product">{{ mt._('admin.specialselections.add') }}</button></div>
      <div class="col-md-6"><button class="btn btn-primary w-30 right-btn save-selection">{{ mt._('_common.save') }}</button></div>
    </div>
    <div class="row">
      <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
        <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
      </div>
    </div>

  </div>
</div>

<!-- Modal for load xls -->
<div class="modal fade modal-load-xls" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm" style="width:50%">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('_common.load.xls') }}</h4>
      </div>
      <div class="modal-body">
        <div class="row" style="padding-bottom:10px">
          <div class="col-md-12 col-sm-12 col-xs-12">{{ mt._('admin.specialselections.xlswarning') }}</div>
          <div class="col-md-12 col-sm-12 col-xs-12" style="margin-top:20px;font-size:13px">
            <form action="{{ url('excel/uploadSpecialSelectionXls') }}" method="post" enctype="multipart/form-data" id="load-xls-selection">
              <input type="file" name="file" id="xls_file">
              <input type="hidden" name="cdspsl" id="cdspsl" value="{{ code }}">
            </form>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="load-xls">{{ mt._('_common.load') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for add product -->
<div class="modal fade modal-add-product" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm" style="width:50%">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('admin.specialselections.add') }}</h4>
      </div>
      <div class="modal-body">
        <div class="row" style="padding-bottom:10px">
          <label for="select-product" class="control-label col-sm-3 col-md-3 col-xs-12 right" style="line-height:34px">{{ mt._('_common.products') }}</label>
          <div class="col-sm-9 col-md-9 col-xs-12">
            <select id="product-to-add" class="form-control selectpicker" title="{{ mt._('_common.products') }}" data-live-search="true">
              {% for product in availableProducts %}
              <option value="{{ product.code }}" data-flimag="{{ product.image }}" data-description="{{ product.description }}">{{ product.code }} - {{ product.description }}</option>
              {% endfor %}
            </select>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="add-product">{{ mt._('_common.add') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for change image -->
<div class="modal fade modal-change-image" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="{{ mt._('close') }}"><span aria-hidden="true">×</span></button>
        <h4 class="modal-title">{{ mt._('_common.image.change') }}</h4>
      </div>
      <div class="modal-body center">
        <input type="hidden" id="current-id"/>
        <input type="hidden" id="new-image"/>
        <div class="row" style="padding-bottom:10px">
          <div class="col-md-2 col-sm-2 col-xs-12">
            <div>{{ mt._('_common.image.current') }}</div>
            <div><img id="current-image" class="w-100" data-iscustom='0'/></div>
            <div style="margin-top:160px"><a href="#" id="restore-default">{{ mt._('_common.restore.default') }}</a></div>
          </div>
          <div class="col-md-10 col-sm-10 col-xs-12 form-group">
            <form action="{{ url('admin/uploadImage') }}" class="dropzone" id="dropzone-change-image"></form>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.cancel') }}</button>
          </div>
          <div class="col-md-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="change-image">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
