<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.settings') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
      {% if settings is defined and settings|length > 0 %}
        {% set current_tab = settings[0].tab %}
        {% set current_index = 0 %}

        <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
          <li role="presentation" class="active">
            <a href="#tab_content_{{ current_index }}" id="tab_{{ current_index }}" role="tab" data-toggle="tab" aria-expanded="true">{{ session.language == 'it' ? current_tab['it'] : current_tab['en'] }}</a>
          </li>
        {% set current_index = current_index + 1 %}

        {% for setting in settings %}
          {% if current_tab != setting.tab %}
            {% set current_tab = setting.tab %}
          <li role="presentation">
            <a href="#tab_content_{{ current_index }}" id="tab_{{ current_index }}" role="tab" data-toggle="tab" aria-expanded="false">{{ session.language == 'it' ? current_tab['it'] : current_tab['en'] }}</a>
          </li>
            {% set current_index = current_index + 1 %}
          {% endif %}
        {% endfor %}

          <li role="presentation">
            <a href="#tab_content_img" id="tab_img" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.images') }}</a>
          </li>
        </ul>

        {% set current_tab = settings[0].tab %}
        {% set current_index = 0 %}
        <div id="myTabContent" class="tab-content">

          <div role="tabpanel" class="tab-pane fade active in" id="tab_content_{{ current_index }}" aria-labelledby="tab_{{ current_index }}">
        {% set current_index = current_index + 1 %}
        {% for setting in settings %}
          {% if current_tab != setting.tab %}
            {% set current_tab = setting.tab %}
          </div>
          <div role="tabpanel" class="tab-pane fade" id="tab_content_{{ current_index }}" aria-labelledby="tab_{{ current_index }}">
            {% set current_index = current_index + 1 %}
          {% endif %}

          {% if session.get('auth')['type'] <= setting.privileges %}
            <div class="row mt-20x">
              <div class="col-md-4 col-sm-4 col-xs-4"><span class="inline-menu-title">{{ setting.name }}</span></div>
              <div class="col-md-8 col-sm-8 col-xs-8">
              {% if is_scalar(setting.options) %}
                <input type="{{ setting.options != 'free' ? setting.options : 'text' }}" class="setting p-8x" value="{{ setting.value }}" id="{{ setting.name }}" style="margin-top:-10px"/>
              {% else %}
                <select class="setting p-8x" id="{{ setting.name }}" style="margin-top:-10px">
                  {% for option in setting.options %}
                    <option value="{{ option['value'] }}" {% if option['value'] == setting.value %}selected{% endif %}>{{ session.language == 'it' ? option['descr']['it'] : option['descr']['en'] }}</option>
                  {% endfor %}
                </select>
              {% endif %}
              </div>
            </div>
            <div class="row mt-10x">
              <div class="col-md-12 col-sm-12 col-xs-12">{{ session.language == 'it' ? setting.descr['it'] : setting.descr['en'] }}</div>
            </div>
            <hr/>
          {% endif %}
        {% endfor %}
          </div>

          <div role="tabpanel" class="tab-pane fade" id="tab_content_img" aria-labelledby="tab_img">
            <div class="row mt-20x">
              <div class="col-md-4 col-sm-4 col-xs-4"><span class="inline-menu-title">{{ loginBg.param }}</span></div>
              <div class="col-md-8 col-sm-8 col-xs-8">
                <input type="text" class="value p-8x" value="{{ loginBg.value }}" style="margin-top:-10px" id='login_image'/>
                <form action="{{ url('admin/uploadLogo') }}" class="dropzone mt-10x" id="dropzone-login-image" style="min-height:40px!important;width:160px!important"></form>
                <div id="message"></div>
              </div>
            </div>
            <hr/>
            <div class="row mt-20x">
              <div class="col-md-4 col-sm-4 col-xs-4"><span class="inline-menu-title">{{ logoImg.param }}</span></div>
              <div class="col-md-8 col-sm-8 col-xs-8">
                <input type="text" class="value p-8x" value="{{ logoImg.value }}" style="margin-top:-10px" id='logo_image'/>
                <form action="{{ url('admin/uploadLogo') }}" class="dropzone mt-10x" id="dropzone-logo-image" style="min-height:40px!important;width:160px!important"></form>
                <div id="message"></div>
              </div>
            </div>
          </div>

          <div class="row mt-20x">
            <div class="col-md-10 col-sm-10 col-xs-10 right pt-10x">{{ mt._('admin.params.warning') }}</div>
            <div class="col-md-2 col-sm-2 col-xs-2 center"><input class="btn btn-primary w-100" type="submit" id="save-params" value="{{ mt._('_common.save') }}"/></div>
          </div>
      {% endif %}

          <div class="row mt-20x">
            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
              <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
            </div>
          </div>

        </div>

      </div>
    </div>
  </div>
</div>
