
<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel" id="period-panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.requestaccess') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content" id="orders-filter">
        <div class="row mt-10x">
          <table id="datatable-reqaccess" class="table table-striped table-bordered">
            <thead class="capitalize">
              <tr>
                <th>{{ mt._('account.customer.businessname') }}</th>
                <th>{{ mt._('account.customer.signboard') }}</th>
                <th>{{ mt._('_common.date') }}</th>
                <th>{{ mt._('account.customer.vatcode') }}</th>
                <th>{{ mt._('_common.email') }}</th>
                <th>{{ mt._('account.customer.telephone') }}</th>
                <th>{{ mt._('account.customer.address') }}</th>
                <th>{{ mt._('account.customer.city') }}</th>
                <th>{{ mt._('account.customer.country') }}</th>
                <th>{{ mt._('account.customer.province') }}</th>
                <th>{{ mt._('_common.status') }}</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
            {% for el in reqaccess %}
              <tr data-descri="{{ el.descri }}" data-dtcrea="{{ el.dtcrea }}">
                <td><span style="display:none">{{ el.dtcrea }}</span>{{ htmlspecialchars(el.descri) }}</td>
                <td>{{ htmlspecialchars(el.dsetic) }}</td>
                <td>{{ date('d/m/Y', strtotime(el.dtcrea)) }}</td>
                <td>{{ htmlspecialchars(el.ivacfi) }}</td>
                <td>{{ htmlspecialchars(el.indema) }}</td>
                <td>{{ htmlspecialchars(el.numtel) }}</td>
                <td>{{ htmlspecialchars(el.indiri) }}</td>
                <td>{{ htmlspecialchars(el.ccitta) }}</td>
                <td>{{ htmlspecialchars(el.dsnazi) }}</td>
                <td>{{ htmlspecialchars(el.provin) }}</td>
                <td>
                  {{ el.dtelab != ''
                    ? mt._('admin.reqaccess.managed')
                    : '<a href="#" style="text-decoration:underline" class="set-managed">' ~
                      mt._('admin.reqaccess.managed.setas') ~ '</a>' }}
                </td>
                <td class="center" style="vertical-align:middle">
                  <a href="#" class="delete-reqacc" title="{{ mt._('_common.delete') }}" data-toggle='modal' data-target='.modal-delete-reqacc'>
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </td>
              </tr>
            {% endfor %}
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete group -->
<div class="modal fade modal-delete-reqacc" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-delete-descri" name="modal-delete-reqacc"/>
      <input type="hidden" id="modal-delete-dtcrea" name="modal-delete-reqacc"/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.reqaccess.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.reqaccess.warning') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-reqacc" data-action="">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
