
{% set active_hdr = tab == 'h' or tab == '' %}
{% set active_bdy = tab == 'b' %}

<div class="x_panel">
  <div class="x_title capitalize">
    <h2>{{ mode == 'w' ? mt._('_common.modifyorder') : mt._('_common.order') }}</h2>
    <div class="clearfix"></div>
  </div>


  <div class="x_content">
    <div class="row">
      <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
        <li role="presentation" {{ active_hdr ? 'class="active"' : '' }}>
          <a href="#tab_content_hdr" data-anchor="tab_content_hdr" id="tab_hdr" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.order.header') }}</a>
        </li>
        <li role="presentation" {{ active_bdy ? 'class="active"' : '' }}>
          <a href="#tab_content_bdy" data-anchor="tab_content_bdy" id="tab_bdy" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.articles') }}</a>
        </li>
      </ul>

      {% set orderDiscount = order.implor > 0 ? 100 * (1 - (order.impnet / order.implor)) : 0 %}

      <div class="row mt-20x text-uppercase">
        <div class="col-md-2 bold">{{ mt._('_common.budget') }}: -</div>
        <div class="col-md-2 bold">{{ mt._('_common.amount.gross') }}: <span style='color:#c12f2f' class="order-total">{{ order.implor|currency }} {{ currency }}</span></div>
        <div class="col-md-2 bold">{{ mt._('_common.amount.net') }}: <span style='color:#c12f2f' class="order-total">{{ order.impnet|currency }} {{ currency }}</span></div>
        <div class="col-md-2 bold">{{ mt._('_common.discount') }}: <span style='color:#c12f2f' class="order-total">{{ orderDiscount|currency }}%</span></div>
      </div>

      <input type="hidden" value="{{ order.flstat }}" id="current-flstat"/>

      <div id="myTabContent" class="tab-content">
        <!-- Header Tab Content -->
        <div role="tabpanel" class="tab-pane fade {{ active_hdr ? 'active in' : '' }}" id="tab_content_hdr" aria-labelledby="tab_hdr">
          <div class="row mt-30x">
            <div class="col-md-12 bold">
              {{ mt._('admin.status') }}:
              {% if mode == 'r' %}
                {% if order.flstat == 1 %}{% set status = mt._('account.order.provisional') %}
                {% elseif order.flstat == 2 %}{% set status = mt._(orderStateMgmt ? 'account.order.processed' : 'account.order.sent') %}
                {% elseif order.flstat == 3 %}{% set status = mt._('account.order.accepted') %}
                {% elseif order.flstat == 4 %}{% set status = mt._('account.order.rejected') %}
                {% elseif order.flstat == 5 %}{% set status = mt._('account.order.waitingquantity') %}
                {% elseif order.flstat == 6 %}{% set status = mt._('account.order.customerconfirmed') %}
                {% endif %}
              <span class="sts{{ order.flstat }}">{{ status }}</span>
              {% else %}
                {% set displaySelect = order.flstat == 5 ? "display:none" : '' %}
                {% set displaySpan = order.flstat != 5 ? "display:none" : '' %}
              <select id="order-state-select" style='text-transform:uppercase;{{ displaySelect }}' class="sts{{ order.flstat }} {{ order.flstat != 5 ? 'active' : '' }}">
                <option value="1" class="sts1" style="text-transform:uppercase" {{ order.flstat == 1 ? 'selected' : '' }}>{{ mt._('account.order.provisional') }}</option>
                <option value="6" class="sts6" style="text-transform:uppercase" {{ order.flstat == 6 ? 'selected' : '' }}>{{ mt._('account.order.customerconfirmed') }}</option>
              </select>
              <span class="sts5" id="order-state-text" style="text-transform:uppercase;{{ displaySpan }}">{{ mt._('account.order.waitingquantity') }}</span>
              {% endif %}
            </div>
          </div>

          <div class="row mt-30x">
            <div class="col-md-12 bold">{{ mt._('_common.generalinfo') }}</div>
          </div>

          <div class="row mt-20x">
            <div class="col-md-6">
              <div class="row">
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.ordernumber') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ order.nuordc }} </div>
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.catalog') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ order.cdcata }}{{ (order.dscata != '' ? ' - ' ~ order.dscata : '') }} </div>
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.orderdate') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ order.dtcrea }} </div>
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.customer') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ order.cdanag }} - {{ order.dsanag }} </div>
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.pricelist') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ order.dslist != '' ? order.dslist : order.nulist }} </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="row">
                <div class="col-md-3 capitalize bold mt-10x" {{ mode == 'w' ? 'style="line-height:34px"' : '' }}>{{ mt._('_common.delivery') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">
                  {% if mode == 'r' %}
                    {% if order.cddesm != 0 %}
                      {{ order.indiri_d }} - {{ order.ccitta_d }} {{ order.provin_d != '' ? '(' ~ order.provin_d ~ ')' : '' }} {{ order.dsnazi_d != '' ? ' - ' ~ order.dsnazi_d : '' }}
                    {% else %}
                      {{ order.indiri_a }} - {{ order.ccitta_a }} {{ order.provin_a != '' ? '(' ~ order.provin_a ~ ')' : '' }} {{ order.dsnazi_a != '' ? ' - ' ~ order.dsnazi_a : '' }}
                    {% endif %}
                  {% else %}
                  <select class="form-control" id="address">
                    <option value="NULL" {{ order.cddesm > 0 ? '' : 'selected' }}>
                      {{ order.indiri_a }} - {{ order.ccitta_a }} {{ order.provin_a != '' ? '(' ~ order.provin_a ~ ')' : '' }} {{ order.dsnazi_a != '' ? ' - ' ~ order.dsnazi_a : '' }}
                    </option>
                  {% if addresses|length > 0 %}
                    {% for address in addresses %}
                    <option value="{{ address.cddesm }}" {{ order.cddesm == address.cddesm ? 'selected' : '' }}>
                      {{ address.indiri }} - {{ address.ccitta }} {{ address.provin != '' ? '(' ~ address.provin ~ ')' : '' }} {{ address.dsnazi != '' ? ' - ' ~ address.dsnazi : '' }}
                    </option>
                    {% endfor %}
                  {% endif %}
                  </select>
                  {% endif %}
                </div>
                <div class="col-md-3 capitalize bold mt-10x" {{ mode == 'w' ? 'style="line-height:34px"' : '' }}>{{ mt._('cart.payment') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">
                  {% if mode == 'r' %}
                    {{ order.dspaga != '' ? order.dspaga : order.tppaga }}
                  {% else %}
                  <select class="form-control" id="payment">
                  {% if payments|length > 0 %}
                    {% for payment in payments %}
                    <option value="{{ payment.tppaga }}" {{ payment.tppaga == order.tppaga ? 'selected' : '' }}>{{ payment.dspaga }}</option>
                    {% endfor %}
                  {% endif %}
                  </select>
                  {% endif %}
                </div>
                <div class="col-md-3 capitalize bold mt-10x" {{ mode == 'w' ? 'style="line-height:34px"' : '' }}>{{ mt._('cart.shipping') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">
                  {% if mode == 'r' %}
                    {{ order.dstpor != '' ? order.dstpor : order.tpport }}
                  {% else %}
                  <select class="form-control" id="shipping">
                  {% if shippings|length > 0 %}
                    {% for shipping in shippings %}
                    <option value="{{ shipping.tpport }}" {{ shipping.tpport == order.tpport ? 'selected' : '' }}>{{ shipping.dstpor }}</option>
                    {% endfor %}
                  {% endif %}
                  </select>
                  {% endif %}
                </div>
              </div>
            </div>
          </div>

          <div class="row mt-30x">
            <div class="col-md-12 bold">{{ mt._('_common.total.notes') }}</div>
          </div>

          <div class="row mt-20x">
            <div class="col-md-6">
              <div class="row">
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.total.articles') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ order.rows }}</div>
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.total.qty') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ order.quanti }}</div>
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.amount.gross') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ order.implor|currency }} {{ currency }}</div>
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.amount.net') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ order.impnet|currency }} {{ currency }}</div>
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('_common.discount') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">{{ orderDiscount|currency }}%</div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="row">
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('cart.customernotes') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">
                {% if mode == 'r' %}
                  {{ order.notcli != '' ? order.notcli : '&nbsp;' }}
                {% else %}
                  <textarea rows="2" class="form-control" id="notcli" name="notcli">{{ order.notcli }}</textarea>
                {% endif %}
                </div>
                <div class="col-md-3 capitalize bold mt-10x">{{ mt._('cart.companynotes') }}</div>
                <div class="col-md-9 mt-10x" style="color:black">
                {% if mode == 'r' %}
                  {{ order.notazi != '' ? order.notazi : '&nbsp;' }}
                {% else %}
                  <textarea rows="2" class="form-control" id="notazi" name="notazi">{{ order.notazi }}</textarea>
                {% endif %}
                </div>
              </div>
            </div>
          </div>

          <div class="row mt-20x">
            <div class="col-md-6 pl-10x">
              <a href="{{ url('admin/orders') }}" class="btn btn-default">{{ mt._('_common.close') }}</a>
            </div>
            {% if mode == 'w' %}
            <div class="col-md-6 pl-10x right">
              <a href="#" class="btn btn-primary" id="save-order-header">{{ mt._('_common.save') }}</a>
            </div>
            <div class="col-md-12">
              <div class="msg-error">{{ mt._('_common.update.error') }}</div>
              <div class="msg-success">{{ mt._('_common.update.success') }}</div>
            </div>
            {% endif %}
          </div>
        </div>

        <!-- Body Tab Content -->
        <div role="tabpanel" class="tab-pane fade {{ active_bdy ? 'active in' : '' }}" id="tab_content_bdy" aria-labelledby="tab_bdy" style="font-size:11px">
          {% if rows|length > 0 %}
          <div class="row mt-30x">
            <div class="col-md-4 pl-10x">
              <a href="{{ url('admin/orders') }}" class="btn btn-default">{{ mt._('_common.close') }}</a>
            </div>
            {% if mode == 'w' %}
            <div class="col-md-8 pl-10x right">
              {% if showVariants %}
              <button type="button" class="btn btn-primary" data-toggle="modal" data-target=".modal-add-row">{{ mt._('admin.order.addrow') }}</button>
              {% endif %}
              <button type="button" class="btn btn-primary" data-toggle="modal" data-target=".modal-delete-no-qty">{{ mt._('admin.order.deletenoqtyarticles') }}</button>
              <button type="button" class="btn btn-primary disabled delete-edit" style="text-transform:capitalize" data-toggle="modal" data-target=".modal-multiple-delete">{{ mt._('_common.delete') }}</button>
              <button type="button" class="btn btn-primary disabled multiple-edit">{{ mt._('_common.modify.multiple') }}</button>
            </div>
            {% endif %}
          </div>

          {% if not hasConfigurator %}
            {% set  col1Width = '2%' %}
            {% set  col2Width = '18%' %}
            {% set  col3Width = '4%' %}
            {% set  col4Width = '4%' %}
            {% set  col5Width = '4%' %}
            {% set  col6Width = showVariants ? (mode == 'w' ? '44%' : '46%') : (mode == 'w' ? '48%' : '50%') %}
            {% set  col7Width = '4.5%' %}
            {% set  col8Width = '4.5%' %}
            {% set  col9Width = '2.5%' %}
            {% set col10Width = '2.5%' %}
            {% set col11Width = '2.5%' %}
            {% set col12Width = '5%' %}
            {% set col13Width = '2.5%' %}
          {% else %}
            {% set  col1Width = '2%' %}
            {% set  col2Width = '33%' %}
            {% set  col3Width = '4%' %}
            {% set  col4Width = '4%' %}
            {% set  col5Width = '4%' %}
            {% set  col6Width = mode == 'w' ? '41%' : '43%' %}
            {% set  col7Width = '4.5%' %}
            {% set  col8Width = '4.5%' %}
            {% set  col9Width = '2.5%' %}
            {% set col10Width = '2.5%' %}
            {% set col11Width = '2.5%' %}
            {% set col12Width = '5%' %}
            {% set col13Width = '2.5%' %}
          {% endif %}

          <div class="row mt-30x capitalize text-center order-detail-rows-header mx-0">
            {% if mode == 'w' %}
            <div class="order-detail-rows-cell" style="width:{{ col1Width }}">&nbsp;</div>
            {% endif %}
            <div class="order-detail-rows-cell" style="width:{{ col2Width }}">{{ mt._('_common.article') }}</div>
            {% if not hasConfigurator %}
            <div class="order-detail-rows-cell" style="width:{{ col3Width }}">{{ mt._('_common.color') }}</div>
            {% endif %}
            {% if showVariants %}
            <div class="order-detail-rows-cell" style="width:{{ col4Width }}">{{ mt._('_common.variations') }}</div>
            {% endif %}
            {% if not hasConfigurator %}
            <div class="order-detail-rows-cell" style="width:{{ col5Width }}">{{ mt._('_common.delivery') }}</div>
            {% endif %}
            <div class="order-detail-rows-cell" style="width:{{ col6Width }}">{{ mt._('_common.sizes.scale') }}</div>
            <div class="order-detail-rows-cell" style="width:{{ col7Width }}">{{ mt._('_common.total.qty.short') }}</div>
            <div class="order-detail-rows-cell" style="width:{{ col8Width }}">{{ mt._('_common.price') }}</div>
            <div class="order-detail-rows-cell" style="width:{{ col9Width }}">{{ mt._('_common.discount.short') }} 1</div>
            <div class="order-detail-rows-cell" style="width:{{ col10Width }}">{{ mt._('_common.discount.short') }} 2</div>
            <div class="order-detail-rows-cell" style="width:{{ col11Width }}">{{ mt._('_common.discount.short') }} 3</div>
            <div class="order-detail-rows-cell" style="width:{{ col12Width }}">{{ mt._('_common.total') }}</div>
            <div class="order-detail-rows-cell" style="width:{{ col13Width }}">{{ mt._('_common.notes') }}</div>
          </div>

          {% set y = 0 %}

          {% for row in rows %}
            {% set x = 0 %}
          <div class="row capitalize order-detail-rows-line mx-0" {{ loop.last ? 'id="last-row"' : '' }}
            data-nurorc="{{ row['nurorc'] }}" data-cdartn="{{ row['cdartn'] }}" data-tpmode="{{ row['tpmode'] }}"
            data-cdtagl="{{ row['cdtagl'] }}"
            data-x="{{ row['octagl']|length - 1 }}" data-y="{{ y }}" data-prezzo="{{ row['prezzo'] }}">
            {% if mode == 'w' %}
            <div class="order-detail-rows-cell text-center" style="width:{{ col1Width }}">
              <label class="checkbox-container">
                <input type="checkbox" name="nurorc-checkbox[]" value="{{ row['nurorc'] }}"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
            {% endif %}
            <div class="order-detail-rows-cell" style="width:{{ col2Width }}">
            {% if not hasConfigurator %}
              {% if row['tpvend'] != 'CUSTOM' %}
              <span class="bold">{{ row['cdartn'] }} {{ row['cdpers'] }}</span><br/>
              {% else %}
              <span class="bold" style="font-style:italic">{{ row['cdarti'] }}</span><br/>
              {% endif %}
              {{ row['dsartn'] }}
            {% else %}
              <span class="bold">{{ row['cdartn'] }} - {{ row['dsartn'] }}</span><br/>
              <span style="font-size:8px">
              {% if row["components"]|length > 0 %}
                {% for component in row["components"] %}
                  {{ component.cdmate }}{{ substr(component.tpcomp, 0, 2) == '10' ? ' - ' ~ component.dsmate : '' }}{{ not loop.last ? ' / ' : '' }}
                {% endfor %}
              {% else %}
                {{ row["dsarti"] }}
              {% endif %}
              </span>
            {% endif %}
            </div>
            {% if not hasConfigurator %}
            <div class="order-detail-rows-cell" style="width:{{ col3Width }}">
              {% if row['tpvend'] != 'CUSTOM' %}
              <span class="bold">{{ row['cdcolo'] }}</span><br/>&nbsp;
              {% else %}
              <span class="bold">CUSTOM</span><br/>&nbsp;
              {% endif %}
            </div>
            {% endif %}
            {% if showVariants %}
            <div class="order-detail-rows-cell" style="width:{{ col4Width }}">
              <span class="bold cdvari-row" {{ mode == 'w' ? 'style="cursor:pointer" data-toggle="modal" data-target=".modal-change-variants"' : '' }}>{{ row['cdvari'] }}</span>
              <br/>&nbsp;
            </div>
            {% endif %}
            {% if not hasConfigurator %}
            <div class="order-detail-rows-cell text-center" style="width:{{ col5Width }}">
            {% if mode == 'r' %}
              <span class="bold">{{ row['dtmcli'] != '00/00/0000' ? row['dtmcli'] : '' }}</span>
              <br/>&nbsp;
            {% else %}
              {% if dateMgmt < 2 %}
              <select class="row-dtmcli" name="period">
                <option value="0000-00-00"></option>
                {% for scacon in period %}
                <option value="{{ scacon.dtmcli }}" {{ row['dtmcli_raw'] == scacon.dtmcli ? 'checked' : '' }}>{{ scacon.dsscad }}</option>
                {% endfor %}
              </select>
              <span class="pointer"><i class="fa fa-caret-down"></i></span>
              {% else %}
              <div class="row form-element mx-0">
                <div class="col-md-12 px-0"><input type="text" class="datepicker datepicker-row-dtmcli" value="{{ row['dtmcli'] != '00/00/0000' ? row['dtmcli'] : '' }}"></div>
              </div>
              {% endif %}
            {% endif %}
            </div>
            {% endif %}
            <div class="order-detail-rows-cell p-0" style="width:{{ col6Width }}" id="order-detail-boxes">
            {% if row['octagl']|length > 0 %}
              <div class="row mx-0 text-center">
              {% for octagl in row['octagl'] %}
                <div class="fl order-detail-size-box {{ mode == 'w' ? 'edit' : '' }}" id="{{ x }}_{{ y }}" style="max-width:40px" data-x="{{ x }}" data-y="{{ y }}">
                {% if mode == 'r' %}
                  <span class="bold">{{ octagl['dstagl'] }}</span><br/>{{ octagl['quanti'] }}
                {% else %}
                  <div class="bold">{{ octagl['dstagl'] }}</div>
                  <div class="read-quanti">{{ octagl['quanti'] }}</div>
                  <div class="edit-quanti"><input type="number" data-dstagl="{{ octagl['dstagl'] }}" value="{{ octagl['quanti'] }}" min="0" step="1"/></div>
                {% endif %}
                </div>
                {% set x = x + 1 %}
              {% endfor %}
              </div>
            {% endif %}
            </div>
            <div class="order-detail-rows-cell text-center" style="width:{{ col7Width }}"><span id="tot_{{ y }}" class="total bold">{{ row['quanti'] }}</span><br/>&nbsp;</div>
            <div class="order-detail-rows-cell text-right" style="width:{{ col8Width }}">
              <span id="prc_{{ y }}" class="bold">{{ row['prezzo']|currency }} {{ currency }}</span><br/>&nbsp;
            </div>
            <div class="order-detail-rows-cell {{ mode == 'w' ? 'edit' : '' }} text-center" style="width:{{ col9Width }}">
            {% if mode == 'r' %}
              <span class="bold">{{ row['scont1'] }}</span><br/>&nbsp;
            {% else %}
              <div class="read-discount">{{ row['scont1'] }}</div>
              <div class="edit-discount">
                <input type="number" id="dsc1_{{ y }}" data-field="scont1" data-x="0" data-y="{{ y }}" value="{{ row['scont1'] }}" min="0" step="0.1"/>
              </div>
            {% endif %}
            </div>
            <div class="order-detail-rows-cell {{ mode == 'w' ? 'edit' : '' }} text-center" style="width:{{ col10Width }}">
            {% if mode == 'r' %}
              <span class="bold">{{ row['scont2'] }}</span><br/>&nbsp;
            {% else %}
              <div class="read-discount">{{ row['scont2'] }}</div>
              <div class="edit-discount">
                <input type="number" id="dsc2_{{ y }}" data-field="scont2" data-x="1" data-y="{{ y }}" value="{{ row['scont2'] }}" min="0" step="0.1"/>
              </div>
            {% endif %}
            </div>
            <div class="order-detail-rows-cell {{ mode == 'w' ? 'edit' : '' }} text-center" style="width:{{ col11Width }}">
            {% if mode == 'r' %}
              <span class="bold">{{ row['scont3'] }}</span><br/>&nbsp;
            {% else %}
              <div class="read-discount">{{ row['scont3'] }}</div>
              <div class="edit-discount">
                <input type="number" id="dsc3_{{ y }}" data-field="scont3" data-x="2" data-y="{{ y }}" value="{{ row['scont3'] }}" min="0" step="0.1"/>
              </div>
            {% endif %}
            </div>
            <div class="order-detail-rows-cell text-right" style="width:{{ col12Width }}"><span id="amt_{{ y }}" class="bold">{{ row['totale']|currency }} {{ currency }}</span><br/>&nbsp;</div>
            <div class="order-detail-rows-cell text-center" style="width:{{ col13Width }}">
            {% if mode == 'r' %}
              {% if row['dsnoco'] != '' %}
              <span class="glyphicon glyphicon-bookmark mytooltip fs13 dsnoco-row" aria-hidden="true">
                <span style="text-transform:none" class="tooltiptext tooltip-left notes-text">{{ row['dsnoco'] }}</span>
              </span>
              {% endif %}
            {% else %}
              <span class="glyphicon glyphicon-bookmark mytooltip fs13 dsnoco-row" aria-hidden="true"
                style="{{ row['dsnoco'] == '' ? 'display:none;' : '' }}cursor:pointer" data-toggle="modal" data-target=".modal-modify-row-notes">
                <span style="text-transform:none" class="tooltiptext tooltip-left notes-text">{{ row['dsnoco'] }}</span>
              </span>
              <span class="glyphicon glyphicon-plus mytooltip fs13 dsnoco-row" aria-hidden="true"
                style="{{ row['dsnoco'] != '' ? 'display:none;' : '' }}cursor:pointer" data-toggle="modal" data-target=".modal-modify-row-notes">
                <span class="tooltiptext tooltip-left">{{ mt._('_common.add') }}</span>
              </span>
            {% endif %}
            </div>
          </div>
            {% set y = y + 1 %}
          {% endfor %}

          <div class="row mt-30x">
            <div class="col-md-4 pl-10x">
              <a href="{{ url('admin/orders') }}" class="btn btn-default">{{ mt._('_common.close') }}</a>
            </div>
            {% if mode == 'w' %}
            <div class="col-md-8 pl-10x right">
              {% if showVariants %}
              <button type="button" class="btn btn-primary" data-toggle="modal" data-target=".modal-add-row">{{ mt._('admin.order.addrow') }}</button>
              {% endif %}
              <button type="button" class="btn btn-primary" data-toggle="modal" data-target=".modal-delete-no-qty">{{ mt._('admin.order.deletenoqtyarticles') }}</button>
              <button type="button" class="btn btn-primary disabled delete-edit" style="text-transform:capitalize" data-toggle="modal" data-target=".modal-multiple-delete">{{ mt._('_common.delete') }}</button>
              <button type="button" class="btn btn-primary disabled multiple-edit">{{ mt._('_common.modify.multiple') }}</button>
            </div>
            {% endif %}
          </div>

          {% else %}
          <!-- no rows -->
          {% endif %}

          </div>

        </div>

      </div>

    </div>

  </div>
</div>

{% if mode == 'w' %}
<!-- Modal for modify row notes -->
<div class="modal fade modal-modify-row-notes" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">
      <input type="hidden" id="dsnoco-nurorc" value=""/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.notes') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row pb-10x">
          <div class='col-md-12'><textarea rows="4" class="form-control" id="dsnoco" name="dsnoco"></textarea></div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="save-notes" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for multiple edit -->
<div class="modal fade modal-multiple-edit" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-40">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.modify.multiple') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <input type="hidden" id="modal-multiple-nurorc" value=""/>
      <div class="modal-body">
        <div class="row pb-20x">
          <div class="col-md-2 bold capitalize" style="line-height:40px">{{ mt._('_common.sizes.qty') }}</div>
          <div class="col-md-10 text-center" id="multiple-sizes">

          </div>
        </div>
        <div class="row pb-20x">
          <div class="col-md-2 bold capitalize">{{ mt._('cart.deliverydate') }}</div>
          <div class="col-md-6">
            {% if dateMgmt < 2 %}
            <select name="multiple-dtmcli" id="multiple-dtmcli">
              <option value="0000-00-00"></option>
              {% for scacon in period %}
              <option value="{{ scacon.dtmcli }}">{{ scacon.dsscad }}</option>
              {% endfor %}
            </select>
            <span class="pointer"><i class="fa fa-caret-down"></i></span>
            {% else %}
            <input type="text" class="datepicker" id="multiple-dtmcli"/>
            {% endif %}
          </div>
        </div>
        <div class="row pb-20x">
          <div class="col-md-2 bold capitalize">{{ mt._('_common.discounts') }}</div>
          <div class="col-md-1"><input type="number" class="w-100" id="multiple-scont1" min="0" step="0.1"/></div>
          <div class="col-md-1"><input type="number" class="w-100" id="multiple-scont2" min="0" step="0.1"/></div>
          <div class="col-md-1"><input type="number" class="w-100" id="multiple-scont3" min="0" step="0.1"/></div>
        </div>
        <div class="row pb-10x">
          <div class="col-md-2 bold capitalize">{{ mt._('_common.notes') }}</div>
          <div class="col-md-10"><textarea rows="4" class="form-control" id="multiple-dsnoco" name="multiple-dsnoco"></textarea></div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="save-multiple" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for multiple delete -->
<div class="modal fade modal-multiple-delete" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-40">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <input type="hidden" id="modal-multiple-nurorc" value=""/>
      <div class="modal-body">
        <div class="row pb-20x">
          <div class="col-12">{{ mt._('model.wizard.warning.deleterows') }}</div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="delete-multiple">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for deleting articles with no quantity -->
<div class="modal fade modal-delete-no-qty" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-40">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <input type="hidden" id="modal-multiple-nurorc" value=""/>
      <div class="modal-body">
        <div class="row pb-20x">
          <div class="col-md-12 col-sm-12 col-xs-12">{{ mt._('model.wizard.warning.deleterows') }}</div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="delete-no-qty">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

{% if showVariants %}
<!-- Modal for modify row cdvari -->
<div class="modal fade modal-change-variants" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="cdvari-nurorc" value=""/>
      <input type="hidden" id="cdvari-old-prezzo" value=""/>
      <input type="hidden" id="cdvari-new-prezzo" value=""/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.variations') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row pb-30x">
          <div class="col-md-6"><span class="pr-10x bold">{{ mt._('_common.variations') }}: </span><span id="modal-cdvari"></span></div>
          <div class="col-md-6"><span class="pr-10x bold">{{ mt._('_common.price.additional') }}: </span><span id="modal-prezzo"></span></div>
        </div>
        <div class="row pb-10x">
          <div class="col-md-12" id="modal-cdvari-selector">

          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="save-cdvari" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for add row -->
<div class="modal fade modal-add-row" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg w-40">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.order.addrow') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <!-- Step 1 -->
        <div class="row pb-30x" id="step1">
          <div class="col-md-12 bold">{{ mt._('admin.order.selectarticle') }}:</div>
          <div class="col-md-4">
            <input type="text" id="modal-add-row-cdarti" name="modal-add-row-cdarti" placeholder="{{ mt._('admin.order.selectarticle') }}" class="form-control" value=""/>
          </div>
          <div class="col-md-3">
            <button type="button" id="modal-select-article" class="btn btn-primary left-btn w-100">{{ mt._('_common.select') }}</button>
          </div>
          <div class="col-md-5 msg-error" id="step1warning" style="line-height:34px;text-align:left">{{ mt._('admin.order.selectedarticlewarning') }}</div>
        </div>
        <div class="row pb-10x" id="step1completed" style="display:none">
          <div class="col-md-4 bold" style="line-height:34px">{{ mt._('admin.order.selectedarticle') }}:</div>
          <div class="col-md-3" style="line-height:34px" id="modal-selected-article"></div>
          <div class="col-md-5">
            <button type="button" id="modal-back-to-select-article" class="btn btn-default left-btn w-50 capitalize">{{ mt._('_common.back') }}</button>
          </div>
        </div>
        <!-- Step 2 -->
        <div class="row pb-30x" id="step2" style="display:none">
          <div class="col-md-12 bold">{{ mt._('admin.order.selectcolor') }}:</div>
          <div class="col-md-4">
            <input type="text" id="modal-add-row-cdcolo" name="modal-add-row-cdcolo" placeholder="{{ mt._('admin.order.selectcolor') }}" class="form-control" value=""/>
          </div>
          <div class="col-md-3">
            <button type="button" id="modal-select-color" class="btn btn-primary left-btn w-100">{{ mt._('_common.select') }}</button>
          </div>
          <div class="col-md-5 msg-error" id="step2warning" style="line-height:34px;text-align:left">{{ mt._('admin.order.selectedcolorwarning') }}</div>
        </div>
        <div class="row pb-10x" id="step2completed" style="display:none">
          <div class="col-md-4 bold" style="line-height:34px">{{ mt._('admin.order.selectedcolor') }}:</div>
          <div class="col-md-3" style="line-height:34px" id="modal-selected-color"></div>
          <div class="col-md-5">
            <button type="button" id="modal-back-to-select-color" class="btn btn-default left-btn w-50 capitalize">{{ mt._('_common.back') }}</button>
          </div>
        </div>
        <!-- Step 3 -->
        <div class="row pb-30x" id="step3" style="display:none">

        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="add-row" style="display:none">{{ mt._('_common.confirm') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

{% endif %}
