<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.newcustomers') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row mt-10x">
          <div class="col-md-6 col-sm-6 col-xs-12 form-group">
            <label class="checkbox checkbox-container customer-type cust-cn">
              <input type="checkbox" value="0" id="show-provisional" checked> {{ mt._('account.customer.provisional.p') }}
              <span class="checkbox-checkmark"></span>
            </label>
            <label class="checkbox checkbox-container customer-type cust-cl">
              <input type="checkbox" value="1" id="show-final" checked> {{ mt._('account.customer.final.p') }}
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-12 text-right">
            <button type="button" class="btn btn-primary waves-effect waves-light m-0 w-30" id="send-email">{{ mt._('_common.send.email') }}</button>
          </div>
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>

        {% if newCustomers is defined and newCustomers|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">

            <table id="table-customers" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th>{{ mt._('account.customer.code.cn') }}</th>
                  <th>{{ mt._('account.customer.code.cl') }}</th>
                  <th>{{ mt._('account.customer.businessname') }}</th>
                  <th>{{ mt._('_common.agent') }}</th>
                  <th>{{ mt._('_common.status') }}</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                {% for el in newCustomers %}
                <tr data-type="{{ el.tpanag }}" data-tpanag="{{ el.tpanag }}" data-cdanag="{{ el.cdanag }}">
                  <td><span>{{ el.tpanag == 'CN' ? el.cdanag : el.newcod }}</span></td>
                  <td><span>{{ el.tpanag == 'CN' ? '' : el.cdanag }}</span></td>
                  <td><span>{{ el.descri }}</span></td>
                  <td><span>{{ el.dsagen }}</span></td>
                  <td>
                    {{ el.tpanag == 'CN' ? "<span class='cust-cn'>" ~ mt._('account.customer.provisional.s') ~ "</span>" : "<span class='cust-cl'>" ~ mt._('account.customer.final.s') ~ "</span>" }}
                  </td>
                  <td class="text-center">
                    <a href="#" class="see-detail no-deco">{{ image("assets/img/eye.jpg", "title": mt._("_common.see"), "style": "height:25px") }}</a>
                    {% if el.tpanag == 'CN' and el.orders == 0 %}
                    <a href="#" class="delete-customer no-deco" data-toggle="modal" data-target=".modal-delete-customer">{{ image("assets/img/delete.jpg", "title": mt._("_common.delete"), "style": "height:25px") }}</a>
                    {% endif %}
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
        {% endif %}

      </div>
    </div>
  </div>
</div>

<!-- Modal for customer detail -->
<div class="modal fade modal-customer-detail" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel2">{{ mt._('admin.customers.info') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.code.cn') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-newcod"></div>
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.code.cl') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-cdanag"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.businessname') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-descri"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.signboard') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-desvid"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.vatcode') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-pariva"></div>
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.taxcode') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-codfis"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.code.pr') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-codupr"></div>
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.code.pa') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-uffipa"></div>
          </div>
        </div>
        <div class="modal-section">
          <div class="row py-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.address') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-indiri"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.city') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-ccitta"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.capzip') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-codcap"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.province') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-provin"></div>
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.country') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-dsnazi"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.zone') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-dszona"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.countrycode') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-intern"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.telephone') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-numtel"></div>
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.mobilephone') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-numcel"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.fax') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-numfax"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.email') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-indema"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.email.other') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-indem2"></div>
          </div>
        </div>
        <div class="modal-section">
          <div class="row py-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>ABI</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-codabi"></div>
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>CAB</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-codcab"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>IBAN</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-cdiban"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.payment') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-dspaga"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.shipment') }}</div>
            <div class='col-md-9 col-sm-8 col-xs-8' id="modal-dstpor"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.carrier') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-dsvett"></div>
            <div class='col-md-3 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('account.customer.agent') }}</div>
            <div class='col-md-3 col-sm-8 col-xs-8' id="modal-dsagen"></div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">&nbsp;</div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default right-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete customer -->
<div class="modal fade modal-delete-customer" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-delete-cdanag"/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row pb-10x">
          <div class="col-md-12 col-sm-12 col-xs-12">{{ mt._('admin.newcustomers.delete') }}</div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-customer">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
