<div class="row">
  <div class="col-md-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.media.load') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <form action="{{ url('admin/uploadFile') }}"  method="post" enctype="multipart/form-data">
          <div class="row">
            <div class="col-md-6"><input type="file" name="file" id="file"></div>
            <div class="col-md-6"><input type="submit" value="{{ mt._('admin.media.load') }}" name="submit"></div>
          </div>
        </form>
        {% if success == 1 %}
        <div class="row">
          <div class="col-md-12">
            <div class="msg-success fl" style="display:block">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
        {% endif %}
      </div>
    </div>

    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.media.list') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row py-15x px-0" style="font-family:'Cutive Mono', monospace, serif;font-size: 14px;">
          <div class="col-md-6">{{ mt._('_common.file') }}</div>
          <div class="col-md-2 text-right">{{ mt._('_common.size') }}</div>
          <div class="col-md-3 text-right">{{ mt._('_common.lastmodified') }}</div>
          <div class="col-md-1"></div>
        </div>
      {% set i = 0 %}
      {% for file in files %}
        <div class="row row-file py-15x px-0">
          <div class="col-md-6"><i class="fa {{ file['icon_class'] }} fa-fw"></i>  {{ file["file"] }}</div>
          <div class="col-md-2 text-right">{{ file["file_size"] }}</div>
          <div class="col-md-3 text-right">{{ file["mod_time"] }}</div>
          <div class="col-md-1 center">
            <a data-toggle='modal' data-target='.modal-delete-file' class="pointer" id="file-{{ i }}" data-file="{{ file['file'] }}">
              <i class="fa fa-remove" title="{{ mt._('_common.delete') }}"></i>
            </a>
          </div>
        </div>
        {% set i = i + 1 %}
      {% endfor %}
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete file -->
<div class="modal fade modal-delete-file" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <input type="hidden" id="mode" name="mode"/>

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.file.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>

      <div class="modal-body">{{ mt._('admin.file.deletewarning', {'file': "<span id='file-to-remove'></span>" }) }}</div>

      <div class="modal-footer">
        <div class="container">
          <div class="row">
            <div class="col-md-6 col-sm-6 col-xs-6">
              <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
            </div>
            <div class="col-md-6 col-sm-6 col-xs-6">
              <button type="button" class="btn btn-primary right-btn w-50" id="delete-file" data-action="">{{ mt._('admin.file.delete') }}</button>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
