<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.linkcatalogs') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">

      {# CATALOGS SECTION #}
      {% if catalogs|length > 0 %}
        <div class="row">
          <div class="col-md-2 col-sm-4 col-xs-6 text-right"><span class="inline-menu-title">{{ mt._('admin.linkcatalogs.selectcatalogs') }}</span></div>
          <div class="col-md-7 col-sm-4 col-xs-6">
          {% for catalog in catalogs %}
            <div class="col-md-3 col-sm-4 col-xs-6 pb-15x">
              <div class="fl">
                <label class="checkbox-container">
                  <input type="checkbox" name="catalogs[]" value="{{ catalog.cdcata }}" />
                  <span class="checkbox-checkmark"></span>
                </label>
              </div>
              <div class="fl ml-10x" style="margin-top:-5px">{{ catalog.cdcata }}<br/>{{ catalog.dscata }}</div>
            </div>
          {% endfor %}
          </div>
          <div class="col-md-3 col-sm-4 col-xs-6 link-catalogs-to-all-container">
            <button type="button" class="btn btn-primary link-catalogs-to-all">{{ mt._('admin.catalog.assignall') }}</button>
            <div class='loader'>{{ image("assets/img/loading.gif", "alt": "Preloader") }}</div>
          </div>
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-all-error msg-error"></div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-2 col-sm-4 col-xs-6 text-right" style="padding-top:9px"><span class="inline-menu-title">{{ mt._('_common.mode') }}</span></div>
          <div class='col-md-2 col-sm-2 col-xs-2 mt-7x'>
            <label class="radio-container">
              <input type="radio" checked name="radio-mode" value="0"> {{ mt._('_common.mode.addition') }}
              <span class="radio-checkmark"></span>
            </label>
          </div>
          <div class='col-md-2 col-sm-8 col-xs-8 mt-7x'>
            <label class="radio-container">
              <input type="radio" name="radio-mode" value="1"> {{ mt._('_common.mode.replacement') }}
              <span class="radio-checkmark"></span>
            </label>
          </div>
        </div>
      {% endif %}

        <hr />

        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-form-error"></div>
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
        <div class="row mb-30x">
          <div class="col-md-6 col-sm-6 col-xs-6">&nbsp;</div>
          <div class="col-md-6 col-sm-6 col-xs-6 right"><button type="button" class="btn btn-primary link-catalogs">{{ mt._('_common.save') }}</button></div>
        </div>

      {% if agents|length > 0 or headoffices|length > 0 or customers|length > 0 or shippings|length > 0 %}
        <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
        {% if agents|length > 0 or headoffices|length > 0 %}
          <li role="presentation" class="active"><a href="#tab_content_agents" id="tab_agents" role="tab" data-toggle="tab" aria-expanded="true">{{ mt._('_common.agents') }}</a></li>
        {% endif %}
        {% if customers|length > 0 %}
          <li role="presentation"><a href="#tab_content_customers" id="tab_customers" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.customers') }}</a></li>
        {% endif %}
        {% if shippings|length > 0 %}
          <li role="presentation"><a href="#tab_content_shippings" id="tab_shippings" role="tab" data-toggle="tab" aria-expanded="false">{{ mt._('_common.shippings') }}</a></li>
        {% endif %}
        </ul>

        <div id="myTabContent" class="tab-content">
        {% if agents|length > 0 or headoffices|length > 0 %}
          <div role="tabpanel" class="tab-pane fade active in" id="tab_content_agents" aria-labelledby="tab_agents">
          {% if headoffices|length > 0 %}
            <table id="table-headoffices" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class="cb no-sort">&nbsp;</th>
                  <th>{{ mt._('admin.username') }}</th>
                  <th>{{ mt._('admin.agents.headoffice') }}</th>
                  <th>{{ mt._('admin.agents.name') }}</th>
                  <th>{{ mt._('admin.catalogs') }}</th>
                  <th>{{ mt._('admin.status') }}</th>
                </tr>
              </thead>

              <tbody>
              {% for agent in headoffices %}
                <tr>
                  <td class="cb">
                    <label class="checkbox-headoffice">
                      <input type="checkbox" name="status-checkbox[]" value="{{ agent.id_usr }}"/>
                      <span class="icon"><i class="fa fa-check" aria-hidden="true"></i></span>
                    </label>
                  </td>
                  <td><span>{{ agent.usrnam }}</span></td>
                  <td><span>{{ agent.cdagen }}</span></td>
                  <td><span>{{ agent.dsagen }}</span></td>
                  <td>
                    {% if agent.catalogs|length > 0 %}
                    <span class="lowercase">{{ agent.catalogs|length }} {{ agent.catalogs|length > 1 ? mt._('admin.catalogs') : mt._('admin.catalog') }}</span>
                    <span class="glyphicon glyphicon-bookmark mytooltip right fs13 mt-5x" aria-hidden="true">
                      <span class="tooltiptext">{% for catalog in agent.catalogs %}{{ catalog.dscata }}<br/>{% endfor %}</span>
                    </span>
                    {% endif %}
                  </td>
                  <td><span>{{ agent.enable == 0 ? mt._('admin.disabled') : mt._('admin.enabled') }}</span></td>
                </tr>
              {% endfor %}
              </tbody>
            </table>
            <div class="w-100" style="height:30px">&nbsp;</div>
          {% endif %}
          {% if agents|length > 0 %}
            <table id="table-agents" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class="cb no-sort">
                    <label>
                      <input type="checkbox" id="select-all-agents"/>
                      <span class="icon"><i class="fa fa-check" aria-hidden="true"></i></span>
                    </label>
                  </th>
                  <th>{{ mt._('admin.username') }}</th>
                  <th>{{ mt._('admin.agents.agentcode') }}</th>
                  <th>{{ mt._('admin.agents.name') }}</th>
                  <th>{{ mt._('admin.catalogs') }}</th>
                  <th>{{ mt._('admin.status') }}</th>
                </tr>
              </thead>

              <tbody>
              {% for agent in agents %}
                <tr>
                  <td class="cb">
                    <label class="checkbox-agent">
                      <input type="checkbox" name="status-checkbox[]" value="{{ agent.id_usr }}"/>
                      <span class="icon"><i class="fa fa-check" aria-hidden="true"></i></span>
                    </label>
                  </td>
                  <td><span>{{ agent.usrnam }}</span></td>
                  <td><span>{{ agent.cdagen }}</span></td>
                  <td><span>{{ agent.dsagen }}</span></td>
                  <td>
                    {% if agent.catalogs|length > 0 %}
                    <span class="lowercase">{{ agent.catalogs|length }} {{ agent.catalogs|length > 1 ? mt._('admin.catalogs') : mt._('admin.catalog') }}</span>
                    <span class="glyphicon glyphicon-bookmark mytooltip right fs13 mt-5x" aria-hidden="true">
                      <span class="tooltiptext">{% for catalog in agent.catalogs %}{{ catalog.dscata }}<br/>{% endfor %}</span>
                    </span>
                    {% endif %}
                  </td>
                  <td><span>{{ agent.enable == 0 ? mt._('admin.disabled') : mt._('admin.enabled') }}</span></td>
                </tr>
              {% endfor %}
              </tbody>
            </table>
          {% endif %}
          </div>
        {% endif %}
        {% if customers|length > 0 %}
          <div role="tabpanel" class="tab-pane fade" id="tab_content_customers" aria-labelledby="tab_customers">
            <table id="table-customers" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class="cb no-sort">
                    <label>
                      <input type="checkbox" id="select-all-customers"/>
                      <span class="icon"><i class="fa fa-check" aria-hidden="true"></i></span>
                    </label>
                  </th>
                  <th>{{ mt._('admin.username') }}</th>
                  <th>{{ mt._('admin.customers.customercode') }}</th>
                  <th>{{ mt._('admin.customers.name') }}</th>
                  <th>{{ mt._('admin.catalogs') }}</th>
                  <th>{{ mt._('admin.status') }}</th>
                </tr>
              </thead>

              <tbody>
              {% for customer in customers %}
                <tr>
                  <td class="cb">
                    <label class="checkbox-customer">
                      <input type="checkbox" name="status-checkbox[]" value="{{ customer.id_usr }}"/>
                      <span class="icon"><i class="fa fa-check" aria-hidden="true"></i></span>
                    </label>
                  </td>
                  <td><span>{{ customer.usrnam }}</span></td>
                  <td><span>{{ customer.cdanag }}</span></td>
                  <td><span>{{ customer.descri }}</span></td>
                  <td>
                    {% if customer.catalogs|length > 0 %}
                    <span class="lowercase">{{ customer.catalogs|length }} {{ customer.catalogs|length > 1 ? mt._('admin.catalogs') : mt._('admin.catalog') }}</span>
                    <span class="glyphicon glyphicon-bookmark mytooltip right fs13 mt-5x" aria-hidden="true">
                      <span class="tooltiptext">{% for catalog in customer.catalogs %}{{ catalog.dscata }}<br/>{% endfor %}</span>
                    </span>
                    {% endif %}
                  </td>
                  <td><span>{{ customer.enable == 0 ? mt._('admin.disabled') : mt._('admin.enabled') }}</span></td>
                </tr>
              {% endfor %}
              </tbody>
            </table>
          </div>
        {% endif %}
        {% if shippings|length > 0 %}
          <div role="tabpanel" class="tab-pane fade" id="tab_content_shippings" aria-labelledby="tab_shippings">
            <table id="table-shippings" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class="cb no-sort">
                    <label>
                      <input type="checkbox" id="select-all-shippings"/>
                      <span class="icon"><i class="fa fa-check" aria-hidden="true"></i></span>
                    </label>
                  </th>
                  <th>{{ mt._('admin.username') }}</th>
                  <th>{{ mt._('admin.customers.customercode') }}</th>
                  <th>{{ mt._('admin.customers.name') }}</th>
                  <th>{{ mt._('admin.shippings.code') }}</th>
                  <th>{{ mt._('admin.shippings.address') }}</th>
                  <th>{{ mt._('admin.catalogs') }}</th>
                  <th>{{ mt._('admin.status') }}</th>
                </tr>
              </thead>

              <tbody>
              {% for shipping in shippings %}
                <tr>
                  <td class="cb">
                    <label class="checkbox-shipping">
                      <input type="checkbox" name="status-checkbox[]" value="{{ shipping.id_usr }}"/>
                      <span class="icon"><i class="fa fa-check" aria-hidden="true"></i></span>
                    </label>
                  </td>
                  <td><span>{{ shipping.usrnam }}</span></td>
                  <td><span>{{ shipping.cdanag }}</span></td>
                  <td><span>{{ shipping.desana }}</span></td>
                  <td><span>{{ shipping.cddesm }}</span></td>
                  <td><span>{{ shipping.indiri|escape }}</span></td>
                  <td>
                    {% if shipping.catalogs|length > 0 %}
                    <span class="lowercase">{{ shipping.catalogs|length }} {{ shipping.catalogs|length > 1 ? mt._('admin.catalogs') : mt._('admin.catalog') }}</span>
                    <span class="glyphicon glyphicon-bookmark mytooltip right fs13 mt-5x" aria-hidden="true">
                      <span class="tooltiptext">{% for catalog in shipping.catalogs %}{{ catalog.dscata }}<br/>{% endfor %}</span>
                    </span>
                    {% endif %}
                  </td>
                  <td><span>{{ shipping.enable == 0 ? mt._('admin.disabled') : mt._('admin.enabled') }}</span></td>
                </tr>
              {% endfor %}
              </tbody>
            </table>
          </div>
        {% endif %}

        </div>

        <div class="row mt-30x">
          <div class="col-md-6 col-sm-6 col-xs-6">&nbsp;</div>
          <div class="col-md-6 col-sm-6 col-xs-6 right"><button type="button" class="btn btn-primary link-catalogs">{{ mt._('_common.save') }}</button></div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-form-error"></div>
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      {% endif %}

      </div>
    </div>
  </div>
</div>
