<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.customfamily.groups') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row py-10x">
          <div class="col-md-8">&nbsp;</div>
          <div class="col-md-4 text-right">
            <a href="#" id="new-group" class="btn btn-primary w-70" data-toggle='modal' data-target='.modal-modify-cdregv'>{{ mt._('admin.customfamily.creategroup') }}</a>
          </div>
        </div>

        {% if familyGroups|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <table id="table-group" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class='capitalize'>{{ mt._('_common.code') }}</th>
                  <th class='capitalize'>{{ mt._('_common.description') }}</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                {% for group in familyGroups %}
                <tr data-cdregv="{{ group.cdregv }}" data-dsregv="{{ group.dsregv }}">
                  <td class="cdregv">{{ group.cdregv }}</td>
                  <td>{{ group.dsregv }}</td>
                  <td class="center" style="vertical-align:middle">
                    <a href="#" class="modify-group pr-10x" title="{{ mt._('admin.customfamily.modifygroup') }}" data-toggle='modal' data-target='.modal-modify-cdregv'>
                      <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                    </a>
                    <a href="{{ url('admin/customfamily/' ~ group.cdregv)}}" class="see-group pr-10x" title="{{ mt._('admin.customfamily.managefamilies') }}">
                      <span class="glyphicon glyphicon-eye-open" aria-hidden="true"></span>
                    </a>
                    <a href="#" class="delete-group" title="{{ mt._('admin.customfamily.deletegroup') }}" data-toggle='modal' data-target='.modal-delete-cdregv'>
                      <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                    </a>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
        {% endif %}
      </div>

    </div>

  </div>
</div>

<!-- Modal for modify group -->
<div class="modal fade modal-modify-cdregv" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-modify-cdregv" name="modal-modify-cdregv"/>
      <div class="modal-header">
        <h4 class="modal-title" id="modal-modify-title"></h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row pb-10x" style="line-height:34px">
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.description') }}</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type="text" value="" id="modal-modify-dsregv" class="form-control"/></div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="modify-group" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete group -->
<div class="modal fade modal-delete-cdregv" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-delete-cdregv" name="modal-delete-cdregv"/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.customfamily.deletegroup') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.customfamily.deletewarning.g') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-group" data-action="">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
