{# patch #}
<input type="search" class="form-control input-sm" placeholder="" aria-controls="table-customers" style="display:none">

<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.users') }} - {{ mt._('admin.menu.customers') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">

       {# {% if queryString != '' %}
        <div class="row mb-20x">
          <h2 class="col-md-6">{{ mt._('_common.searchresultsfor') }} "{{ queryString }}"</h2>
          <div class="col-md-6 text-right text-capitalize">
            <a href="{{ url('admin/customers') }}" class="btn btn-default w-50">{{ mt._('_common.back') }}</a>
          </div>
        </div>
        {% endif %}#}

        <div class="row">
          <div class="col-md-8 col-sm-8 col-xs-8">
            <span class="inline-menu-title">{{ mt._('admin.massiveactions') }}:</span>
            {#<span class="inline-menu-title">
              <a class="pointer" id="bulk-enable">{{ mt._('admin.enableusers') }}</a>
            </span>
            <span class="inline-menu-title">
              <a class="pointer" id="bulk-disable">{{ mt._('admin.disableusers') }}</a>
            </span>#}
            {% if (enableCustomerManagement) %}
              <span class="inline-menu-title">
                <a data-toggle="modal" data-target="#modal-bulk-ban-status">{{ mt._('admin.banrestore') }}</a>
              </span>
            {% endif %}
            <span class="inline-menu-title">
              <a data-toggle="modal" data-target="#modal-bulk-login-status">{{ mt._('admin.enabledisable') }}</a>
            </span>
            <span class="inline-menu-title">
              <a data-toggle="modal" data-target="#modal-bulk-reset">{{ mt._('admin.resetpassword') }}</a>
            </span>
            <span class="inline-menu-title">
              {#<a class="pointer" id="bulk-create">{{ mt._('admin.createusers') }}</a>#}
              <a data-toggle="modal" data-target="#modal-bulk-create">{{ mt._('admin.createusers') }}</a>
            </span>
          </div>
          <div class="col-md-4 col-sm-4 col-xs-4 right p-0">
            <span class="inline-menu-title"><a id="customers-export-data" href="/admin/customersTableExport" target="_blank">{{ mt._('admin.exportcsv') }}</a></span>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-bulk-error left fl" id="bulk-error"></div>
          </div>
        </div>

        {#{% if tot_pages > 1 %}
        <div class="paginator my-20x">
          <div class="cust-page">{{ curr_page > 1 ? '<a href="' ~ url('admin/customers/' ~ (curr_page - 1) ) ~ '"><<</a>' : '<<' }}</div>
          {% for i in range(1,tot_pages) %}
          <div class="cust-page {% if curr_page == i %}bold{% endif %}"><a href="{{ url('admin/customers/' ~ i )}}">{{ i }}</a></div>
          {% endfor %}
          <div class="cust-page">{{ curr_page < tot_pages ? '<a href="' ~ url('admin/customers/' ~ (curr_page + 1) ) ~ '">>></a>' : '>>' }}</div>
        </div>
        {% endif %}#}

       {# {% if queryString == '' %}
        <div class="row my-20x">
          <div class="col-sm-6"></div>
          <div class="col-sm-6">
            <div class="search-all-pages-container">
              <form autocomplete="off">
                <label class="search-all-pages-label">{{ mt._('_common.searchpages') }}: <input type="text" class="form-control input-sm search-all-pages" autocomplete="false"></label>
                <div class="col-sm-12 search-all-pages-results"></div>
              </form>
            </div>
          </div>
        </div>
        {% endif %}#}

        {% if customers is defined and customers|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">

            <table id="table-customers" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class="no-sort"></th>
                  <th>{{ mt._('admin.customers.customercode') }}</th>
                  <th>{{ mt._('admin.customers.name') }}</th>
                  <th>{{ mt._('_common.email') }}</th>
                  <th>{{ mt._('admin.status') }}</th>
                  <th>{{ mt._('admin.catalogs') }}</th>
                  <th>{{ mt._('_common.shippings') }}</th>
                  <th>{{ mt._('admin.username') }}</th>
                  <th>{{ mt._('admin.customer.canlogin') }}</th>
                  <th>{{ mt._('admin.customer.canorder') }}</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                {% for el in customers %}
                <tr id="{{ el.tpanag }}{{ el.cdanag }}" {{ el.tpanag == 'CN' ? 'style="font-style:italic"' : '' }}>
                  <td class="cb">
                    <label class="checkbox-customer checkbox-container">
                      <input type="checkbox" name="status-checkbox[]" value="{{ el.id_usr }}"/>
                      <span class="checkbox-checkmark"></span>
                    </label>
                  </td>
                  <td class="cdanag"><span>{{ el.cdanag }}</span></td>
                  <td><span>{{ el.descri|escape }}{{ el.tpanag == 'CN' ? ' (' ~ mt._('_common.provisional') ~ ')' : '' }}</span></td>
                  <td><span>{{ el.indema|escape }}</span></td>
                  <td class="cdblco">
                    {% if enableCustomerManagement %}
                      <span>
                        <select class="table-ban form-control input-sm w-100 p-5x {{ el.cdblco == 0 ? 'enabled' : 'disabled' }}" data-cdanag="{{ el.cdanag }}">
                          <option value="0" {{ el.cdblco == 0 ? 'selected' : '' }} class="enabled">{{ mt._('account.customer.ban.0') }}</option>
                          <option value="1" {{ el.cdblco == 1 ? 'selected' : '' }} class="disabled">{{ mt._('account.customer.ban.1') }}</option>
                          <option value="2" {{ el.cdblco == 2 ? 'selected' : '' }} class="disabled">{{ mt._('account.customer.ban.2') }}</option>
                          <option value="3" {{ el.cdblco == 3 ? 'selected' : '' }} class="disabled">{{ mt._('account.customer.ban.3') }}</option>
                          <option value="4" {{ el.cdblco == 4 ? 'selected' : '' }} class="disabled">{{ mt._('account.customer.ban.4') }}</option>
                          <option value="5" {{ el.cdblco == 5 ? 'selected' : '' }} class="disabled">{{ mt._('account.customer.ban.5') }}</option>
                          <option value="6" {{ el.cdblco == 6 ? 'selected' : '' }} class="disabled">{{ mt._('account.customer.ban.6') }}</option>
                          <option value="999" {{ el.cdblco == 999 ? 'selected' : '' }} class="disabled">{{ mt._('account.customer.ban.999') }}</option>
                        </select>
                      </span>
                    {% else %}
                      <span>{{ mt._('account.customer.ban.' ~ el.cdblco) }}</span>
                    {% endif %}
                  </td>
                  <td>
                    {% if el.catalogs|length > 0 %}
                    <span class="lowercase">{{ el.catalogs|length }} {{ el.catalogs|length > 1 ? mt._('admin.catalogs') : mt._('admin.catalog') }}</span>
                    <span class="glyphicon glyphicon-bookmark mytooltip fr fs13 mt-5x" aria-hidden="true">
                      <span class="tooltiptext">{% for catalog in el.catalogs %}{{ catalog.dscata }}<br/>{% endfor %}</span>
                    </span>
                    {% endif %}
                  </td>
                  <td><span>{{ el.shippings }}</span></td>
                  <td><span>{{ el.usrnam }}</span></td>
                  <td>
                    {% if el.id_usr != -1 %}
                      <span>
                        <select class="table-status form-control input-sm w-100 p-5x {{ el.enabled == 0 ? 'disabled' : 'enabled' }}"
                                data-idusr="{{ el.id_usr }}" data-type="enabled">
                          <option value="0" {% if el.enabled == 0 %}selected{% endif %} class="disabled">{{ mt._('admin.disabled') }}</option>
                          <option value="1" {% if el.enabled == 1 %}selected{% endif %} class="enabled">{{ mt._('admin.enabled') }}</option>
                        </select>
                        <div class="msg-form-error-row left" id="login-enabled-error-{{ el.id_usr }}"></div>
                      </span>
                    {% endif %}
                  </td>
                  <td>
                    {% if el.id_usr != -1 %}
                      <span>
                        <select class="table-status form-control input-sm w-100 p-5x {{ el.orders_enabled == 0 ? 'disabled' : 'enabled' }}"
                                data-idusr="{{ el.id_usr }}" data-type="orders_enabled">
                          <option value="0" {% if el.orders_enabled == 0 %}selected{% endif %} class="disabled">{{ mt._('admin.disabled') }}</option>
                          <option value="1" {% if el.orders_enabled == 1 %}selected{% endif %} class="enabled">{{ mt._('admin.enabled') }}</option>
                        </select>
                      </span>
                    {% endif %}
                  </td>
                  <td>
                    <div class="action-wrapper center" style="vertical-align:middle"
                         data-tpanag="{{ el.tpanag|escape_attr }}" data-cdanag="{{ el.cdanag|escape_attr }}"
                         data-cdblco="{{ el.cdblco|escape_attr }}" data-descri="{{ el.descri|escape_attr }}"
                         data-idusr="{{ el.id_usr != -1 ? el.id_usr|escape_attr : '' }}" data-username="{{ el.username|escape_attr }}"
                         data-enabled="{{ el.enabled|escape_attr }}" data-ordersenabled="{{ el.orders_enabled|escape_attr }}"
                         data-catalogs="{{ el.catalogs|escape_attr }}" data-shippings="{{ el.shippings|escape_attr }}">
                        <span data-toggle='modal' data-target='.modal-modify-user'>
                          <a href="#" class="modify-user" title="{{ mt._('admin.customers.modifycustomer') }}">
                            <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                          </a>
                        </span>
                        <span class="pl-20x" data-toggle='modal' data-target='.modal-manage-shippings'>
                          <a href="#" class="manage-shippings" title="{{ mt._('admin.customers.manageshippings') }}">
                            <span class="glyphicon glyphicon-send" aria-hidden="true"></span>
                          </a>
                        </span>
                        {% if enableBudget %}
                        <span class="pl-20x" data-toggle='modal' data-target='.modal-show-budget'>
                          <a href="#" class="show-budget" title="{{ mt._('_common.budget') }}">
                            <span class="glyphicon glyphicon-euro" aria-hidden="true"></span>
                          </a>
                        </span>
                        {% endif %}
                    </div>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>

          </div>
        </div>
        {% else %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <table id="table-customers-ajax" class="table table-striped table-bordered">

            </table>
          </div>
        </div>
        {% endif %}

        {#{% if tot_pages > 1 %}
        <div class="paginator mt-20x">
          <div class="cust-page">{{ curr_page > 1 ? '<a href="' ~ url('admin/customers/' ~ (curr_page - 1) ) ~ '"><<</a>' : '<<' }}</div>
          {% for i in range(1,tot_pages) %}
          <div class="cust-page {% if curr_page == i %}bold{% endif %}"><a href="{{ url('admin/customers/' ~ i )}}">{{ i }}</a></div>
          {% endfor %}
          <div class="cust-page">{{ curr_page < tot_pages ? '<a href="' ~ url('admin/customers/' ~ (curr_page + 1) ) ~ '">>></a>' : '>>' }}</div>
        </div>
        {% endif %}#}
      </div>

      {# This table is needed only to export csv, so it's hidden #}
      {#<div id="dvData" style="display:none">
        <table>
          <tr>
            <td>Username</td>
            <td>Password</td>
            <td>{{ mt._('admin.customers.shortname') }}</td>
            <td>{{ mt._('_common.email') }}</td>
            <td>{{ mt._('_common.zone') }}</td>
            <td>{{ mt._('_common.catalogs') }}</td>
          </tr>
          {% for el in customers if (substr(el.usrnam, 0, prefix|length) == prefix and substr(el.usrnam, prefix|length) is numeric) %}
          <tr>
            <td>{{ el.usrnam }}</td>
            <td>{{ prefix }}SNG{{ 100000 - substr(el.usrnam, prefix|length) }}</td>
            <td>{{ el.descri }}</td>
            <td>{{ el.indema }}</td>
            <td>{{ el.dszona }}</td>
            <td>{% for catalog in el.catalogs %}{{ catalog.dscata }}{% if not loop.last %}|{% endif %}{% else %}&nbsp;{% endfor %}</td>
          </tr>
          {% endfor %}
        </table>
      </div>#}

    </div>
  </div>
</div>

{% if enableCustomerManagement %}
<!-- Modal for bulk ban status edit -->
<div id="modal-bulk-ban-status" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" aria-labelledby="modal-bulk-status-label">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title" id="modal-bulk-status-label">{{ mt._('admin.enabledisable') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.status') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
                <select class="modal-bulk-ban-status form-control enabled">
                  <option value="0" class="enabled">{{ mt._('account.customer.ban.0') }}</option>
                  <option value="1" class="disabled">{{ mt._('account.customer.ban.1') }}</option>
                  <option value="2" class="disabled">{{ mt._('account.customer.ban.2') }}</option>
                  <option value="3" class="disabled">{{ mt._('account.customer.ban.3') }}</option>
                  <option value="4" class="disabled">{{ mt._('account.customer.ban.4') }}</option>
                  <option value="5" class="disabled">{{ mt._('account.customer.ban.5') }}</option>
                  <option value="6" class="disabled">{{ mt._('account.customer.ban.6') }}</option>
                  <option value="999" class="disabled">{{ mt._('account.customer.ban.999') }}</option>
                </select>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="bulk-ban-update" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-form-error"></div>
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}

<!-- Modal for bulk create users -->
<div id="modal-bulk-create" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" aria-labelledby="modal-bulk-create-label">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title" id="modal-bulk-create-label">{{ mt._('admin.enabledisable') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row py-10x" style="line-height:18px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customer.canlogin') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <select class="modal-bulk-create-status form-control muted" data-type="enabled">
                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
              </select>
            </div>
          </div>
          <div class="row py-10x" style="line-height:18px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customer.canorder') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <select class="modal-bulk-create-status form-control" data-type="orders_enabled">
                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
              </select>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="bulk-create" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-form-error"></div>
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- Modal for bulk reset users password -->
<div id="modal-bulk-reset" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" aria-labelledby="modal-bulk-reset-label">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title" id="modal-bulk-reset-label">{{ mt._('admin.enabledisable') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row py-10x" style="line-height:18px">
            <h4>{{ mt._('admin.resetpassword.disclaimer') }}</h4>
          </div>
          <div class="row py-10x" style="line-height:18px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.send.email') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <label class="checkbox-customer checkbox-container">
                <input type="checkbox" name="sendMail" value="1"/>
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="bulk-reset" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-form-error"></div>
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for bulk login status edit -->
<div id="modal-bulk-login-status" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" aria-labelledby="modal-bulk-status-label">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title" id="modal-bulk-status-label">{{ mt._('admin.enabledisable') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row py-10x" style="line-height:18px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customer.canlogin') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <select class="modal-bulk-login-status form-control muted" data-type="enabled">
                <option value="-1" class="muted">{{ mt._('admin.nomutate') }}</option>
                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
              </select>
            </div>
          </div>
          <div class="row py-10x" style="line-height:18px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customer.canorder') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <select class="modal-bulk-login-status form-control" data-type="orders_enabled">
                <option value="-1" class="text-muted">{{ mt._('admin.nomutate') }}</option>
                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
              </select>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="bulk-login-update" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-form-error"></div>
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for modify user -->
<div class="modal fade modal-modify-user" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel2">{{ mt._('admin.customers.modifycustomer') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.code') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' id="modal-code"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.type') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' id="modal-type"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.description') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' id="modal-description"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.status') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' id="modal-status">
              <select class="modal-ban-status form-control" {{ (enableCustomerManagement ? '' : 'readonly  tabindex="-1"') }}>
                <option value="0" class="enabled">{{ mt._('account.customer.ban.0') }}</option>
                <option value="1" class="disabled">{{ mt._('account.customer.ban.1') }}</option>
                <option value="2" class="disabled">{{ mt._('account.customer.ban.2') }}</option>
                <option value="3" class="disabled">{{ mt._('account.customer.ban.3') }}</option>
                <option value="4" class="disabled">{{ mt._('account.customer.ban.4') }}</option>
                <option value="5" class="disabled">{{ mt._('account.customer.ban.5') }}</option>
                <option value="6" class="disabled">{{ mt._('account.customer.ban.6') }}</option>
                <option value="999" class="disabled">{{ mt._('account.customer.ban.999') }}</option>
              </select>
            </div>
          </div>
        </div>
        <div class="modal-section">
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right' style="line-height:23px">{{ mt._('session.register.username') }}</div>
            <div class='col-md-4 col-sm-4 col-xs-4'><input type="text" value="" id="modal-username"  class="form-control"/></div>
            <div class='col-md-4 col-sm-4 col-xs-4 fs11' id="modal-edit-password-box">
              <label class="checkbox-container">
                <input type="checkbox" id="modal-edit-password" checked />  {{ mt._('admin.dontmodifypassword') }}
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
          </div>
          <div class="row pb-10x" id="modal-password-box" style="line-height:18px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('session.register.password') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" value="" id="modal-password" class="form-control"/></div>
          </div>
          <div class="row pb-10x" id="modal-repeatpassword-box" style="line-height:18px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('session.register.confirmpassword') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" value="" id="modal-repeatpassword"  class="form-control"/></div>
          </div>
          <div class="row py-10x" style="line-height:18px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customer.canlogin') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <select class="modal-login-status form-control" data-type="enabled">
                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
              </select>
              <div class="msg-form-error-row left" id="modal-login-enabled-error"></div>
            </div>
          </div>
          <div class="row py-10x" style="line-height:18px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.customer.canorder') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <select class="modal-login-status form-control" data-type="orders_enabled">
                <option value="0" class="disabled">{{ mt._('admin.disabled') }}</option>
                <option value="1" class="enabled">{{ mt._('admin.enabled') }}</option>
              </select>
            </div>
          </div>
        </div>
        <div >
          <div class="row py-10x" style="line-height:25px">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-7x'>{{ mt._('admin.catalogs') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' style="height:135px;overflow-y:auto">
              <div class="row">
                {% for catalog in catalogs %}
                <div class="col-md-12 col-sm-12 col-xs-12 py-8x px-10x">
                  <label class="checkbox-container">
                    <input type="checkbox" class="catalog-checkbox" name="catalog-checkbox[]" id="checkbox-{{ catalog.cdcata }}" value="{{ catalog.cdcata }}"/>  {{ catalog.dscata }}
                    <span class="checkbox-checkmark"></span>
                  </label>
                </div>
                {% endfor %}
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="save-user" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-form-error"></div>
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for manage shippings -->
<div class="modal fade modal-manage-shippings" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-md w-80">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.customers.manageshippings') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <input type="hidden" value="false" id="is-changed"/>
      <input type="hidden" value="" id="current-cdanag"/>
      <input type="hidden" value="" id="current-tpanag"/>
      <div class="modal-body">

      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="new-shipping">{{ mt._('admin.customers.newshipping') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

{% if enableBudget %}
<div class="modal fade modal-show-budget" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg w-100" role="document" style="max-width:100%">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('cart.analysis.full') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <input type="hidden" id="budget-tpanag"/>
      <input type="hidden" id="budget-cdanag"/>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row mb-10x">
            <div class="col-md-2 bold text-right" style="line-height:34px">{{ mt._('account.budget.selectseason') }}</div>
            {% if seasons|length > 0 %}
            <div class="col-md-3 form-element form-select">
              <select class="form-control" id="season-budget-selector">
                {% for season in seasons %}
                <option value="{{ season.cdstag }}">{{ season.cdstag }} - {{ season.dsstag }}</option>
                {% endfor %}
              </select>
            </div>
            <div class="col-md-2 bold text-right" style="line-height:34px">{{ mt._('account.budget.selectgrouping') }}</div>
            <div class="col-md-3 form-element form-select">
              <select class="form-control" id="grouping-budget-selector">
                <option value="0">{{ mt._('_common.budget.grouping.line') }}</option>
                <option value="1">{{ mt._('_common.budget.grouping.drop') }}</option>
              </select>
            </div>
            <div class="col-md-2" id="load-budget">
              <button type="button" class="btn btn-primary waves-effect waves-light" id="load-budget">{{ mt._('account.budget.load') }}</button>
            </div>
            {% else %}
            {{ mt._('account.customer.noseason') }}
            {% endif %}
          </div>
        </div>
        <div class="py-10x" id="budget-box" style="overflow-x:auto">

        </div>
      </div>
    </div>
  </div>
</div>
{% endif %}
