<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.customdiscount') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row py-10x">
          <div class="col-md-8">&nbsp;</div>
          <div class="col-md-4 text-right">
            <a href="{{ url('admin/editCustomDiscount') }}" class="btn btn-primary w-40">{{ mt._('admin.newdiscount') }}</a>
          </div>
        </div>

        {% if discounts|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <table id="table-discount" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class='capitalize'>{{ mt._('_common.code.short') }}</th>
                  <th class='capitalize'>{{ mt._('_common.description') }}</th>
                  <th class='capitalize'>{{ mt._('_common.customers') }}</th>
                  <th class='capitalize'>{{ mt._('_common.pricelists') }}</th>
                  <th class='capitalize'>{{ mt._('_common.catalogs') }}</th>
                  <th class='capitalize'>{{ mt._('admin.validfrom') }}</th>
                  <th class='capitalize'>{{ mt._('admin.validto') }}</th>
                  <th class='capitalize'>{{ mt._('_common.status') }}</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                {% for discount in discounts %}
                <tr data-numdis="{{ discount.numdis }}">
                  <td class="numdis">{{ discount.numdis }}</td>
                  <td>{{ discount.dsdisc }}</td>
                  <td>{{ discount.fltota == 0 ? discount.totana : mt._('_common.allp') }}</td>
                  <td>{{ discount.totlis }}</td>
                  <td>{{ discount.totctl }}</td>
                  <td><span style='display:none'>{{ discount.dtiniz_sort }}</span>{{ discount.dtiniz }}</td>
                  <td><span style='display:none'>{{ discount.dtfine_sort }}</span>{{ discount.dtfine }}</td>
                  <td>
                    <select class="table-discount-status w-100 p-5x {{ discount.flbloc == 0 ? 'enabled' : 'disabled' }}">
                      <option value="0" {% if discount.flbloc == 0 %}selected{% endif %} class="enabled">{{ mt._('admin.enabled') }}</option>
                      <option value="1" {% if discount.flbloc == 1 %}selected{% endif %} class="disabled">{{ mt._('admin.disabled') }}</option>
                    </select>
                  </td>
                  <td class="center" style="vertical-align:middle">
                    <a href="{{ url('admin/editCustomDiscount/' ~ discount.numdis) }}" class="modify-discount pr-10x" title="{{ mt._('admin.discount.modifydiscount') }}">
                      <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                    </a>
                    <a href="#" class="delete-discount" title="{{ mt._('admin.discount.deletediscount') }}" data-toggle='modal' data-target='.modal-delete-numdis'>
                      <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                    </a>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
        {% endif %}
      </div>

    </div>
  </div>
</div>

<!-- Modal for delete discount -->
<div class="modal fade modal-delete-numdis" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-delete-numdis" name="modal-delete-numdis"/>
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel2">{{ mt._('admin.discount.deletediscount') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.discount.deletewarning') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-discount" data-action="">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
