<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.customvariantsbis') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row mt-10x">
          <div class="col-md-6 col-sm-6 col-xs-12 form-group">&nbsp;</div>
          <div class="col-md-3 col-sm-3 col-xs-12 text-right">
            <button type="button" class="btn btn-primary waves-effect waves-light m-0 w-30" id="download-csv">{{ mt._('_common.download.csv') }}</button>
          </div>
          <div class="col-md-3 col-sm-3 col-xs-12 text-right">
            <button type="button" class="btn btn-primary waves-effect waves-light m-0 w-30" id="send-email">{{ mt._('_common.send.email') }}</button>
          </div>
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>

        {% if variants is defined and variants|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">

            <table id="table-variants" class="table table-striped table-bordered">
              <thead style="text-transform:capitalize">
                <tr>
                  <th>{{ mt._('_common.code.provisional') }}</th>
                  <th>{{ mt._('_common.model') }}</th>
                  {% for feature in features %}
                  <th>{{ feature.dscomp }}</th>
                  {% endfor %}
                  <th>{{ mt._('_common.orders') }}</th>
                  <th>{{ mt._('_common.quantity') }}</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                {% for el in variants %}
                <tr data-cdarti="{{ el.cdarti }}">
                  <td><span>{{ el.cdarti }}</span></td>
                  <td><span>{{ el.cdartn }}</span></td>
                  {% for feature in features %}
                    {% set value = '&nbsp;' %}
                    {% for elementFeature in el.features %}
                      {% if elementFeature.tpcomp == feature.tpcomp %}
                        {% set value = elementFeature.valore %}
                      {% endif %}
                    {% endfor %}
                  <td><span>{{ value }}</span></td>
                  {% endfor %}
                  <td>
                  {% if el.presence > 0 and el.orders|length > 0 %}
                    {% for order in el.orders %}
                    <span>{{ order.nuordc }}</span><br/>
                    {% endfor %}
                  {% endif %}
                  </td>
                  <td>
                  {% if el.presence > 0 and el.orders|length > 0 %}
                    {% for order in el.orders %}
                    <span>{{ order.quanti }}</span><br/>
                    {% endfor %}
                  {% endif %}
                  </td>
                  <td>
                    {% if el.presence == 0 %}
                    <a href="#" class="delete-variant" title="{{ mt._('admin.customvariants.delete') }}" data-toggle='modal' data-target='.modal-delete-variant'>
                      <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                    </a>
                    {% endif %}
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
        {% endif %}

      </div>
    </div>
  </div>
</div>

<!-- Modal for delete variants -->
<div class="modal fade modal-delete-variant" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <input type="hidden" id="modal-delete-cdarti" name="modal-delete-cdarti"/>
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.customvariants.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.customvariants.deletewarning') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-variant" data-action="">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
