<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.coupon.list') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row">
          <div class="col-md-8 col-sm-8 col-xs-8">
            <span class="inline-menu-title">{{ mt._('admin.massiveactions') }}:</span> <span class="inline-menu-title"><a  data-toggle='modal' data-target='.modal-delete-coupon' class="pointer">{{ mt._('admin.coupon.delete') }}</a></span>
          </div>
          <div class="col-md-4 col-sm-4 col-xs-4 right p-0">
            <span class="inline-menu-title"><a class="pointer" id="new-coupon" data-toggle='modal' data-target='.modal-modify-coupon'>{{ mt._('admin.coupon.new') }}</a></span>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-bulk-error left fl" id="bulk-error"></div>
          </div>
        </div>

        {% if coupons is defined and coupons|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">

            <table id="table-coupons" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class="no-sort"></th>
                  <th>{{ mt._('_common.code') }}</th>
                  <th>{{ mt._('_common.description') }}</th>
                  <th>{{ mt._('_common.validity') }}</th>
                  <th>{{ mt._('admin.coupon.use') }}</th>
                  <th>{{ mt._('admin.coupon.type') }}</th>
                  <th></th>
                </tr>
              </thead>

              <tbody>
              {% for coupon in coupons %}
                <tr>
                  <td class="cb">
                    <label class="checkbox-container">
                      <input type="checkbox" name="status-checkbox[]" value="{{ coupon.cdcoup }}"/>
                      <span class="checkbox-checkmark"></span>
                    </label>
                  </td>
                  <td><span>{{ coupon.cdcoup }}</span></td>
                  <td><span>{{ coupon.dscoup }}</span></td>
                  <?php
                    $today = date("Y-m-d");
                    $dtiniz = date("Y-m-d", strtotime(str_replace('-','/', $coupon->dtiniz)));
                    $dtfine = date("Y-m-d", strtotime(str_replace('-','/', $coupon->dtfine)));
                    $dtiniz_ok = explode('-', $dtiniz);
                    $dtfine_ok = explode('-', $dtfine);
                    $validity = (strtotime($today) >= strtotime($dtiniz) && strtotime($today) <= strtotime($dtfine));
                  ?>
                  <td><span {% if not validity %}class="text-danger"{% endif %}>{{ dtiniz_ok[2] }}/{{ dtiniz_ok[1] }}/{{ dtiniz_ok[0] }} - {{ dtfine_ok[2] }}/{{ dtfine_ok[1] }}/{{ dtfine_ok[0] }}</span></td>
                  <td><span>{{ coupon.tpuser == 0 ? mt._('_common.allp') : mt._('_common.limited') }}</span></td>
                  <td><span>{% if coupon.tpcoup == 0 %}{{ mt._('admin.coupon.freedelivery') }}{% elseif coupon.tpcoup == 1 %}{{ coupon.impsco }}% {{ mt._('_common.cart') }}{% elseif coupon.tpcoup == 2 %}{{ coupon.impsco }}€ {{ mt._('_common.discount') }}{% endif %}</span></td>
                  <td class='center' style='vertical-align:middle'>
                    <span data-toggle='modal' data-target='.modal-modify-coupon'>
                      <a class='pointer modify-coupon' title="{{ mt._('admin.coupon.modifycoupon') }}" data-cdcoup="{{ coupon.cdcoup }}"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span></a>
                    </span>
                  </td>
                </tr>
              {% endfor %}
              </tbody>
            </table>

          </div>
        </div>
        {% endif %}

      </div>
    </div>
  </div>
</div>

<!-- Modal for modify/new coupon -->
<div class="modal fade modal-modify-coupon" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">
      <input type="hidden" id="mode" name="mode"/>
      <div class="modal-header">
        <h4 class="modal-title" id="modal-title-edit"></h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row pb-10x fs15"><div class='col-md-12 modal-section-title'>{{ mt._('admin.coupon.general') }}</div></div>
          <div class="row pb-10x" id="row-code">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title right'>{{ mt._('_common.code') }}</div>
            <div class='col-md-9 col-sm-9 col-xs-9' id="modal-coupon-code"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title right mt-7x'>{{ mt._('_common.description') }}</div>
            <div class='col-md-9 col-sm-9 col-xs-9' id="modal-coupon-description"><input type="text" id="dscoup" value="" class="p-5x"/></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title right mt-7x'>{{ mt._('admin.coupon.coupontype') }}</div>
            <div class='col-md-9 col-sm-9 col-xs-9' id="modal-coupon-type">
              <div class="form-element form-select">
                <select class="form-control" id="tpcoup" class="p-5x">
                  <option value="0">{{ mt._('admin.coupon.freedelivery') }}</option>
                  <option value="1">{{ mt._('admin.coupon.discountcart') }}</option>
                  <option value="2">{{ mt._('admin.coupon.discounttotal') }}</option>
                </select>
              </div>
            </div>
          </div>
          <div class="row pb-10x" style="display:none" id="row-amount">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title right mt-7x'>{{ mt._('_common.amount') }}</div>
            <div class='col-md-9 col-sm-9 col-xs-9' id="modal-coupon-amount"><input type="text" id="impsco" value="" class="p-5x"/></div>
          </div>
        </div>
        <div class="modal-section">
          <div class="row py-10x fs15"><div class='col-md-12 modal-section-title'>{{ mt._('_common.validity') }}</div></div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title right mt-7x'>{{ mt._('_common.period') }}</div>
            <div class='col-md-9 col-sm-9 col-xs-9'>
              <input type="hidden" style="width:200px" name="period" id="period" class="form-control" value=""/>
              <div id="period-box" class="row py-5x px-10x ml-0" style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:250px">
                <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
                <div class='col-md-9 px-0'><span></span></div>
                <div class='col-md-1 px-0'><b class="caret"></b></div>
              </div>
            </div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title right mt-7x'>{{ mt._('admin.coupon.amountmin') }}</div>
            <div class='col-md-2 col-sm-2 col-xs-2'><input type="text" id="qtamin" value="" class="p-5x" style="width:90px"/></div>
            <div class='col-md-2 col-sm-2 col-xs-2 modal-section-title right mt-7x'>{{ mt._('admin.coupon.amountmax') }}</div>
            <div class='col-md-5 col-sm-5 col-xs-5'><input type="text" id="qtamax" value="" class="p-5x" style="width:90px"/></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title right mt-7x'>{{ mt._('admin.coupon.usage') }}</div>
            <div class='col-md-2 col-sm-2 col-xs-2 mt-7x'>
              <label class="radio-container">
                <input type="radio" checked name="radio-usage" value="0"> {{ mt._('admin.coupon.always') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-3 col-sm-3 col-xs-3 mt-7x'>
              <label class="radio-container">
                <input type="radio" name="radio-usage" value="1"> {{ mt._('admin.coupon.limitpercoupon') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-3 col-sm-3 col-xs-3 mt-7x'>
              <label class="radio-container">
                <input type="radio" name="radio-usage" value="2"> {{ mt._('admin.coupon.limitperuser') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-1 col-sm-1 col-xs-1'><input type="text" id="limit" value="" name="limit" class="p-5x" style="display:none;width:40px;margin-left:-10px"/></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title right mt-7x'>{{ mt._('admin.catalogs') }}</div>
            <div class='col-md-2 col-sm-2 col-xs-2 mt-7x'>
              <label class="radio-container">
                <input type="radio" checked name="radio-catalogs" value="0"> {{ mt._('_common.allp') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-7 col-sm-7 col-xs-7 mt-7x'>
              <label class="radio-container">
                <input type="radio" name="radio-catalogs" value="1"> {{ mt._('_common.selected') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
          </div>
          <div class="row pb-10x" style="display:none" id="row-catalogs">
            <div class='col-md-3 col-sm-3 col-xs-3'></div>
            <div class='col-md-9 col-sm-9 col-xs-9'>
              <div class="form-element form-select">
                <select class="form-control" id="catalogs-select" name="catalogs" multiple="multiple">
                  {% for catalog in catalogs %}
                  <option value="{{ catalog.cdcata }}">{{ catalog.cdcata }} - {{ catalog.dscata }}</option>
                  {% endfor %}
                </select>
              </div>
            </div>
          </div>
        </div>
        <div>
          <div class="row py-10x fs15"><div class='col-md-12 modal-section-title'>{{ mt._('_common.users') }}</div></div>
          <div class="row pb-10x">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title right mt-7x'>{{ mt._('admin.coupon.type') }}</div>
            <div class='col-md-2 col-sm-2 col-xs-2 mt-7x'>
              <label class="radio-container">
                <input type="radio" checked name="radio-type" value="0"> {{ mt._('_common.allp') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-2 col-sm-2 col-xs-2 mt-7x'>
              <label class="radio-container">
                <input type="radio" name="radio-type" value="1"> {{ mt._('_common.agents') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-2 col-sm-2 col-xs-2 mt-7x'>
              <label class="radio-container">
                <input type="radio" name="radio-type" value="3"> {{ mt._('_common.customers') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-3 col-sm-3 col-xs-3 mt-7x'>
              <label class="radio-container">
                <input type="radio" name="radio-type" value="5"> {{ mt._('_common.shippings') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
          </div>
          <div class="row pb-10x" style="display:none" id="row-type2">
            <div class='col-md-3 col-sm-3 col-xs-3 modal-section-title'></div>
            <div class='col-md-2 col-sm-2 col-xs-2 mt-7x'>
              <label class="radio-container">
                <input type="radio" checked name="radio-type2" value="0"> {{ mt._('_common.allp') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
            <div class='col-md-2 col-sm-2 col-xs-2 mt-7x'>
              <label class="radio-container">
                <input type="radio" name="radio-type2" value="1"> {{ mt._('_common.selected') }}
                <span class="radio-checkmark"></span>
              </label>
            </div>
          </div>
          <div class="row pb-10x" style="display:none" id="row-agents">
            <div class='col-md-3 col-sm-3 col-xs-3'></div>
            <div class='col-md-9 col-sm-9 col-xs-9'>
              <div class="form-element form-select">
                <select class="form-control" id="agents-select" name="agents" multiple="multiple">
                  {% for agent in agents %}
                  <option value="{{ agent.id_usr }}">{{ agent.cdagen }} - {{ agent.dsagen }}</option>
                  {% endfor %}
                </select>
              </div>
            </div>
          </div>
          <div class="row pb-10x" style="display:none" id="row-customers">
            <div class='col-md-3 col-sm-3 col-xs-3'></div>
            <div class='col-md-9 col-sm-9 col-xs-9'>
              <div class="form-element form-select">
                <select class="form-control" id="customers-select" name="customers" multiple="multiple">
                  {% for customer in customers %}
                  <option value="{{ customer.id_usr }}">{{ customer.cdanag }} - {{ customer.descri }}</option>
                  {% endfor %}
                </select>
              </div>
            </div>
          </div>
          <div class="row pb-10x" style="display:none" id="row-shippings">
            <div class='col-md-3 col-sm-3 col-xs-3'></div>
            <div class='col-md-9 col-sm-9 col-xs-9'>
              <div class="form-element form-select">
                <select class="form-control" id="shippings-select" name="shippings" multiple="multiple">
                  {% for shipping in shippings %}
                  <option value="{{ shipping.id_usr }}">{{ shipping.cddesm }} - {{ shipping.desdsm }}</option>
                  {% endfor %}
                </select>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="save-coupon" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-form-error"></div>
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete coupon -->
<div class="modal fade modal-delete-coupon" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">
      <input type="hidden" id="mode" name="mode"/>
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel2">{{ mt._('admin.coupon.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.coupon.deletewarning') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="delete-coupon" data-action="">{{ mt._('admin.coupon.delete') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
