<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.checkprices') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row mt-10x">
          <div class="col-md-12 mb-10x" style="font-weight:bold">{{ mt._('_common.catalogs') }}</div>
          {% for catalog in catalogs %}
          <div class="col-md-2">
            <label class="checkbox-container">
              <input type="checkbox" name="catalog-checkbox[]" value="{{ catalog.cdcata }}"/> {{ catalog.cdcata }}
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
          {% endfor %}
        </div>

        <div class="row mt-30x">
          <div class="col-md-12 mb-10x" style="font-weight:bold">{{ mt._('_common.seasons') }}</div>
          {% for season in seasons %}
          <div class="col-md-2">
            <label class="checkbox-container">
              <input type="checkbox" name="season-checkbox[]" value="{{ season.cdstag }}"/> {{ season.cdstag }}
              <span class="checkbox-checkmark"></span>
            </label>
          </div>
          {% endfor %}
        </div>

        <div class="row mt-30x">
          <div class='col-md-12 mb-10x' style="font-weight:bold">{{ mt._('_common.period') }}</div>
          <div class='col-md-6'>
            <input type="hidden" style="width:200px" name="period" id="period" class="form-control" value=""/>
            <div id="period-box" class="row py-5x px-10x ml-0" style="background:#fff;cursor:pointer;border:1px solid #ccc;line-height:28px;width:250px">
              <div class='col-md-2 px-0'><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></div>
              <div class='col-md-9 px-0'><span></span></div>
              <div class='col-md-1 px-0'><b class="caret"></b></div>
            </div>
          </div>
        </div>

        <div class="row mt-30x">
          <div class="col-md-9 col-sm-9 col-xs-12 form-group">&nbsp;</div>
          <div class="col-md-3 col-sm-3 col-xs-12 text-right">
            <button type="button" class="btn btn-primary waves-effect waves-light m-0 w-30" id="download-csv">{{ mt._('_common.download.csv') }}</button>
          </div>
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>

        {% if articles is defined and articles|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">

            <table id="table-articles" class="table table-striped table-bordered">
              <thead style="text-transform:capitalize">
                <tr>
                  <th>{{ mt._('_common.code') }}</th>
                  <th>{{ mt._('_common.quantity') }}</th>
                  <th>{{ mt._('_common.ordernumber') }}</th>
                  <th>{{ mt._('_common.catalog') }}</th>
                  <th>{{ mt._('_common.season') }}</th>
                  <th>{{ mt._('_common.date') }}</th>
                </tr>
              </thead>
              <tbody>
                {% for el in articles %}
                <tr
                  data-cdarti="{{ el.cdarti }}" data-quanti="{{ el.quanti }}" data-nuordc="{{ el.nuordc }}"
                  data-cdcata="{{ el.cdcata }}" data-cdstag="{{ el.cdstag }}" data-dtcrea="{{ el.dtcrea }}"
                  data-dtcrea-human="{{ el.dtcrea_human }}">
                  <td><span>{{ el.cdarti }}</span></td>
                  <td><span>{{ el.quanti }}</span></td>
                  <td><span>{{ el.nuordc }}</span></td>
                  <td><span>{{ el.cdcata }}</span></td>
                  <td><span>{{ el.cdstag }}</span></td>
                  <td><span>{{ el.dtcrea_human }}</span></td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
        {% endif %}

      </div>
    </div>
  </div>
</div>
