<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.users') }} - {{ mt._('admin.menu.agents') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">
        <div class="row">
          <div class="col-md-8 col-sm-8 col-xs-8">
            <span class="inline-menu-title">{{ mt._('admin.massiveactions') }}:</span> <span class="inline-menu-title"><a href="#" id="bulk-enable">{{ mt._('admin.enableusers') }}</a></span> <span class="inline-menu-title"><a href="#" id="bulk-disable">{{ mt._('admin.disableusers') }}</a></span>
          </div>
          <div class="col-md-4 col-sm-4 col-xs-4 right p-0"></div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-bulk-error left fl" id="bulk-error"></div>
          </div>
        </div>

        {% if headoffices is defined and headoffices|length > 0 %}
        <div class="row py-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">

            <table id="table-headoffices" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class="no-sort"></th>
                  <th>{{ mt._('admin.agents.headoffice') }}</th>
                  <th>{{ mt._('admin.agents.name') }}</th>
                  <th>{{ mt._('admin.username') }}</th>
                  <th>{{ mt._('admin.catalogs') }}</th>
                  <th>{{ mt._('admin.status') }}</th>
                  <th>{{ mt._('_common.email') }}</th>
                  <th></th>
                </tr>
              </thead>

              <tbody>
                {% for el in headoffices %}
                <tr id="{{ el.cdagen }}">
                  <td class="cb">
                    {% if el.id_usr != -1 %}
                    <label class="checkbox-container">
                      <input type="checkbox" name="status-checkbox[]" value="{{ el.id_usr }}"/>
                      <span class="checkbox-checkmark"></span>
                    </label>
                    {% endif %}
                  </td>
                  <td class="cdagen"><span>{{ el.cdagen }}</span></td>
                  <td><span>{{ el.dsagen }}</span></td>
                  <td><span>{{ el.usrnam }}</span></td>
                  <td>
                    {% if el.catalogs|length > 0 %}
                    <span class="lowercase">{{ el.catalogs|length }} {{ el.catalogs|length > 1 ? mt._('admin.catalogs') : mt._('admin.catalog') }}</span>
                    <span class="glyphicon glyphicon-bookmark mytooltip fr mt-5x fs13" aria-hidden="true">
                      <span class="tooltiptext">{% for catalog in el.catalogs %}{{ catalog.dscata }}<br/>{% endfor %}</span>
                    </span>
                    {% endif %}
                  </td>
                  <td>
                    {% if el.id_usr != -1 %}
                    <span>
                      <select class="{{ el.enable == 0 ? 'disabled' : 'enabled' }} table-status w-100 p-5x" {% if el.id_usr != -1 %}data-idusr="{{ el.id_usr }}"{% endif %}>
                        <option value="0" {% if el.enable == 0 %}selected{% endif %} class="disabled">{{ mt._('admin.disabled') }}</option>
                        <option value="1" {% if el.enable == 1 %}selected{% endif %} class="enabled">{{ mt._('admin.enabled') }}</option>
                      </select>
                    </span>
                    <div class="msg-form-error-row left" id="limit-error-{{ el.id_usr }}"></div>
                    {% endif %}
                  </td>
                  <td><span>{{ el.indema }}</span></td>
                  <td class="center" style="vertical-align:middle">
                    <span data-toggle='modal' data-target='.modal-modify-user'>
                      <a href="#" class="modify-user" title="{{ mt._('admin.agents.modifyagent') }}"
                        data-cdagen="{{ el.cdagen }}" data-dsagen="{{ el.dsagen }}" data-nulist="{{ el.nulist }}"
                        data-indema="{{ el.indema }}"
                        {% if el.id_usr != -1 %}data-idusr="{{ el.id_usr }}" data-usrnam="{{ el.usrnam }}" data-enable="{{ el.enable }}"{% endif %}
                        {% if el.catalogs|length > 0 %}data-catalogs="{% for catalog in el.catalogs %}{{ catalog.cdcata }}{% if not loop.last %},{% endif %}{% endfor %}"{% endif %}>
                        <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                      </a>
                    </span>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>

          </div>
        </div>
        {% endif %}

        {% if agents is defined and agents|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">

            <table id="table-agents" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th class="no-sort"></th>
                  <th>{{ mt._('admin.agents.agentcode') }}</th>
                  <th>{{ mt._('admin.agents.name') }}</th>
                  <th>{{ mt._('admin.username') }}</th>
                  <th>{{ mt._('admin.catalogs') }}</th>
                  <th>{{ mt._('admin.status') }}</th>
                  <th>{{ mt._('_common.email') }}</th>
                  <th></th>
                </tr>
              </thead>

              <tbody>
                {% for el in agents %}
                <tr id="{{ el.cdagen }}">
                  <td class="cb">
                    <label class="checkbox-container">
                      <input type="checkbox" name="status-checkbox[]" value="{{ el.id_usr }}"/>
                      <span class="checkbox-checkmark"></span>
                    </label>
                  </td>
                  <td class="cdagen"><span>{{ el.cdagen }}</span></td>
                  <td><span>{{ el.dsagen }}</span></td>
                  <td><span>{{ el.usrnam }}</span></td>
                  <td>
                    {% if el.catalogs|length > 0 %}
                    <span class="lowercase">{{ el.catalogs|length }} {{ el.catalogs|length > 1 ? mt._('admin.catalogs') : mt._('admin.catalog') }}</span>
                    <span class="glyphicon glyphicon-bookmark mytooltip fr mt-5x fs13" aria-hidden="true">
                      <span class="tooltiptext">{% for catalog in el.catalogs %}{{ catalog.dscata }}<br/>{% endfor %}</span>
                    </span>
                    {% endif %}
                  </td>
                  <td>
                    {% if el.id_usr != -1 %}
                    <span>
                      <select class="{{ el.enable == 0 ? 'disabled' : 'enabled' }} table-status w-100 p-5x" {% if el.id_usr != -1 %}data-idusr="{{ el.id_usr }}"{% endif %}>
                        <option value="0" {% if el.enable == 0 %}selected{% endif %} class="disabled">{{ mt._('admin.disabled') }}</option>
                        <option value="1" {% if el.enable == 1 %}selected{% endif %} class="enabled">{{ mt._('admin.enabled') }}</option>
                      </select>
                    </span>
                    <div class="msg-form-error-row left" id="limit-error-{{ el.id_usr }}"></div>
                    {% endif %}
                  </td>
                  <td><span>{{ el.indema }}</span></td>
                  <td class="center" style="vertical-align:middle">
                    <span data-toggle='modal' data-target='.modal-modify-user'>
                      <a href="#" class="modify-user" title="{{ mt._('admin.agents.modifyagent') }}"
                        data-cdagen="{{ el.cdagen }}" data-dsagen="{{ el.dsagen }}" data-nulist="{{ el.nulist }}"
                        data-indema="{{ el.indema }}"
                        {% if el.id_usr != -1 %}data-idusr="{{ el.id_usr }}" data-usrnam="{{ el.usrnam }}" data-enable="{{ el.enable }}"{% endif %}
                        {% if el.catalogs|length > 0 %}data-catalogs="{% for catalog in el.catalogs %}{{ catalog.cdcata }}{% if not loop.last %},{% endif %}{% endfor %}"{% endif %}>
                        <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                      </a>
                    </span>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>

          </div>
        </div>
        {% endif %}

      </div>

    </div>
  </div>
</div>

<!-- Modal for modify user -->
<div class="modal fade modal-modify-user" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel2">{{ mt._('admin.agents.modifyagent') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.code') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' id="modal-code"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.description') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' id="modal-description"></div>
          </div>
        </div>
        <div class="modal-section">
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('session.register.username') }}</div>
            <div class='col-md-4 col-sm-4 col-xs-4'><input type="text" value="" id="modal-username"/></div>
            <div class='col-md-4 col-sm-4 col-xs-4 fs11' id="modal-edit-password-box">
              <label class="checkbox-container">
                <input type="checkbox" id="modal-edit-password" checked />  {{ mt._('admin.dontmodifypassword') }}
                <span class="checkbox-checkmark"></span>
              </label>
            </div>
          </div>
          <div class="row pb-10x" id="modal-password-box">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('session.register.password') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" value="" id="modal-password"/></div>
          </div>
          <div class="row pb-10x" id="modal-repeatpassword-box">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('session.register.confirmpassword') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" value="" id="modal-repeatpassword"/></div>
          </div>
        </div>
        <div class="modal-section" id="modal-section-status">
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.status') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <select id="modal-status">
                <option value="0" id="status-disabled" class="disabled">{{ mt._('admin.disabled') }}</option>
                <option value="1" id="status-enabled" class="enabled">{{ mt._('admin.enabled') }}</option>
              </select>
            </div>
          </div>
        </div>
        <div class="modal-section" id="modal-section-nulist">
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.defaultpricelist') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <div class='row'>
            {% if lstests|length > 0 %}
              {% for lstest in lstests %}
                <div class="col-md-6 py-10x">
                  <label class="radio-container">
                    <input type="radio" name="nulist" value="{{ lstest.nulist }}"> {{ lstest.dslist }}
                    <span class="radio-checkmark"></span>
                  </label>
                </div>
              {% endfor %}
            {% endif %}
              </div>
            </div>
          </div>
        </div>
        <div class="modal-section" id="modal-section-catalogs">
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('admin.catalogs') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' style="height:135px;overflow-y:auto">
              <div class="row">
                {% for catalog in catalogs %}
                <div class="col-md-12 col-sm-12 col-xs-12 py-8x px-10x">
                  <label class="checkbox-container">
                    <input type="checkbox" class="catalog-checkbox" name="catalog-checkbox[]" id="checkbox-{{ catalog.cdcata }}" value="{{ catalog.cdcata }}"/>  {{ catalog.dscata }}
                    <span class="checkbox-checkmark"></span>
                  </label>
                </div>
                {% endfor %}
              </div>
            </div>
          </div>
        </div>
        <div>
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.email') }}</div>
            <div class='col-md-4 col-sm-4 col-xs-4'><input type="text" value="" id="modal-email"/></div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="save-user" data-action="">{{ mt._('_common.save') }}</button>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="msg-form-error"></div>
            <div class="msg-error">{{ mt._('_common.generic.db.error') }}</div>
            <div class="msg-success">{{ mt._('_common.generic.db.success') }}</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
