<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.users') }} - {{ mt._('admin.menu.agents') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">

        {% if headoffices is defined and headoffices|length > 0 %}
        <div class="row py-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">

            <table id="table-headoffices" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th>{{ mt._('admin.agents.headoffice') }}</th>
                  <th>{{ mt._('admin.agents.name') }}</th>
                  <th>{{ mt._('_common.email') }}</th>
                  <th>{{ mt._('_common.users') }}</th>
                  <th></th>
                </tr>
              </thead>

              <tbody>
                {% for el in headoffices %}
                <tr id="{{ el['cdagen'] }}"
                  data-cdagen="{{ el['cdagen'] }}" data-dsagen="{{ el['dsagen'] }}"
                  data-nulist="{{ el['nulist'] }}" data-indema="{{ el['indema'] }}"
                  {{ selectablePriceLists ? 'data-nulist-s="' ~ el['nulist_s'] ~ '"' : '' }}>
                  <td class="cdagen"><span>{{ el['cdagen'] }}</span></td>
                  <td><span>{{ el['dsagen'] }}</span></td>
                  <td><span>{{ el['indema'] }}</span></td>
                  <td><span>{{ el['users'] }}</span></td>
                  <td class="center" style="vertical-align:middle">
                    <span class="pr-20x" data-toggle='modal' data-target='.modal-manage-users'>
                      <a href="#" class="manage-users" title="{{ mt._('admin.agents.manageusers') }}">
                        <span class="glyphicon glyphicon-user" aria-hidden="true"></span>
                      </a>
                    </span>
                    <span data-toggle='modal' data-target='.modal-modify-agent'>
                      <a href="#" class="modify-agent" title="{{ mt._('admin.agents.modifyagent') }}">
                        <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                      </a>
                    </span>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>

          </div>
        </div>
        {% endif %}

        {% if agents is defined and agents|length > 0 %}
        <div class="row pt-25x">
          <div class="col-md-12 col-sm-12 col-xs-12">

            <table id="table-agents" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th>{{ mt._('admin.agents.agentcode') }}</th>
                  <th>{{ mt._('admin.agents.name') }}</th>
                  <th>{{ mt._('_common.email') }}</th>
                  <th>{{ mt._('_common.users') }}</th>
                  <th></th>
                </tr>
              </thead>

              <tbody>
                {% for el in agents %}
                <tr id="{{ el['cdagen'] }}"
                  data-cdagen="{{ el['cdagen'] }}" data-dsagen="{{ el['dsagen'] }}"
                  data-nulist="{{ el['nulist'] }}" data-indema="{{ el['indema'] }}"
                  data-fldfbh="{{ el['fldfbh'] }}"
                  {{ selectablePriceLists ? 'data-nulist-s="' ~ el['nulist_s'] ~ '"' : '' }}>
                  <td class="cdagen"><span>{{ el['cdagen'] }}</span></td>
                  <td><span>{{ el['dsagen'] }}</span></td>
                  <td><span>{{ el['indema'] }}</span></td>
                  <td><span>{{ el['users'] }}</span></td>
                  <td class="center" style="vertical-align:middle">
                    <span class="pr-20x" data-toggle='modal' data-target='.modal-manage-users'>
                      <a href="#" class="manage-users" title="{{ mt._('admin.agents.manageusers') }}">
                        <span class="glyphicon glyphicon-user" aria-hidden="true"></span>
                      </a>
                    </span>
                    <span data-toggle='modal' data-target='.modal-modify-agent'>
                      <a href="#" class="modify-agent" title="{{ mt._('admin.agents.modifyagent') }}">
                        <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                      </a>
                    </span>
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>

          </div>
        </div>
        {% endif %}

      </div>

    </div>
  </div>
</div>

<!-- Modal for modify agent -->
<div class="modal fade modal-modify-agent" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.agents.modifyagent') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.code') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' id="modal-code"></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right'>{{ mt._('_common.description') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8' id="modal-description"></div>
          </div>
        </div>
        <div class="modal-section" id="modal-section-nulist">
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right' style="margin-top:11px">{{ mt._('admin.defaultpricelist') }}</div>
            <div class="col-md-8 col-sm-8 col-xs-8 form-element form-select">
              <select class="form-control selectpicker" id="modal-default-pricelist" data-live-search="true">
                <option value="">&nbsp;</option>
              {% if lstests|length > 0 %}
                {% for lstest in lstests %}
                <option value="{{ lstest.nulist }}">{{ lstest.nulist }} - {{ lstest.dslist }}</option>
                {% endfor %}
              {% endif %}
              </select>
            </div>
          </div>
        </div>
        {% if selectablePriceLists %}
        <div class="modal-section" id="modal-section-selectable-nulist">
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right' style="margin-top:11px">{{ mt._('_common.pricelists.selectable') }}</div>
            <div class="col-md-8 col-sm-8 col-xs-8 form-element form-select">
              <select class="form-control selectpicker" id="modal-selectable-pricelist" multiple>
              {% if lstests|length > 0 %}
                {% for lstest in lstests %}
                <option value="{{ lstest.nulist }}">{{ lstest.nulist }} - {{ lstest.dslist }}</option>
                {% endfor %}
              {% endif %}
              </select>
            </div>
          </div>
        </div>
        {% endif %}
        <div {{ differentBehaviours ? 'class="modal-section"' : '' }}>
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right' style="margin-top:4px">{{ mt._('_common.email') }}</div>
            <div class='col-md-4 col-sm-4 col-xs-4'><input type="text" value="" id="modal-email"/></div>
          </div>
        </div>
        {% if differentBehaviours %}
        <div>
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right' style="margin-top:4px">{{ mt._('_common.differentbehaviour') }}</div>
            <div class='col-md-4 col-sm-4 col-xs-4'>
              <span class="checkbox-container">
                <input type="checkbox" id="modal-different-behaviour">
                <span class="checkbox-checkmark"></span>
              </span>
            </div>
          </div>
        </div>
        {% endif %}
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="save-agent">{{ mt._('_common.save') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for manage users -->
<div class="modal fade modal-manage-users" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('admin.agents.manageusers') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <input type="hidden" value="false" id="is-changed"/>
      <input type="hidden" value="" id="current-cdagen"/>
      <div class="modal-body">

      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="new-user">{{ mt._('admin.agents.newuser') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
