<div class="row">
  <div class="col-md-12 col-sm-12 col-xs-12">
    <div class="x_panel">
      <div class="x_title">
        <h2>{{ mt._('admin.menu.admin') }}</h2>
        <div class="clearfix"></div>
      </div>

      <div class="x_content">

        <div class="row mt-10x">
          <div class="col-md-4 col-sm-4 col-xs-12"></div>
          <div class="col-md-4 col-sm-4 col-xs-12 text-center">
            <button type="button" class="btn btn-primary waves-effect waves-light m-0 w-30" data-toggle="modal" data-target=".modal-add-user">{{ mt._('_common.add') }}</button>
          </div>
        </div>

        {% if admins is defined and admins|length > 0 %}
        <div class="row py-25x">
          <div class="col-md-4"></div>
          <div class="col-md-4">

            <table id="table-users" class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th>{{ mt._('admin.username') }}</th>
                  <th></th>
                </tr>
              </thead>

              <tbody>
                {% for el in admins %}
                <tr id="{{ el.id }}" data-username="{{ el.username }}">
                  <td class="username"><span>{{ el.username }} (id: {{ el.id }})</span></td>
                  <td class="center" style="vertical-align:middle">
                    <span data-toggle='modal' data-target='.modal-edit-user'>
                      <a href="#" class="edit-user" title="{{ mt._('_common.edit') }}">
                        <span class="glyphicon glyphicon-edit" aria-hidden="true"></span>
                      </a>
                    </span>
                    {% if canDelete %}
                    <span class="pl-20x" data-toggle='modal' data-target='.modal-delete-user'>
                      <a href="#" class="delete-user" title="{{ mt._('_common.delete') }}">
                        <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                      </a>
                    </span>
                    {% endif %}
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>

          </div>
        </div>
        {% endif %}

      </div>

    </div>
  </div>
</div>

<!-- Modal for add user -->
<div class="modal fade modal-add-user" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.add') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('admin.username') }}</div>
            <div class='col-md-4 col-sm-4 col-xs-4'><input type="text" class="form-control" id="add-user-username" name="add-user-username" autocomplete="new-username"/></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('session.register.password') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" class="form-control" id="add-user-new-password" name="add-user-new-password" autocomplete="new-password"/></div>
          </div>
          <div class="row">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('session.register.confirmpassword') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" class="form-control" id="add-user-rpt-password" name="add-user-rpt-password" autocomplete="new-rpt-password"/></div>
          </div>
          <div class="row pb-10x">
            <div class='col-md-4 col-sm-4 col-xs-4'></div>
            <div class='col-md-8 col-sm-8 col-xs-8 msg-error text-left'>{{ mt._('session.register.errorconfirm') }}</div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="add-user" disabled>{{ mt._('_common.add') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for edit user -->
<div class="modal fade modal-edit-user" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-50">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.edit') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <div class="modal-section">
          <input type="hidden" id="edit-user-id" name="edit-user-id"/>
          <div class="row py-10x">
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('admin.username') }}</div>
            <div class='col-md-4 col-sm-4 col-xs-4'><input type="text" class="form-control" id="edit-user-username" name="edit-user-username" autocomplete="new-username"/></div>
            <div class='col-md-4 col-sm-4 col-xs-4 modal-edit-password-box'>
              <label class='checkbox-container' style='margin-top:5px'>
                <input type='checkbox' name='edit-user-edit-password' id='edit-user-edit-password' checked /> {{ mt._('admin.dontmodifypassword') }}
                <span class='checkbox-checkmark'></span>
              </label>
            </div>
          </div>
          <div class="row pb-10x modal-password-box" style='display:none'>
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('session.register.password') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" class="form-control" id="edit-user-new-password" name="edit-user-new-password" autocomplete="new-password"/></div>
          </div>
          <div class="row modal-password-box" style='display:none'>
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>{{ mt._('session.register.confirmpassword') }}</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type="password" class="form-control" id="edit-user-rpt-password" name="edit-user-rpt-password" autocomplete="new-rpt-password"/></div>
          </div>
          <div class="row pb-10x modal-password-box" style='display:none'>
            <div class='col-md-4 col-sm-4 col-xs-4'></div>
            <div class='col-md-8 col-sm-8 col-xs-8 msg-error text-left'>{{ mt._('session.register.errorconfirm') }}</div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50" id="edit-user">{{ mt._('_common.edit') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal for delete user -->
<div class="modal fade modal-delete-user" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm w-30">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ mt._('_common.delete') }}</h4>
        <div class="modal-close" data-dismiss="modal">{{ image("assets/img/times.png", "class": "m-0-auto pointer", "alt": mt._('_common.close')) }}</div>
      </div>
      <div class="modal-body">
        <input type="hidden" id="delete-user-id" name="delete-user-id"/>
        <div class="row center"><div class='col-md-12 modal-section-title'>{{ mt._('admin.admin.deletewarning') }}</div></div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">{{ mt._('_common.close') }}</button>
          </div>
          <div class="col-md-6 col-sm-6 col-xs-6">
            <button type="button" class="btn btn-primary right-btn w-50 capitalize" id="delete-user" data-action="">{{ mt._('_common.delete') }}</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
