<?php

namespace Go2B\Tasks\Sync;

use Go2B\Controllers\Utility;
use Go2B\Models\Anagra;
use Go2B\Models\Tipolo;
use Phalcon\DI as Di;

class StandardSync
{
    const IMPORT_FOLDER = '../public/io/import';
    const CUSTOM_IMPORT_FOLDER = '../public/io/csv';
    const IMAGES_FOLDER = '../public/img';

    const XML_NAMES = array(
        'anaage', 'anaart', 'anaeti', 'anagra', 'anaiva', 'anamat', 'ananaz',
        'anaper', 'anatgl', 'anavet', 'anazon', 'artcla', 'artcol', 'artcrt',
        'artvar', 'ascorp', 'assmod', 'astest', 'barcod', 'blocom', 'cracol',
        'crafco', 'cramis', 'cratve', 'ctanag', 'ctarti', 'ctetic', 'cttest',
        'desart', 'deslin', 'desmer', 'dscorp', 'gopart', 'imgart', 'indorc',
        'linmod', 'lkarti', 'lkcorp', 'lkimag', 'lkmode', 'lktest', 'lscorp',
        'lstest', 'lsvcat', 'modvar', 'noccom', 'octest', 'postgl', 'pvcatc',
        'pvcorp', 'pvgrup', 'pvnote', 'pvtest', 'regqta', 'regqtm', 'scacon',
        'scmcon', 'sctest', 'sermod', 'smcorp', 'sparti', 'spmate', 'stoord',
        'svanag', 'svarti', 'svcorp', 'svtest', 'svtipo', 'tabstg', 'tabval',
        'tgagen', 'tglinm', 'tgtest', 'tipcla', 'tipmat', 'tipolo', 'tipvar',
        'titlin', 'tpaggc', 'tpcomp', 'tpcond', 'tpcrar', 'tpgene', 'tpmode',
        'tpmvar', 'tppaga', 'tpport', 'visana',
        'B2B_images', 'B2B_classificazione', 'B2B_discounts',
    );

    public static function sync($echo, $syncImage = true, $syncDescriptions = true)
    {
        foreach (self::XML_NAMES as $xml) {
            if ($syncDescriptions || $xml != 'desart') {
                self::importAction($xml, $syncImage, $echo);
            }
        }
        \Go2B\Models\B2bUsrctl::insertAllRecordsFromCtanag();
        static::postSyncOperations();
    }

    public static function postSyncOperations()
    {
        $di = Di::getDefault();
        $utility = $di->get('utility');
        $spreadImages = boolval($utility->getAppSettings('SpreadNeutralImages'));
        if ($spreadImages) {
            // Applichiamo le immagi dei neutri a tutti gli articoli senza immagine
            $neutralsWithImage = Tipolo::find("flimag IS NOT NULL AND flimag != ''");
            /** @var \Phalcon\Db\Adapter\Pdo\Mysql $db */
            $db = $di->get('db');
            foreach ($neutralsWithImage as $neutral) {
                $db->query("UPDATE anaart SET flimag = :neutralImg WHERE cdartn = :cdartn AND (flimag IS NULL OR flimag = '')", ['cdartn' => $neutral->cdartn, 'neutralImg' => $neutral->flimag]);
            }
        }
    }

    public static function importAction($xmlName, $syncImage, $echo)
    {
        if (is_array($xmlName) && isset($xmlName[0])) {
            $xmlName = $xmlName[0];
            if (!in_array($xmlName, self::XML_NAMES)) {
                $error = "\nERROR: allowed parameters are: ";
                foreach (self::XML_NAMES as $xmlName) {
                    $error .= $xmlName . ", ";
                }
                if ($echo) {
                    echo substr($error, 0, -2) . "\n\n";
                }
                return;
            }
        } else if (!is_string($xmlName)) {
            if ($echo) {
                echo "\nERROR: you must give a parameter!\n\n";
            }
            return;
        }

        if ($echo) {
            echo "[" . date("Y-m-d H:i:s") . "] trying to import " . $xmlName . "\n";
        }

        if ($xmlName == 'B2B_classificazione') {
            CsvB2b::importClassifications();
        } else if ($xmlName == 'B2B_discounts') {
            CsvB2b::importCustomDiscounts();
        } else if ($xmlName == 'B2B_images') {
            // import images
            $fileName = 'B2B_images.zip';
            $zipFilePath = self::IMPORT_FOLDER . '/' . $fileName;
            $newZipFilePath = self::IMPORT_FOLDER . '/_' . $fileName;

            if ($echo) {
                echo "[" . date("Y-m-d H:i:s") . "] searching for file 'B2B_images.zip'... ";
            }

            if (file_exists($zipFilePath)) {
                if ($echo) {
                    echo "SUCCESS!\n";
                }

                // Extract xml
                $zip = new \ZipArchive();
                $res = $zip->open($zipFilePath);

                if ($echo) {
                    echo "[" . date("Y-m-d H:i:s") . "] trying extracting '" . $zipFilePath . "'... ";
                }
                if ($res === TRUE) {
                    $zip->extractTo(self::IMPORT_FOLDER);
                    $zip->close();
                    if ($echo) {
                        echo "SUCCESS!\n";
                    }

                    // Rename file while working on it
                    rename($zipFilePath, $newZipFilePath);
                    $zipFilePath = $newZipFilePath;
                } else {
                    if ($echo) {
                        echo "ERROR!\n";
                    }
                }
            } else {
                if ($echo) {
                    echo "NOT FOUND!\n";
                }
                return 0;
            }

            $folders = array('brand', 'model', 'lookb');

            foreach ($folders as $folder) {
                if (!file_exists(self::IMAGES_FOLDER . '/' . $folder . '/')) {
                    mkdir(self::IMAGES_FOLDER . '/' . $folder . '/', 0777, true);
                }
                if (!file_exists(self::IMPORT_FOLDER . '/' . strtoupper($folder) . '/')) {
                    mkdir(self::IMPORT_FOLDER . '/' . strtoupper($folder) . '/', 0777, true);
                }

                $files = glob(self::IMPORT_FOLDER . '/' . strtoupper($folder) . '/*', GLOB_BRACE);
                foreach ($files as $file) {
                    // Do your work here
                    if (trim($file) != '' && trim($file) != '.' && trim($file) != '..') {
                        try {
                            rename(self::IMPORT_FOLDER . '/' . strtoupper($folder) . '/' . basename($file),
                                self::IMAGES_FOLDER . '/' . $folder . '/' . basename($file));
                        } catch (\Exception $e) {
                            if ($echo) {
                                echo 'Caught exception: ', $e->getMessage(), "\n";
                            }
                        }
                    }
                }

                // Move files to processed folder
                if (file_exists(self::IMPORT_FOLDER . '/' . strtoupper($folder))) {
                    array_map('unlink', glob(self::IMPORT_FOLDER . "/" . strtoupper($folder) . "/*.*"));
                    rmdir(self::IMPORT_FOLDER . '/' . strtoupper($folder));
                }
            }
            rename($zipFilePath, self::IMPORT_FOLDER . '/processed/' . $fileName);
        } else {
            $fileName = $xmlName . '.zip';
            $zipFilePath = self::IMPORT_FOLDER . '/' . $fileName;
            $newZipFilePath = self::IMPORT_FOLDER . '/_' . $fileName;
            $xmlFilePath = self::IMPORT_FOLDER . '/' . $xmlName . '.xml';

            if ($echo) {
                echo "[" . date("Y-m-d H:i:s") . "] searching for file '" . $xmlName . ".zip'... ";
            }

            if (self::extractFile($zipFilePath, $newZipFilePath, $echo)) {
                $xmlObject = simplexml_load_file($xmlFilePath) or die('Error: Cannot create object');

                $tipoagg = $xmlObject->attributes()['tipoagg'];

                $class = '\Go2B\Models\\' . ucfirst($xmlName);

                if (trim($tipoagg) == 'del') {
                    $rows = $class::find();
                    $rows->delete();
                } else if (trim($tipoagg) == 'delstag') {
                    $seasons = $xmlObject->attributes()['cdstag'];
                    $class::deleteSeason($seasons);
                }

                try {
                    if ($xmlName == 'anagra') {
                        $utility = new Utility();
                        $autoSysusr = intval($utility->getAppSettings('CreateSysusrForNewCustomer'));
                        $prefix = $utility->getAppUtils('prefix');
                        $index = $utility->getAppUtils('index');
                        // Sta cosa me sembra parecchio storta ma la faccio cosi per evitare di fare tante query di lettura e scrittura del parametro 'index'
                        foreach ($xmlObject->rec as $record) {
                            $username = null;
                            $password = null;
                            $enabled = null;
                            if ($autoSysusr > 0) {
                                $enabled = $autoSysusr - 1;
                                $username = $prefix . sprintf('%05d', $index);
                                $password = $prefix . "SNG" . sprintf('%05d', (100000 - $index));
                            }
                            $res = $class::saveRecord($record, $tipoagg, $username, $password, $enabled);
                            if ($res > 1) {
                                $index++;
                            }
                        }

                        $utility->setAppUtils('index', $index);
                    } else {
                        foreach ($xmlObject->rec as $record) {
                            if ($xmlName == 'anaart' || $xmlName == 'tipolo') {
                                $class::saveRecord($record, $tipoagg, $syncImage);
                            } else {
                                $class::saveRecord($record, $tipoagg);
                            }
                        }
                    }
                } catch (\Exception $e) {
                    if ($echo) {
                        echo 'Caught exception while saveRecord: ', $e->getMessage(), "\n";
                    }
                }

                rename($newZipFilePath, self::IMPORT_FOLDER . '/processed/' . $fileName);
                rename($xmlFilePath, self::IMPORT_FOLDER . '/processed/' . $xmlName . '.xml');
            }
        }
    }

    public static function extractFile($zipFilePath, $newZipFilePath, $echo)
    {
        try {
            if (file_exists($zipFilePath)) {
                if ($echo) {
                    echo "SUCCESS!\n";
                }

                // Extract xml
                $zip = new \ZipArchive();
                $res = $zip->open($zipFilePath);

                if ($echo) {
                    echo "[" . date("Y-m-d H:i:s") . "] trying extracting '" . $zipFilePath . "'... ";
                }
                if ($res === TRUE) {
                    $zip->extractTo(self::IMPORT_FOLDER);
                    $zip->close();
                    if ($echo) {
                        echo "SUCCESS!\n";
                    }

                    try {
                        // Rename file while working on it
                        rename($zipFilePath, $newZipFilePath);
                        $zipFilePath = $newZipFilePath;
                        return true;
                    } catch (\Exception $e) {
                        if ($echo) {
                            echo 'Caught exception: ' . $e->getMessage() . "\n";
                        }
                        return false;
                    }
                } else {
                    if ($echo) {
                        echo "ERROR!\n";
                    }
                    return false;
                }
            } else {
                if ($echo) {
                    echo "NOT FOUND\n";
                }
                return false;
            }
        } catch (\Exception $e) {
            if ($echo) {
                echo $e->getMessage();
            }
        }
    }
}

?>
