<?php

namespace Go2B\Tasks\Sync;

use Go2B\Controllers\Utility;
use Go2B\Models\CnvDatast;
use Go2B\Models\CnvSyncro;
use Phalcon\Di;

class NavSync
{

    // const ODATA_URL = 'https://odata.kocca.it:7068/TestNUP/api/NBL/PRIME365API/v2.0/companies(ad5ffe68-486f-ee11-823f-00224881ec17)/';
    // const ODATA_USR = 'USERB2B';
    // const ODATA_PWD = 'AppOrdini2024!';
    const SYNC_LOG = true;

    /**
     * Avvia sincronizzazione
     *
     * @param bool $echo Messaggio stampabile
     * @return void
     */
    public static function sync($echo = false, $tipoSync = 'all')
    {
        /**
         * Instanza classi Phalcon
         */
        $di = Di::getDefault();

        /**
         * Instanza classi utility
         * @var Utility $utility
         */
        $utility = $di->get('utility');

        $db = $di->get('db');

        self::checkSyncroTables($echo, $db);
        self::preImport($echo, $db, $tipoSync);

        switch ($tipoSync) {
            case 'all':
                self::syncGroupArtico($echo, $db);
                self::syncGroupListin($echo, $db);
                self::syncGroupDispon($echo, $db);
                self::syncGroupAnagra($echo, $db);
                self::syncGroupStoric($echo, $db);
                break;
            case 'art':
                self::syncGroupArtico($echo, $db);
                break;
            case 'lis':
                self::syncGroupListin($echo, $db);
                break;
            case 'dis':
                self::syncGroupDispon($echo, $db);
                break;
            case 'ana':
                self::syncGroupAnagra($echo, $db);
                break;
            case 'sts':
                self::syncGroupStoric($echo, $db);
                break;
        }
    }

    private static function checkSyncroTables($echo, $db)
    {

        // cnv_syncro
        $query = "CREATE TABLE IF NOT EXISTS `cnv_syncro` (
            `tipdat` varchar(20) NOT NULL COMMENT 'Tipo dato',
            `vals01` varchar(80) NOT NULL DEFAULT '' COMMENT 'Valore stringa 1',
            `vals02` varchar(80) NOT NULL DEFAULT '' COMMENT 'Valore stringa 2',
            `valn01` int(11) NOT NULL DEFAULT 0 COMMENT 'Valore numerico 1',
            `valn02` int(11) NOT NULL DEFAULT 0 COMMENT 'Valore numerico 2',
            `dato01` varchar(80) NOT NULL DEFAULT '' COMMENT 'Dato stringa 1',
            PRIMARY KEY (`tipdat`,`vals01`,`vals02`,`valn01`,`valn02`),
            INDEX `dato01`(`tipdat`, `dato01`)
        )";
        $db->query($query);

        // cnv_datast
        $query = "CREATE TABLE IF NOT EXISTS `cnv_datast` (
            `tipdat` varchar(20) NOT NULL COMMENT 'Tipo dato',
            `dato01` varchar(80) NOT NULL DEFAULT '' COMMENT 'Dato cnv 1',
            `dato02` varchar(80) NOT NULL DEFAULT '' COMMENT 'Dato cnv 2',
            `dato03` varchar(80) NOT NULL DEFAULT '' COMMENT 'Dato cnv 3',
            `newdat` varchar(80) NOT NULL DEFAULT '' COMMENT 'Nuovo dato stringa',
            `newnum` int(11) NOT NULL DEFAULT 0 COMMENT 'Nuovo numerico',
            `descri` varchar(80) NOT NULL DEFAULT '' COMMENT 'Descrizione',
            PRIMARY KEY (`tipdat`,`dato01`,`dato02`,`dato03`),
            INDEX `tipdat`(`tipdat`,`newdat`,`newnum`)
        )";
        $db->query($query);

        // cnv_datast
        $query = "CREATE TABLE IF NOT EXISTS `cnv_artico` (
            `artori` varchar(50) NOT NULL DEFAULT '' COMMENT 'Articolo origine',
            `codvar` varchar(20) NOT NULL DEFAULT '' COMMENT 'Variante',
            `desvar` varchar(80) NOT NULL DEFAULT '' COMMENT 'Descrizione variante',
            `cdartn` varchar(30) NOT NULL DEFAULT '' COMMENT 'Articolo Neutro',
            `cdtagl` varchar(10) NOT NULL DEFAULT '' COMMENT 'Codice taglie',
            `cdarti` varchar(30) NOT NULL DEFAULT '' COMMENT 'Articolo',
            `cdcolo` varchar(10) NOT NULL DEFAULT '' COMMENT 'Codice colore',
            `dsarti` varchar(60) NOT NULL DEFAULT '' COMMENT 'Descrizione articolo',
            `taglia` varchar(30) NOT NULL DEFAULT '' COMMENT 'Taglia',
            `flbloc` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Flag bloccato',
            PRIMARY KEY (`artori`) USING BTREE,
            INDEX `cdartn`(`cdartn`, `codvar`),
            INDEX `cdarti`(`cdarti`, `cdcolo`, `taglia`)
          )";
        $db->query($query);

    }

    private static function preImport($echo, $db, $tipoSync)
    {

        $db->query("TRUNCATE cnv_syncro");

        switch ($tipoSync) {
            case 'all':
                break;
            case 'art':
                break;
            case 'dis':
                break;
        }

    }

    private static function syncGroupArtico($echo, $db)
    {

        echo "ARTICO " . date("Y-m-d H:i:s") . PHP_EOL;

        self::syncCnvSyncroCampaigns($echo, $db);
        self::syncTabstg($echo, $db);
        self::syncTitlin($echo, $db);
        self::syncLinmodSermodTpmode($echo, $db);
        self::syncAnatglPostgl($echo, $db);
        self::syncColori($echo, $db);
        self::syncTipolo($echo, $db);
        self::syncAnaart($echo, $db);
        self::syncBarcod($echo, $db);
        self::syncCtarti($echo, $db);

    }

    private static function syncCnvSyncroCampaigns($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncCnvSyncroCampaigns" . PHP_EOL;

        $filter = 'startingdate le ' . date('Y-m-d') . ' and endingdate ge ' . date('Y-m-d');

        if (($values = self::getOdataApiRecords('campaigns', $filter))) {

            // sposta data fine cataloghi per bloccare in non più passati
            $db->query("UPDATE cttest SET dtfine = DATE_ADD(CURDATE(), INTERVAL -1 DAY)");

            foreach ($values as $rec) {
                if (!Utility::emptyOrSpace(self::jsGet($rec->stagioneDimensionValueCode, ''))) {
                    $syncro['tipdat'] = 'artico.stgatt';
                    $syncro['vals01'] = self::jsGet($rec->stagioneDimensionValueCode, '');
                    $syncro['vals02'] = '';
                    $syncro['valn01'] = 0;
                    $syncro['valn02'] = 0;
                    self::insUpdTableRec($echo, $db, 'cnv_syncro', $syncro, 5);
                }

                if (!Utility::emptyOrSpace(self::jsGet($rec->marchioDimensionValueCode, ''))) {
                    $syncro['tipdat'] = 'artico.titatt';
                    $syncro['vals01'] = self::jsGet($rec->marchioDimensionValueCode, '');
                    $syncro['vals02'] = '';
                    $syncro['valn01'] = 0;
                    $syncro['valn02'] = 0;
                    self::insUpdTableRec($echo, $db, 'cnv_syncro', $syncro, 5);
                }

                // Crea testate cataloghi
                if (!Utility::emptyOrSpace(self::jsGet($rec->no, ''))) {
                    $fields['cdcata'] = self::jsGet($rec->no, '');
                    $fields['dscata'] = self::jsGet($rec->description, '');
                    $fields['dtiniz'] = self::jsGet($rec->startingdate, '');
                    $fields['dtfine'] = self::jsGet($rec->endingdate, '');
                    $fields['cdstag'] = self::jsGet($rec->stagioneDimensionValueCode, '');
                    $fields['cdtitl'] = self::jsGet($rec->marchioDimensionValueCode, '');
                    self::insUpdTableRec($echo, $db, 'cttest', $fields, 1);
                }
            }
        }

        /*
                "no": "PE24",
                "description": "PRIMAVERA/ESTATE 2024",
                "startingdate": "2023-01-01",
                "endingdate": "2024-12-31",
                "marchioDimensionValueCode": "KOC",
                "stagioneDimensionValueCode": "PE24",
                "auxiliaryIndex1": 5071,
                "auxiliaryIndex2": "PE24",
                "auxiliaryIndex3": "MARCHIO",
                "auxiliaryIndex4": 5071,
                "auxiliaryIndex5": "PE24",
                "auxiliaryIndex6": "STAGIONE"
                */
    }

    private static function getOdataApiRecords($api, $filter = '', $urlalt = false, $logdat = false)
    {
        $navConfig = Di::getDefault()->get('config')->get('nav');
        $url = $navConfig->baseUrl;
        $usr = $navConfig->username;
        $pwd = $navConfig->password;

        $auth = base64_encode($usr . ":" . $pwd);

        if ($urlalt) {
            if (!empty($navConfig->dynamicUrl)) {
                $url = $navConfig->dynamicUrl;
            } else {
                $url = str_replace('NBL', 'DYN', $url);
            }
        }

        // echo $url.PHP_EOL;
        $response = null;

        $head = array(
            'Content-Type: application/json',
            'Authorization: Basic  ' . $auth);

        $c_api = $api;
        if (!empty($filter)) $c_api .= '?$filter=' . urlencode($filter);

        try {
            $validResponse = true;
            $watchdog = 0;
            $skiptoken = '';
            $tempResponse = [];

            if ($logdat) echo "   + Get api data [$api]" . PHP_EOL;
            $progre = 0;
            do {
                if (!empty($skiptoken)) {
                    $_api = $c_api . (strpos($c_api, '?') ? '&' : '?') . '$skiptoken=' . urlencode($skiptoken);
                    $skiptoken = '';
                } else {
                    $_api = $c_api;
                }
                // echo 'URL: '.$url.$_api.PHP_EOL;
                $curl = curl_init($url . $_api);

                curl_setopt_array($curl, array(
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                        CURLOPT_HTTPHEADER => $head)
                );

                // Execute and close
                $progre++;
                if ($logdat) echo "      Request $progre" . PHP_EOL;

                $rawResponse = curl_exec($curl);
                curl_close($curl);
                $_response = $rawResponse ? json_decode($rawResponse) : null;

                if (empty($_response) || isset($_response->error) || !isset($_response->value)) {
                    echo sprintf("cURL Error [%s]", isset($_response->error) ? $_response->error->message : 'unknown') . PHP_EOL;
                    $validResponse = false;
                }

                if ($validResponse) {
                    $nextUrl = property_exists($_response, "@odata.nextLink") ? $_response->{"@odata.nextLink"} : '';
                    if (!empty($nextUrl)) {
                        // echo 'Trovata altra pagina: ' . $nextUrl . PHP_EOL;

                        parse_str(parse_url($nextUrl, PHP_URL_QUERY), $nextUrlParams);
                        if (!empty($nextUrlParams['$skiptoken'])) {
                            $skiptoken = $nextUrlParams['$skiptoken'];
                        }
                    }

                    if (isset($_response->value)) {
                        if (!empty($tempResponse))
                            $tempResponse = array_merge($tempResponse, $_response->value);
                        else
                            $tempResponse = $_response->value;
                    }
                }

            } while (!empty($skiptoken) && $validResponse && ++$watchdog < 100);

            if (!empty($tempResponse)) {
                $response = $tempResponse;
                if ($logdat) echo "   + OK, total rows " . count($response) . PHP_EOL;
            }
        } catch (\Exception $exception) {
            echo $exception->getTraceAsString() . PHP_EOL;
        }

        return $response;
    }

    private static function jsGet(&$node, $default)
    {

        return isset($node) ? (is_string($node) ? trim($node) : $node) : $default;

    }

    private static function insUpdTableRec($echo, $db, $table, $fields, $keynum)
    {

        try {
            if (count($fields) == $keynum) {
                $query = "REPLACE INTO `" . $table . "`
                (`" . implode('`,`', array_keys($fields)) . "`)
                VALUES (:" . implode(',:', array_keys($fields)) . ")";
            } else {
                $query = "INSERT INTO `" . $table . "`
                (`" . implode('`,`', array_keys($fields)) . "`)
                VALUES (:" . implode(',:', array_keys($fields)) . ")
                ON DUPLICATE KEY UPDATE ";
                $sep = '';
                foreach (array_slice($fields, $keynum) as $key => $val) {
                    $query .= $sep . "`" . $key . "` = :" . $key;
                    $sep = ',';
                }
            }
            $db->query($query, $fields);
        } catch (\Exception $exception) {
            echo $exception->getMessage() . PHP_EOL;
            // echo $exception->getTraceAsString() . PHP_EOL;
        }

    }

    private static function syncTabstg($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncTabstg" . PHP_EOL;

        if (($values = self::getOdataApiRecords('vrpseasons'))) {
            foreach ($values as $rec) {
                if (Utility::emptyOrSpace(self::jsGet($rec->seasoncode, ''))) continue;
                if (!CnvSyncro::keyExists('artico.stgatt', self::jsGet($rec->seasoncode, ''))) continue;

                $fields['cdstag'] = self::jsGet($rec->seasoncode, '');
                $fields['dsstag'] = self::jsGet($rec->description, '');
                self::insUpdTableRec($echo, $db, 'tabstg', $fields, 1);
            }
        }

    }

    private static function syncTitlin($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncTitlin" . PHP_EOL;

        if (($values = self::getOdataApiRecords('vrpbrands'))) {
            foreach ($values as $rec) {
                if (Utility::emptyOrSpace(self::jsGet($rec->brandcode, ''))) continue;
                if (!CnvSyncro::keyExists('artico.titatt', self::jsGet($rec->brandcode, ''))) continue;

                $fields['cdtitl'] = self::jsGet($rec->brandcode, '');
                $fields['dstitl'] = self::jsGet($rec->description, '');
                self::insUpdTableRec($echo, $db, 'titlin', $fields, 1);
            }
        }

    }

    private static function syncLinmodSermodTpmode($echo, $db)
    {

        if (($values = self::getOdataApiRecords('ItemCategories'))) {
            foreach ($values as $rec) {
                if (Utility::emptyOrSpace(self::jsGet($rec->code, ''))) continue;

                if (Utility::emptyOrSpace(self::jsGet($rec->parentcategory, ''))) {
                    // Linea
                    $fields['cdlinm'] = self::jsGet($rec->code, '');
                    $fields['dslinm'] = self::jsGet($rec->description, '');
                    // $fields['seqrap'] = self::jsGet($rec->presentationorder,'');
                    $fields['cdtitl'] = 'KOC';
                    self::insUpdTableRec($echo, $db, 'linmod', $fields, 1);
                    unset($fields);
                } else {
                    // Serie
                    $fields['cdlinm'] = self::jsGet($rec->parentcategory, '');
                    $fields['cdserm'] = self::jsGet($rec->code, '');
                    $fields['dsserm'] = self::jsGet($rec->description, '');
                    // $fields['seqrap'] = self::jsGet($rec->presentationorder,'');
                    self::insUpdTableRec($echo, $db, 'sermod', $fields, 2);
                    unset($fields);
                }
            }
        }

        /*
        "code": "ABI",
        "parentcategory": "M-ABB",
        "description": "ABITO",
        "indentation": 1,
        "presentationorder": 30000,
        "haschildren": false,
        "lastmodifieddatetime": "2023-07-21T08:03:07.557Z",
        "prime365enabled": true,
        "id": "9524d796-4d64-ed11-823f-00224881ec17"
        */

        // TPMODE
        $query = "INSERT IGNORE INTO tpmode 
                ( tpmode, dstmod ) 
            SELECT sm.cdserm,
                sm.dsserm 
            FROM sermod sm
            INNER JOIN tipolo tp ON tp.cdlinm = sm.cdlinm 
	            AND tp.cdserm = sm.cdserm 
            GROUP BY sm.dsserm";
        $db->query($query);

    }

    private static function syncAnatglPostgl($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncAnatglPostgl" . PHP_EOL;

        if (($values = self::getOdataApiRecords('vrpsizes'))) {
            foreach ($values as $rec) {
                if (Utility::emptyOrSpace(self::jsGet($rec->size, ''))) continue;
                if (intval(self::jsGet($rec->line, '')) <= 0) continue;

                // Anatgl
                $fields['cdtagl'] = self::jsGet($rec->sizeGroupCode, '');
                $fields['dstagl'] = 'Taglie ' . self::jsGet($rec->sizeGroupCode, '');
                self::insTableRec($echo, $db, 'anatgl', $fields);
                unset($fields);

                // Postgl
                $fields['cdtagl'] = self::jsGet($rec->sizeGroupCode, '');
                $fields['postgl'] = intval(self::jsGet($rec->line, ''));
                $fields['taglia'] = self::jsGet($rec->size, '');
                self::insUpdTableRec($echo, $db, 'postgl', $fields, 2);
                unset($fields);
            }
        }

        /*
        "description": "",
        "line": 2,
        "size": "75",
        "sizeGroupCode": "BAF"
        */

        // Genera sequenza assoluta taglie
        /*
            INSERT IGNORE INTO cnv_datast
            (tipdat,dato01,dato02,dato03,newdat,newnum,descri)
            SELECT
            'taglia.seqrap',
            taglia,
            '',
            '',
            '',
            IF( t.seq > 0, t.seq, t.postgl * 100 ) AS seqrap,
            ''
            FROM (
            SELECT postgl.*,
            REPLACE ( taglia, ',', '.' )+ 0 )* 100 AS seq
            FROM postgl
            ORDER BY cdtagl,postgl) AS t
            GROUP BY taglia,seqrap
        */
    }

    private static function insTableRec($echo, $db, $table, $fields)
    {

        try {
            $query = "INSERT IGNORE INTO `" . $table . "`
            (`" . implode('`,`', array_keys($fields)) . "`)
            VALUES (:" . implode(',:', array_keys($fields)) . ")";
            $db->query($query, $fields);
        } catch (\Exception $exception) {
            echo $exception->getTraceAsString() . PHP_EOL;
        }

    }

    private static function syncColori($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncColori" . PHP_EOL;

        if (($values = self::getOdataApiRecords('vrpcolors'))) {
            foreach ($values as $rec) {
                if (Utility::emptyOrSpace(self::jsGet($rec->colorcode, ''))) continue;

                $fields['tipdat'] = 'colori.cdcolo';
                $fields['dato01'] = self::jsGet($rec->colorcode, '');
                $fields['dato02'] = '';
                $fields['dato03'] = '';
                $fields['newdat'] = '';
                $fields['newnum'] = 0;
                $fields['descri'] = self::jsGet($rec->description, '');
                self::insUpdTableRec($echo, $db, 'cnv_datast', $fields, 4);
            }
        }

        /*
        "colorcode": "S0010",
        "description": "BLACK DIAMOND",
        "categorycode": "S",
        "customizedcolorcode": "",
        "usagetype": "Color",
        "redcomponent": 94,
        "greencomponent": 93,
        "blucomponent": 97
        */
    }

    private static function syncTipolo($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncTipolo" . PHP_EOL;

        if (($values = self::getOdataApiRecords('Items'))) {
            // Blocca tutti i modelli
            $db->query("UPDATE tipolo SET flbloc = 1");

            foreach ($values as $rec) {
                if (Utility::emptyOrSpace(self::jsGet($rec->itemNo, ''))) continue;

                $fields['cdartn'] = self::jsGet($rec->itemNo, '');
                $fields['dsartn'] = trim(self::jsGet($rec->description, '') . ' ' . self::jsGet($rec->description2, ''));
                $fields['cdstag'] = self::jsGet($rec->itemSeason, '');
                $fields['cdlinm'] = \Go2B\Models\Sermod::getFirstCdlinmFromCdserm(self::jsGet($rec->itemCategoryCode, ''));
                $fields['cdserm'] = self::jsGet($rec->itemCategoryCode, '');

                $fields['tpgene'] = 'D';
                $fields['tpmode'] = '';
                $fields['ummaga'] = self::jsGet($rec->baseUnitofMeasure, '');
                // In post import
                // $fields['cdtagl'] = xxxxxx;
                // $fields['tglini'] = xxxxxx;
                // $fields['tglfin'] = xxxxxx;
                $fields['tppers'] = '';
                $fields['flbloc'] = 0;
                // $fields['flasso'] = xxxxxx;
                // $fields['flimag'] = xxxxxx;
                // $fields['flvide'] = xxxxxx;
                // $fields['seqrap'] = xxxxxx;
                self::insUpdTableRec($echo, $db, 'tipolo', $fields, 1);

                // Crea collegamento modello brand
                $syncro['tipdat'] = 'tipolo.titlin';
                $syncro['vals01'] = self::jsGet($rec->itemNo, '');
                $syncro['vals02'] = self::jsGet($rec->itemBrand, '');
                $syncro['valn01'] = 0;
                $syncro['valn02'] = 0;
                self::insUpdTableRec($echo, $db, 'cnv_syncro', $syncro, 5);

                if (!Utility::emptyOrSpace(self::jsGet($rec->derivedBy, ''))) {
                    // Crea collegamento modello brand
                    $datast['tipdat'] = 'tipolo.artori';
                    $datast['dato01'] = self::jsGet($rec->itemNo, '');
                    $datast['dato02'] = '';
                    $datast['dato03'] = '';
                    $datast['newdat'] = self::jsGet($rec->derivedBy, '');
                    self::insUpdTableRec($echo, $db, 'cnv_datast', $datast, 4);
                }
            }
        }

        /*
        "systemId": "67a2bfae-4f71-ed11-823f-00224881ec17",
        "itemNo": "P23JAB8903AAUN0000",
        "description": "ABITO",
        "description2": "ODIERA",
        "type": "Inventory",
        "itemCategoryId": "5197f47f-620f-ee11-823f-00224881ec17",
        "itemCategoryCode": "AB",
        "blocked": false,
        "gtin": "",
        "unitPrice": 0,
        "priceIncludesVAT": false,
        "unitCost": 31.24333,
        "taxGroupId": "00000000-0000-0000-0000-000000000000",
        "taxGroupCode": "",
        "baseUnitofMeasure": "PZ",
        "unitofMeasureId": "728ae38a-4d64-ed11-823f-00224881ec17",
        "lastDateModified": "1900-01-01",
        "vrpUseBlocked": "",
        "b2bActive": true,
        "status": "Released",
        "vrpFeatureSetID": 527386,
        "derivedBy": "P23CAB8903AAUN0000",
        "inventory": 51,
        "prime365Enabled": true,
        "itemBrand": "KOCK",
        "itemSeason": "PE23",
        "auxiliaryIndex1": "AB"
        */

        // Assegna tipo modello
        $query = "UPDATE tipolo
            INNER JOIN sermod sm ON sm.cdlinm = tipolo.cdlinm 
                AND sm.cdserm = tipolo.cdserm
            INNER JOIN tpmode tm ON tm.dstmod = sm.dsserm 
            SET tipolo.tpmode = tm.tpmode";
        $db->query($query);

    }

    private static function syncAnaart($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncAnaart" . PHP_EOL;
        if (self::SYNC_LOG) echo "   + Step 1" . PHP_EOL;

        $db->query("UPDATE cnv_artico SET flbloc = 1");

        // Import dati
        if (($values = self::getOdataApiRecords('ItemVariants'))) {
            foreach ($values as $rec) {
                // print_r($rec);
                if (Utility::emptyOrSpace(self::jsGet($rec->itemNo, ''))) continue;
                // if ( !\Go2B\Models\Tipolo::existsAndUnlockedModel($rec->itemNo) ) continue;

                $fields['artori'] = trim(self::jsGet($rec->itemNo, '') . ' ' . self::jsGet($rec->code, ''));

                $fields['codvar'] = self::jsGet($rec->code, '');
                $fields['desvar'] = trim(self::jsGet($rec->description, '') . ' ' . self::jsGet($rec->description2, ''));
                $fields['cdartn'] = self::jsGet($rec->itemNo, '');

                $sep = strpos($fields['codvar'], '-');
                if ($sep > 0) {
                    $fields['cdcolo'] = substr($fields['codvar'], 0, $sep);
                    $fields['taglia'] = substr($fields['codvar'], $sep + 1);
                    //if ($fields['taglia'] == '0') $fields['taglia'] = 'U';
                } else {
                    $fields['cdcolo'] = $fields['codvar'];
                    $fields['taglia'] = '';
                }

                $fields['cdarti'] = trim($fields['cdartn'] . ' ' . $fields['cdcolo']);
                $fields['flbloc'] = 0;

                self::insUpdTableRec($echo, $db, 'cnv_artico', $fields, 1);
                // $fields['cdtagl'] = xxxxxx;
                // $fields['dsarti'] = xxxxxx;
                // $fields['flbloc'] = xxxxxx;
            }
        }

        /*
        "itemNo": "P23JAB8903AAUN0000",
        "description": "ABITO[LATTE/PANNA-10]",
        "description2": "",
        "code": "60725-10",
        "notUsed": false,
        "vrpNotUsed": false,
        "vrpManuallyCancelled": false,
        "manuallyCancelled": false,
        "vrpFeatureSetID": 527386,
        "vrpUseBlocked": "",
            "b2bActive": true,
            "status": "Released",
            "prime365Enabled": true,
            "itemBrand": "KOCK",
            "itemSeason": "PE23",
            "auxiliaryIndex1": "P23JAB8903AAUN0000",
            "auxiliaryIndex2": "AB",
            "notUsed2FilterOnly": null,
            "blockedFilterOnly": null
        */

        unset($fields);

        if (self::SYNC_LOG) echo "   + Step 2" . PHP_EOL;

        // Assegnazione taglie
        $query = "SELECT ca.cdartn,
                ca.strtgl,
                MD5(ca.strtgl) AS md5tgl
            FROM (
                SELECT ca.cdartn,
                    GROUP_CONCAT(ca.taglia ORDER BY IFNULL(cd.newnum,0) SEPARATOR '|') AS strtgl
                FROM (
                    SELECT ca.cdartn,
                        ca.taglia 
                    FROM cnv_artico ca
                    INNER JOIN tipolo tp ON tp.cdartn = ca.cdartn
                    GROUP BY ca.cdartn,ca.taglia) as ca
                LEFT JOIN cnv_datast cd ON cd.tipdat = 'taglia.seqrap' 
                    AND cd.dato01 = ca.taglia 
                    AND cd.dato02 = '' 
                    AND cd.dato03 = ''
                GROUP BY ca.cdartn) AS ca
            LEFT JOIN cnv_datast cd ON cd.tipdat = 'cnvart.md5tgl' 
                AND cd.dato01 = ca.cdartn 
                AND cd.dato02 = '' 
                AND cd.dato03 = '' 
                AND cd.newdat = MD5(ca.strtgl)
            WHERE ISNULL(cd.dato01) ";

        $res = $db->query($query)->fetchAll();

        if (count($res) > 0) {
            foreach ($res as $row) {
                if (($cdtagl = self::getCdtaglFromStrtgl($echo, $db, $row['strtgl']))) {
                    $query = "UPDATE tipolo SET cdtagl = :cdtagl WHERE cdartn = :cdartn";
                    $db->query($query, array('cdtagl' => $cdtagl, 'cdartn' => $row['cdartn']));

                    // Memorizza la firma MD5 della stringa taglie per rilevare le
                    // eventuali modifiche successive
                    $fields['tipdat'] = 'cnvart.md5tgl';
                    $fields['dato01'] = $row['cdartn'];
                    $fields['dato02'] = '';
                    $fields['dato03'] = '';
                    $fields['newdat'] = $row['md5tgl'];
                    self::insUpdTableRec($echo, $db, 'cnv_datast', $fields, 4);
                }
            }
        }

        if (self::SYNC_LOG) echo "   + Step 3" . PHP_EOL;

        // Assegnazione taglia inizio / taglia fine
        $query = "UPDATE tipolo
            INNER JOIN (
	            SELECT tp.cdartn,
                    MIN( pt.postgl ) AS tglini,
                    MAX( pt.postgl ) AS tglfin 
	            FROM tipolo tp
		        LEFT JOIN cnv_artico ca ON ca.cdartn = tp.cdartn
		        LEFT JOIN postgl pt ON pt.cdtagl = tp.cdtagl 
			        AND pt.taglia = ca.taglia
                WHERE tp.flbloc = 0     
	            GROUP BY tp.cdartn ) AS cn ON cn.cdartn = tipolo.cdartn 
	        SET tipolo.tglini = cn.tglini,
	            tipolo.tglfin = cn.tglfin";
        $db->query($query);

        if (self::SYNC_LOG) echo "   + Step 4" . PHP_EOL;

        // Creazione/aggiornamento anaart
        $db->query("UPDATE anaart SET flbloc = 1");

        $query = "INSERT INTO anaart 
                ( cdarti, dsarti, cdartn, flbloc, cdcolo, dscolo ) 
            SELECT *    
            FROM (
                SELECT ca.cdarti,
                    CONCAT(tp.dsartn,' ',IFNULL( co.descri,'')) AS dsarti,
                    ca.cdartn,
                    0 AS flbloc,
                    ca.cdcolo,
                    co.descri AS dscolo
                FROM cnv_artico ca
                INNER JOIN tipolo tp ON tp.cdartn = ca.cdartn
                LEFT JOIN cnv_datast co ON co.tipdat = 'colori.cdcolo' 
                    AND co.dato01 = ca.cdcolo 
                    AND co.dato02 = '' 
                    AND co.dato03 = '' 
                WHERE tp.flbloc = 0 
                    AND ca.flbloc = 0 
                GROUP BY ca.cdarti ) AS ca 
            ON DUPLICATE KEY UPDATE 
                anaart.dsarti = ca.dsarti,
                anaart.flbloc = ca.flbloc,
                anaart.cdcolo = ca.cdcolo,
                anaart.dscolo = ca.dscolo";
        $db->query($query);
    }

    private static function getCdtaglFromStrtgl($echo, $db, $strtgl)
    {

        $query = "SELECT tg.cdtagl
            FROM (
                SELECT pt.cdtagl,
                    COUNT(pt.postgl) AS numtgl,
                    GROUP_CONCAT(pt.taglia ORDER BY IFNULL(cd.newnum,0) SEPARATOR '|') AS strtgl
                FROM postgl pt
                LEFT JOIN cnv_datast AS cd ON cd.tipdat = 'taglia.seqrap' 
                    AND cd.dato01 = pt.taglia 
                    AND cd.dato02 = '' 
                    AND cd.dato03 = '' 
                GROUP BY pt.cdtagl) AS tg
            WHERE tg.strtgl LIKE '%" . $strtgl . "%'
            ORDER BY tg.numtgl
            LIMIT 1";

        return ($res = $db->query($query)->fetch()) ? $res['cdtagl'] : false;

    }

    private static function syncBarcod($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncBarcod" . PHP_EOL;

        if (($values = self::getOdataApiRecords('ItemCrossReferences'))) {
            // print_r($values);
            foreach ($values as $rec) {
                if (Utility::emptyOrSpace(self::jsGet($rec->itemNo, ''))) continue;
                if (Utility::emptyOrSpace(self::jsGet($rec->crossReferenceNo, ''))) continue;
                if (Utility::emptyOrSpace(self::jsGet($rec->variantCode, ''))) continue;

                $fields['tipdat'] = 'barcod.nubrcd';
                $fields['vals01'] = self::jsGet($rec->itemNo, '');
                $fields['vals02'] = self::jsGet($rec->variantCode, '');
                $fields['valn01'] = 0;
                $fields['valn02'] = 0;
                $fields['dato01'] = self::jsGet($rec->crossReferenceNo, '');
                self::insUpdTableRec($echo, $db, 'cnv_syncro', $fields, 5);
            }
        }
        /*
            "itemNo": "1TAD05UN0004",
            "variantCode": "60725",
            "unitofMeasure": "MT",
            "crossReferenceType": "Bar Code",
            "crossReferenceTypeNo": "",
            "crossReferenceNo": "1000000102451",
            "description": "",
            "discontinueBarCode": false,
            "description2": "",
            "blocked": false,
            "vrpUseBlocked": "",
            "b2bActive": false,
            "status": "Released",
            "prime365Enabled": false,
            "itemBrand": "KOC",
            "itemSeason": "PE24",
            "auxiliaryIndex1": "1TAD05UN0004",
            "auxiliaryIndex2": "LEG"
        */

        // Inserisce barcode
        $query = "INSERT INTO barcod
                (nubrcd,cdarti,cdcolo,taglia)
            SELECT *
            FROM (
                SELECT cs.dato01 AS nubrcd,
                    ca.cdarti,
                    '' AS cdcolo,
                    ca.taglia 
                FROM cnv_syncro cs
                INNER JOIN cnv_artico ca ON ca.cdartn = cs.vals01 
                    AND ca.codvar = cs.vals02 
                WHERE cs.tipdat = 'barcod.nubrcd') AS bc
            ON DUPLICATE KEY UPDATE
                barcod.cdarti = bc.cdarti,
                barcod.taglia = bc.taglia";
        $db->query($query);

        // Inserisce barcode campioni
        $query = "INSERT INTO barcod
                (nubrcd,cdarti,cdcolo,taglia)
            SELECT *
            FROM (
                SELECT cs.dato01 AS nubrcd,
                    ca.cdarti,
                    '' AS cdcolo,
                    ca.taglia 
                FROM cnv_datast cd
                INNER JOIN cnv_syncro cs ON cs.tipdat = 'barcod.nubrcd' 
                    AND cs.vals01 = cd.newdat
                INNER JOIN cnv_artico ca ON ca.cdartn = cd.dato01 
                    AND ca.codvar = cs.vals02 
                WHERE cd.tipdat = 'tipolo.artori') AS bc
            ON DUPLICATE KEY UPDATE
                barcod.cdarti = bc.cdarti,
                barcod.taglia = bc.taglia";
        $db->query($query);
    }

    private static function syncCtarti($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncCtarti" . PHP_EOL;

        $db->query("TRUNCATE ctarti");

        $query = "INSERT IGNORE INTO ctarti
                (cdcata,cdarti,seqrap)
            SELECT ct.cdcata,
	            ar.cdarti,
	            0 AS seqrap 
            FROM cttest ct
	        INNER JOIN tipolo tp ON tp.cdstag = ct.cdstag 
	            AND tp.flbloc = 0
	        INNER JOIN cnv_syncro cm ON cm.tipdat = 'tipolo.titlin' 
	            AND cm.vals01 = tp.cdartn 
	            AND cm.vals02 = ct.cdtitl
	        INNER JOIN anaart ar ON ar.cdartn = tp.cdartn 
            WHERE ar.flbloc = 0 
                AND curdate() BETWEEN ct.dtiniz 
                AND ct.dtfine";
        $db->query($query);

    }

    private static function syncGroupListin($echo, $db)
    {

        echo "LISTIN " . date("Y-m-d H:i:s") . PHP_EOL;

        self::syncLstest($echo, $db);
        self::syncLscorp($echo, $db);

    }

    private static function syncLstest($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncLstest" . PHP_EOL;

        if (($values = self::getOdataApiRecords('CustomerPriceGroups'))) {
            foreach ($values as $rec) {
                $syncro['tipdat'] = 'lstest.nulist';
                $syncro['vals01'] = self::jsGet($rec->code, '');
                $syncro['vals02'] = '';
                $syncro['valn01'] = '';
                $syncro['valn02'] = '';
                $syncro['dato01'] = self::jsGet($rec->description, '0');
                self::insUpdTableRec($echo, $db, 'cnv_syncro', $syncro, 5);
            }
        }

        /*
            "code": "SALDIFULL",
            "description": "Saldi Full",
            "vatbuspostinggrprice": "",
            "priceincludesvat": false,
            "allowinvoicedisc": true,
            "allowlinedisc": true
        */
    }

    private static function syncLscorp($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncLscorp" . PHP_EOL;

        $filter = "salescode ne '' and startingdate le " . date('Y-m-d') . " and (endingdate eq 0001-01-01 or endingdate ge " . date('Y-m-d') . ")";
        if (($values = self::getOdataApiRecords('VRPSalesPrices', $filter))) {
            foreach ($values as $rec) {
                $syncro['tipdat'] = 'lscorp.prezzo';
                $syncro['vals01'] = self::jsGet($rec->salescode, '');
                $syncro['vals02'] = self::jsGet($rec->itemno, '');
                $syncro['valn01'] = '';
                $syncro['valn02'] = '';
                $syncro['dato01'] = self::jsGet($rec->unitprice, '0');
                self::insUpdTableRec($echo, $db, 'cnv_syncro', $syncro, 5);
            }
        }

        /*
            "itemno": "A18JGO887108UN0651",
            "salescode": "OUT40",
            "currencycode": "",
            "startingdate": "2021-01-01",
            "unitprice": 38.93,
            "priceincludesvat": false,
            "allowinvoicedisc": true,
            "vatbuspostinggrprice": "",
            "salestype": "Customer Price Group",
            "minimumquantity": 0,
            "endingdate": "2099-01-01",
            "shortcutdimension1code": "",
            "shortcutdimension2code": "",
            "dimensionsetid": 0,
            "unitofmeasurecode": "PZ",
            "variantcode": "",
            "allowlinedisc": true,
            "entryno": 83736,
            "vrpfeaturesetid": 0,
            "parententryno": 0,
            "isvisible": true,
            "variantscount": 0
        */

        // Inserisce corpo listino
        $query = "INSERT INTO lscorp
                (nulist,cdarti,taglia,cdvalu,prezzo)
            SELECT *
            FROM (
                SELECT cs.vals01 AS nulist,
	                ar.cdarti,
	                '' AS taglia,
	                'EUR' AS cdvalu,
	                cs.dato01 AS prezzo 
                FROM cnv_syncro cs
                INNER JOIN tipolo tp ON tp.cdartn = cs.vals02
                INNER JOIN anaart ar ON ar.cdartn = tp.cdartn
                INNER JOIN cnv_datast cd ON cd.tipdat = 'anagra.nulist'
                    AND cd.dato01 = cs.vals01
                    AND cd.dato02 = ''
                    AND cd.dato03 = '' 
                WHERE cs.tipdat = 'lscorp.prezzo' 
                    AND cs.vals01 > '') AS p
            ON DUPLICATE KEY UPDATE
                lscorp.prezzo = p.prezzo";
        $db->query($query);

        // Inserisce teste listino
        $query = "INSERT INTO lstest
                (nulist,dslist,seqrap,cdvalu,dtiniz,dtfine)
            SELECT *
            FROM (
                SELECT cs.vals01 AS nulist,
                    cs.dato01 AS dslist,
                    0 AS seqrap,
                    'EUR' AS cdvalu,
                    CURDATE() AS dtiniz,
                    '2099-12-31' AS dtfine
                FROM cnv_syncro cs
                INNER JOIN lscorp ls ON ls.nulist = cs.vals01
                WHERE cs.tipdat = 'lstest.nulist'
                GROUP BY cs.vals01) AS l
            ON DUPLICATE KEY UPDATE
                lstest.dslist = l.dslist";
        $db->query($query);

    }

    private static function syncGroupDispon($echo, $db)
    {

        echo "DISPON " . date("Y-m-d H:i:s") . PHP_EOL;

        self::syncDscorp($echo, $db);

    }

    private static function syncDscorp($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncDscorp" . PHP_EOL;

        if (($values = self::getOdataApiRecords("itemsAvailability", "availability gt 0", true))) {
            foreach ($values as $rec) {
                $syncro['tipdat'] = 'dispon.quanti';
                $syncro['vals01'] = self::jsGet($rec->itemNo, '');
                $syncro['vals02'] = self::jsGet($rec->variantCode, '');
                $syncro['valn01'] = 0;
                $syncro['valn02'] = 0;
                $syncro['dato01'] = self::jsGet($rec->availability, '');
                self::insTableRec($echo, $db, 'cnv_syncro', $syncro);
            }
        }

        /*
            "itemNo": "A14RSC188907UN0000",
            "variantCode": "00016-39",
            "availability": 2
        */

        $query = "INSERT IGNORE INTO dscorp
                (cdarti,cdcolo,cdvari,cdasso,taglia,dtdisp,quanti)
            SELECT ar.cdarti,
                '' AS cdcolo,
                '' AS cdvari,
                '' AS cdasso,
                ca.taglia,
                CURDATE() AS dtdisp,
                cs.dato01 AS quanti
            FROM cnv_syncro cs
            INNER JOIN cnv_artico ca ON ca.cdartn = cs.vals01
                AND ca.codvar = cs.vals02
            INNER JOIN anaart ar ON ar.cdarti = ca.cdarti
            INNER JOIN tipolo tp ON tp.cdartn = ar.cdartn
            INNER JOIN postgl pt ON pt.cdtagl = tp.cdtagl
                AND pt.taglia = ca.taglia
            WHERE cs.tipdat = 'dispon.quanti'";
        $db->query($query);

    }

    private static function syncGroupAnagra($echo, $db)
    {

        echo "ANAGRA " . date("Y-m-d H:i:s") . PHP_EOL;

        self::syncAnanaz($echo, $db);
        self::syncAnagra($echo, $db);
        self::syncDesmer($echo, $db);
        self::syncAnaage($echo, $db);
        self::syncUtenti($echo, $db);
        self::syncAnareg($echo, $db);
        self::syncAgeanaCustomer($echo, $db);
        self::syncCommissionRules($echo, $db);
        self::syncWebDelivery($echo, $db);
        self::postImportAna($echo, $db);

    }

    private static function syncAnanaz($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncAnanaz" . PHP_EOL;

        if (($values = self::getOdataApiRecords("Countries", "", true))) {
            foreach ($values as $rec) {
                if (Utility::emptyOrSpace(self::jsGet($rec->code, ''))) continue;

                $ananaz['cdnazi'] = self::jsGet($rec->code, '');
                $ananaz['dsnazi'] = self::jsGet($rec->displayName, '');
                self::insTableRec($echo, $db, 'ananaz', $ananaz);
            }
        }

        /*
            "id": "999e528d-1c67-ed11-823f-00224881ec17",
            "code": "AB",
            "displayName": "Antigua e Barbuda",
            "isoCode": "AG",
            "addressFormat": "City+Post Code",
            "lastModifiedDateTime": "2024-01-15T15:23:57.463Z",
            "registeredPostalCode": false
        */

    }

    private static function syncAnagra($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncAnagra" . PHP_EOL;

        if (($values = self::getOdataApiRecords("Customers", "blocked eq ' '"))) {
            // Blocco tutti
            $db->query("UPDATE anagra SET cdblco = 999, dtblco = CURDATE()");

            foreach ($values as $rec) {
                if (substr(self::jsGet($rec->no, ''), 0, 2) != 'C0') continue;

                $anagra['tpanag'] = 'CL';
                $anagra['cdanag'] = self::jsGet($rec->no, '');
                $anagra['descri'] = self::jsGet($rec->name, '');
                $anagra['desvid'] = substr(self::jsGet($rec->name, ''), 0, 20);
                $anagra['indiri'] = self::jsGet($rec->address, '');
                $anagra['codcap'] = self::jsGet($rec->postCode, '');
                $anagra['ccitta'] = self::jsGet($rec->city, '');
                $anagra['provin'] = self::jsGet($rec->county, '');
                $anagra['cdnazi'] = self::jsGet($rec->country, '');
                $anagra['idlang'] = 'IT';
                $anagra['cdzona'] = self::jsGet($rec->zonaStat, '');
                if ($anagra['cdnazi'] == 'IT') {
                    $anagra['pariva'] = self::jsGet($rec->vatRegistrationNo, '');
                    $anagra['codfis'] = '';
                } else {
                    $anagra['pariva'] = '';
                    $anagra['codfis'] = self::jsGet($rec->vatRegistrationNo, '');
                }
                $anagra['numtel'] = self::jsGet($rec->phoneNo, '');
                // $anagra['numcel'] = xxxxxx;
                // $anagra['numfax'] = xxxxxx;
                // $anagra['intern'] = xxxxxx;
                $anagra['indema'] = self::jsGet($rec->eMail, '');
                // $anagra['indem2'] = xxxxxx;
                // $anagra['percon'] = xxxxxx;
                $anagra['cdvalu'] = 'EUR';
                $anagra['tpaggc'] = 'GEN';

                // Listino - solo per utilizzati
                if (!Utility::emptyOrSpace(self::jsGet($rec->customerPriceGroup, ''))) {
                    $syncro['tipdat'] = 'anagra.nulist';
                    $syncro['dato01'] = self::jsGet($rec->customerPriceGroup, '');
                    $syncro['dato02'] = '';
                    $syncro['dato03'] = '';
                    self::insTableRec($echo, $db, 'cnv_datast', $syncro);
                }

                $anagra['nulist'] = self::jsGet($rec->customerPriceGroup, '');
                // $anagra['rulist'] = xxxxxx;
                // $anagra['nuscon'] = xxxxxx;
                // $anagra['scont1'] = xxxxxx;
                // $anagra['scont2'] = xxxxxx;
                // $anagra['scont3'] = xxxxxx;

                // Porto
                if ($newnum = CnvDatast::dataInSerial($db, 'tpport.tpport', self::jsGet($rec->shipmentMethodCode, ''))) {
                    $tpport['tpport'] = str_pad($newnum, 4, '0', STR_PAD_LEFT);
                    $tpport['dstpor'] = self::jsGet($rec->shipmentMethodCode, '');
                    self::insTableRec($echo, $db, 'tpport', $tpport);
                } else {
                    $tpport['tpport'] = '';
                }

                $anagra['tpport'] = $tpport['tpport'];

                // Pagamento
                if ($newnum = CnvDatast::dataInSerial($db, 'tppaga.tppaga', self::jsGet($rec->paymentMethodCode, ''), self::jsGet($rec->paymentTermsCode, ''))) {
                    $tppaga['tppaga'] = str_pad($newnum, 4, '0', STR_PAD_LEFT);
                    $tppaga['dspaga'] = trim(self::jsGet($rec->paymentMethodCode, '') . ' ' . self::jsGet($rec->paymentTermsCode, ''));
                    self::insTableRec($echo, $db, 'tppaga', $tppaga);
                } else {
                    $tppaga['tppaga'] = '';
                }

                $anagra['tppaga'] = $tppaga['tppaga'];

                // $anagra['cdesen'] = xxxxxx;
                // $anagra['codabi'] = xxxxxx;
                // $anagra['codcab'] = xxxxxx;
                // $anagra['cdiban'] = xxxxxx;
                // $anagra['cdvett'] = xxxxxx;
                // $anagra['cdagen'] = xxxxxx;

                // Sblocco i passati
                $anagra['cdblco'] = 0;
                $anagra['dtblco'] = 0;
                // $anagra['provvi'] = xxxxxx;
                // $anagra['cddesm'] = xxxxxx;
                // $anagra['dtvali'] = xxxxxx;
                // $anagra['newcod'] = xxxxxx;
                // $anagra['priori'] = xxxxxx;
                // $anagra['cdetic'] = xxxxxx;
                // $anagra['latitu'] = xxxxxx;
                // $anagra['longit'] = xxxxxx;
                // $anagra['notdes'] = xxxxxx;
                // $anagra['cdage2'] = xxxxxx;
                // $anagra['cdage3'] = xxxxxx;
                // $anagra['cdage4'] = xxxxxx;
                // $anagra['cdage5'] = xxxxxx;
                // $anagra['indpec'] = xxxxxx;
                // $anagra['uffipa'] = xxxxxx;
                // $anagra['codupr'] = xxxxxx;
                // $anagra['websit'] = xxxxxx;
                // $anagra['cdcana'] = xxxxxx;
                self::insUpdTableRec($echo, $db, 'anagra', $anagra, 2);
            }
        }

        /*
            "no": "2013CLI00000078",
            "name": "kocca*",
            "vatRegistrationNo": "01183350915",
            "address": "PIAZZA SAN GIOVANNI 3",
            "city": "NUORO",
            "territoryCode": "SAR",
            "postCode": "08100",
            "county": "NU",
            "country": "IT",
            "eMail": "curreligiuseppe@gmail.com",
            "phoneNo": "0784255029",
            "customerPriceGroup": "000",
            "paymentTermsCode": "ANTICIPATO",
            "paymentMethodCode": "BONIFICO",
            "shipmentMethodCode": "ASS",
            "customerDiscGroup": "",
            "nblLatitude": 0,
            "nblLogitude": 0,
            "nblappEnabled": true,
            "lastModifiedDateTime": "2022-12-22T09:28:26.02Z",
            "lastDateModified": "2022-12-22",
            "shipmentBlocked": "",
            "blocked": " ",
            "comment": true,
            "salespersonCode": "",
            "zonaStat": "IT-CAM-1",
            "auxiliaryIndex1": "2013CLI00000078",
            "auxiliaryIndex2": 18,
            "auxiliaryIndex3": "2013CLI00000078",
            "auxiliaryIndex4": "ZONA_STAT"
        */

    }

    private static function syncDesmer($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncDesmer" . PHP_EOL;

        if (($values = self::getOdataApiRecords("ShiptoAddresses"))) {
            // Blocco tutti
            $db->query("UPDATE desmer SET cdblco = 999");

            foreach ($values as $rec) {
                if (substr(self::jsGet($rec->customerNo, ''), 0, 2) != 'C0') continue;
                if (!\Go2B\Models\Anagra::existsAndUnlockedCustomer(self::jsGet($rec->customerNo, ''))) continue;

                // Aggiorna il vettore nell'anagrafica clienti e salta
                if (self::jsGet($rec->code, '') == '000') {
                    $anagra['tpanag'] = 'CL';
                    $anagra['cdanag'] = self::jsGet($rec->customerNo, '');
                    $anagra['cdvett'] = self::jsGet($rec->shippingAgentCode, '');
                    self::insUpdTableRec($echo, $db, 'anagra', $anagra, 2);

                    // Per collegamento agenti clienti - Non lo fa più 15/05/2023
                    // $syncro['tipdat'] = 'anades.cdzona';
                    // $syncro['vals01'] = 'CL';
                    // $syncro['vals02'] = self::jsGet($rec->customerNo,'');
                    // $syncro['valn01'] = 0;
                    // $syncro['valn02'] = 0;
                    // $syncro['dato01'] = self::jsGet($rec->dimension1Code,'');
                    // self::insTableRec($echo,$db,'cnv_syncro',$syncro,5);
                    continue;
                }

                $desmer['tpanag'] = 'CL';
                $desmer['cddesm'] = self::jsGet($rec->customerNo, '') . '-' . self::jsGet($rec->code, '');
                $desmer['cdanag'] = self::jsGet($rec->customerNo, '');
                $desmer['descri'] = self::jsGet($rec->name, '') . ' ' . self::jsGet($rec->name2, '');
                $desmer['desvid'] = substr(self::jsGet($rec->name, ''), 0, 20);
                $desmer['indiri'] = self::jsGet($rec->address, '') . ' ' . self::jsGet($rec->address2, '');
                $desmer['codcap'] = self::jsGet($rec->postCode, '');
                $desmer['ccitta'] = self::jsGet($rec->city, '');
                $desmer['provin'] = self::jsGet($rec->county, '');
                $desmer['cdnazi'] = self::jsGet($rec->countryRegionCode, '');
                $desmer['cdzona'] = self::jsGet($rec->dimension1Code, '');
                $desmer['numtel'] = self::jsGet($rec->phoneNo, '');
                // $desmer['numcel'] = self::jsGet($rec->customerNo,'');
                // $desmer['numfax'] = self::jsGet($rec->customerNo,'');
                // $desmer['intern'] = self::jsGet($rec->customerNo,'');
                $desmer['indema'] = self::jsGet($rec->eMail, '');
                $desmer['percon'] = self::jsGet($rec->contact, '');
                $desmer['cdvett'] = self::jsGet($rec->shippingAgentCode, '');
                $desmer['cdblco'] = 0;
                self::insUpdTableRec($echo, $db, 'desmer', $desmer, 2);
            }
        }

        /*
        "customerNo": "C0011773",
        "code": "000",
        "name": "STROCCHI BUS DI STROCCHI STEFANO",
        "name2": "E C  SAS",
        "address": "VIA SAVARNA 124",
        "address2": "",
        "city": "SAVARNA",
        "contact": "",
        "phoneNo": "0544 53 659",
        "telexNo": "",
        "shipmentMethodCode": "DAP",
        "shippingAgentCode": "BRT",
        "placeofExport": "",
        "countryRegionCode": "IT",
        "lastDateModified": "1900-01-01",
        "locationCode": "G-PF",
        "faxNo": "",
        "telexAnswerBack": "MONIA",
        "gln": "",
        "postCode": "48020",
        "county": "RA",
        "eMail": "",
        "homePage": "",
        "taxAreaCode": "",
        "taxLiable": false,
        "shippingAgentServiceCode": "",
        "serviceZoneCode": "",
        "nblLatitude": 0,
        "nblLogitude": 0,
        "dimension1Code": "IT-EMI-1"
        */
    }

    private static function syncAnaage($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncAnaage" . PHP_EOL;

        if (($values = self::getOdataApiRecords("SalespersonCustomers"))) {
            foreach ($values as $rec) {
                if (substr(self::jsGet($rec->customerNo, ''), 0, 2) != 'C0') continue;
                if (!\Go2B\Models\Anagra::existsAndUnlockedCustomer(self::jsGet($rec->customerNo, ''))) continue;

                if ($cdagen = \Go2B\Models\Anaage::getCdagenFromCodice(self::jsGet($rec->salesPersonCode, ''), true)) {
                    $anaage['cdagen'] = $cdagen;
                    $anaage['dsagen'] = self::jsGet($rec->salesPersonCode, '');
                    $anaage['cdzona'] = self::jsGet($rec->zonaStatCode, '');
                    $anaage['codice'] = self::jsGet($rec->salesPersonCode, '');
                    self::insTableRec($echo, $db, 'anaage', $anaage);

                    $cdcata = self::getCatalogFromBrandSeason($db, self::jsGet($rec->brandCode, ''), self::jsGet($rec->campaignCode, ''));

                    // Non lo fa più, fatto trecentesima modifica e l'associazione avviene in SalespersonShipToAddresses
                    // $ageana['tipdat'] = 'C';
                    // $ageana['cdagen'] = $cdagen;
                    // $ageana['tpanag'] = 'CL';
                    // $ageana['codice'] = self::jsGet($rec->customerNo,'');;
                    // self::insTableRec($echo,$db,'ageana',$ageana,4);

                    if (!Utility::emptyOrSpace($cdcata)) {
                        $syncro['tipdat'] = 'anagra.cdcata';
                        $syncro['vals01'] = $cdcata;
                        $syncro['vals02'] = self::jsGet($rec->customerNo, '');
                        $syncro['valn01'] = 0;
                        $syncro['valn02'] = 0;
                        $syncro['dato01'] = '';
                        self::insTableRec($echo, $db, 'cnv_syncro', $syncro, 5);
                    }

                    if (!Utility::emptyOrSpace($cdcata)) {
                        $syncro['tipdat'] = 'anaage.cdcata';
                        $syncro['vals01'] = $cdcata;
                        $syncro['vals02'] = '';
                        $syncro['valn01'] = $cdagen;
                        $syncro['valn02'] = 0;
                        $syncro['dato01'] = '';
                        self::insTableRec($echo, $db, 'cnv_syncro', $syncro, 5);
                    }
                }
            }
        }

        /*
            "salesPersonCode": "0010077",
            "campaignCode": "PE23",
            "zonaStatCode": "IT-SAR-1",
            "brandCode": "KOC",
            "customerNo": "C0010152",
            "group": 2,
            "starting_Date_FilterOnly": null,
            "ending_Date_FilterOnly": null
        */

    }

    private static function getCatalogFromBrandSeason($db, $titlin, $cdstag)
    {

        $query = "SELECT
                c.cdcata 
            FROM
                cttest c
            WHERE
                c.cdstag = :cdstag 
                AND c.cdtitl = :titlin";

        return ($res = $db->query($query, array('cdstag' => $cdstag, 'titlin' => $titlin))->fetch()) ? $res['cdcata'] : '';

    }

    private static function syncUtenti($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncUtenti" . PHP_EOL;
        //Rotta provvisoria da ApiUsers a ApiUsers_Web
        if (($values = self::getOdataApiRecords("ApiUsers_Web", "UserEnabled eq true"))) {
            foreach ($values as $rec) {
                switch (self::jsGet($rec->User_Type, '')) {
                    case 'Agent':
                        if (!($cdagen = \Go2B\Models\Anaage::getCdagenFromCodice(self::jsGet($rec->UserCode, '')))) continue;

                        // Aggiornamento descrizione agente
                        if (!Utility::emptyOrSpace(self::jsGet($rec->UserName, ''))) {
                            $query = "UPDATE anaage 
                                SET dsagen = :dsagen 
                                WHERE cdagen = :cdagen
                                AND codice = dsagen";
                            $db->query($query, array('dsagen' => self::jsGet($rec->UserName, ''), 'cdagen' => $cdagen));
                        }

                        if (\Go2B\Models\B2bSysusr::findFirst(array('username = :codice:', 'bind' => array('codice' => self::jsGet($rec->UserUsername, ''))))) {
                            continue;
                        }

                        // b2b_sysusr
                        $sysusr = new \Go2B\Models\B2bSysusr;
                        $sysusr->username = self::jsGet($rec->UserUsername, '');
                        $sysusr->password = sha1(self::jsGet($rec->UserPassword, ''));
                        $sysusr->enabled = 1;
                        $sysusr->orders_enabled = 1;
                        $sysusr->created_at = date('Y-m-d H:i:s');
                        $sysusr->type = 3;
                        $sysusr->locale = 'it';
                        $sysusr->email_sent = 0;
                        $sysusr->save();

                        // b2b_usrage
                        $usrage = new \Go2B\Models\B2bUsrage();
                        $usrage->id_usr = $sysusr->id;
                        $usrage->cdagen = $cdagen;
                        $usrage->save();
                        break;

                    case 'Customer':
                        if (substr(self::jsGet($rec->UserCode, ''), 0, 2) != 'C0') continue;
                        if (!\Go2B\Models\Anagra::existsAndUnlockedCustomer(self::jsGet($rec->UserCode, ''))) continue;

                        if (\Go2B\Models\B2bSysusr::findFirst(array('username = :codice:', 'bind' => array('codice' => self::jsGet($rec->UserUsername, ''))))) {
                            continue;
                        }

                        // b2b_sysusr
                        $sysusr = new \Go2B\Models\B2bSysusr;
                        $sysusr->username = self::jsGet($rec->UserUsername, '');
                        $sysusr->password = sha1(self::jsGet($rec->UserPassword, ''));
                        $sysusr->enabled = 1;
                        $sysusr->orders_enabled = 1;
                        $sysusr->created_at = date('Y-m-d H:i:s');
                        $sysusr->type = 4;
                        $sysusr->locale = 'it';
                        $sysusr->email_sent = 0;
                        $sysusr->save();

                        $usrana = new \Go2B\Models\B2bUsrana();
                        $usrana->id_usr = $sysusr->id;
                        $usrana->tpanag = 'CL';
                        $usrana->cdanag = self::jsGet($rec->UserCode, '');
                        $usrana->save();
                        break;
                }
            }
        }
        /*
            "@odata.etag": "W/\"JzIwOzEyOTIxNDQxODc4ODExNTIzMTkyMTswMDsn\"",
            "UserGuid": "c11710f6-a08d-4ff5-951d-009e1bd61075",
            "UserCode": "0018662",
            "UserName": "GIUSEPPE COSTANZO",
            "UserBadgeurl": "",
            "UserUsername": "0018662",
            "UserPassword": "K11916G",
            "UserEnabled": true,
            "UserDefaultPricekm": 0,
            "UserMainOffice": "",
            "UserUrlYoutube": "https://www.youtube.com/user/koccaofficial",
            "UserUrlInstagram": "https://www.instagram.com/koccaofficial",
            "UserUrlVideo": "",
            "UserUrlBrochure": "https://prime365orderentry.file.core.windows.net/brochure/KOCCA.zip?sv=2021-04-10&st=2023-03-21T11%3A22%3A05Z&se=2031-11-22T11%3A22%3A00Z&sr=f&sp=r&sig=0zlH6F3fBhr%2FiiPCzwiWRlO52f9tf5hmjW3qHPDjow0%3D",
            "UserTargetAmount": 0,
            "UserRevenueAmount": 0,
            "UserCurrency": "",
            "SalespersonCode": "",
            "SalespersonName": "",
            "NewCustomerAgentCode": "",
            "NewCustomerPriceGroupCode": "",
            "UserAlertMail1": "",
            "UserAlertMail2": "",
            "Prime365ForceUpdate": "0001-01-01T00:00:00Z",
            "User_showorders": false,
            "User_showinvoices": false,
            "User_showledgers": false,
            "User_minversion": "2.01.9905",
            "User_minversion_ios": "2.01.9905",
            "User_minversion_android": "2.01.9905",
            "User_minversion_uwp": "2.1.871",
            "User_Type": "Agent"
      */
    }

    private static function syncAnareg($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncAnareg" . PHP_EOL;

        $filter = 'startingDate le ' . date('Y-m-d') . ' and endingDate ge ' . date('Y-m-d');

        if (($values = self::getOdataApiRecords("koccatradeagreements", $filter))) {

            $db->query("TRUNCATE anareg");

            foreach ($values as $rec) {
                if (substr(self::jsGet($rec->customerNo, ''), 0, 2) != 'C0') continue;
                if (Utility::emptyOrSpace(self::jsGet($rec->dimension1Code, ''))) continue;
                if (Utility::emptyOrSpace(self::jsGet($rec->dimension2Code, ''))) continue;
                if (Utility::emptyOrSpace(self::jsGet($rec->dimension3Code, ''))) continue;
                if (self::jsGet($rec->startingDate, '') > date('Y-m-d')) continue;
                if (self::jsGet($rec->endingDate, '') < date('Y-m-d')) continue;

                if (!\Go2B\Models\Anagra::existsAndUnlockedCustomer(self::jsGet($rec->customerNo, ''))) continue;

                $cdcata = self::getCatalogFromBrandSeason($db, self::jsGet($rec->dimension3Code, ''), self::jsGet($rec->dimension1Code, ''));
                if (empty($cdcata)) continue;

                $anareg['tpanag'] = 'CL';
                $anareg['cdanag'] = self::jsGet($rec->customerNo, '');
                $anareg['cdcata'] = $cdcata;
                $anareg['tpordi'] = self::jsGet($rec->dimension2Code, '');
                $anareg['dtiniz'] = self::jsGet($rec->startingDate, '');
                $anareg['dtfine'] = self::jsGet($rec->endingDate, '');
                $anareg['reoval'] = self::jsGet($rec->reorderValue, 0);
                $anareg['retval'] = self::jsGet($rec->returnValue, 0);
                $anareg['stkval'] = self::jsGet($rec->stockValue, 0);
                $anareg['subval'] = self::jsGet($rec->substitutionValue, 0);
                self::insTableRec($echo, $db, 'anareg', $anareg, 4);
            }
        }
        /*
            "reorderValue": 0,
            "returnValue": 0,
            "stockValue": 0,
            "substitutionValue": 0,
            "allowInvoiceDisc": true,
            "allowLineDisc": false,
            "code": "AI23-24",
            "customerNo": "C0010049",
            "dimension1Code": "AI23-24",
            "dimension2Code": "RES",
            "dimension3Code": "KOC",
            "dimension4Code": "",
            "dimension5Code": "",
            "endingDate": "2024-01-31",
            "invoiceDiscount": 5,
            "lineDiscount": 0,
            "lineDiscount1": 0,
            "lineDiscount2": 0,
            "lineDiscount3": 0,
            "lineDiscount4": 0,
            "lineDiscount5": 0,
            "paymentMethodCode": "RIBA",
            "paymentTermsCode": "30FM",
            "startingDate": "2023-11-02",
            "type": "Contract"
        */
    }

    private static function syncAgeanaCustomer($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncAgeanaCustomer" . PHP_EOL;

        if (($values = self::getOdataApiRecords("SalespersonShipToAddresses"))) {

            $db->query("TRUNCATE ageana");

            foreach ($values as $rec) {
                if (substr(self::jsGet($rec->customerNo, ''), 0, 2) != 'C0') continue;
                if (self::jsGet($rec->code, '') != '000') continue;
                if (Utility::emptyOrSpace(self::jsGet($rec->salesPersonCode, ''))) continue;
                if (!($cdagen = \Go2B\Models\Anaage::getCdagenFromCodice(self::jsGet($rec->salesPersonCode, '')))) continue;

                $ageana['tipdat'] = 'C';
                $ageana['cdagen'] = $cdagen;
                $ageana['tpanag'] = 'CL';
                $ageana['codice'] = self::jsGet($rec->customerNo, '');;
                self::insTableRec($echo, $db, 'ageana', $ageana, 4);
            }
        }

        /*
            "salesPersonCode": "0023983",
            "customerNo": "C0011866",
            "code": "000",
            "name": "PETRUZZELLI E GLIGHINO SNC",
            "name2": "DI STEFANO PETRUZZELLI   CO",
            "address": "VIA S  VINCENZO 102  104 R",
            "address2": "",
            "city": "GENOVA",
            "contact": "",
            "phoneNo": "010 56 56 52",
            "telexNo": "",
            "shipmentMethodCode": "DAP",
            "shippingAgentCode": "BRT",
            "placeofExport": "",
            "countryRegionCode": "IT",
            "lastDateModified": "1900-01-01",
            "locationCode": "G-PF",
            "faxNo": "",
            "telexAnswerBack": "SIG CLAUDIO",
            "gln": "",
            "postCode": "16100",
            "county": "GE",
            "eMail": "",
            "homePage": "",
            "taxAreaCode": "",
            "taxLiable": false,
            "shippingAgentServiceCode": "",
            "serviceZoneCode": "",
            "nblLatitude": 0,
            "nblLogitude": 0,
            "dimension1Code": "IT-LIG-1",
            "auxiliaryIndex1": "C0011866"
        */

    }

    private static function syncCommissionRules($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncCommissionRules" . PHP_EOL;

        // Collegamento destinazioni merce all'agente
        if (($values = self::getOdataApiRecords("koccacommissionrules"))) {
            foreach ($values as $rec) {
                $syncro['tipdat'] = 'salesp.cdzona';
                $syncro['vals01'] = self::jsGet($rec->salesPersonCode, '');
                $syncro['vals02'] = self::jsGet($rec->dimension2Code, '');
                $syncro['valn01'] = 0;
                $syncro['valn02'] = 0;
                $syncro['dato01'] = '';
                self::insTableRec($echo, $db, 'cnv_syncro', $syncro, 5);

                /* Vecchio
                // if ( !($cdagen = \Go2B\Models\Anaage::getCdagenFromCodice(self::jsGet($rec->salesPersonCode,''))) ) continue;

                $p = array('cdagen' => $cdagen,'cdzona' => self::jsGet($rec->dimension2Code,''));
                $query = "INSERT IGNORE INTO ageana
                        (tipdat,cdagen,tpanag,codice)
                    SELECT
                        'D' AS tipdat,
                        g.cdagen,
                        d.tpanag,
                        d.cddesm AS codice
                    FROM
                        desmer d
                        INNER JOIN ageana g ON g.tipdat = 'C'
                        AND g.tpanag = d.tpanag
                        AND g.codice = d.cdanag
                    WHERE
                        g.cdagen = :cdagen
                        AND d.cdzona = :cdzona";
                $db->query($query,$p);
                */
            }
        }

        $query = "INSERT IGNORE INTO ageana
                (tipdat,cdagen,tpanag,codice)
            SELECT
                'D' AS tipdat,
                g.cdagen,
                d.tpanag,
                d.cddesm AS codice
            FROM
                cnv_syncro c
                INNER JOIN anaage g ON g.codice = c.vals01
                INNER JOIN ageana a ON a.tipdat = 'C' 
                AND a.cdagen = g.cdagen
                INNER JOIN desmer d ON d.tpanag = a.tpanag 
                AND d.cdanag = a.codice 
                AND d.cdzona = c.vals02 
            WHERE
                c.tipdat = 'salesp.cdzona'";
        $db->query($query);

        /*
            "commission": 0,
            "commissionType": "%",
            "customerNo": "",
            "customerPriceGroup": "",
            "dimension1Code": "AI14-15",
            "dimension2Code": "IT-TRE-1",
            "dimension3Code": "",
            "dimension4Code": "KOC",
            "dimension5Code": "",
            "elementNo": 1,
            "endingDate": "9999-12-31",
            "fixedAmount": 0,
            "itemCategoryCode": "",
            "itemNo": "",
            "lastModifiedDate": "2024-02-08",
            "lastModifiedTime": "17:33:20.613",
            "lastModifiedUserID": "ADMIN",
            "prevCommission": 0,
            "productGroupCode": "",
            "salesPersonCode": "0010074",
            "startingDate": "0001-01-01",
            "subjectType": " "
        */

    }

    private static function syncWebDelivery($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncWebDelivery" . PHP_EOL;

        $filter = 'webActive eq 1 and startingDate le ' . date('Y-m-d') . 'T00:00:00Z and endingDate ge ' . date('Y-m-d') . 'T00:00:00Z';

        if (($values = self::getOdataApiRecords("webdeliverydates", $filter))) {
            foreach ($values as $rec) {
                $cdcata = self::getCatalogFromBrandSeason($db, self::jsGet($rec->code1PRS, ''), self::jsGet($rec->campaignNo, ''));
                if (empty($cdcata)) continue;

                $syncro['tipdat'] = 'anareg.datcon';
                $syncro['vals01'] = $cdcata;

                switch (self::jsGet($rec->opt1PRS, '') . self::jsGet($rec->opt2PRS, '')) {
                    case '10':
                        $syncro['vals02'] = "STD";
                        break;
                    case '13':
                        $syncro['vals02'] = "STO";
                        break;
                    case '14':
                        $syncro['vals02'] = "SOST";
                        break;
                    case '15':
                        $syncro['vals02'] = "RIASS";
                        break;
                    case '16':
                        $syncro['vals02'] = "SOSTRIASS";
                        break;
                    case '50':
                        $syncro['vals02'] = "RES";
                        break;
                }

                $syncro['valn01'] = 0;
                $syncro['valn02'] = 0;
                $syncro['dato01'] = substr(self::jsGet($rec->requestedDeliveryDate, ''), 0, 10) . '|' . substr(self::jsGet($rec->requestedDeliveryDateLimit, ''), 0, 10);
                self::insTableRec($echo, $db, 'cnv_syncro', $syncro, 5);
            }
        }
        /*
            "campaignNo": "AI23-24",
            "code1PRS": "KOCK",
            "date1PRS": "0001-01-01T00:00:00Z",
            "description": "ai23-24 sost",
            "endingDate": "2024-12-30T23:00:00Z",
            "opt1PRS": 1,
            "opt2PRS": 6,
            "requestedDeliveryDate": "2023-01-01T11:00:00Z",
            "requestedDeliveryDateLimit": "2024-12-30T23:00:00Z",
            "startingDate": "2022-11-01T11:00:00Z",
            "webActive": 1,
            "webDeliveryDateId": "fa5a65fb-6ca9-49fe-8322-2461e59fd4a5"
        */
    }

    private static function postImportAna($echo, $db)
    {

        if (self::SYNC_LOG) echo " + postImportAna" . PHP_EOL;

        // creazione record zone
        $query = "INSERT IGNORE INTO anazon
                (cdzona,dszona)
            SELECT DISTINCT cdzona,cdzona
            FROM anagra
            WHERE cdzona > ''
            UNION
            SELECT DISTINCT cdzona,cdzona
            FROM desmer
            WHERE cdzona > ''";
        $db->query($query);

        // creazione record vettori
        $query = "INSERT IGNORE INTO anavet 
                (cdvett,dsvett)
            SELECT cdvett,cdvett
            FROM anagra
            WHERE cdvett > ''
            UNION
            SELECT cdvett,cdvett
            FROM desmer
            WHERE cdvett > ''";
        $db->query($query);

        // Collegamento clienti/agenti vecchia modalità
        $query = "SELECT
                codice AS cdanag,
                cdagen 
            FROM
                ageana 
            WHERE
                tipdat = 'C'
            ORDER BY tipdat,tpanag,codice,cdagen";

        $res = $db->query($query)->fetchAll();

        if (count($res) > 0) {
            $oldcli = '';
            $eleage = array();

            foreach ($res as $row) {
                if ($oldcli != $row['cdanag']) {
                    if (count($eleage) > 0) {
                        array_push($eleage, 0, 0, 0, 0, 0);
                        $param = array('cdagen' => $eleage[0],
                            'cdage2' => $eleage[1],
                            'cdage3' => $eleage[2],
                            'cdage4' => $eleage[3],
                            'cdage5' => $eleage[4],
                            'cdanag' => $oldcli);
                        $query = "UPDATE anagra
                            SET cdagen = :cdagen,
                                cdage2 = :cdage2, 
                                cdage3 = :cdage3,
                                cdage4 = :cdage4,
                                cdage5 = :cdage5 
                            WHERE 
                                tpanag = 'CL'
                                AND cdanag = :cdanag";
                        $db->query($query, $param);
                    }

                    $eleage = array();
                    $oldcli = $row['cdanag'];
                }
                array_push($eleage, $row['cdagen']);
            }
        }

        // Collegamento agenti/destinazioni in base alla zona geografica
        // Obsoleto, generato da CommissionRules
        /*
        $query = "INSERT IGNORE INTO ageana
                ( tipdat, cdagen, tpanag, codice )
            SELECT
                'D' AS tipdat,
                g.cdagen,
                d.tpanag,
                d.cddesm AS codice
            FROM
                ageana c
            INNER JOIN anaage g ON g.cdagen = c.cdagen
            INNER JOIN desmer d ON d.tpanag = c.tpanag
                AND d.cdanag = c.codice
                AND d.cdzona = g.cdzona
            WHERE
                c.tipdat = 'C'
                AND c.cdagen > 0";
        $db->query($query);
        */

        // Aggiunte clienti ageana degli agenti che hanno almeno una destinazione - non lo fa più 15/05/2023
        /*
        $query = "INSERT IGNORE INTO ageana
                ( tipdat, cdagen, tpanag, codice )
            SELECT
                'C' AS tipdat,
                a.cdagen,
                d.tpanag,
                d.cdanag AS codice
            FROM
                ageana a
                INNER JOIN desmer d ON d.tpanag = a.tpanag
                AND d.cddesm = a.codice
            WHERE
                a.tipdat = 'D'
            GROUP BY
                a.tipdat,
                a.cdagen,
                d.tpanag,
                d.cdanag";
        $db->query($query);
        */

        // Collegamento utenti / cataloghi
        $db->query("TRUNCATE b2b_usrctl");

        $query = "INSERT IGNORE INTO b2b_usrctl
                (id_usr,cdcata)
            SELECT
		        u.id_usr,
		        c.cdcata 
            FROM
		        cnv_syncro s
		        INNER JOIN b2b_usrage u ON u.cdagen = s.valn01
		        INNER JOIN cttest c ON c.cdcata = s.vals01 
            WHERE
		        s.tipdat = 'anaage.cdcata'
		        AND CURDATE() BETWEEN c.dtiniz AND c.dtfine
		
            UNION	

            SELECT
		        u.id_usr,
		        c.cdcata 
            FROM
		        cnv_syncro s
		        INNER JOIN b2b_usrana u ON u.tpanag = 'CL'
				    AND u.cdanag = s.vals02 
		        INNER JOIN cttest c ON c.cdcata = s.vals01 
            WHERE
		        s.tipdat = 'anagra.cdcata'
		        AND CURDATE() BETWEEN c.dtiniz AND c.dtfine";
        $db->query($query);

        // Inserimento tipi ordine mancanti
        $query = "INSERT IGNORE INTO b2b_tipord
                (codice,descri,seqrap,tipord,flbloc)
            SELECT DISTINCT
		        a.tpordi AS codice,
		        a.tpordi AS descri,
                0 AS seqrap,
                0 AS tipord,
                1 AS flbloc 
            FROM
		        anareg a
            WHERE
                a.tpordi > ''";
        $db->query($query);

        // Assegnazione date consegna anareg
        $query = "UPDATE anareg
            INNER JOIN cnv_syncro c ON c.tipdat = 'anareg.datcon' 
                AND c.vals01 = anareg.cdcata 
                AND c.vals02 = anareg.tpordi 
            SET 
                anareg.dtmcli = SUBSTRING_INDEX( dato01, '|', 1 ),
                anareg.dtmmax = SUBSTRING_INDEX( dato01, '|',- 1 )";
        $db->query($query);

        // Rimuove record anareg con data consegna vuota
        $db->query("DELETE FROM anareg WHERE dtmcli = 0");

        // Aggiunta campagne standard anareg da deliverydates
        $query = "REPLACE INTO anareg
                (tpanag,cdanag,cdcata,tpordi,dtiniz,dtfine,reoval,retval,stkval,subval,dtmcli,dtmmax)
            SELECT
                'CL' AS tpanag,
                c.vals02 AS cdanag,
                c.vals01 AS cdcata,
                d.vals02 AS tpordi,
                CURDATE() AS dtiniz,
                DATE_ADD( CURDATE(), INTERVAL 10 DAY ) AS dtfine,
                0 AS reoval,
                0 AS retval,
                0 AS stkval,
                0 AS subval,
                SUBSTRING_INDEX( d.dato01, '|', 1 ) AS dtmcli,
                SUBSTRING_INDEX( d.dato01, '|',- 1 ) AS dtmmax 
            FROM
	            cnv_syncro d
	        INNER JOIN cnv_syncro c ON c.tipdat = 'anagra.cdcata' 
	            AND c.vals01 = d.vals01 
            WHERE
                d.tipdat = 'anareg.datcon' 
                AND d.vals02 = 'STD' 
            GROUP BY
                tpanag,
                cdanag,
                cdcata,
                tpordi";
        $db->query($query);
    }

    
    private static function syncGroupStoric($echo, $db)
    {

        echo "STORIC " . date("Y-m-d H:i:s") . PHP_EOL;

        self::syncShcorp($echo, $db);

    }

    private static function syncShcorp($echo, $db)
    {

        if (self::SYNC_LOG) echo " + syncShcorp" . PHP_EOL;

        $query = "SELECT
                c.cdstag,c.cdtitl 
            FROM
                cttest c
                INNER JOIN anareg r ON r.cdcata = c.cdcata
                INNER JOIN b2b_tipord t ON t.codice = r.tpordi 
            WHERE
                CURDATE() BETWEEN c.dtiniz 
                AND c.dtfine 
                AND r.tpordi IN ( 'RES','SOST','SOSTRIASS' ) 
                AND t.flbloc = 0 
            GROUP BY
                c.cdstag,
                c.cdtitl 
            ORDER BY
                c.cdstag,
                c.cdtitl";

        $res = $db->query($query)->fetchAll();

        if (count($res) > 0) {
            foreach ($res as $row) {
                $filter = "selltocustomerno gt '' " . 
                      "and shortcutdimension1code eq '" . $row['cdtitl'] . "' " .
                      "and shortcutdimension2code eq '" . $row['cdstag'] . "' " .
                      "and sumquantityinvoiced gt 0";

                if (($values = self::getOdataApiRecords("salesLineInvoicedQuantities",$filter,true))) {
                    foreach ($values as $rec) {
                        if (substr(self::jsGet($rec->selltocustomerno, ''), 0, 2) != 'C0') continue;
                        if (Utility::emptyOrSpace(self::jsGet($rec->no, ''))) continue;
                        if (Utility::emptyOrSpace(self::jsGet($rec->variantcode, ''))) continue;
                        if (Utility::emptyOrSpace(self::jsGet($rec->shortcutdimension1code, ''))) continue;
                        if (Utility::emptyOrSpace(self::jsGet($rec->shortcutdimension2code, ''))) continue;
                        
                        $shcorp['tpanag'] = 'CL';
                        $shcorp['cdanag'] = self::jsGet($rec->selltocustomerno, '');
                        
                        if ( !Utility::emptyOrSpace(self::jsGet($rec->shiptocode, '')) && self::jsGet($rec->shiptocode, '') != '000' )
                            $shcorp['cddesm'] = self::jsGet($rec->selltocustomerno, '') . '-' . self::jsGet($rec->shiptocode, '');
                        else 
                            $shcorp['cddesm'] = '';
                
                        $shcorp['cdstag'] = self::jsGet($rec->shortcutdimension2code, '');
                        $shcorp['cdtitl'] = self::jsGet($rec->shortcutdimension1code, '');
        
                        $codvar = self::jsGet($rec->variantcode, '');
                        $sep = strpos($codvar,'-');
                        if ( $sep > 0 ) {
                            $shcorp['cdarti'] = self::jsGet($rec->no, '') . ' ' . substr($codvar, 0, $sep);
                            $shcorp['cdcolo'] = '';
                            $shcorp['taglia'] = substr($codvar, $sep + 1);
                        } else {
                            $shcorp['cdarti'] = self::jsGet($rec->no, '') . ' ' . $codvar;
                            $shcorp['cdcolo'] = '';
                            $shcorp['taglia'] = '';
                        }
                        $shcorp['quanti'] = self::jsGet($rec->sumquantityinvoiced, 0);
                        self::insTableRec($echo, $db, 'shcorp', $shcorp, 8);
                    }
                }
            }
        }

        /*
            "selltocustomerno": "C0010049",
            "no": "A23PBL0314ABFA0000",
            "variantcode": "F6040-S",
            "shortcutdimension1code": "KOC",
            "shortcutdimension2code": "AI23-24",
            "shiptocode": "002",
            "sumquantityinvoiced": 1
        */

    }

    private static function postImport($echo, $db, $tipoSync)
    {

    }

}
