<?php

namespace Go2B\Tasks\Sync;

use Go2B\Controllers\Utility;
use Go2B\Models\B2bClassificazione;
use Go2B\Models\B2bDisana;
use Go2B\Models\B2bDisbdy;
use Go2B\Models\B2bDisctl;
use Go2B\Models\B2bDishea;
use Go2B\Models\B2bDislst;
use Go2B\Models\B2bDispag;
use Go2B\Models\B2bDispor;
use Go2B\Models\Cttest;
use Go2B\Models\Lstest;

class CsvB2b
{
    public static function importClassifications()
    {
        // Apro il file CSV in lettura
        $csvFileName = 'classificazioni.csv';
        $csvFilePath = StandardSync::CUSTOM_IMPORT_FOLDER . '/' . $csvFileName;
        echo $csvFilePath . PHP_EOL;

        if (is_readable($csvFilePath) && ($handle = fopen($csvFilePath, 'r')) !== FALSE) {
            echo 'File Aperto' . PHP_EOL;
            $mappaRiferimenti = [];

            // Leggo riga per riga il file CSV
            $indice = 0;

            // Svuotiamo la tabella
            B2bClassificazione::find()->delete();

            $headers = [];
            $columnIds = [
                'slug' => 'code',
                'desc_it' => 'description',
                'desc_en' => 'en',
                'desc_es' => 'es',
                'desc_fr' => 'fr',
                'desc_de' => 'de',
                'enabled' => 'enabled',
            ];
            $foundColumnIds = [];

            while ($indice++ < 100000 && ($data = fgetcsv($handle)) !== FALSE) {
                $data = array_reverse($data);

                if (empty($headers)) {
                    // Setto le intestazioni e gli indici delle colonne
                    $headers = $data;

                    foreach ($columnIds as $key => $label) {
                        $foundId = array_search($label, $headers);
                        if ($foundId !== false) {
                            $foundColumnIds[$key] = $foundId;
                        }
                    }

                    arsort($foundColumnIds);
                    continue;
                }

                $tupla = [];
                foreach ($foundColumnIds as $key => $columnId) {
                    $tupla[$key] = current(array_splice($data, $columnId, 1));
                }

                if (empty($tupla['desc_it'])) {
                    continue;
                }

                if (empty($tupla['slug'])) {
                    $tupla['slug'] = preg_replace('/[^\w]+/i', '_', strtolower($tupla['desc_it']));
                }
                $tupla['slug'] = substr(trim($tupla['slug'], ' _'), 0, 56);

                if (!array_key_exists('enabled', $tupla)) {
                    $tupla['enabled'] = 1;
                }

                // Recupero id principale e parent id (se presente)
                $loopControl = 100;
                $loopIndex = 0;
                $externalElemId = null;
                $externalParentId = null;
                while ($loopIndex < $loopControl && empty($externalElemId) && !empty($data)) {
                    $externalElemId = array_shift($data);
                }

                if (empty($externalElemId)) {
                    // Non abbiamo trovato il codice
                    continue;
                }

                $tupla['external_id'] = $externalElemId;

                if (!empty($data)) {
                    $externalParentId = array_shift($data);
                    if (array_key_exists($externalParentId, $mappaRiferimenti)) {
                        $tupla['parent_id'] = $mappaRiferimenti[$externalParentId];
                    }
                }

                try {
                    $cat = new B2bClassificazione($tupla);
                    if ($cat->save() == false) {
                        echo print_r($cat->getMessages(), true) . PHP_EOL;
                        continue;
                    }

                    if ($indice % 1000 == 0) {
                        echo 'SALVATI ' . count($mappaRiferimenti) . ' ELEMENTI' . PHP_EOL;
                    }

                    $mappaRiferimenti[$externalElemId] = $cat->id;
                } catch (\Exception $e) {
                    echo $e->getMessage() . PHP_EOL;
                }
            }
            echo 'SALVATI ' . count($mappaRiferimenti) . ' ELEMENTI TOTALI' . PHP_EOL;

            // Chiudo il file
            fclose($handle);
            echo 'File Chiuso' . PHP_EOL;

            rename($csvFilePath, StandardSync::IMPORT_FOLDER . '/processed/' . $csvFileName);
            echo 'File Spostato' . PHP_EOL;
        }
    }

    public static function importCustomDiscounts()
    {
        // Apro il file CSV in lettura
        $csvFileName = 'discounts.csv';
        $csvFilePath = StandardSync::CUSTOM_IMPORT_FOLDER . '/' . $csvFileName;
        echo $csvFilePath . PHP_EOL;

        if (is_readable($csvFilePath) && ($handle = fopen($csvFilePath, 'r')) !== FALSE) {
            echo 'File Aperto' . PHP_EOL;

            // Leggo riga per riga il file CSV
            $indice = 0;
            $salvati = 0;

            $cataloghiCodes = [];
            /** @var Cttest $cttest */
            foreach (Cttest::find() as $cttest) {
                $cataloghiCodes[] = $cttest->cdcata;
            }

            $listiniCodes = [];
            /** @var Lstest $lstest */
            foreach (Lstest::find() as $lstest) {
                $listiniCodes[] = $lstest->nulist;
            }

            // Svuotiamo le tabelle
            // B2bDisbdy::find()->delete();
            // B2bDispor::find()->delete();
            // B2bDispag::find()->delete();
            // B2bDisctl::find()->delete();
            // B2bDislst::find()->delete();
            // B2bDishea::find()->delete();

            $headers = [];
            $columnIds = [
                'cddisc' => 'code',
                'dsdisc' => 'description',
                'dtiniz' => 'start',
                'dtfine' => 'end',
                'flbloc' => 'blocked',
                'fltota' => 'customers',
                'flpora' => 'ports',
                'flpaga' => 'payments',
                'catalogs' => 'catalogs',
                'lists' => 'lists',
                // Body
                'brands' => 'brands',
                'lines' => 'lines',
                'series' => 'series',
                'value' => 'discount',
            ];

            $foundColumnIds = [];

            while ($indice++ < 100000 && ($data = fgetcsv($handle)) !== FALSE) {
                if (empty($headers)) {
                    // Setto le intestazioni e gli indici delle colonne
                    $headers = $data;

                    foreach ($columnIds as $key => $label) {
                        $foundId = array_search($label, $headers);
                        if ($foundId !== false) {
                            $foundColumnIds[$key] = $foundId;
                        }
                    }

                    arsort($foundColumnIds);
                    continue;
                }

                $tupla = [];
                foreach ($foundColumnIds as $key => $columnId) {
                    $tupla[$key] = current(array_splice($data, $columnId, 1));
                }

                if (empty($tupla['cddisc']) || empty($tupla['dtiniz']) || empty($tupla['dtfine'])) {
                    continue;
                }

                if (!array_key_exists('flbloc', $tupla)) {
                    $tupla['flbloc'] = 0;
                }

                if (!empty($tupla['fltota']) && !empty(trim($tupla['fltota']))) {
                    $customerCodes = explode(',', trim($tupla['fltota']));
                    $tupla['fltota'] = (int)($tupla['fltota'] == 'all');
                } else {
                    $customerCodes = [];
                    $tupla['fltota'] = 1;
                }

                if (empty($tupla['flpora'])) {
                    $tupla['flpora'] = 1;
                } else {
                    $portCodes = $tupla['flpora'];
                    $tupla['flpora'] = (int)($tupla['flpora'] == 'all');
                }
                if (empty($tupla['flpaga'])) {
                    $tupla['flpaga'] = 1;
                } else {
                    $paymentCodes = $tupla['flpaga'];
                    $tupla['flpaga'] = (int)($tupla['flpaga'] == 'all');
                }

                // Calcoliamo il tipo di sconto mentre componiamo il corpo
                $tupla['tpdisc'] = 0;
                $brandCodes = [];
                if (!empty($tupla['brands'])) {
                    $tupla['tpdisc'] += 32;
                    $brandCodes = explode(',', $tupla['brands']);
                    unset($tupla['brands']);
                }

                $lineCodes = [];
                if (!empty($tupla['lines'])) {
                    $tupla['tpdisc'] += 16;
                    $lineCodes = explode(',', $tupla['lines']);
                    unset($tupla['lines']);
                }

                $serieCodes = [];
                if (!empty($tupla['series'])) {
                    $tupla['tpdisc'] += 8;
                    $serieCodes = explode(',', $tupla['series']);
                    unset($tupla['series']);
                }

                if (!empty($tupla['catalogs'])) {
                    $catalogCodes = array_intersect(explode(',', preg_replace('/\s/i', '', $tupla['catalogs'])), $cataloghiCodes);
                    unset($tupla['catalogs']);
                } else {
                    $catalogCodes = $cataloghiCodes;
                }

                if (!empty($tupla['lists'])) {
                    $listCodes = array_intersect(explode(',', preg_replace('/\s/i', '', $tupla['lists'])), $listiniCodes);
                    unset($tupla['lists']);
                } else {
                    $listCodes = $listiniCodes;
                }

                /*
                  <option value="32" {{ sel_tl ? 'selected' : '' }}>{{ mt._('_common.brand') }}</option>
                  <option value="16" {{ sel_lm ? 'selected' : '' }}>{{ mt._('_common.line') }}</option>
                  <option value="8" {{ sel_sm ? 'selected' : '' }}>{{ mt._('_common.series') }}</option>
                  <option value="4" {{ sel_tm ? 'selected' : '' }}>{{ mt._('_common.modeltype') }}</option>
                  <option value="2" {{ sel_an ? 'selected' : '' }}>{{ mt._('_common.models') }}</option>
                  <option value="1" {{ sel_ar ? 'selected' : '' }}>{{ mt._('_common.articles') }}</option>
                 */

                try {
                    if (strpos($tupla['dtiniz'], '/') >= 0) {
                        $dtParts = explode('/', $tupla['dtiniz']);
                        $tupla['dtiniz'] = $dtParts[2] . "-" . $dtParts[1] . "-" . $dtParts[0];
                    }

                    if (strpos($tupla['dtfine'], '/') >= 0) {
                        $dtParts = explode('/', $tupla['dtfine']);
                        $tupla['dtfine'] = $dtParts[2] . "-" . $dtParts[1] . "-" . $dtParts[0];
                    }

                    $tupla['value'] = floatval(str_replace(',', '.', $tupla['value']));

                    // Per evitare di modificare informazioni storiche, rompendo i calcoli degli ordini precedenti, evitiamo modifiche
                    $giaPresente = B2bDishea::findFirstByCddisc($tupla['cddisc']);

                    if ($giaPresente instanceof B2bDishea) {
                        echo "Sconto $giaPresente->cddisc skippato perchè già presente"  . PHP_EOL;
                        continue;
                    }

                    $b2bDishea = new B2bDishea($tupla);
                    if (!$b2bDishea->save()) {
                        echo print_r($b2bDishea->getMessages(), true) . PHP_EOL;
                        continue;
                    }

                    $salvati++;

                    if (!$tupla['fltota'] && !empty($customerCodes)) {
                        foreach($customerCodes as $customerCode) {
                            if (!empty($customerCode)) {
                                $b2bDisana = new B2bDisana([
                                    'numdis' => $b2bDishea->numdis,
                                    'tpanag' => 'CL',
                                    'cdanag' => $customerCode,
                                ]);
                                $b2bDisana->save();
                            }
                        }
                    }

                    if (!$tupla['flpora'] && !empty($portCodes)) {
                        $portCodes = explode(',', $portCodes);
                        foreach ($portCodes as $portCode) {
                            $portCode = trim($portCode);
                            if (!empty($portCode)) {
                                $b2bDispor = new B2bDispor([
                                    'numdis' => $b2bDishea->numdis,
                                    'tpport' => $portCode,
                                ]);
                                $b2bDispor->save();
                            }
                        }
                    }
                    if (!$tupla['flpaga'] && !empty($paymentCodes)) {
                        $paymentCodes = explode(',', $paymentCodes);
                        foreach ($paymentCodes as $paymentCode) {
                            $paymentCode = trim($paymentCode);
                            if (!empty($paymentCode)) {
                                $b2bDispag = new B2bDispag([
                                    'numdis' => $b2bDishea->numdis,
                                    'tppaga' => $paymentCode,
                                ]);
                                $b2bDispag->save();
                            }
                        }
                    }

                    foreach ($brandCodes as $brandCode) {
                        $brandCode = trim($brandCode);
                        if (!empty($brandCode)) {
                            $b2bDisbdy = new B2bDisbdy([
                                'numdis' => $b2bDishea->numdis,
                                'sconto' => $tupla['value'],
                                'cdtitl' => $brandCode,
                            ]);
                            $b2bDisbdy->save();
                        }
                    }

                    foreach ($lineCodes as $lineCode) {
                        $lineCode = trim($lineCode);
                        if (!empty($lineCode)) {
                            $b2bDisbdy = new B2bDisbdy([
                                'numdis' => $b2bDishea->numdis,
                                'sconto' => $tupla['value'],
                                'cdlinm' => $lineCode,
                            ]);
                            $b2bDisbdy->save();
                        }
                    }

                    foreach ($serieCodes as $serieCode) {
                        $serieCode = trim($serieCode);
                        if (!empty($serieCode)) {
                            $b2bDisbdy = new B2bDisbdy([
                                'numdis' => $b2bDishea->numdis,
                                'sconto' => $tupla['value'],
                                'cdserm' => $serieCode,
                            ]);
                            $b2bDisbdy->save();
                        }
                    }

                    foreach ($catalogCodes as $catalogCode) {
                        $b2bDisctl = new B2bDisctl([
                            'numdis' => $b2bDishea->numdis,
                            'cdcata' => $catalogCode,
                        ]);
                        $b2bDisctl->save();
                    }

                    foreach ($listCodes as $listCode) {
                        $b2bDislst = new B2bDislst([
                            'numdis' => $b2bDishea->numdis,
                            'nulist' => $listCode,
                        ]);
                        $b2bDislst->save();
                    }

                } catch (\Exception $e) {
                    echo $e->getMessage() . PHP_EOL;
                }
            }
            echo 'SALVATI ' . $salvati . ' su ' . ($indice - 2) . ' ELEMENTI TOTALI' . PHP_EOL;

            // Chiudo il file
            fclose($handle);
            echo 'File Chiuso' . PHP_EOL;

            rename($csvFilePath, StandardSync::IMPORT_FOLDER . '/processed/' . $csvFileName);
            echo 'File Spostato' . PHP_EOL;
        }
    }
}
