<?php

namespace Go2B\Tasks;

use Go2B\Controllers\Utility;
use Go2B\Models\B2bMsgque;
use Phalcon\CLI\Task;

class QueueTask extends Task
{
    public function mainAction()
    {
        echo "\n*** QUEUE TASK starting ... ***\n\n";

        $to_time = strtotime(date("Y-m-d H:i:s"));

        echo "START " . date("Y-m-d H:i:s") . "\n";

        set_time_limit(0);

        /** @var Utility $utility */
        $utility = $this->getDI()->get('utility');

        try {
            $emails = B2bMsgque::findByFlsent(0);

            echo "Found " . count($emails) . " email/s to send\n";

            /** @var B2bMsgque $email */
            foreach ($emails as $email) {
                if ($email->flmult == 1) {
                    $recipients = explode(';', $email->indema);
                    $recipient = $recipients[0];
                } else {
                    $recipients = [];
                    $recipient = $email->indema;
                }
                $utility->sendEmail($email->mitten, $recipient, $email->subjct, $email->htmbod, $recipients);

                $email->flsent = 1;
                $email->save();
            }
        } catch (\Exception $e) {
            var_dump($e);
        }

        set_time_limit(30);

        $from_time = strtotime(date("Y-m-d H:i:s"));
        echo "END " . date("Y-m-d H:i:s") . "\n";

        echo "\n" . round(abs($to_time - $from_time) / 60, 2) . " minute\n";
    }
}
