<?php

namespace Go2B\Tasks;

use Go2B\Controllers\Utility;
use Go2B\Models\Octagl;
use Go2B\Models\Octest;
use Go2B\Plugins\Nav\ApiKOC;
use Phalcon\Logger\Adapter;

class OrdersTask extends \Phalcon\CLI\Task
{

    /* public function __call($name, $arguments)
    {
      // Verifica se il metodo chiamato inizia con "get"
      if (strpos($name, 'get') === 0) {
        // Estrae il nome del metodo da "get" in poi
        $methodName = lcfirst(substr($name, 3));
        // Verifica se il metodo esiste nella classe
        if (method_exists($this, $methodName)) {
          // Chiama il metodo richiesto e restituisce il risultato
          return call_user_func_array([$this, $methodName], $arguments);
        } else {
          throw new \Exception("Metodo $name non trovato nella classe.");
          return false;
        }
      } else {
        throw new \Exception("Metodo $name non valido.");
      }
    } */

    public function syncOrderKOC()
    {
        $di = \Phalcon\DI::getDefault();
        /** @var Adapter $logger */
        $logger = $di->get('logger');

        $tentativiCicliMassimi = 5;
        $currentCiclo = 0;

        $octest = Octest::findFirst(
            array(
                "flstat = :s: AND (uuid IS NULL OR uuid = '')",
                "bind" => array("s" => Octest::ORDER_STATUS_SENT)
            )
        );

        try {
            if ($octest instanceof Octest) {
                $logger->info(str_pad("TROVATO ORDINE DA INVIARE A NAV ", 80, '-'));
                $api = new ApiKOC();
                $octest = $api->sendHeader($octest);

                do {
                    $currentCiclo++;
                    $success = $api->sendLines($octest);
                    $logger->debug("CICLO 'sendLines' N." . $currentCiclo . ' - RESULT: ' . (($success) ? 'SUCCESS' : 'ERROR'));
                } while (!$success && $currentCiclo < $tentativiCicliMassimi);
                if ($currentCiclo == $tentativiCicliMassimi) {
                    $logger->debug("HO RAGGIUNTO IL MASSIMO DI TENATIVI PER L'ORDINE N." . $octest->nuordc);
                    $articoliCompletamenteInviati = $di->get('db')->query('SELECT COUNT(*) FROM occorp WHERE nuordc = :nu AND uuid IS NULL')->fetchColumn(0);
                    $logger->debug('Articoli inviati: ' . $articoliCompletamenteInviati);
                    $success = $articoliCompletamenteInviati > 0;
                }

                if ($success) {
                    $logger->info(str_pad("ORDINE CORRETTAMENTE INVIATO A NAV ", 80, '-'));
                    $logger->debug("Tentativo di accettazione automatica ordine [{$octest->nuordc}] tramite sendToBC");
                    $api->sendToBC($octest);
                } else {
                    $logger->error(str_pad("ORDINE NON INVIATO A NAV ", 80, '-'));
                }
            } else {
                $logger->info("NESSUN ORDINE DA INVIARE A NAV");
            }
        } catch (\Exception $e) {
            $logger->error($e->getMessage());
            $logger->error($e->getTraceAsString());
            echo $e->getTraceAsString() . PHP_EOL;
        }
    }

    public function mainAction()
    {
        $utility = new Utility();
        $autoAccept = $utility->getAppSettings('AutoAcceptOrders') == 1;
        $exportType = $utility->getAppSettings('ExportOrderType');

        $callMethod = "syncOrder" . $utility->getAppUtils('company');
        echo "Searching specific sync: " . $callMethod . ".\n";
        if (method_exists($this, $callMethod)) {
            echo "Calling specific sync: " . $callMethod . ".\n";
            $this->$callMethod();
        }

        if ($autoAccept && $exportType != 3) {
            $orders = Octest::find('flstat = 2');
            $count = 0;
            foreach ($orders as $order) {
                $order->flstat = 3;
                if ($order->save() === false) {
                    $messages = $order->getMessages();
                    echo "#### Errors ####\n" . $messages;
                } else {
                    echo "Updated nuordc: " . $order->nuordc . ";\n";
                    $count++;
                }
            }
            echo "Accepted orders: " . $count . ".\n";
        }
        echo "- COMPLETED -\n";
    }

    public function cleanupAction()
    {
        echo Octest::cleanOlderOrders() ? "- COMPLETED -\n" : "- FAILED -\n";
    }
}
