<?php

namespace Go2B\Tasks;

use Go2B\Controllers\Utility;

// per chiamare cd app/
// php console.php main sync

class MainTask extends \Phalcon\CLI\Task
{
  public function mainAction($args)
  {
    echo "\n*** IMPORT ALL starting ... ***\n\n";

    $to_time = strtotime(date("Y-m-d H:i:s"));

    echo "START " . date("Y-m-d H:i:s") . "\n";

    set_time_limit(0);

    $utility = new Utility();
    $param   = $utility->getAppSettings('SyncType');
    $syncImage        = $utility->getAppSettings('SyncImageType') == 0;
    $syncDescriptions = $utility->getAppSettings('SyncIgnoreDescriptions') == 0;

    switch ($param) {
      case 0:
        \Go2B\Tasks\Sync\StandardSync::sync(true, $syncImage, $syncDescriptions);
        break;
      case 1:
        \Go2B\Tasks\Sync\CsvLardini::sync(true);
        break;
      case 2:
        \Go2B\Tasks\Sync\CsvZanotti::sync(true);
        break;
      case 3:
        \Go2B\Tasks\Sync\ExcelSync::sync(true);
        break;
      case 4:
        \Go2B\Tasks\Sync\CsvLardini2::sync(true);
        break;
      case 5:
        \Go2B\Tasks\Sync\NavSync::sync(true, ...$args);
        break;
      case 6:
        \Go2B\Tasks\Sync\CsvThi::sync(true);
        break;

    }

    set_time_limit(30);

    $from_time = strtotime(date("Y-m-d H:i:s"));
    echo "END " . date("Y-m-d H:i:s") . "\n";

    echo "\n" . round(abs($to_time - $from_time) / 60, 2) . " minute(s)\n";
  }
}
