<?php

namespace Rest\Components\Repositories;

use Go2B\Models\ApiAppusr;
use League\OAuth2\Server\Entities\ClientEntityInterface;
use League\OAuth2\Server\Repositories\UserRepositoryInterface;
use Phalcon\Di\FactoryDefault as Di;
use Phalcon\Security;
use Rest\Components\Entities\UserEntity;

class UserRepository implements UserRepositoryInterface
{
  /**
   * {@inheritdoc}
   */
  public function getUserEntityByUserCredentials(
    $username,
    $password,
    $grantType,
    ClientEntityInterface $clientEntity
  ) {
    $di = new Di();
    $security = $di->getShared('security');
    $user = ApiAppusr::query()
      ->where("username = :username:")
      ->bind([
        'username' => $username
      ])
      ->limit(1)
      ->execute()
      ->toArray();

    $correctDetails = false;
    if (count($user) === 1) {
      $user = current($user);
      if ($security->checkHash($password, $user['password'])) {
        $correctDetails = true;
      } else {
        $security->hash(rand());
      }
    } else {
      // prevent timing attacks
      $security->hash(rand());
    }

    if ($correctDetails) {
      //$scope = new ScopeEntity();
      //$scope->setIdentifier('email');
      //$scopes[] = $scope;

      return new UserEntity($user);
    }

    return null;
  }
}
