<?php

namespace Rest\Components\Repositories;

use League\OAuth2\Server\Entities\AuthCodeEntityInterface;
use League\OAuth2\Server\Repositories\AuthCodeRepositoryInterface;
use Rest\Components\Entities\AuthCodeEntity;

class AuthCodeRepository implements AuthCodeRepositoryInterface
{
  /**
   * {@inheritdoc}
   */
  public function persistNewAuthCode(AuthCodeEntityInterface $authCodeEntity) {
    // Some logic to persist the auth code to a database
  }

  /**
   * {@inheritdoc}
   */
  public function revokeAuthCode($codeId) {
    // Some logic to revoke the auth code in a database
  }

  /**
   * {@inheritdoc}
   */
  public function isAuthCodeRevoked($codeId) {
    return false; // The auth code has not been revoked
  }

  /**
   * {@inheritdoc}
   */
  public function getNewAuthCode() {
    return new AuthCodeEntity();
  }
}
