<?php

namespace Go2B\Plugins\Nav;

class HeaderNavKOC extends \Phalcon\Di\Injectable
{
  /**
   * @Column(column="etag", type="string", nullable=true)
   * @var string
   */

  public $odata_etag;
  public $CustomerOrderID;
  public $CustomerNo;
  public $NewCustomerGuid;
  public $Comment1;
  public $Comment2;
  public $OrderRefNo;
  public $OrderDiscount;
  public $OrderDate;
  public $ConsignmentDate;
  public $OrderType;
  public $OrderProcessDate;
  public $OrderProcessStatus;
  public $OrderProcessErrors;
  public $ShipToAddressNo;
  public $SalespersonCode;
  public $AppSalespersonCode;
  public $Brand;
  public $Season;
  public $User_code;
  public $ProposalOrderNo;

  public function setEtag($string)
  {
    $this->odata_etag = 'W/"' . base64_encode($string) . '"';
  }

  public function jsonSerialize()
  {
    // Copia le proprietà dell'oggetto in un array
    $data = get_object_vars($this);

    // Modifica il formato della chiave solo per la proprietà 'odata_etag'
    if (isset($data['odata_etag'])) {
      $data['@odata.etag'] = $data['odata_etag'];
      unset($data['odata_etag']);
    }

    $data["ProposalOrderNo"] = "PROP" . str_pad($data["ProposalOrderNo"], 6, "0", STR_PAD_LEFT);

    unset($data["_dependencyInjector"]);
    unset($data["_eventsManager"]);

    return json_encode($data);
  }

  public function set($data)
  {
    foreach ($data as $key => $value) {
      if (property_exists($this, $key)) {
        $this->$key = $value;
      }
    }
  }
}
