<?php

namespace Go2B\Plugins\Nav;

class BodyNavKOC extends \Phalcon\Di\Injectable implements \JsonSerializable
{
  public $odata_etag;
  public $CustomerItemID;
  public $CustomerNo;
  public $ItemNo;
  public $VariantNo;
  public $ItemPrice;
  public $ItemDiscount;
  public $Quantity;
  public $DefPriceManuallyChanged;
  public $DefDiscountManuallyChanged;
  public $CustomerOrderID;
  public $NewCustomerGuid;

  public function setEtag($string)
  {
    $this->odata_etag = 'W/"' . base64_encode($string) . '"';
  }

  public function setCustomerItemID($string)
  {
    $this->CustomerItemID = (string) $string;
  }

  public function jsonSerialize()
  {
    // Copia le proprietà dell'oggetto in un array
    $data = get_object_vars($this);

    // Modifica il formato della chiave solo per la proprietà 'odata_etag'
    if (isset($data['odata_etag'])) {
      $data['@odata.etag'] = $data['odata_etag'];
      unset($data['odata_etag']);
    }

    $data["ItemPrice"] = floatval($data["ItemPrice"]);
    $data["Quantity"] = intval($data["Quantity"]);
    $data["ItemDiscount"] = intval($data["ItemDiscount"]);
    $data["DefPriceManuallyChanged"] = filter_var($data["DefPriceManuallyChanged"], FILTER_VALIDATE_BOOLEAN);
    $data["DefDiscountManuallyChanged"] = filter_var($data["DefDiscountManuallyChanged"], FILTER_VALIDATE_BOOLEAN);

    unset($data["_dependencyInjector"]);
    unset($data["_eventsManager"]);

    return json_encode($data);
  }

  public function set($data)
  {
    foreach ($data as $key => $value) {
      if (property_exists($this, $key)) {
        $this->$key = $value;
      }
    }
  }
}
