<?php

namespace Go2B\Plugins\Nav;

use DateTime;
use Exception;
use Go2B\Library\Environment;
use Go2B\Models\Anagra;
use Go2B\Models\B2bUsrage;
use Go2B\Models\CnvDatast;
use Go2B\Models\Cttest;
use Go2B\Models\Desmer;
use Go2B\Models\Occorp;
use Go2B\Models\Octagl;
use Go2B\Models\Octest;
use Go2B\Plugins\ApiManager;
use Go2B\Plugins\Nav\HeaderNavKOC as NavHeaderNav;
use Ramsey\Uuid\Uuid;
use stdClass;

date_default_timezone_set("Europe/Rome");

class ApiKOC extends ApiManager
{
    /**
     * Undocumented function
     *
     * @param Octest $octest
     * @return Octest
     * @throws Exception
     */
    public function sendHeader($octest)
    {
        if (!$octest instanceof Octest) {
            throw new \Exception("Ordine da evadere errato");
        }

        $watchdog = 0;
        $uuid = null;
        do {
            $tmpUuid = Uuid::uuid4();
            $octestUuid = Octest::findFirstByUuid($tmpUuid->toString());
            if (!$octestUuid instanceof Octest) {
                $uuid = $tmpUuid;
            }
        } while (++$watchdog < 10 && $octestUuid instanceof Octest);

        if (!$uuid instanceof Uuid) {
            throw new \Exception("Impossibile generare un uuid valido");
        }

        // Formatta l'UUID nel formato desiderato
        $formatted_uuid = $uuid->toString();

        $createJson = new NavHeaderNav();

        /** @var DateTime $date */
        $date = new DateTime();
        $date->createFromFormat('Y-m-d', $octest->dtcrea);
        $OrderDate = $date->format('Y-m-d\TH:i:s\Z');
        $date->createFromFormat('Y-m-d', $octest->dtmcli);
        $ConsignmentDate = $date->format('Y-m-d\TH:i:s\Z');
        $date->createFromFormat('Y-m-d', $octest->dtinvi);
        $OrderProcessDate = $date->format('Y-m-d\TH:i:s\Z');

        $cdstag = Cttest::findFirst(
            array(
                "cdcata = :cata:",
                "bind" => array(
                    "cata" => $octest->cdcata
                )
            )
        );

        $codiceAgente = "";
        if ($octest->agente instanceof B2bUsrage) {
            $this->di->get('logger')->debug('cdagen: ' . $octest->agente->cdagen);
            $tmp = CnvDatast::findFirst(
                array(
                    "tipdat = :tipo: and newnum = :numero:",
                    "bind" => array(
                        "tipo" => "anaage.cdagen",
                        "numero" => $octest->agente->cdagen
                    )
                )
            );

            if ($tmp instanceof CnvDatast) {
                $codiceAgente = (string)$tmp->dato01;
            }
        }

        $idDestinazione = "000";
        if (!empty($octest->cddesm) && strpos($octest->cddesm, "-") === false) {
            $idDestinazione = explode("-", $octest->cddesm)[1];
        }

        /* $newCustomer = Anagra::findCustomerByKey("CL", $octest->cdanag);

        if ($newCustomer instanceof Anagra && $newCustomer->newcod > 0) {
            $newCustomer = $newCustomer->newcod;
        } else {
            $newCustomer = null;
        } */

        $newCustomer = null;

        $customer = is_null($newCustomer) ? $octest->cdanag : "";
        $newCustomer = is_null($newCustomer) ? "00000000-0000-0000-0000-000000000000" : $newCustomer;

        $createJson->set([
            "ProposalOrderNo" => $octest->nuordc,
            "CustomerOrderID" => $formatted_uuid,
            "CustomerNo" => $customer,
            "NewCustomerGuid" => $newCustomer,
            "Comment1" => $octest->notcli,
            "Comment2" => $octest->notazi,
            "OrderRefNo" => "",
            // TODO qui ci mettiamo la scontistica cliente?
            "OrderDiscount" => 0,
            "OrderDate" => $OrderDate,
            "ConsignmentDate" => $ConsignmentDate,
            // TODO Utilizzare mappa tipi ordine (1 ordine campagna, 2 reso, 3 riassortimento, 4 sostit., 5 reso da sostit.)
            "OrderType" => 1, // Da prendere il valore dalla Mappa
            "OrderProcessDate" => $OrderProcessDate,
            "OrderProcessStatus" => 0,
            "OrderProcessErrors" => "",
            "ShipToAddressNo" => ($octest->cddesm ? $idDestinazione : "000"),
            "SalespersonCode" => $codiceAgente, //($octest->agente instanceof B2bUsrage ? $octest->agente->cdagen : ""), //"0024701",
            "AppSalespersonCode" => $codiceAgente, //($octest->agente instanceof B2bUsrage ? $octest->agente->cdagen : ""), //"0024701",
            // TODO da dove prendiamo il brand (primo articolo nell'ordine???)
            "Brand" => (!empty($cdstag->cdtitl) ? $cdstag->cdtitl : ""), //Manca il brand
            "Season" => $cdstag->cdstag,
            "User_code" => "", //User code quale?
        ]);
        $createJson->setEtag($formatted_uuid);

        $response = $this->requestToNav(self::METHOD_POST, 'ApiAppSalesHeaders', $createJson->jsonSerialize());
        if (!$response instanceof stdClass) {
            $this->di->get('logger')->debug("Request: " . json_encode([
                    'METHOD' => self::METHOD_POST,
                    'API' => 'ApiAppSalesHeaders',
                    'DATA' => $createJson
                ])
            );
            $this->di->get('logger')->debug("Response: " . (gettype($response)) . (is_object($response) ? get_class($response) : '') . PHP_EOL . print_r($response, true) . PHP_EOL);
            throw new \Exception('Risposta dal server corrotta');
        }

        if (!empty($response->error)) {
            throw new \Exception('Risposta dal server errore: ' . $response->error->message);
        }

        $octest->uuid = $formatted_uuid;
        $autoAccept = Environment::getCustomParam('AutoAcceptOrders') == 1;
        if ($autoAccept) {
            $octest->flstat = Octest::ORDER_STATUS_ACCEPTED;
        }
        if ($octest->save() == false) {
            $this->di->get('logger')->error(
                "Errore salvataggio: " . json_encode($octest->getMessages())
            );
            throw new \Exception("Errore salvataggio: " . json_encode($octest->getMessages()));
        }

        $this->di->get('logger')->info("Salvo uuid dell'ordine: " . $octest->nuordc . "{ " . $formatted_uuid . " }");

        return $octest;
    }

    /**
     * Undocumented function
     *
     * @param Octest $order
     * @return bool
     * @throws Exception
     */
    public function sendLines($order)
    {
        /* $newCustomer = Anagra::findCustomerByKey("CL", $order->cdanag);

        if ($newCustomer instanceof Anagra && $newCustomer->newcod > 0) {
            $newCustomer = $newCustomer->newcod;
        } else {
            $newCustomer = null;
        } */

        $newCustomer = null;

        $customer = is_null($newCustomer) ? $order->cdanag : "";
        $newCustomer = is_null($newCustomer) ? "00000000-0000-0000-0000-000000000000" : $newCustomer;

        $occorp = $this->di->get('db')->query(
            "SELECT
            	occorp.nurorc,
	            octagl.dstagl,
                '" . $customer . "' AS CustomerNo,
                anaart.cdartn AS ItemNo,
                CONCAT( TRIM(anaart.cdcolo), '-', octagl.dstagl ) AS VariantNo,
                octagl.prezzo AS ItemPrice,
                octagl.scont1 AS ItemDiscount,
                octagl.quanti AS Quantity,
                'false' AS DefPriceManuallyChanged,
                'false' AS DefDiscountManuallyChanged,
                '" . $order->uuid . "' AS CustomerOrderID,
                '" . $newCustomer . "' AS NewCustomerGuid 
            FROM
                occorp
                INNER JOIN anaart ON occorp.cdarti = anaart.cdarti
                LEFT JOIN octagl ON occorp.nurorc = octagl.nurorc 
            WHERE
                occorp.nuordc = :nuordc 
                AND occorp.uuid IS NULL 
                AND octagl.uuid IS NULL 
                AND octagl.quanti > 0",
            array(
                "nuordc" => $order->nuordc
            )
        )->fetchAll();

        $this->di->get('logger')->debug('Conteggio items to send = ' . count($occorp));

        $itemsRes = [];
        $allSent = true;
        foreach ($occorp as $i => $row) {
            //$uuid = Uuid::uuid4();
            $itemsRes[$row["nurorc"]][$row["dstagl"]] = false;
            do {
                $uuid = Uuid::uuid4();
                $octestUuid = Occorp::findFirstByUuid($uuid->toString());
            } while ($octestUuid instanceof Occorp);

            // Formatta l'UUID nel formato desiderato
            $formatted_uuid = $uuid->toString();

            $createJson = new BodyNavKOC();
            $createJson->set($row);
            $createJson->setEtag($formatted_uuid);
            $createJson->setCustomerItemID($formatted_uuid);

            $request = $this->requestToNav(self::METHOD_POST, 'ApiAppSalesLines', $createJson->jsonSerialize());

            if ($request instanceof stdClass) {
                if (!empty($request->error)) {
                    $setMessage = "Richiesta: [" . $row["nurorc"] . " " . $row["dstagl"] . "] - Risposta: " . $request->error->message;
                    throw new Exception($setMessage);
                }

                $oc = Octagl::findFirst(
                    array(
                        "nurorc = :nu: AND dstagl = :ds:",
                        "bind" => array(
                            "nu" => $row["nurorc"],
                            "ds" => $row["dstagl"]
                        )
                    )
                );
                $oc->uuid = $uuid->toString();

                $itemsRes[$row["nurorc"]][$row["dstagl"]] = $oc->save();

                $this->di->get('logger')->debug($createJson->jsonSerialize());
                $this->di->get('logger')->info(
                    "Salvo uuid della riga taglia dell'ordine - [R] " . $row["nurorc"] . " [T]: " . $row["dstagl"] . " [O] " . $order->nuordc
                );
                //echo "RIGA INVIATA [" . $row["nurorc"] . "] [" . $row["dstagl"] . "]" . PHP_EOL;
            } else {
                throw new Exception('Risposta server corrotta: ' . $request);
            }
        }

        $this->di->get('logger')->debug('Dettaglio invio: ' . json_encode($itemsRes));

        foreach ($itemsRes as $nurorc => $taglie) {
            if (!in_array(false, $taglie)) {
                $this->di->get('db')->query(
                    'UPDATE occorp SET uuid = :uuid WHERE nurorc = :nurorc',
                    [
                        'uuid' => $uuid->toString(),
                        'nurorc' => $nurorc,
                    ]
                );
            } else {
                $allSent = false;
            }
        }

        return $allSent;
    }

    /**
     * Effettua chiamata SOAP per confermare l'ordine
     *
     * @param Octest $order
     * @throws Exception
     */
    public function sendToBC($order)
    {
        /** @var object $response */
        return $this->sendOrderToSoap($order->uuid);
//        $config = Di::getDefault()->get('config');
//        $response = $this->sendToSoap(
//            "https://odata.kocca.it:7067/TestNUP/WS/Kocca%20s.r.l./Codeunit/NBLImportOrder",
//            "ImportOrder",
//            array(
//                "login" =>  $config->get('nav')->username,
//                "password" =>  $config->get('nav')->password,
//                "trace" => 1
//            ),
//            array(
//                'orderID' => $order->uuid
//            )
//        );

        // torna sempre true
//        $this->di->get('logger')->debug(json_encode($response));

//        $json = json_decode($response->return_value);
//        if ($json->Values[0]->ImportStatus === ApiManager::STATUS_ORDER_SOAP_SUCCESS) {
//            //echo "Ordine Salvato su BC!" . PHP_EOL;
//            $this->di->get('logger')->info("Ordine Salvato su BC: " . $json->Values[0]->OrderID);
//        }
//        if ($json->Values[0]->ImportStatus === ApiManager::STATUS_ORDER_SOAP_NOT_FOUND) {
//            //echo "Ordine NON Salvato su BC!" . PHP_EOL;
//            $this->di->get('logger')->error("Ordine NON Salvato su BC: " . $order->nuordc);
//        }
    }

    /**
     * Effettua chiamata per creare un nuovo cliente
     *
     * @param Anagra $customer
     * @return Anagra|false
     * @throws Exception
     */
    public function sendNewCustomer($customer)
    {
        try {
            /**@var Anagra $customer */
            $obj = $customer->exportToNav();
            $request = $this->requestToNav(self::METHOD_POST, 'AppCustomers', $obj->jsonSerialize());

            if ($request instanceof stdClass) {
                if (isset($request->error) && !empty($request->error)) {
                    $setMessage = "[CLIENTE NON SALVATO " . $customer->descri . "] " . $request->error->message;
                    $this->di->get('logger')->error($setMessage);
                    throw new \Exception($request->error->message);
                    return false;
                }

                $this->di->get('logger')->debug($obj->jsonSerialize());
                $this->di->get('logger')->info(
                    "Cliente salvato: " . $obj->jsonSerialize() . " [" . $request->CustomerNo . "]"
                );

                $this->di->get('logger')->info(
                    json_encode($customer)
                );

                $this->di->get('db')->query("UPDATE anagra SET cdanag = :a, tpanag = 'CL' WHERE tpanag = 'CN' AND cdanag = :oa", array(
                    "a" => $request->CustomerNo,
                    "oa" => $customer->cdanag
                ));
                $this->di->get('db')->query("UPDATE ageana SET codice = :a, tpanag = 'CL' WHERE tipdat = 'C' AND tpanag = 'CN' AND codice = :oa", array(
                    "a" => $request->CustomerNo,
                    "oa" => $customer->cdanag
                ));
                $this->di->get('db')->query("UPDATE cnv_datast SET dato02 = :a, dato01 = 'CL' WHERE tipdat = 'anagra.newcod' AND dato01 = 'CN' AND dato02 = :oa", array(
                    "a" => $request->CustomerNo,
                    "oa" => $customer->cdanag
                ));
                return true;
            } else {
                $this->di->get('logger')->info(
                    $request
                );
                throw new \Exception($request);
            }
        } catch (\Exception $e) {

            $this->di->get('logger')->info(
                $e->getMessage()
            );
            throw new \Exception($e->getMessage());
        }
    }

    /**
     * Effettua chiamata per creare una nuova destinazione
     *
     * @param Desmer $desmer
     * @return Desmer|false
     * @throws Exception
     */
    public function sendNewAddressCustomer($desmer)
    {
        // Campi obbligatori
//        customerNo*
//        code*
//        uuid*
//        nazione*

//        NB
//        nella risposta ci darà il codice statistico

        $obj = $desmer->exportToNav();
        $request = $this->requestToNav(self::METHOD_POST, 'ApiShipToAddresses', $obj->jsonSerialize());

        if ($request instanceof stdClass) {
            if (!empty($request->error)) {
                $setMessage = "DESTINAZIONE NON SALVATA " . $desmer->getAddress() . " " . $request->error->message;
                throw new \Exception($setMessage);
            }

            $params = [
                "new" => $request->customerNo . '-' . $request->code,
                "old" => $desmer->cddesm
            ];

            $this->di->get('db')
                ->query("UPDATE desmer SET cddesm = :new, cdzona = :zona, uuid = :uuid, flsb2b = 0 WHERE cddesm = :old",
                    array_merge($params, [
                        'zona' => $request->dimension1Code,
                        'uuid' => $request->id
                    ])
                );
            $this->di->get('db')
                ->query("UPDATE ageana SET codice = :new WHERE tipdat = 'D' AND codice = :old", $params);
            $this->di->get('db')
                ->query("UPDATE cnv_datast SET dato03 = :new WHERE tipdat = 'desmer.newcod' AND dato01 = :d1 AND dato02 = :d2 AND dato03 = :old", array_merge($params, [
                        "d1" => $desmer->tpanag,
                        "d2" => $desmer->cdanag
                    ])
                );
            return true;
        } else {
            $this->di->get('logger')->debug('Response: ' . print_r($request, true));
            throw new \Exception('Risposta del server corrotta');
        }
    }
}

