<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tpgene extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $tpgene;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsgene;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tpgene');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpgene' => isset($rec->tpgene) && (string)$rec->tpgene !== '' ? (string)$rec->tpgene : new RawValue('""'),
      'dsgene' => isset($rec->dsgene) && (string)$rec->dsgene !== '' ? (string)$rec->dsgene : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'tpgene = :tpgene:';
    $params = array(
      'tpgene' => $values['tpgene']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tpgene objects
   */
  public static function getAllArticleGenresFromCatalog($cdcata, $items) {
    $params = array('cdcata' => $cdcata, 'tpdato' => 'des_' . strtolower($items['lang']));

    $innerJoinAnaper = '';
    $andWhere = '';
    if (isset($items['cdpers'])) {
      $params['cdpers'] = $items['cdpers'];
      $andWhere .= ' AND ap.cdpers = :cdpers: ';
      $innerJoinAnaper = 'INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers ';
    }

    $join = '';
    if ($items['from'] != 'all') {
      switch ($items['from']) {
        case 'sermod':
          $params['code1'] = $items['code1'];
          $params['code2'] = $items['code2'];
          $andWhere .= ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ';
          break;
        case 'linmod':
          $params['code'] = $items['code'];
          $andWhere .= ' AND tp.cdlinm = :code: ';
          break;
        case 'titlin':
          $params['code'] = $items['code'];
          $join = 'INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
                   INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl';
          $andWhere .= ' AND tl.cdtitl = :code: ';
          break;
      }
    }

    $query = "SELECT tg.tpgene AS codice, COALESCE(ai.valore,tg.dsgene) AS descri
      FROM Go2B\Models\Tpgene tg
      INNER JOIN Go2B\Models\Tipolo tp ON tg.tpgene = tp.tpgene
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      $innerJoinAnaper
      $join
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'tpgene' AND ai.codic1 = tg.tpgene AND ai.codic2 = '' AND ai.tpdato = :tpdato:
      WHERE ca.cdcata = :cdcata:
      $andWhere
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY tg.tpgene
      ORDER BY tg.seqrap, tg.dsgene";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpgene objects
   */
  public static function getGenresForLocalization() {
    $query = "SELECT tg.tpgene AS code, tg.dsgene AS description,
      COALESCE(it.valore,'') AS des_it, COALESCE(en.valore,'') AS des_en,
      COALESCE(es.valore,'') AS des_es, COALESCE(fr.valore,'') AS des_fr,
      COALESCE(de.valore,'') AS des_de
      FROM Go2B\Models\Tpgene tg
      LEFT JOIN Go2B\Models\B2bAddinf it ON it.tabell = 'tpgene' AND it.codic1 = tg.tpgene AND it.codic2 = '' AND it.tpdato = 'des_it'
      LEFT JOIN Go2B\Models\B2bAddinf en ON en.tabell = 'tpgene' AND en.codic1 = tg.tpgene AND en.codic2 = '' AND en.tpdato = 'des_en'
      LEFT JOIN Go2B\Models\B2bAddinf es ON es.tabell = 'tpgene' AND es.codic1 = tg.tpgene AND es.codic2 = '' AND es.tpdato = 'des_es'
      LEFT JOIN Go2B\Models\B2bAddinf fr ON fr.tabell = 'tpgene' AND fr.codic1 = tg.tpgene AND fr.codic2 = '' AND fr.tpdato = 'des_fr'
      LEFT JOIN Go2B\Models\B2bAddinf de ON de.tabell = 'tpgene' AND de.codic1 = tg.tpgene AND de.codic2 = '' AND de.tpdato = 'des_de'
      ORDER BY tg.dsgene";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpgene objects
   */
  public static function getAllGenres() {
    $query = "SELECT tg.tpgene, tg.dsgene
      FROM Go2B\Models\Tpgene tg
      ORDER BY tg.dsgene";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpgene objects
   */
  public static function getAllGenresWithLanguageDescriptions() {
    $query = "SELECT tg.tpgene, tg.dsgene, COALESCE(den.descri,'') AS des_en,
      COALESCE(des.descri,'') AS des_es, COALESCE(dfr.descri,'') AS des_fr,
      COALESCE(dde.descri,'') AS des_de
      FROM Go2B\Models\Tpgene tg
      LEFT JOIN Go2B\Models\Deslin den ON den.tpdato = 'dsgene' AND den.codic1 = tg.tpgene AND den.codic2 = '' AND den.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin des ON des.tpdato = 'dsgene' AND des.codic1 = tg.tpgene AND des.codic2 = '' AND des.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dfr ON dfr.tpdato = 'dsgene' AND dfr.codic1 = tg.tpgene AND dfr.codic2 = '' AND dfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dde ON dde.tpdato = 'dsgene' AND dde.codic1 = tg.tpgene AND dde.codic2 = '' AND dde.idlang = 'DE'
      ORDER BY tg.dsgene";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tpgene objects
   */
  public static function getGenresFromCatalog($cdcata) {
    $query = 'SELECT tg.tpgene, tg.dsgene
      FROM Go2B\Models\Tpgene tg
      INNER JOIN Go2B\Models\Tipolo tp ON tp.tpgene = tg.tpgene
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      WHERE ca.cdcata = :cdcata:
      GROUP BY tg.tpgene';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }
  //endregion
}
