<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tpcrar extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpinpu;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $tpcrar;

  /**
   *
   * @var string
   * @Column(type="string", length=50, nullable=false)
   */
  public $dscrar;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tpcrar');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpinpu' => isset($rec->tpinpu) && (string)$rec->tpinpu !== '' ? (string)$rec->tpinpu : new RawValue('""'),
      'tpcrar' => isset($rec->tpcrar) && (string)$rec->tpcrar !== '' ? (string)$rec->tpcrar : new RawValue('""'),
      'dscrar' => isset($rec->dscrar) && (string)$rec->dscrar !== '' ? (string)$rec->dscrar : new RawValue('""')
    );

    $query  = 'tpinpu = :tpinpu: AND tpcrar = :tpcrar:';
    $params = array(
      'tpinpu' => $values['tpinpu'],
      'tpcrar' => $values['tpcrar']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tpcrar objects
   */
  public static function getAdditionalFilters() {
    $query = 'SELECT DISTINCT t.tpinpu, t.tpcrar, t.dscrar, COALESCE(v.flbloc, 0) AS flbloc,
      COALESCE(v.des_it, t.dscrar) AS des_it, COALESCE(v.des_en, t.dscrar) AS des_en,
      COALESCE(v.des_es, t.dscrar) AS des_es, COALESCE(v.des_de, t.dscrar) AS des_de,
      COALESCE(v.des_fr, t.dscrar) AS des_fr, COALESCE(v.seqrap, 0) AS seqrap
      FROM Go2B\Models\Tpcrar t
      LEFT JOIN Go2B\Models\B2bFlvisi v ON t.tpinpu = v.codic1 AND t.tpcrar = v.codic2';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function emptyTable() {
    $query = 'DELETE tc.*
      FROM tpcrar tc';
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
