<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Mvc\Model;

class Tpcond extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $tpcond;

  /**
   *
   * @var string
   * @Column(type="string", length=40, nullable=false)
   */
  public $dscond;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tpcond');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpcond' => isset($rec->tpcond) && (string)$rec->tpcond !== '' ? (string)$rec->tpcond : 0,
      'dscond' => isset($rec->dscond) && (string)$rec->dscond !== '' ? (string)$rec->dscond : new RawValue('""')
    );

    $query  = 'tpcond = :tpcond:';
    $params = array(
      'tpcond' => $values['tpcond']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
