<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tpcomp extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $tpcomp;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dscomp;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flstat;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tpcomp');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpcomp' => isset($rec->tpcomp) && (string)$rec->tpcomp !== '' ? (string)$rec->tpcomp : new RawValue('""'),
      'dscomp' => isset($rec->dscomp) && (string)$rec->dscomp !== '' ? (string)$rec->dscomp : new RawValue('""'),
      'flstat' => isset($rec->flstat) && (string)$rec->flstat !== '' ? (string)$rec->flstat : 0,
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'tpcomp = :tpcomp:';
    $params = array(
      'tpcomp' => $values['tpcomp']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tpcomp objects
   */
  public static function getAllFeatures() {
    $query = "SELECT tc.tpcomp, tc.dscomp
      FROM Go2B\Models\Tpcomp tc
      ORDER BY tc.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }
  //endregion
}
