<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Titlin extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdtitl;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dstitl;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('titlin');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdtitl' => isset($rec->cdtitl) && (string)$rec->cdtitl !== '' ? (string)$rec->cdtitl : new RawValue('""'),
      'dstitl' => isset($rec->dstitl) && (string)$rec->dstitl !== '' ? (string)$rec->dstitl : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'flimag' => isset($rec->flimag) && (string)$rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""')
    );

    $query  = 'cdtitl = :cdtitl:';
    $params = array(
      'cdtitl' => $values['cdtitl']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Titlin objects
   */
  public static function getAllBrands() {
    $query = "SELECT tl.cdtitl, tl.dstitl,
      tl.cdtitl AS code, tl.dstitl AS description
      FROM Go2B\Models\Titlin tl
      ORDER BY tl.dstitl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Titlin objects
   */
  public static function getAllBrandsWithLanguageDescriptions() {
    $query = "SELECT tl.cdtitl, tl.dstitl, COALESCE(den.descri,'') AS des_en,
      COALESCE(des.descri,'') AS des_es, COALESCE(dfr.descri,'') AS des_fr,
      COALESCE(dde.descri,'') AS des_de
      FROM Go2B\Models\Titlin tl
      LEFT JOIN Go2B\Models\Deslin den ON den.tpdato = 'dstitl' AND den.codic1 = tl.cdtitl AND den.codic2 = '' AND den.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin des ON des.tpdato = 'dstitl' AND des.codic1 = tl.cdtitl AND des.codic2 = '' AND des.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dfr ON dfr.tpdato = 'dstitl' AND dfr.codic1 = tl.cdtitl AND dfr.codic2 = '' AND dfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dde ON dde.tpdato = 'dstitl' AND dde.codic1 = tl.cdtitl AND dde.codic2 = '' AND dde.idlang = 'DE'
      ORDER BY tl.dstitl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Titlin objects
   */
  public static function getAllBrandsFromCode($brands) {
    $where = '';
    $params = array();
    for ($i = 0; $i < count($brands); $i++) {
      $where .= ':cdtitl' . $i . ':,';
      $params['cdtitl' . $i] = $brands[$i];
    }
    $where = substr($where,0,-1);

    $query = "SELECT tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Titlin tl
      WHERE tl.cdtitl IN ($where)
      ORDER BY tl.seqrap, tl.dstitl, tl.cdtitl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Titlin objects
   */
  public static function getBrandsFromCatalog($cdcata) {
    $query = 'SELECT tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Titlin tl
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdtitl = tl.cdtitl
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      WHERE ca.cdcata = :cdcata:
      GROUP BY tl.cdtitl
      ORDER BY tl.dstitl';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Titlin objects
   */
  public static function getAllSimpleFromCatalog($cdcata) {
    $query = "SELECT tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Titlin tl
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdtitl = tl.cdtitl
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY tl.cdtitl
      ORDER BY tl.seqrap, tl.dstitl, tl.cdtitl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Titlin objects
   */
  public static function getBrandsWithDiscountFromCatalogs($whereCatalogs, $params) {
    $query = "SELECT DISTINCT tl.cdtitl, tl.dstitl, COALESCE(cb.sconto,0) AS sconto
      FROM Go2B\Models\Titlin tl
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdtitl = tl.cdtitl
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bDisbdy cb ON cb.cdtitl = tl.cdtitl AND cb.numdis = :numdis:
      WHERE ca.cdcata IN ($whereCatalogs)";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Titlin objects
   */
  public static function getAllAvailableBrandsFromCatalog($cdcata) {
    $query = "SELECT tl.cdtitl, tl.dstitl, tl.seqrap, tl.flimag
      FROM Go2B\Models\Titlin tl
      INNER JOIN Go2B\Models\Linmod lm ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Tipolo tp ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY tl.cdtitl
      ORDER BY tl.seqrap, tl.dstitl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Titlin objects
   */
  public static function getAllBrandsForPromo($cdprom) {
    if (!empty($cdprom)) {
      $presPvcorp = 'COALESCE((SELECT COUNT(c.cdtitl) FROM Go2B\Models\Pvcorp c WHERE c.cdtitl = t.cdtitl AND c.cdprom = :cdprom:), 0) AS presPvcorp';
      $presPvgrup = 'COALESCE((SELECT COUNT(g.cdtitl) FROM Go2B\Models\Pvgrup g WHERE g.cdtitl = t.cdtitl AND g.cdprom = :cdprom:), 0) AS presPvgrup';
      $params = array('cdprom' => $cdprom);
    } else {
      $presPvcorp = '0 AS presPvcorp';
      $presPvgrup = '0 AS presPvgrup';
      $params = array();
    }
    $query = "SELECT t.cdtitl, t.dstitl, $presPvcorp, $presPvgrup
      FROM Go2B\Models\Titlin t
      ORDER BY t.cdtitl";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return   string
   */
  public static function getFullDescriptionBrand($cdtitl) {
    $query = "SELECT tl.dstitl AS description
      FROM Go2B\Models\Titlin tl
      WHERE tl.cdtitl = :cdtitl:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdtitl' => $cdtitl));
    return count($result) == 1 ? $result[0]->description : '';
  }
  //endregion
}
