<?php

namespace Go2B\Models;

use Go2B\Controllers\Utility;
use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tipolo extends Model
{
    //region Fields
    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=30, nullable=false)
     */
    public $cdartn;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $dsartn;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $cdstag;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $cdlinm;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $cdserm;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $tpgene;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $tpmode;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $ummaga;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $cdtagl;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $tglini;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $tglfin;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=false)
     */
    public $tppers;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $flbloc;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $flasso;

    /**
     *
     * @var string
     * @Column(type="string", length=255, nullable=false)
     */
    public $flimag;

    /**
     *
     * @var string
     * @Column(type="string", length=255, nullable=false)
     */
    public $flvide;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $seqrap;
    //endregion

    //region Default functions
    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('tipolo');
    }

    /**
     * Checks record uniqueness before to save
     *
     * @return bool
     */
    public function validation()
    {
        $validator = new \Phalcon\Validation();
        $validator->add(
            'cdartn',
            new \Phalcon\Validation\Validator\Uniqueness()
        );
        return $this->validate($validator);
    }

    public function getAvailableSizes()
    {
        $sizes = [];
        foreach (Postgl::getAllSizes($this->cdtagl) as $size) {
            if ($size['postgl'] >= $this->tglini && $size['postgl'] <= $this->tglfin) {
                $sizes[$size['postgl']] = $size['taglia'];
            }
        }

        return $sizes;
    }
    //endregion

    //region Sync functions
    /**
     * Save flawlessly record
     */
    public static function safelySave($tipolo)
    {
        $tipolo->save(array(
            'cdartn' => (string)$tipolo->cdartn !== '' ? trim((string)$tipolo->cdartn) : new RawValue('""'),
            'dsartn' => (string)$tipolo->dsartn !== '' ? (string)$tipolo->dsartn : new RawValue('""'),
            'cdstag' => (string)$tipolo->cdstag !== '' ? (string)$tipolo->cdstag : new RawValue('""'),
            'cdlinm' => (string)$tipolo->cdlinm !== '' ? (string)$tipolo->cdlinm : new RawValue('""'),
            'cdserm' => (string)$tipolo->cdserm !== '' ? (string)$tipolo->cdserm : new RawValue('""'),
            'tpgene' => (string)$tipolo->tpgene !== '' ? (string)$tipolo->tpgene : new RawValue('""'),
            'tpmode' => (string)$tipolo->tpmode !== '' ? (string)$tipolo->tpmode : new RawValue('""'),
            'ummaga' => (string)$tipolo->ummaga !== '' ? (string)$tipolo->ummaga : new RawValue('""'),
            'cdtagl' => (string)$tipolo->cdtagl !== '' ? (string)$tipolo->cdtagl : new RawValue('""'),
            'tglini' => (string)$tipolo->tglini !== '' ? (string)$tipolo->tglini : 0,
            'tglfin' => (string)$tipolo->tglfin !== '' ? (string)$tipolo->tglfin : 0,
            'tppers' => (string)$tipolo->tppers !== '' ? (string)$tipolo->tppers : new RawValue('""'),
            'flbloc' => (string)$tipolo->flbloc !== '' ? (string)$tipolo->flbloc : 0,
            'flasso' => (string)$tipolo->flasso !== '' ? (string)$tipolo->flasso : 0,
            'flimag' => (string)$tipolo->flimag !== '' ? (string)$tipolo->flimag : new RawValue('""'),
            'flvide' => (string)$tipolo->flvide !== '' ? (string)$tipolo->flvide : new RawValue('""'),
            'seqrap' => (string)$tipolo->seqrap !== '' ? (string)$tipolo->seqrap : 0
        ));
    }

    /**
     * Sync from xml
     */
    public static function saveRecord($rec, $tipoagg, $updateImage = true)
    {
        $values = array(
            'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? trim((string)$rec->cdartn) : new RawValue('""'),
            'dsartn' => isset($rec->dsartn) && (string)$rec->dsartn !== '' ? (string)$rec->dsartn : new RawValue('""'),
            'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
            'cdlinm' => isset($rec->cdlinm) && (string)$rec->cdlinm !== '' ? (string)$rec->cdlinm : new RawValue('""'),
            'cdserm' => isset($rec->cdserm) && (string)$rec->cdserm !== '' ? (string)$rec->cdserm : new RawValue('""'),
            'tpgene' => isset($rec->tpgene) && (string)$rec->tpgene !== '' ? (string)$rec->tpgene : new RawValue('""'),
            'tpmode' => isset($rec->tpmode) && (string)$rec->tpmode !== '' ? (string)$rec->tpmode : new RawValue('""'),
            'ummaga' => isset($rec->ummaga) && (string)$rec->ummaga !== '' ? (string)$rec->ummaga : new RawValue('""'),
            'cdtagl' => isset($rec->cdtagl) && (string)$rec->cdtagl !== '' ? (string)$rec->cdtagl : new RawValue('""'),
            'tglini' => isset($rec->tglini) && (string)$rec->tglini !== '' ? (string)$rec->tglini : 0,
            'tglfin' => isset($rec->tglfin) && (string)$rec->tglfin !== '' ? (string)$rec->tglfin : 0,
            'tppers' => isset($rec->tppers) && (string)$rec->tppers !== '' ? (string)$rec->tppers : new RawValue('""'),
            'flbloc' => isset($rec->flbloc) && (string)$rec->flbloc !== '' ? (string)$rec->flbloc : 0,
            'flasso' => isset($rec->flasso) && (string)$rec->flasso !== '' ? (string)$rec->flasso : 0,
            'flimag' => isset($rec->flimag) && (string)$rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""'),
            'flvide' => isset($rec->flvide) && (string)$rec->flvide !== '' ? (string)$rec->flvide : new RawValue('""'),
            'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
        );

        $query = 'cdartn = :cdartn:';
        $params = array(
            'cdartn' => $values['cdartn']
        );

        if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
            $row = new self();
        }

        // If video file of the record is empty, use old value
        $values['flvide'] = !empty($row->flvide) ? $row->flvide : $values['flvide'];
        $values['flimag'] = $updateImage ? $values['flimag'] : $row->flimag;
        $row->save($values);
    }
    //endregion

    //region Utility functions
    private static function getCatalogPriceSubquery()
    {
        return "COALESCE(
      IF(
        (SELECT COUNT(DISTINCT lc.prezzo)
        FROM Go2B\Models\Lscorp lc
        INNER JOIN Go2B\Models\Ctarti ct2 ON ct2.cdarti = lc.cdarti
        INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = ct2.cdarti
        INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
        WHERE lc.nulist = :nulist: AND ct2.cdcata = :cdcata: AND tp.cdartn = tp2.cdartn) = 1,

        (SELECT lc.prezzo
        FROM Go2B\Models\Lscorp lc
        INNER JOIN Go2B\Models\Ctarti ct2 ON ct2.cdarti = lc.cdarti
        INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = ct2.cdarti
        INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
        WHERE lc.nulist = :nulist: AND ct2.cdcata = :cdcata: AND tp.cdartn = tp2.cdartn LIMIT 1),
      0), 0) as catalogPrice";
    }

    private static function getRetailPriceSubquery()
    {
        return "COALESCE(
      IF(
        (SELECT COUNT(DISTINCT lc.prezzo)
        FROM Go2B\Models\Lscorp lc
        INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = lc.cdarti
        INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
        WHERE lc.nulist = :rulist: AND tp.cdartn = tp2.cdartn) = 1,

        (SELECT lc.prezzo
        FROM Go2B\Models\Lscorp lc
        INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = lc.cdarti
        INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
        WHERE lc.nulist = :rulist: AND tp.cdartn = tp2.cdartn LIMIT 1),
      0), 0) as retailPrice";
    }

    private static function getCustomDiscountLeftJoins($addArticle = true)
    {
        return
            "
      LEFT JOIN Go2B\Models\B2bDisbdy c1
        ON c1.numdis = :numdis: AND c1.cdtitl = tl.cdtitl AND c1.cdtitl != ''
      LEFT JOIN Go2B\Models\B2bDisbdy c2
        ON c2.numdis = :numdis: AND c2.cdtitl = '' AND c2.cdlinm = tp.cdlinm AND c2.cdlinm != '' AND c2.cdserm = ''
      LEFT JOIN Go2B\Models\B2bDisbdy c3
        ON c3.numdis = :numdis: AND c3.cdtitl = '' AND c3.cdlinm = tp.cdlinm AND c3.cdlinm != '' AND c3.cdserm = tp.cdserm AND c3.cdserm != ''
      LEFT JOIN Go2B\Models\B2bDisbdy c4
        ON c4.numdis = :numdis: AND c4.cdtitl = '' AND c4.cdlinm = '' AND c4.cdserm = '' AND c4.tpmode = tp.tpmode AND c4.tpmode != ''
      LEFT JOIN Go2B\Models\B2bDisbdy c5
        ON c5.numdis = :numdis: AND c5.cdtitl = '' AND c5.cdlinm = '' AND c5.cdserm = '' AND c5.tpmode = '' AND c5.cdartn = tp.cdartn AND c5.cdartn != '' " .
            ($addArticle
                ? "LEFT JOIN Go2B\Models\B2bDisbdy c6
        ON c6.numdis = :numdis: AND c6.cdtitl = '' AND c6.cdlinm = '' AND c6.cdserm = '' AND c6.tpmode = '' AND c6.cdartn = '' AND c6.cdarti = aa.cdarti AND c6.cdarti != '' "
                : '');
    }

    private static function getCustomDiscountFields($addArticle = true)
    {
        $maxDiscountParam = Di::getDefault()->get('utility')->getAppSettings('MaxDiscountInCollection') == 1;
        if (Di::getDefault()->get('utility')->getAppSettings('MaxDiscountInCollection') == 1) {
            return 'MAX(COALESCE(c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0)) AS cust_disc' . ($addArticle ? ', MAX(COALESCE(c6.sconto,0)) AS art_cust_disc ' : '');
        }

        return 'COALESCE(c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc' . ($addArticle ? ', COALESCE(c6.sconto,0) AS art_cust_disc ' : '');
    }
    //endregion

    //region Custom queries
    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllModelsForCatalog($items)
    {
        $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist']);

        $having = '';

        // Catalog price
        $catalogPrice = self::getCatalogPriceSubquery();

        // Retail price
        if ($items['rulist'] != '') {
            $retailPrice = self::getRetailPriceSubquery();
            $params['rulist'] = $items['rulist'];
        } else {
            $retailPrice = '0 AS retailPrice';
        }

        // Dsartn, dslinm, dsserm translation
        $leftJoinTransl =
            "LEFT JOIN Go2B\Models\B2bAddinf i1 ON i1.tabell = 'linmod' AND i1.codic1 = lm.cdlinm AND i1.codic2 = '' AND i1.tpdato = :tpdato:
       LEFT JOIN Go2B\Models\B2bAddinf i2 ON i2.tabell = 'sermod' AND i2.codic1 = sm.cdserm AND i2.codic2 = sm.cdlinm AND i2.tpdato = :tpdato: ";
        $params['tpdato'] = 'des_' . strtolower($items['idlang']);

        if ($items['idlang'] != 'IT') {
            $dsartn = 'COALESCE(d2.descri, d1.descri,tp.dsartn) AS dsartn';
            $dslinm = 'COALESCE(i1.valore,d1.descri,lm.dslinm)';
            $dsserm = 'COALESCE(i2.valore,d1.descri,sm.dsserm)';
            $leftJoinTransl .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
            $leftJoinTransl .= " LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";

            $params['idlang'] = $items['idlang'];
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $dslinm = 'COALESCE(i1.valore,lm.dslinm)';
            $dsserm = 'COALESCE(i2.valore,sm.dsserm)';
        }

        // Presence and availability
        $presence = '';
        $isAvailable = '';
        $leftJoinArtcol = '';
        if ($items['isOrder']) {
            // Presence
            $whr1_pr = '';
            if ($items['isPT']) {
                $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
                // 08/01/2024 Da adeguare a Anaart::getAllArtColForCatalog() ???
//                $leftJoinArtcol = ' INNER JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti AND aa.flbloc = 0 ';
//                $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
                $whr1_pr = ' AND (oc1.cdcolo = ac.cdcolo OR (oc1.cdcolo = \'\' AND ac.cdcolo IS NULL)) ';
        }

            $params['id_usr'] = $items['idUsr'];
            $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

            // If availability order, add is_available field
            if ($items['isAvailability']) {
                $whr1_av = '';
                $whr2_av = '';
                if ($items['isPT']) {
                    $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
//                    $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
                    $whr2_av = ' AND (dc2.cdcolo = ac.cdcolo OR (dc2.cdcolo = \'\' AND ac.cdcolo IS NULL)) ';
                }

                $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

                // If parameter "show not available" is false, filter not available items
                if (!$items['showNotAvailable']) {
                    $having = ' HAVING is_available = 1 ';
                }
            }
        }

        // Custom discount
        if ($items['numdis'] > 0) {
            $custDisc = self::getCustomDiscountFields();
            $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
            $params['numdis'] = $items['numdis'];
        } else {
            $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
            $leftJoinDisbdy = '';
        }

        // Sales items
        if ($items['isSales']) {
            $having .= ($having != '' ? ' AND ' : 'HAVING ') . ' (cust_disc > 0 OR art_cust_disc > 0) ';
        }

        // Section selected
        $whereSection = $items['section']['where'];
        if ($whereSection != '') {
            if (isset($items['section']['code'])) {
                $params['code'] = $items['section']['code'];
            } else {
                $params['code1'] = $items['section']['code1'];
                $params['code2'] = $items['section']['code2'];
            }
        }

        // Tag
        $innerJoinArtcla = '';
        if ($items['tag'] != '') {
            $params['tag'] = $items['tag'];
            if ($items['tagType'] == 'AN') {
                $innerJoinArtcla = 'INNER JOIN Go2B\Models\Artcla arc ON arc.tpinpu = "AN" AND arc.codice = tp.cdartn AND arc.tpclas LIKE "TB2%" AND arc.valore = :tag:';
            } else {
                $innerJoinArtcla = 'INNER JOIN Go2B\Models\Artcla arc ON arc.tpinpu = "AR" AND arc.codice = ca.cdarti AND arc.tpclas LIKE "TB2%" AND arc.valore = :tag:';
            }
        }

        // Filters
        $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
        $innerJoinFilters .= $items['filters']['joins'];
        $whereFilters = $items['filters']['where'];

        // Price filter
        if ($items['filters']['price'] != '') {
            $having .= ($having != '' ? ' AND ' : ' HAVING ') . $items['filters']['price'];
        }

        // Different sorting
        if ($items['hasCustomSorting']) {
            $tpdato = $items['isSpecialSorting'] ? 'seqra2' : 'seqrap';
            $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = '$tpdato' ";
            $seqrapField = "COALESCE(tpsr.valore, 0) AS customSeqrap,";
            $seqrapOrder = 'customSeqrap + 0';
        } else {
            if ($items['isSpecialSorting']) {
                $seqrapField = "COALESCE(tpsr.valore, 0) AS customSeqrap,";
                $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqra2' ";
                $seqrapOrder = 'customSeqrap + 0';
            } else {
                $seqrapField = '';
                $leftJoinSeqrap = '';
                $seqrapOrder = 'tp.seqrap';
            }
        }

        $query = "SELECT tp.cdartn, $dsartn, lm.cdtitl, tl.dstitl, tp.cdlinm,
      $dslinm AS dslinm, COALESCE(limg.valore,'') AS banner_linm,
      tp.cdserm, $dsserm AS dsserm, COALESCE(simg.valore,'') AS banner_serm,
      tp.tpgene, tp.tpmode, tp.cdtagl, tp.tppers, tp.flimag, $seqrapField
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $custDisc
      $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti AND aa.flbloc = 0
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn AND tp.flbloc = 0
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf limg ON limg.tabell = 'linmod' AND limg.codic1 = lm.cdlinm AND limg.codic2 = '' AND limg.tpdato = 'banner'
      LEFT JOIN Go2B\Models\B2bAddinf simg ON simg.tabell = 'sermod' AND simg.codic1 = sm.cdlinm AND simg.codic2 = sm.cdserm AND simg.tpdato = 'banner'
      $innerJoinArtcla
      $innerJoinFilters
      $leftJoinDisbdy
      $leftJoinTransl
      $leftJoinArtcol
      $leftJoinSeqrap
      WHERE ca.cdcata = :cdcata:
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      $whereSection
      $whereFilters
      GROUP BY tp.cdartn
      $having
      ORDER BY lm.cdtitl, tp.cdlinm, tp.cdserm, $seqrapOrder, tp.cdartn";
        // Utility::dumpQuery($query, $params, true, true);
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllSimpleModelsForCatalog($items)
    {
        $params = array('cdcata' => $items['cdcata']);

        // Dsartn, dslinm, dsserm translation
        $leftJoinTransl =
            "LEFT JOIN Go2B\Models\B2bAddinf i1 ON i1.tabell = 'linmod' AND i1.codic1 = lm.cdlinm AND i1.codic2 = '' AND i1.tpdato = :tpdato:
       LEFT JOIN Go2B\Models\B2bAddinf i2 ON i2.tabell = 'sermod' AND i2.codic1 = sm.cdserm AND i2.codic2 = sm.cdlinm AND i2.tpdato = :tpdato: ";
        $params['tpdato'] = 'des_' . strtolower($items['idlang']);

        if ($items['idlang'] != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $dslinm = 'COALESCE(i1.valore,d1.descri,lm.dslinm)';
            $dsserm = 'COALESCE(i2.valore,d1.descri,sm.dsserm)';
            $leftJoinTransl .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
            $params['idlang'] = $items['idlang'];
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $dslinm = 'COALESCE(i1.valore,lm.dslinm)';
            $dsserm = 'COALESCE(i2.valore,sm.dsserm)';
        }

        // Section selected
        $andWhere = '';
        if (!empty($items['cdtitl'])) {
            $andWhere .= ' AND lm.cdtitl = :cdtitl: ';
            $params['cdtitl'] = $items['cdtitl'];
        }
        if (!empty($items['cdlinm'])) {
            $andWhere .= ' AND tp.cdlinm = :cdlinm: ';
            $params['cdlinm'] = $items['cdlinm'];
        }
        if (!empty($items['cdserm'])) {
            $andWhere .= ' AND tp.cdserm = :cdserm: ';
            $params['cdserm'] = $items['cdserm'];
        }

        // Different sorting
        $valore = $items['isSpecialSorting'] ? 'tps2.valore' : 'tpsr.valore';

        $query = "SELECT tp.cdartn, $dsartn, lm.cdtitl, tl.dstitl, tp.cdlinm, $dslinm AS dslinm, tp.cdserm,
      $dsserm AS dsserm, tp.flimag, COALESCE($valore, tp.seqrap) AS customSeqrap, COALESCE(tm.dstmod, '') AS dstmod,
      COALESCE(tpsr.valore, 0) AS seqrap, COALESCE(tps2.valore, 0) AS seqra2
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Tpmode tm ON tm.tpmode = tp.tpmode
      LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqrap'
      LEFT JOIN Go2B\Models\B2bAddinf tps2 ON tps2.tabell = 'tipolo' AND tps2.codic1 = tp.cdartn AND tps2.codic2 = '' AND tps2.tpdato = 'seqra2'
      $leftJoinTransl
      WHERE ca.cdcata = :cdcata:
      $andWhere
      GROUP BY tp.cdartn
      ORDER BY lm.cdtitl, tp.cdlinm, tp.cdserm, customSeqrap + 0, tp.cdartn";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllModelsForCatalogList($items)
    {
        $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist']);

        $having = '';

        // Catalog price
        $catalogPrice = self::getCatalogPriceSubquery();

        // Retail price
        if ($items['rulist'] != '') {
            $retailPrice = self::getRetailPriceSubquery();
            $params['rulist'] = $items['rulist'];
        } else {
            $retailPrice = '0 AS retailPrice';
        }

        // PRIMA
        // Dsartn translation
        // if ($items['idlang'] != 'IT') {
        //     $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
        //     $leftJoinTransl = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
        //     $params['idlang'] = $items['idlang'];
        // } else {
        //     $dsartn = 'tp.dsartn AS dsartn';
        //     $leftJoinTransl = '';
        // }
        // DOPO
        // Dsartn, dslinm, dsserm translation
        $leftJoinTransl =
            "LEFT JOIN Go2B\Models\B2bAddinf i1 ON i1.tabell = 'linmod' AND i1.codic1 = lm.cdlinm AND i1.codic2 = '' AND i1.tpdato = :tpdato:
       LEFT JOIN Go2B\Models\B2bAddinf i2 ON i2.tabell = 'sermod' AND i2.codic1 = sm.cdserm AND i2.codic2 = sm.cdlinm AND i2.tpdato = :tpdato: ";
        $params['tpdato'] = 'des_' . strtolower($items['idlang']);

        if ($items['idlang'] != 'IT') {
            $dsartn = 'COALESCE(d2.descri, d1.descri,tp.dsartn) AS dsartn';
            $dslinm = 'COALESCE(i1.valore,d1.descri,lm.dslinm)';
            $dsserm = 'COALESCE(i2.valore,d1.descri,sm.dsserm)';
            $leftJoinTransl .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
            $leftJoinTransl .= " LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";

            $params['idlang'] = $items['idlang'];
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $dslinm = 'COALESCE(i1.valore,lm.dslinm)';
            $dsserm = 'COALESCE(i2.valore,sm.dsserm)';
        }

        // Presence and availability
        $presence = '';
        $isAvailable = '';
        $leftJoinArtcol = '';
        if ($items['isOrder']) {
            // Presence
            $whr1_pr = '';
            if ($items['isPT']) {
                $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
                // 08/01/2024 Da adeguare a Anaart::getAllArtColForCatalog() ???
//                $leftJoinArtcol = ' INNER JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti AND aa.flbloc = 0 ';
//                $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
                $whr1_pr = ' AND (oc1.cdcolo = ac.cdcolo OR (oc1.cdcolo = \'\' AND ac.cdcolo IS NULL)) ';
        }

            $params['id_usr'] = $items['idUsr'];
            $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

            // If availability order, add is_available field
            if ($items['isAvailability']) {
                $whr1_av = '';
                $whr2_av = '';
                if ($items['isPT']) {
                    $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
//                    $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
                    $whr2_av = ' AND (dc2.cdcolo = ac.cdcolo OR (dc2.cdcolo = \'\' AND ac.cdcolo IS NULL)) ';
                }

                $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

                // If parameter "show not available" is false, filter not available items
                if (!$items['showNotAvailable']) {
                    $having = ' HAVING is_available = 1 ';
                }
            }
        }

        // Custom discount
        if ($items['numdis'] > 0) {
            $custDisc = self::getCustomDiscountFields();
            $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
            $params['numdis'] = $items['numdis'];
        } else {
            $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
            $leftJoinDisbdy = '';
        }

        // Sales items
        if ($items['isSales']) {
            $having .= ($having != '' ? ' AND ' : 'HAVING ') . ' (cust_disc > 0 OR art_cust_disc > 0) ';
        }

        // Section selected
        $whereSection = $items['section']['where'];
        if ($whereSection != '') {
            if (isset($items['section']['code'])) {
                $params['code'] = $items['section']['code'];
            } else {
                $params['code1'] = $items['section']['code1'];
                $params['code2'] = $items['section']['code2'];
            }
        }

        // Tag
        $innerJoinArtcla = '';
        if ($items['tag'] != '') {
            $params['tag'] = $items['tag'];
            if ($items['tagType'] == 'AN') {
                $innerJoinArtcla = 'INNER JOIN Go2B\Models\Artcla arc ON arc.tpinpu = "AN" AND arc.codice = tp.cdartn AND arc.tpclas LIKE "TB2%" AND arc.valore = :tag:';
            } else {
                $innerJoinArtcla = 'INNER JOIN Go2B\Models\Artcla arc ON arc.tpinpu = "AR" AND arc.codice = ca.cdarti AND arc.tpclas LIKE "TB2%" AND arc.valore = :tag:';
            }
        }

        // Filters
        $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
        $innerJoinFilters .= $items['filters']['joins'];
        $whereFilters = $items['filters']['where'];

        // Price filter
        if ($items['filters']['price'] != '') {
            $having .= ($having != '' ? ' AND ' : ' HAVING ') . $items['filters']['price'];
        }

        // Different sorting
        if ($items['hasCustomSorting']) {
            $tpdato = $items['isSpecialSorting'] ? 'seqra2' : 'seqrap';
            $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = '$tpdato' ";
            $seqrapField = "COALESCE(tpsr.valore, 0) AS customSeqrap,";
            $seqrapOrder = 'customSeqrap + 0';
        } else {
            if ($items['isSpecialSorting']) {
                $seqrapField = "COALESCE(tpsr.valore, 0) AS customSeqrap,";
                $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqra2' ";
                $seqrapOrder = 'customSeqrap + 0';
            } else {
                $seqrapField = '';
                $leftJoinSeqrap = '';
                $seqrapOrder = 'tp.seqrap';
            }
        }

        $query = "SELECT tp.cdartn, aa.cdarti, $dsartn, tp.cdserm, $dsserm AS dsserm, tp.tppers, tp.flimag, tp.cdtagl,
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $custDisc, $seqrapField
      tp.tglini, tp.tglfin $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti AND aa.flbloc = 0
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn AND tp.flbloc = 0
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf limg ON limg.tabell = 'linmod' AND limg.codic1 = lm.cdlinm AND limg.codic2 = '' AND limg.tpdato = 'banner'
      LEFT JOIN Go2B\Models\B2bAddinf simg ON simg.tabell = 'sermod' AND simg.codic1 = sm.cdlinm AND simg.codic2 = sm.cdserm AND simg.tpdato = 'banner'
      $innerJoinArtcla
      $innerJoinFilters
      $leftJoinDisbdy
      $leftJoinTransl
      $leftJoinArtcol
      $leftJoinSeqrap
      WHERE ca.cdcata = :cdcata:
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      $whereSection
      $whereFilters
      GROUP BY tp.cdartn
      $having
      ORDER BY lm.cdtitl, tp.cdlinm, tp.cdserm, $seqrapOrder, tp.cdartn";
//        Utility::dumpQuery($query, $params, true, true);
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllModelsForCatalogFromSearch($items, $checkSearchType = true)
    {
        $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist'], 'search' => $items['search']);

        $having = '';

        // Catalog price
        $catalogPrice = self::getCatalogPriceSubquery();

        // Retail price
        if ($items['rulist'] != '') {
            $retailPrice = self::getRetailPriceSubquery();
            $params['rulist'] = $items['rulist'];
        } else {
            $retailPrice = '0 AS retailPrice';
        }

        // Dsartn translation
        if ($items['idlang'] != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $leftJoinDsartn = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
            $params['idlang'] = $items['idlang'];
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $leftJoinDsartn = '';
        }

        // Search type
        $searchFields = '';
        $leftJoinSearchType = '';
        $andWhereSearchType = '';
        if ($checkSearchType && $items['searchType'] > 0) {
            $searchFields = ", tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, lm.dslinm, COALESCE(sm.dsserm,'') AS dsserm ";
            $leftJoinSearchType = 'LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
                             LEFT JOIN Go2B\Models\Tpmode tm ON tp.tpmode = tm.tpmode ';
            $andWhereSearchType = ' OR (tp.tpmode LIKE :search: OR dstmod LIKE :search:) OR (lm.dslinm LIKE :search: OR dsserm LIKE :search:)';

            if ($items['searchType'] == 2) {
                $searchFields .= ", COALESCE(sa.valore,'') AS bolla ";
                $leftJoinSearchType .= "LEFT JOIN Go2B\Models\Sparti sa ON aa.cdarti = sa.cdarti AND sa.tpcomp = 'BOLLA' ";
                $andWhereSearchType .= ' OR (sa.valore LIKE :search:)';
            }
        }
        // Barcode
        if (!empty($items['barcode'])) {
            $searchFields .= ', bc.nubrcd';
            $leftJoinSearchType .= " LEFT JOIN Go2B\Models\Barcod bc ON aa.cdarti = bc.cdarti AND bc.nubrcd LIKE :barcode: ";
            $params['barcode'] = $items['barcode'];
            $andWhereSearchType .= ' OR (bc.nubrcd IS NOT NULL)';
        }
        // Presence
        $presence = '';
        $isAvailable = '';
        $leftJoinArtcol = '';
        if ($items['isOrder']) {
            // Presence
            $whr1_pr = '';
            if ($items['isPT']) {
                $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
                $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
            }

            $params['id_usr'] = $items['idUsr'];
            $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

            // If availability order, add is_available field
            if ($items['isAvailability']) {
                $whr1_av = '';
                $whr2_av = '';
                if ($items['isPT']) {
                    $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
                    $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
                }

                $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

                // If parameter "show not available" is false, filter not available items
                if (!$items['showNotAvailable']) {
                    $having = ' HAVING is_available = 1 ';
                }
            }
        }

        // Custom discount
        if ($items['numdis'] > 0) {
            $custDisc = self::getCustomDiscountFields();
            $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
            $params['numdis'] = $items['numdis'];
        } else {
            $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
            $leftJoinDisbdy = '';
        }
//        $scontoBaseCliente = (!empty($items['customerDiscount']) ? $items['customerDiscount'] : 0);
//        if ($items['numdis'] > 0) {
//            $custDisc = self::getCustomDiscountFields();
//            $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
//            $params['numdis'] = $items['numdis'];
//        } else {
//            $custDisc = "$scontoBaseCliente AS cust_disc, $scontoBaseCliente AS art_cust_disc ";
//            $leftJoinDisbdy = '';
//        }

        // Filters
        $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
        $innerJoinFilters .= in_array('CF', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn ' : '';
        $innerJoinFilters .= $items['filters']['joins'];
        $whereFilters = $items['filters']['where'];

        // Price filter
        if ($items['filters']['price'] != '') {
            $having .= ($having != '' ? ' AND ' : ' HAVING ') . $items['filters']['price'];
        }

        // Different sorting
        if ($items['hasCustomSorting']) {
            $tpdato = $items['isSpecialSorting'] ? 'seqra2' : 'seqrap';
            $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = '$tpdato' ";
            $seqrapField = "COALESCE(tpsr.valore, 0) AS customSeqrap,";
            $seqrapOrder = 'customSeqrap';
        } else {
            if ($items['isSpecialSorting']) {
                $seqrapField = "COALESCE(tpsr.valore, 0) AS customSeqrap,";
                $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqra2' ";
                $seqrapOrder = 'customSeqrap';
            } else {
                $seqrapField = '';
                $leftJoinSeqrap = '';
                $seqrapOrder = 'tp.seqrap';
            }
        }

        // Availability flag
        $hasAvailabilityFlag = '0 AS hasAvailabilityFlag';
        $innerJoinArtcla = '';
        if ($items['showAvailabilityFlag']) {
            $hasAvailabilityFlag = 'COALESCE(MAX(ac.valore), 0) AS hasAvailabilityFlag';
            $innerJoinArtcla = "LEFT JOIN Go2B\Models\Artcla ac ON ac.tpinpu = 'AR' AND ac.codice = aa.cdarti AND ac.tpclas = 'DISP'";
        }

        $query = "SELECT tp.cdartn, $dsartn, lm.cdtitl, tp.cdlinm, tp.cdserm,
      tp.tpgene, tp.tpmode, tp.cdtagl, tp.tppers, tp.flimag, $seqrapField
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $hasAvailabilityFlag, $custDisc
      $searchFields $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      $innerJoinFilters
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $leftJoinDisbdy
      $leftJoinDsartn
      $innerJoinArtcla
      $leftJoinArtcol
      $leftJoinSeqrap
      $leftJoinSearchType
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      AND ((tp.cdartn LIKE :search: OR dsartn LIKE :search:) $andWhereSearchType)
      $whereFilters
      GROUP BY tp.cdartn
      $having
      ORDER BY $seqrapOrder, tp.cdartn";

//        Utility::dumpQuery($query, $params, true, true);

        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllModelsForCatalogFromListSearch($items, $checkSearchType = true)
    {
        $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist'], 'search' => $items['search']);

        // Catalog price
        $catalogPrice = self::getCatalogPriceSubquery();

        // Retail price
        if ($items['rulist'] != '') {
            $retailPrice = self::getRetailPriceSubquery();
            $params['rulist'] = $items['rulist'];
        } else {
            $retailPrice = '0 AS retailPrice';
        }

        // Dsartn translation
        if ($items['idlang'] != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $leftJoinDsartn = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
            $params['idlang'] = $items['idlang'];
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $leftJoinDsartn = '';
        }

        // Search type
        $searchFields = '';
        $leftJoinSearchType = '';
        $andWhereSearchType = '';
        if ($checkSearchType && $items['searchType'] > 0) {
            $searchFields = ", tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, lm.dslinm, COALESCE(sm.dsserm,'') AS dsserm ";
            $leftJoinSearchType = 'LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
                             LEFT JOIN Go2B\Models\Tpmode tm ON tp.tpmode = tm.tpmode ';
            $andWhereSearchType = ' OR (tp.tpmode LIKE :search: OR dstmod LIKE :search:) OR (lm.dslinm LIKE :search: OR dsserm LIKE :search:)';

            if ($items['searchType'] == 2) {
                $searchFields .= ", COALESCE(sa.valore,'') AS bolla ";
                $leftJoinSearchType .= "LEFT JOIN Go2B\Models\Sparti sa ON aa.cdarti = sa.cdarti AND sa.tpcomp = 'BOLLA' ";
                $andWhereSearchType .= ' OR (sa.valore LIKE :search:)';
            }
        }
        // Barcode
        if (!empty($items['barcode'])) {
            $searchFields .= ', bc.nubrcd';
            $leftJoinSearchType .= " LEFT JOIN Go2B\Models\Barcod bc ON aa.cdarti = bc.cdarti AND bc.nubrcd LIKE :barcode: ";
            $params['barcode'] = $items['barcode'];
            $andWhereSearchType .= ' OR (bc.nubrcd IS NOT NULL)';
        }

        // Presence and availability
        $presence = '';
        $isAvailable = '';
        $leftJoinArtcol = '';
        $having = '';
        if ($items['isOrder']) {
            // Presence
            $whr1_pr = '';
            if ($items['isPT']) {
                $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
                $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
            }

            $params['id_usr'] = $items['idUsr'];
            $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
        -1) AS presence ";

            // If availability order, add is_available field
            if ($items['isAvailability']) {
                $whr1_av = '';
                $whr2_av = '';
                if ($items['isPT']) {
                    $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
                    $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
                }

                $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
              COALESCE(
                (SELECT SUM(og2.quanti)
                FROM Go2B\Models\Octagl og2
                INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
                FROM Go2B\Models\Dscorp dc2
                WHERE dc2.cdarti = aa.cdarti $whr2_av),
                0)
                ) > 0, true, false) AS is_available ";

                // If parameter "show not available" is false, filter not available items
                if (!$items['showNotAvailable']) {
                    $having = ' HAVING is_available = 1 ';
                }
            }
        }

        // Custom discount
        if ($items['numdis'] > 0) {
            $custDisc = self::getCustomDiscountFields();
            $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
            $params['numdis'] = $items['numdis'];
        } else {
            $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
            $leftJoinDisbdy = '';
        }

        // Different sorting
        if ($items['hasCustomSorting']) {
            $tpdato = $items['isSpecialSorting'] ? 'seqra2' : 'seqrap';
            $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = '$tpdato' ";
            $seqrapField = "COALESCE(tpsr.valore, 0) AS customSeqrap,";
            $seqrapOrder = 'customSeqrap';
        } else {
            if ($items['isSpecialSorting']) {
                $seqrapField = "COALESCE(tpsr.valore, 0) AS customSeqrap,";
                $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqra2' ";
                $seqrapOrder = 'customSeqrap';
            } else {
                $seqrapField = '';
                $leftJoinSeqrap = '';
                $seqrapOrder = 'tp.seqrap';
            }
        }

        $query = "SELECT tp.cdartn, $dsartn, tp.tppers, tp.flimag, tp.cdtagl,
      $catalogPrice, $retailPrice, $custDisc, $seqrapField
      tp.tglini, tp.tglfin $searchFields $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $leftJoinDisbdy
      $leftJoinDsartn
      $leftJoinArtcol
      $leftJoinSeqrap
      $leftJoinSearchType
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      AND ((tp.cdartn LIKE :search: OR dsartn LIKE :search:) $andWhereSearchType)
      GROUP BY tp.cdartn
      $having
      ORDER BY $seqrapOrder, tp.cdartn";

        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllModelsFromFabricForCatalog($items)
    {
        $params = array('cdcata' => $items['cdcata'], 'cdpers' => $items['cdpers'], 'nulist' => $items['nulist']);

        // Catalog price
        $catalogPrice = self::getCatalogPriceSubquery();

        // Retail price
        if ($items['rulist'] != '') {
            $retailPrice = self::getRetailPriceSubquery();
            $params['rulist'] = $items['rulist'];
        } else {
            $retailPrice = '0 AS retailPrice';
        }

        // Dsartn translation
        if ($items['idlang'] != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $leftJoinDsartn = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
            $params['idlang'] = $items['idlang'];
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $leftJoinDsartn = '';
        }

        // Presence
        $presence = '';
        $leftJoinArtcol = '';
        if ($items['isOrder']) {
            // Presence
            $whr1_pr = '';
            if ($items['isPT']) {
                $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
                $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
            }

            $params['id_usr'] = $items['idUsr'];
            $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";
        }

        // Custom discount
        if ($items['numdis'] > 0) {
            $custDisc = self::getCustomDiscountFields();
            $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
            $params['numdis'] = $items['numdis'];
        } else {
            $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
            $leftJoinDisbdy = '';
        }

        // Section selected
        $whereSection = $items['section']['where'];
        if ($whereSection != '') {
            if (isset($items['section']['code'])) {
                $params['code'] = $items['section']['code'];
            } else {
                $params['code1'] = $items['section']['code1'];
                $params['code2'] = $items['section']['code2'];
            }
        }

        // Filters
        $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
        $innerJoinFilters .= $items['filters']['joins'];
        $whereFilters = $items['filters']['where'];

        // Price filter
        $having = '';
        if ($items['filters']['price'] != '') {
            $having .= ' HAVING ' . $items['filters']['price'];
        }

        // Different sorting
        if ($items['isSpecialSorting']) {
            $seqrapField = "COALESCE(tpsr.valore,0) AS seqrap,";
            $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqra2' ";
            $seqrapOrder = 'seqrap';
        } else {
            $seqrapField = '';
            $leftJoinSeqrap = '';
            $seqrapOrder = 'tp.seqrap';
        }

        $query = "SELECT tp.cdartn, $dsartn, lm.cdtitl, tl.dstitl, tp.cdlinm,
      lm.dslinm, tp.cdserm, sm.dsserm, $seqrapField
      tp.tpgene, tp.tpmode, tp.cdtagl, tp.tppers, tp.flimag,
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $custDisc
      $presence
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $innerJoinFilters
      $leftJoinDisbdy
      $leftJoinDsartn
      $leftJoinArtcol
      $leftJoinSeqrap
      WHERE ca.cdcata = :cdcata: AND ap.cdpers = :cdpers:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      $whereSection
      $whereFilters
      GROUP BY tp.cdartn
      $having
      ORDER BY lm.cdtitl, tp.cdlinm, tp.cdserm, $seqrapOrder, tp.cdartn";

        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllModelsForSelection($items)
    {
        $params = array('cdcata' => $items['cdcata'], 'cdspsl' => $items['cdspsl'], 'nulist' => $items['nulist']);

        $having = '';

        // Catalog price
        $catalogPrice = self::getCatalogPriceSubquery();

        // Retail price
        if ($items['rulist'] != '') {
            $retailPrice = self::getRetailPriceSubquery();
            $params['rulist'] = $items['rulist'];
        } else {
            $retailPrice = '0 AS retailPrice';
        }

        // Dsartn, dslinm, dsserm translation
        $leftJoinTransl =
            "LEFT JOIN Go2B\Models\B2bAddinf i1 ON i1.tabell = 'linmod' AND i1.codic1 = lm.cdlinm AND i1.codic2 = '' AND i1.tpdato = :tpdato:
       LEFT JOIN Go2B\Models\B2bAddinf i2 ON i2.tabell = 'sermod' AND i2.codic1 = sm.cdserm AND i2.codic2 = sm.cdlinm AND i2.tpdato = :tpdato: ";
        $params['tpdato'] = 'des_' . strtolower($items['idlang']);

        if ($items['idlang'] != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $dslinm = 'COALESCE(i1.valore,d1.descri,lm.dslinm)';
            $dsserm = 'COALESCE(i2.valore,d1.descri,sm.dsserm)';
            $leftJoinTransl .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
            $params['idlang'] = $items['idlang'];
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $dslinm = 'COALESCE(i1.valore,lm.dslinm)';
            $dsserm = 'COALESCE(i2.valore,sm.dsserm)';
        }

        // Presence and availability
        $presence = '';
        $isAvailable = '';
        $leftJoinArtcol = '';
        if ($items['isOrder']) {
            // Presence
            $whr1_pr = '';
            if ($items['isPT']) {
                $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
                $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
            }

            $params['id_usr'] = $items['idUsr'];
            $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

            // If availability order, add is_available field
            if ($items['isAvailability']) {
                $whr1_av = '';
                $whr2_av = '';
                if ($items['isPT']) {
                    $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
                    $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
                }

                $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

                // If parameter "show not available" is false, filter not available items
                if (!$items['showNotAvailable']) {
                    $having = ' HAVING is_available = 1 ';
                }
            }
        }

        // Custom discount
        if ($items['numdis'] > 0) {
            $custDisc = self::getCustomDiscountFields();
            $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
            $params['numdis'] = $items['numdis'];
        } else {
            $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
            $leftJoinDisbdy = '';
        }

        // Section selected
        $whereSection = $items['section']['where'];
        if ($whereSection != '') {
            if (isset($items['section']['code'])) {
                $params['code'] = $items['section']['code'];
            } else {
                $params['code1'] = $items['section']['code1'];
                $params['code2'] = $items['section']['code2'];
            }
        }

        // Filters
        $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
        $innerJoinFilters .= $items['filters']['joins'];
        $whereFilters = $items['filters']['where'];

        // Price filter
        if ($items['filters']['price'] != '') {
            $having .= ($having != '' ? ' AND ' : ' HAVING ') . $items['filters']['price'];
        }

        $query = "SELECT tp.cdartn, $dsartn, lm.cdtitl, tl.dstitl, tp.cdlinm,
      $dslinm AS dslinm, '' AS banner_linm,
      tp.cdserm, $dsserm AS dsserm, '' AS banner_serm,
      tp.tpgene, tp.tpmode, tp.cdtagl, tp.tppers, tp.flimag,
      sc.seqrap, sc.flimag AS custom_flimag, 1 AS is_selection,
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $custDisc
      $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\B2bSscorp sc ON sc.codice = tp.cdartn
      INNER JOIN Go2B\Models\B2bSstest st ON st.cdspsl = sc.cdspsl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $innerJoinFilters
      $leftJoinDisbdy
      $leftJoinTransl
      $leftJoinArtcol
      WHERE ca.cdcata = :cdcata: AND st.cdspsl = :cdspsl: AND st.flbloc = 0
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      $whereSection
      $whereFilters
      GROUP BY tp.cdartn
      $having
      ORDER BY sc.seqrap";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getLinkedBuyProducts($items)
    {
        $params = array('cdartn' => $items['cdartn'], 'nulist' => $items['nulist']);

        // Dsartn translation
        $dsartn = 'tp.dsartn AS dsartn';
        $leftJoinDsartn = '';
        if ($items['idlang'] != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $leftJoinDsartn = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang ";
            $params['idlang'] = $items['idlang'];
        }

        // Custom discount
        $custDisc = '0 AS cust_disc ';
        $leftJoinDisbdy = '';
        if ($items['numdis'] > 0) {
            $custDisc = 'COALESCE(c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
            $leftJoinDisbdy =
                "INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
        LEFT JOIN b2b_disbdy c1 ON c1.cdtitl = lm.cdtitl AND c1.numdis = :numdis
        LEFT JOIN b2b_disbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis
        LEFT JOIN b2b_disbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis
        LEFT JOIN b2b_disbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis
        LEFT JOIN b2b_disbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis ";
            $params['numdis'] = $items['numdis'];
        }

        // Presence and availability
        $presence = '';
        $isAvailable = '';
        $leftJoinArtcol = '';
        $havingNotAvailable = '';
        if ($items['isOrder']) {
            // Presence
            $whr1_pr = '';
            if ($items['isPT']) {
                $leftJoinArtcol = ' LEFT JOIN artcol ac ON ac.cdarti = nn.cdarti ';
                $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
            }

            $params['id_usr'] = $items['idUsr'];
            $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM occorp oc1
          INNER JOIN octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE nn.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

            // If availability order, add is_available field
            if ($items['isAvailability']) {
                $whr1_av = '';
                $whr2_av = '';
                if ($items['isPT']) {
                    $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
                    $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
                }

                $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM octagl og2
                  INNER JOIN occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM dscorp dc2
              WHERE dc2.cdarti = nn.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

                // If parameter "show not available" is false, filter not available items
                if ($items['showAvailables'] == 0) {
                    $havingNotAvailable = ' HAVING is_available = 1 ';
                }
            }
        }

        $query = "SELECT tp.cdartn, $dsartn, tp.tppers, tp.flimag, COALESCE(im.flimag,'') AS flimg2,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice,
      $custDisc,
      nn.quanti $presence $isAvailable
      FROM (
        SELECT aa.cdartn, oc.quanti, aa.cdarti
        FROM (
          SELECT DISTINCT oc3.nuordc, aa3.cdartn
          FROM occorp oc3
          INNER JOIN anaart aa3 ON aa3.cdarti = oc3.cdarti
          WHERE aa3.cdartn = :cdartn
        ) AS oo
        INNER JOIN occorp oc ON oc.nuordc = oo.nuordc
        INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
        WHERE aa.cdartn != oo.cdartn
        GROUP BY aa.cdartn
      ) AS nn
      INNER JOIN tipolo tp ON tp.cdartn = nn.cdartn
      LEFT JOIN lscorp lc ON lc.nulist = :nulist AND lc.cdarti = nn.cdarti
      LEFT JOIN imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'
      $leftJoinDisbdy
      $leftJoinDsartn
      $leftJoinArtcol
      $havingNotAvailable
      ORDER BY nn.quanti DESC
      LIMIT 4";
        return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getSalesModels($items)
    {
        $params = array('cdcata' => $items['cdcata'], 'numdis' => $items['numdis']);

        // Availability
        $isAvailable = '';
        $leftJoinArtcol = '';
        $having = '';
        if ($items['isAvailabilityOrder']) {
            $whr1_av = '';
            $whr2_av = '';
            if ($items['isPT']) {
                $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
                $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
                $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
            }

            $isAvailable = ",
        IF(MAX(
          COALESCE(
            (SELECT MAX(dc2.quanti -
              COALESCE(
                (SELECT SUM(og2.quanti)
                FROM Go2B\Models\Octagl og2
                INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
              ) AS quanti
            FROM Go2B\Models\Dscorp dc2
            WHERE dc2.cdarti = aa.cdarti $whr2_av),
          0)
        ) > 0, true, false) AS is_available ";

            // If parameter "show not available" is false, filter not available items
            if (!$items['showNotAvailable']) {
                $having = ' HAVING is_available = 1 ';
            }
        }

        $custDisc = self::getCustomDiscountFields();
        $leftJoinDisbdy = self::getCustomDiscountLeftJoins();

        $having .= ($having != '' ? ' AND ' : 'HAVING ') . ' (cust_disc > 0 OR art_cust_disc > 0)';

        $query = "SELECT tp.cdartn, $custDisc
      $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      $leftJoinArtcol
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $leftJoinDisbdy
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY tp.cdartn
      $having
      ORDER BY tp.seqrap, tp.cdartn";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getArticleCodesFromModels($where, $params)
    {
        $query = "SELECT a.cdarti
      FROM Go2B\Models\Tipolo t
      INNER JOIN Go2B\Models\Anaart a ON t.cdartn = a.cdartn
      WHERE t.cdartn IN ($where)";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getArticleCodesFromSeasons($where, $params)
    {
        $query = "SELECT DISTINCT a.cdarti
      FROM Go2B\Models\Tipolo t
      INNER JOIN Go2B\Models\Anaart a ON t.cdartn = a.cdartn
      WHERE t.cdstag IN ($where)";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getModelCodesFromCatalog($cdcata)
    {
        $query = "SELECT t.cdartn
      FROM Go2B\Models\Tipolo t
      INNER JOIN Go2B\Models\Anaart a ON t.cdartn = a.cdartn
      INNER JOIN Go2B\Models\Ctarti c ON a.cdarti = c.cdarti
      WHERE c.cdcata = :cdcata:";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllModelsFromCatalog($cdcata = '', $cdstag = '')
    {
        $params = array();
        $where = '';
        if ($cdcata != '') {
            $params['cdcata'] = $cdcata;
            $where = 'WHERE aa.cdarti NOT IN (SELECT ca.cdarti FROM Go2B\Models\Ctarti ca WHERE ca.cdcata = :cdcata: AND ca.cdarti IS NOT NULL)';
        }

        $seasonJoin = '';
        if ($cdstag != '') {
            $where .= $where != '' ? ' AND ' : ' WHERE ';
            $where .= ' ct.cdstag = :cdstag: ';
            $seasonJoin = 'INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
        INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata';
            $params['cdstag'] = $cdstag;
        }

        $query = "SELECT tp.cdartn, tp.dsartn, lm.cdlinm,
      COALESCE(sm.cdserm,'') AS cdserm, tl.cdtitl
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      $seasonJoin
      INNER JOIN Go2B\Models\Linmod lm ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      $where
      GROUP BY tp.cdartn
      ORDER BY tl.cdtitl, lm.seqrap, lm.cdlinm, tp.cdartn";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllSeasonsFromCatalog($cdcata = '')
    {
        $params = array();
        $where = '';
        if ($cdcata != '') {
            $params['cdcata'] = $cdcata;
            $where =
                'INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
         WHERE aa.cdarti NOT IN (SELECT ca.cdarti FROM Go2B\Models\Ctarti ca WHERE ca.cdcata = :cdcata: AND ca.cdarti IS NOT NULL)';
        }

        $query = "SELECT DISTINCT tp.cdstag
      FROM Go2B\Models\Tipolo tp
      $where
      GROUP BY tp.cdartn";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getModelsWithDiscountFromCatalogs($whereCatalogs, $params)
    {
        $query = "SELECT DISTINCT tp.cdartn, tp.dsartn, COALESCE(cb.sconto,0) AS sconto
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bDisbdy cb ON cb.cdartn = tp.cdartn AND cb.numdis = :numdis:
      WHERE ca.cdcata IN ($whereCatalogs)";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getModelsAndRules($whereCatalogs, $whereLines, $params)
    {
        $where = $whereCatalogs != '' ? "WHERE ca.cdcata IN ($whereCatalogs) " : '';
        if ($whereLines != '') {
            $where .= ($whereCatalogs != '' ? "AND " : "WHERE ") . " tp.cdlinm IN ($whereLines)";
        }

        $query = "SELECT DISTINCT tp.cdartn AS code, tp.dsartn AS description,
      COALESCE(ra.qtamin,1) AS ra_qtamin, COALESCE(ra.qtamul,1) AS ra_qtamul, COALESCE(ra.qtamax,0) AS ra_qtamax,
      COALESCE(rm.qtamin,1) AS rm_qtamin, COALESCE(rm.qtamul,1) AS rm_qtamul
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\Regqta ra ON ra.cdartn = tp.cdartn AND ra.cdarti = '' AND ra.cdcolo = '' AND ra.taglia = ''
      LEFT JOIN Go2B\Models\Regqtm rm ON rm.cdartn = tp.cdartn AND rm.cdarti = '' AND rm.cdcolo = ''
      $where";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getModels()
    {
        $query = "SELECT tp.cdartn, tp.dsartn, tl.cdtitl, tp.cdlinm, tp.cdserm,
      tp.tpmode, tp.tpgene, tp.cdstag, tp.seqrap,
      COALESCE(DATE_FORMAT(ba.dtiniz, '%d/%m/%Y'),'') AS dtiniz,
      COALESCE(DATE_FORMAT(ba.dtfine, '%d/%m/%Y'),'') AS dtfine,
      COALESCE(DATE_FORMAT(ba.dtiniz, '%Y%m%d'),'') AS dtiniz_sort,
      COALESCE(DATE_FORMAT(ba.dtfine, '%Y%m%d'),'') AS dtfine_sort
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      ORDER BY tp.cdartn";
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getModelsWithFullInfo()
    {
//    $query = "SELECT
//      tp.cdartn, tp.dsartn AS dsarit,
//      COALESCE(dl1.descri, '') AS dsaren,
//      COALESCE(dl2.descri, '') AS dsares,
//      COALESCE(dl3.descri, '') AS dsarfr,
//      COALESCE(dl4.descri, '') AS dsarde,
//      COALESCE(da1.descri, '') AS dscoit,
//      COALESCE(da2.descri, '') AS dscoen,
//      COALESCE(da3.descri, '') AS dscoes,
//      COALESCE(da4.descri, '') AS dscofr,
//      COALESCE(da5.descri, '') AS dscode,
//      tp.seqrap, tl.dstitl, lm.dslinm, sm.dsserm,
//      ts.dsstag, mi.dettit, mi.detten, mi.dettes,
//      mi.dettfr, mi.dettde, mi.madein, mi.compos,
//      mi.vestib, mi.filpdf, mi.filvid, ba.dtiniz, ba.dtfine
//      FROM Go2B\Models\Tipolo tp
//      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
//      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
//      LEFT JOIN Go2B\Models\Deslin dl1 ON dl1.tpdato = 'dsartn' AND dl1.codic1 = tp.cdartn AND dl1.idlang = 'EN'
//      LEFT JOIN Go2B\Models\Deslin dl2 ON dl2.tpdato = 'dsartn' AND dl2.codic1 = tp.cdartn AND dl2.idlang = 'ES'
//      LEFT JOIN Go2B\Models\Deslin dl3 ON dl3.tpdato = 'dsartn' AND dl3.codic1 = tp.cdartn AND dl3.idlang = 'FR'
//      LEFT JOIN Go2B\Models\Deslin dl4 ON dl4.tpdato = 'dsartn' AND dl4.codic1 = tp.cdartn AND dl4.idlang = 'DE'
//      LEFT JOIN Go2B\Models\Desart da1 ON tp.cdartn = da1.codice AND da1.tpinpu = 'AN' AND da1.idlang = 'IT' AND da1.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Desart da2 ON tp.cdartn = da2.codice AND da2.tpinpu = 'AN' AND da2.idlang = 'EN' AND da2.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Desart da3 ON tp.cdartn = da3.codice AND da3.tpinpu = 'AN' AND da3.idlang = 'ES' AND da3.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Desart da4 ON tp.cdartn = da4.codice AND da4.tpinpu = 'AN' AND da4.idlang = 'FR' AND da4.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Desart da5 ON tp.cdartn = da5.codice AND da5.tpinpu = 'AN' AND da5.idlang = 'DE' AND da5.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
//      LEFT JOIN Go2B\Models\Tabstg ts ON tp.cdstag = ts.cdstag
//      LEFT JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn
//      LEFT JOIN Go2B\Models\B2bTipval ba ON tp.cdartn = ba.cdartn
//      GROUP BY tp.cdartn
//      ORDER BY tp.cdartn";
//    $query = "SELECT
//      tp.cdartn, tp.dsartn AS dsarit,
//      COALESCE(dl1.descri, '') AS dsaren,
//      COALESCE(dl2.descri, '') AS dsares,
//      COALESCE(dl3.descri, '') AS dsarfr,
//      COALESCE(dl4.descri, '') AS dsarde,
//      COALESCE(mi.descit, da1.descri, '') AS dscoit,
//      COALESCE(mi.descen, da2.descri, '') AS dscoen,
//      COALESCE(mi.desces, da3.descri, '') AS dscoes,
//      COALESCE(mi.descfr, da4.descri, '') AS dscofr,
//      COALESCE(mi.descde, da5.descri, '') AS dscode,
//      tp.seqrap, tl.dstitl, lm.dslinm, sm.dsserm,
//      ts.dsstag, mi.dettit, mi.detten, mi.dettes,
//      mi.dettfr, mi.dettde, mi.madein, mi.compos,
//      mi.vestib, mi.filpdf, mi.filvid, ba.dtiniz, ba.dtfine
//      FROM Go2B\Models\Tipolo tp
//      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
//      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
//      LEFT JOIN Go2B\Models\Deslin dl1 ON dl1.tpdato = 'dsartn' AND dl1.codic1 = tp.cdartn AND dl1.idlang = 'EN'
//      LEFT JOIN Go2B\Models\Deslin dl2 ON dl2.tpdato = 'dsartn' AND dl2.codic1 = tp.cdartn AND dl2.idlang = 'ES'
//      LEFT JOIN Go2B\Models\Deslin dl3 ON dl3.tpdato = 'dsartn' AND dl3.codic1 = tp.cdartn AND dl3.idlang = 'FR'
//      LEFT JOIN Go2B\Models\Deslin dl4 ON dl4.tpdato = 'dsartn' AND dl4.codic1 = tp.cdartn AND dl4.idlang = 'DE'
//      LEFT JOIN Go2B\Models\Desart da1 ON tp.cdartn = da1.codice AND da1.tpinpu = 'AN' AND da1.idlang = 'IT' AND da1.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Desart da2 ON tp.cdartn = da2.codice AND da2.tpinpu = 'AN' AND da2.idlang = 'EN' AND da2.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Desart da3 ON tp.cdartn = da3.codice AND da3.tpinpu = 'AN' AND da3.idlang = 'ES' AND da3.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Desart da4 ON tp.cdartn = da4.codice AND da4.tpinpu = 'AN' AND da4.idlang = 'FR' AND da4.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Desart da5 ON tp.cdartn = da5.codice AND da5.tpinpu = 'AN' AND da5.idlang = 'DE' AND da5.tpdesc = 'COMM'
//      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
//      LEFT JOIN Go2B\Models\Tabstg ts ON tp.cdstag = ts.cdstag
//      LEFT JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn
//      LEFT JOIN Go2B\Models\B2bTipval ba ON tp.cdartn = ba.cdartn
//      GROUP BY tp.cdartn
//      ORDER BY tp.cdartn";
        $query = "SELECT 
      tp.cdartn, tp.dsartn AS dsarit, 
      COALESCE(dl1.descri, '') AS dsaren,
      COALESCE(dl2.descri, '') AS dsares,
      COALESCE(dl3.descri, '') AS dsarfr,
      COALESCE(dl4.descri, '') AS dsarde,
      COALESCE(mi.descit, '') AS dscoit,
      COALESCE(mi.descen, '') AS dscoen,
      COALESCE(mi.desces, '') AS dscoes,
      COALESCE(mi.descfr, '') AS dscofr,
      COALESCE(mi.descde, '') AS dscode,
      tp.seqrap, tl.dstitl, lm.dslinm, sm.dsserm,
      ts.dsstag, mi.dettit, mi.detten, mi.dettes,
      mi.dettfr, mi.dettde, mi.madein, mi.compos,
      mi.vestib, mi.filpdf, mi.filvid, ba.dtiniz, ba.dtfine
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Deslin dl1 ON dl1.tpdato = 'dsartn' AND dl1.codic1 = tp.cdartn AND dl1.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin dl2 ON dl2.tpdato = 'dsartn' AND dl2.codic1 = tp.cdartn AND dl2.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dl3 ON dl3.tpdato = 'dsartn' AND dl3.codic1 = tp.cdartn AND dl3.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dl4 ON dl4.tpdato = 'dsartn' AND dl4.codic1 = tp.cdartn AND dl4.idlang = 'DE'
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      LEFT JOIN Go2B\Models\Tabstg ts ON tp.cdstag = ts.cdstag
      LEFT JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn
      LEFT JOIN Go2B\Models\B2bTipval ba ON tp.cdartn = ba.cdartn
      GROUP BY tp.cdartn
      ORDER BY tp.cdartn";
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllModelsForCustomVar($cdregv, $cdvari, $idlang = 'IT')
    {
        if ($idlang != 'IT') {
            $dsartn = 'COALESCE(d1.descri,t.dsartn) AS dsartn';
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = t.cdartn AND d1.idlang = :idlang: ";
        } else {
            $dsartn = 't.dsartn AS dsartn';
            $lnJoin = '';
        }

        $query = "SELECT t.cdartn, $dsartn, IF(EXISTS(SELECT m.cdartn FROM Go2B\Models\Modvar m WHERE m.cdregv = :cdregv: AND m.cdvari = :cdvari: AND m.cdartn = t.cdartn), 1, 0) AS exist
      FROM Go2B\Models\Tipolo t
      $lnJoin
      GROUP BY t.cdartn";

        $params = $idlang != 'IT'
            ? array('cdregv' => $cdregv, 'cdvari' => $cdvari, 'idlang' => $idlang)
            : array('cdregv' => $cdregv, 'cdvari' => $cdvari);

        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getModelsFromLookbook($cdlkbk)
    {
        $query = 'SELECT tp.cdartn, tp.dsartn, tp.cdlinm, tp.cdserm
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Cttest ct ON ca.cdcata = ct.cdcata
      INNER JOIN Go2B\Models\Lktest lt ON ct.cdcata = lt.cdcata
      WHERE lt.cdlkbk = :cdlkbk:
      GROUP BY tp.cdartn
      ORDER BY tp.cdlinm, tp.cdserm, tp.cdartn';
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getModelsFromClassification($idClassificazione, $cdcata, $nulist, $idlang = 'IT')
    {
//        $query = 'SELECT *
//      FROM Go2B\Models\Tipolo tp
//      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
//      INNER JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn
//      WHERE mi.clsfz1 = :clsfzn: OR mi.clsfz2 = :clsfzn: OR mi.clsfz3 = :clsfzn: OR mi.clsfz4 = :clsfzn:
//      GROUP BY tp.cdartn
//      ORDER BY tp.cdlinm, tp.cdserm, tp.cdartn';

        if (empty($idlang)) {
            $idlang = 'IT';
        }

        // Catalog price
        $catalogPrice = self::getCatalogPriceSubquery();

        $params = array('cdcata' => $cdcata, 'nulist' => $nulist, 'clsfzn' => $idClassificazione, 'idlang' => $idlang);
        if ($idlang != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $dslinm = 'COALESCE(d2.descri,lm.dslinm) AS dslinm';
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dslinm' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $dslinm = 'lm.dslinm AS dslinm';
            $lnJoin = '';
        }

        $modDescComm = 'mi.desc' . strtolower($idlang);
        $query = "SELECT tp.cdartn, $dsartn, tl.cdtitl, tl.dstitl, tp.cdlinm, $dslinm,
      tp.cdserm, sm.dsserm, tp.tpgene, tg.dsgene, tp.tpmode, tm.dstmod, tp.cdtagl,
      tp.tppers, tp.flimag, COALESCE(mi.filvid, tp.flvide) AS flvide,
      IFNULL($modDescComm,'') AS descomhtml,
      IFNULL(dc.descri,'') AS descom, IFNULL(dt.descri,'') AS destec,
      IFNULL(dd.descri,'') AS descmp, IFNULL(dm.descri,'') AS desmad, 0 AS cust_disc,
      tp.tglini, tp.tglfin, tp.flasso, COALESCE(im.flimag,'') AS flimg2,
       $catalogPrice
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Tpgene tg ON tg.tpgene = tp.tpgene
      LEFT JOIN Go2B\Models\Tpmode tm ON tm.tpmode = tp.tpmode
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'
      LEFT JOIN Go2B\Models\Desart dc ON tp.cdartn = dc.codice AND dc.tpinpu = 'AN' AND dc.idlang = :idlang: AND dc.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Desart dt ON tp.cdartn = dt.codice AND dt.tpinpu = 'AN' AND dt.idlang = :idlang: AND dt.tpdesc = 'TECN'
      LEFT JOIN Go2B\Models\Desart dd ON tp.cdartn = dd.codice AND dd.tpinpu = 'AN' AND dd.idlang = '' AND dd.tpdesc = 'COMD'
      LEFT JOIN Go2B\Models\Desart dm ON tp.cdartn = dm.codice AND dm.tpinpu = 'AN' AND dm.idlang = '' AND dm.tpdesc = 'MADE'
      LEFT JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $lnJoin
      WHERE ca.cdcata = :cdcata: AND tp.flbloc = 0 AND (mi.clsfz1 = :clsfzn: OR mi.clsfz2 = :clsfzn: OR mi.clsfz3 = :clsfzn: OR mi.clsfz4 = :clsfzn:) AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY tp.cdartn";

        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getModelsForLookFromSearch($search, $cdcata)
    {
        $query = 'SELECT tp.cdartn
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      WHERE ca.cdcata = :cdcata: AND tp.cdartn LIKE :search:
      GROUP BY tp.cdartn
      ORDER BY tp.cdartn
      LIMIT 10';
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata, 'search' => '%' . $search . '%'));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getAllModelsForPromo($cdprom)
    {
        if (!empty($cdprom)) {
            $presPvcorp = 'COALESCE((SELECT COUNT(c.cdartn) FROM Go2B\Models\Pvcorp c WHERE c.cdartn = t.cdartn AND c.cdprom = :cdprom:), 0) AS presPvcorp';
            $presPvgrup = 'COALESCE((SELECT COUNT(g.cdartn) FROM Go2B\Models\Pvgrup g WHERE g.cdartn = t.cdartn AND g.cdprom = :cdprom:), 0) AS presPvgrup';
            $params = array('cdprom' => $cdprom);
        } else {
            $presPvcorp = '0 AS presPvcorp';
            $presPvgrup = '0 AS presPvgrup';
            $params = array();
        }
        $query = "SELECT t.cdartn, t.dsartn, $presPvcorp, $presPvgrup
      FROM Go2B\Models\Tipolo t
      ORDER BY t.cdartn";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getMinimalModelWithImage($cdartn, $idlang = 'IT')
    {
        if ($idlang != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
            $params = array('cdartn' => $cdartn, 'idlang' => $idlang);
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $lnJoin = '';
            $params = array('cdartn' => $cdartn);
        }

        $query = "SELECT tp.cdartn, $dsartn, tp.flimag
      FROM Go2B\Models\Tipolo tp
      $lnJoin
      WHERE tp.cdartn = :cdartn:
      GROUP BY tp.cdartn";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getCompleteModel($cdartn, $cdcata, $numdis, $idlang = 'IT')
    {
        $params = array('cdcata' => $cdcata, 'cdartn' => $cdartn, 'idlang' => $idlang);
        if ($idlang != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $dslinm = 'COALESCE(d2.descri,lm.dslinm) AS dslinm';
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dslinm' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $dslinm = 'lm.dslinm AS dslinm';
            $lnJoin = '';
        }

        if ($numdis > 0) {
            $custDisc = self::getCustomDiscountFields(false);
            $leftJoinDisbdy = self::getCustomDiscountLeftJoins(false);
            $params['numdis'] = $numdis;
        } else {
            $custDisc = '0 AS cust_disc';
            $leftJoinDisbdy = '';
        }

        $modDescComm = 'mi.desc' . strtolower($idlang);
        $query = "SELECT tp.cdartn, $dsartn, tl.cdtitl, tl.dstitl, tp.cdlinm, $dslinm,
      tp.cdserm, sm.dsserm, tp.tpgene, tg.dsgene, tp.tpmode, tm.dstmod, tp.cdtagl,
      tp.tppers, tp.flimag, COALESCE(mi.filvid, tp.flvide) AS flvide,
      IFNULL($modDescComm,'') AS descomhtml,
      IFNULL(dc.descri,'') AS descom, IFNULL(dt.descri,'') AS destec,
      IFNULL(dd.descri,'') AS descmp, IFNULL(dm.descri,'') AS desmad, $custDisc,
      tp.tglini, tp.tglfin, tp.flasso
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Tpgene tg ON tg.tpgene = tp.tpgene
      LEFT JOIN Go2B\Models\Tpmode tm ON tm.tpmode = tp.tpmode
      LEFT JOIN Go2B\Models\Desart dc ON tp.cdartn = dc.codice AND dc.tpinpu = 'AN' AND dc.idlang = :idlang: AND dc.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Desart dt ON tp.cdartn = dt.codice AND dt.tpinpu = 'AN' AND dt.idlang = :idlang: AND dt.tpdesc = 'TECN'
      LEFT JOIN Go2B\Models\Desart dd ON tp.cdartn = dd.codice AND dd.tpinpu = 'AN' AND dd.idlang = '' AND dd.tpdesc = 'COMD'
      LEFT JOIN Go2B\Models\Desart dm ON tp.cdartn = dm.codice AND dm.tpinpu = 'AN' AND dm.idlang = '' AND dm.tpdesc = 'MADE'
      LEFT JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $lnJoin
      $leftJoinDisbdy
      WHERE tp.cdartn = :cdartn: AND tp.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY tp.cdartn";

        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Tipolo objects
     */
    public static function getCompletePreviewModel($cdartn, $idlang = 'IT')
    {
        $params = array('cdartn' => $cdartn, 'idlang' => $idlang);
        if ($idlang != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $dslinm = 'COALESCE(d2.descri,lm.dslinm) AS dslinm';
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dslinm' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $dslinm = 'lm.dslinm AS dslinm';
            $lnJoin = '';
        }

        $query = "SELECT tp.cdartn, $dsartn, tl.cdtitl, tl.dstitl, tp.cdlinm, $dslinm,
      tp.cdserm, sm.dsserm, tp.tpgene, tg.dsgene, tp.tpmode, tm.dstmod, tp.flimag,
      COALESCE(mi.filvid, tp.flvide) AS flvide, IFNULL(dc.descri,'') AS descom, IFNULL(dt.descri,'') AS destec,
      IFNULL(dd.descri,'') AS descmp, IFNULL(dm.descri,'') AS desmad
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Tpgene tg ON tg.tpgene = tp.tpgene
      LEFT JOIN Go2B\Models\Tpmode tm ON tm.tpmode = tp.tpmode
      LEFT JOIN Go2B\Models\Desart dc ON tp.cdartn = dc.codice AND dc.tpinpu = 'AN' AND dc.idlang = :idlang: AND dc.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Desart dt ON tp.cdartn = dt.codice AND dt.tpinpu = 'AN' AND dt.idlang = :idlang: AND dt.tpdesc = 'TECN'
      LEFT JOIN Go2B\Models\Desart dd ON tp.cdartn = dd.codice AND dd.tpinpu = 'AN' AND dd.idlang = '' AND dd.tpdesc = 'COMD'
      LEFT JOIN Go2B\Models\Desart dm ON tp.cdartn = dm.codice AND dm.tpinpu = 'AN' AND dm.idlang = '' AND dm.tpdesc = 'MADE'
      LEFT JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $lnJoin
      WHERE tp.cdartn = :cdartn: AND tp.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE()
      AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY tp.cdartn";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Tipolo object
     */
    public static function getMinimalModel($cdartn)
    {
        $query = "SELECT t.dsartn, t.flimag
      FROM Go2B\Models\Tipolo t
      WHERE t.cdartn = :cdartn:";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn))[0];
    }

    /**
     * Query:   SELECT
     * Return:  Tipolo object
     */
    public static function getModel($cdartn)
    {
        $query = "SELECT tp.cdartn, tp.dsartn, tp.seqrap, tl.dstitl, lm.dslinm,
      sm.dsserm, tm.dstmod, tg.dsgene, ts.dsstag, mi.descit, mi.descen,
      mi.desces, mi.descfr, mi.descde, mi.dettit, mi.detten,
      mi.dettes, mi.dettfr, mi.dettde, mi.madein, mi.compos, mi.vestib,
      mi.filpdf, mi.filvid, mi.clsfz1, mi.clsfz2, mi.clsfz3, mi.clsfz4, ba.dtiniz, ba.dtfine,
      DATE_FORMAT(ba.dtiniz, '%d/%m/%Y') AS dtiniz_eu,
      DATE_FORMAT(ba.dtfine, '%d/%m/%Y') AS dtfine_eu
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      LEFT JOIN Go2B\Models\Tpmode tm ON tp.tpmode = tm.tpmode
      LEFT JOIN Go2B\Models\Tpgene tg ON tp.tpgene = tg.tpgene
      LEFT JOIN Go2B\Models\Tabstg ts ON tp.cdstag = ts.cdstag
      LEFT JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn
      LEFT JOIN Go2B\Models\B2bTipval ba ON tp.cdartn = ba.cdartn
      WHERE tp.cdartn = :cdartn:";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn))[0];
    }

    /**
     * Query:   SELECT
     * Return:  Tipolo object
     */
    public static function getModelForGallery($cdartn, $idlang = 'IT')
    {
        $params = array('cdartn' => $cdartn, 'idlang' => $idlang);
        if ($idlang != 'IT') {
            $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
        } else {
            $dsartn = 'tp.dsartn AS dsartn';
            $lnJoin = '';
        }
        $query = "SELECT tp.cdartn, $dsartn, tp.flimag,
      COALESCE(dc.descri,'') AS descomm, COALESCE(dt.descri,'') AS destecn
      FROM Go2B\Models\Tipolo tp
      LEFT JOIN Go2B\Models\Desart dt ON dt.tpinpu = 'AN' AND dt.codice = tp.cdartn AND dt.tpdesc = 'TECN' AND dt.idlang = :idlang:
      LEFT JOIN Go2B\Models\Desart dc ON dc.tpinpu = 'AN' AND dc.codice = tp.cdartn AND dc.tpdesc = 'COMM' AND dc.idlang = :idlang:
      $lnJoin
      WHERE tp.cdartn = :cdartn: ";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
    }

    /**
     * Query:   SELECT
     * Return:  Tipolo object
     */
    public static function getModelFromCdarti($cdarti)
    {
        $query = "SELECT tp.cdartn, tp.dsartn, tp.tppers, tp.cdtagl, tp.tglini,
      tp.tglfin
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      WHERE aa.cdarti = :cdarti:";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti))[0];
    }

    /**
     * Query:   SELECT
     * Return:  string
     */
    public static function getModelImage($cdartn)
    {
        $query = "SELECT tp.flimag
      FROM Go2B\Models\Tipolo tp
      WHERE tp.cdartn = :cdartn:";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn))[0]->flimag;
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getTotalAvailableModels()
    {
        $query = "SELECT DISTINCT tp.cdartn
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ct.dtiniz <= CURRENT_DATE() AND ct.dtfine >= CURRENT_DATE()
      AND aa.flbloc = 0 AND tp.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY tp.cdartn";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query);
        return count($result);
    }

    /**
     * Query:   SELECT
     * Return:  bool
     */
    public static function hasAvailabilityFlag($cdartn)
    {
        $query = "SELECT MAX(ac.valore) AS maxValore
      FROM Go2B\Models\Tipolo tp
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Artcla ac ON ac.tpinpu = 'AR' AND ac.codice = aa.cdarti AND ac.tpclas = 'DISP'
      WHERE tp.cdartn = :cdartn:";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn));
        return $result[0]->maxValore > 0;
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateModelDescription($cdartn, $dsartn)
    {
        $params = array('cdartn' => $cdartn, 'dsartn' => $dsartn);
        $query = 'UPDATE tipolo t
      SET t.dsartn = :dsartn
      WHERE t.cdartn = :cdartn';
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateModelImage($cdartn, $flimag)
    {
        $params = array('cdartn' => $cdartn, 'flimag' => $flimag);
        $query = 'UPDATE tipolo t
      SET t.flimag = :flimag
      WHERE t.cdartn = :cdartn';
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateImage($cdartn, $dummyCode, $flimag)
    {
        $params = array('cdartn' => $cdartn, 'flimag' => $flimag);
        $query = "UPDATE tipolo t
      SET t.flimag = :flimag
      WHERE t.cdartn = :cdartn";
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function updateModelIndex($cdartn, $seqrap)
    {
        $params = array('cdartn' => $cdartn, 'seqrap' => $seqrap);
        $query = "UPDATE tipolo t
      SET t.seqrap = :seqrap
      WHERE t.cdartn = :cdartn";
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function blockAllModels()
    {
        $query = "UPDATE tipolo t SET t.flbloc = 1";
        Di::getDefault()->get('db')->query($query);
    }

    /**
    * Query:   SELECT
    * Return   boolean
    */
    public static function existsAndUnlockedModel($cdartn) {
        $query = "SELECT tp.cdartn AS codmod
            FROM Go2B\Models\Tipolo tp
            WHERE tp.cdartn = :cdartn:
            AND tp.flbloc = 0  
            LIMIT 1";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn));
        return (count($result) > 0);
    }
    //endregion
}
