<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tipmat extends \Phalcon\Mvc\Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdmatn;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsmatn;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdmacr;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flbloc;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $catpre;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tipmat');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdmatn' => isset($rec->cdmatn) && (string)$rec->cdmatn !== '' ? (string)$rec->cdmatn : new RawValue('""'),
      'dsmatn' => isset($rec->dsmatn) && (string)$rec->dsmatn !== '' ? (string)$rec->dsmatn : new RawValue('""'),
      'cdmacr' => isset($rec->cdmacr) && (string)$rec->cdmacr !== '' ? (string)$rec->cdmacr : new RawValue('""'),
      'flbloc' => isset($rec->flbloc) && (string)$rec->flbloc !== '' ? (string)$rec->flbloc : 0,
      'catpre' => isset($rec->catpre) && (string)$rec->catpre !== '' ? (string)$rec->catpre : new RawValue('""'),
    );

    $query  = 'cdmatn = :cdmatn:';
    $params = array(
      'cdmatn' => $values['cdmatn']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Spmate objects
   */
  public static function getMaterialTypes($cdmacr) {
    $query = 'SELECT DISTINCT tm.cdmatn, tm.dsmatn
      FROM Go2B\Models\Tipmat tm
      WHERE tm.cdmacr = :cdmacr: AND tm.flbloc = "0"
      ORDER BY tm.dsmatn';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdmacr' => $cdmacr));
  }
  //endregion
}
