<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Mvc\Model;

class Tglinm extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $nutrgt;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdlinm;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tglinm');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nutrgt' => isset($rec->nutrgt) && (string)$rec->nutrgt !== '' ? (string)$rec->nutrgt : 0,
      'cdlinm' => isset($rec->cdlinm) && (string)$rec->cdlinm !== '' ? (string)$rec->cdlinm : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'nutrgt = :nutrgt:';
    $params = array(
      'nutrgt' => $values['nutrgt']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
