<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Tabvar extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdregv;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdvari;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $dsvari;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $tpvari;

  /**
   *
   * @var double
   * @Column(type="double", nullable=false)
   */
  public $prezzo;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flgene;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flbloc;

  /**
   *
   * @var string
   * @Column(type="string", nullable=true)
   */
  public $ntvari;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('tabvar');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdregv' => isset($rec->cdregv) && (string)$rec->cdregv !== '' ? (string)$rec->cdregv : 0,
      'cdvari' => isset($rec->cdvari) && (string)$rec->cdvari !== '' ? (string)$rec->cdvari : new RawValue('""'),
      'dsvari' => isset($rec->dsvari) && (string)$rec->dsvari !== '' ? (string)$rec->dsvari : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'tpvari' => isset($rec->tpvari) && (string)$rec->tpvari !== '' ? (string)$rec->tpvari : new RawValue('""'),
      'prezzo' => isset($rec->prezzo) && (string)$rec->prezzo !== '' ? (string)$rec->prezzo : 0,
      'flgene' => isset($rec->flgene) && (string)$rec->flgene !== '' ? (string)$rec->flgene : 0,
      'flbloc' => isset($rec->flbloc) && (string)$rec->flbloc !== '' ? (string)$rec->flbloc : 0,
      'ntvari' => isset($rec->ntvari) && (string)$rec->ntvari !== '' ? (string)$rec->ntvari : new RawValue('""'),
      'flimag' => isset($rec->flimag) && (string)$rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""')
    );

    $query  = 'cdregv = :cdregv: AND cdvari = :cdvari:';
    $params = array(
      'cdregv' => $values['cdregv'],
      'cdvari' => $values['cdvari']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Tabvar arrays
   */
  public static function getAllCustomsForModel($cdartn, $tpmode, $cdcata) {
    $query = "SELECT ta.cdvari, ta.dsvari, ta.seqrap, ti.tpvari, ti.dstvar,
      ta.prezzo, ta.flgene, ta.flbloc, ta.ntvari, ta.flimag
      FROM tabvar ta
      INNER JOIN tipvar ti ON ti.cdregv = ta.cdregv AND ti.tpvari = ta.tpvari
      INNER JOIN cttest ct ON ct.cdregv = ta.cdregv AND ct.cdcata = :cdcata
      WHERE ta.flgene = 1 AND ta.flbloc = 0
      UNION
      SELECT ta.cdvari, ta.dsvari, ta.seqrap, ti.tpvari, ti.dstvar,
      ta.prezzo, ta.flgene, ta.flbloc, ta.ntvari, ta.flimag
      FROM tabvar ta
      INNER JOIN tipvar ti ON ti.cdregv = ta.cdregv AND ti.tpvari = ta.tpvari
      INNER JOIN cttest ct ON ct.cdregv = ta.cdregv AND ct.cdcata = :cdcata
      INNER JOIN modvar mo ON mo.cdregv = ta.cdregv AND mo.cdartn = :cdartn
      WHERE ta.flbloc = 0
      UNION
      SELECT ta.cdvari, ta.dsvari, ta.seqrap, ti.tpvari, ti.dstvar,
      ta.prezzo, ta.flgene, ta.flbloc, ta.ntvari, ta.flimag
      FROM tabvar ta
      INNER JOIN tipvar ti ON ti.cdregv = ta.cdregv AND ti.tpvari = ta.tpvari
      INNER JOIN cttest ct ON ct.cdregv = ta.cdregv AND ct.cdcata = :cdcata
      INNER JOIN tpmvar tp ON tp.cdregv = ta.cdregv AND tp.tpmode = :tpmode
      WHERE ta.flbloc = 0
      GROUP BY cdvari
      ORDER BY dstvar, dsvari";
    return Di::getDefault()->get('db')->query($query, array('cdartn' => $cdartn, 'tpmode' => $tpmode, 'cdcata' => $cdcata))->fetchAll();
  }
  /**
   * Query:   SELECT
   * Return:  Array of Tabvar arrays
   */
  public static function getAllCustomsForOrderRow($nurorc) {
    $query = "SELECT ta.cdvari, ta.dsvari, ta.seqrap, ti.tpvari, ti.dstvar,
      ta.prezzo, ta.flgene, ta.flbloc, ta.ntvari, ta.flimag
      FROM tabvar ta
      INNER JOIN tipvar ti ON ti.cdregv = ta.cdregv AND ti.tpvari = ta.tpvari
      INNER JOIN cttest ct ON ct.cdregv = ta.cdregv
      INNER JOIN octest ot ON ot.cdcata = ct.cdcata
      INNER JOIN occorp oc ON oc.nuordc = ot.nuordc
      WHERE oc.nurorc = :nurorc AND ta.flgene = 1 AND ta.flbloc = 0
      UNION
      SELECT ta.cdvari, ta.dsvari, ta.seqrap, ti.tpvari, ti.dstvar,
      ta.prezzo, ta.flgene, ta.flbloc, ta.ntvari, ta.flimag
      FROM tabvar ta
      INNER JOIN tipvar ti ON ti.cdregv = ta.cdregv AND ti.tpvari = ta.tpvari
      INNER JOIN cttest ct ON ct.cdregv = ta.cdregv
      INNER JOIN octest ot ON ot.cdcata = ct.cdcata
      INNER JOIN occorp oc ON oc.nuordc = ot.nuordc
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN modvar mo ON mo.cdregv = ta.cdregv AND mo.cdartn = aa.cdartn
      WHERE oc.nurorc = :nurorc AND ta.flbloc = 0
      UNION
      SELECT ta.cdvari, ta.dsvari, ta.seqrap, ti.tpvari, ti.dstvar,
      ta.prezzo, ta.flgene, ta.flbloc, ta.ntvari, ta.flimag
      FROM tabvar ta
      INNER JOIN tipvar ti ON ti.cdregv = ta.cdregv AND ti.tpvari = ta.tpvari
      INNER JOIN cttest ct ON ct.cdregv = ta.cdregv
      INNER JOIN octest ot ON ot.cdcata = ct.cdcata
      INNER JOIN occorp oc ON oc.nuordc = ot.nuordc
      INNER JOIN anaart aa ON aa.cdarti = oc.cdarti
      INNER JOIN tipolo tl ON tl.cdartn = aa.cdartn
      INNER JOIN tpmvar tp ON tp.cdregv = ta.cdregv AND tp.tpmode = tl.tpmode
      WHERE oc.nurorc = :nurorc AND ta.flbloc = 0
      GROUP BY cdvari
      ORDER BY dstvar, dsvari";
    return Di::getDefault()->get('db')->query($query, array('nurorc' => $nurorc))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Tabvar objects
   */
  public static function getAllCustomsByCdregvAndTpvari($cdregv, $tpvari) {
    $query = "SELECT t.cdvari, t.dsvari, t.seqrap, g.cdregv, g.dsregv,
      f.tpvari, f.dstvar, t.prezzo, t.flgene, t.flbloc, t.ntvari, t.flimag
      FROM Go2B\Models\Tabvar t
      INNER JOIN Go2B\Models\Regvar g ON g.cdregv = t.cdregv
      INNER JOIN Go2B\Models\Tipvar f ON f.cdregv = t.cdregv AND f.tpvari = t.tpvari
      WHERE t.cdregv = :cdregv: AND t.tpvari = :tpvari: ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdregv' => $cdregv, 'tpvari' => $tpvari));
  }

  /**
   * Query:   SELECT
   * Return:  Tabvar object
   */
  public static function getCustomFromCdvariAndCdcata($cdvari, $cdcata) {
    $query = "SELECT ta.cdvari, ta.dsvari, ta.seqrap, ta.prezzo, ta.flgene,
      ta.flbloc, ta.ntvari, ta.flimag
      FROM Go2B\Models\Tabvar ta
      INNER JOIN Go2B\Models\Cttest ct ON ct.cdregv = ta.cdregv AND ct.cdcata = :cdcata:
      WHERE ta.flbloc = 0 AND ta.cdvari = :cdvari:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdvari' => $cdvari, 'cdcata' => $cdcata));
    return count($result) > 0 ? $result[0] : null;
  }

  /**
   * Query:   SELECT
   * Return:  Tabvar object
   */
  public static function getCustomFromCdvariAndNurorc($cdvari, $nurorc) {
    $query = "SELECT ta.cdvari, ta.dsvari, ta.seqrap, ta.prezzo, ta.flgene,
      ta.flbloc, ta.ntvari, ta.flimag
      FROM Go2B\Models\Tabvar ta
      INNER JOIN Go2B\Models\Cttest ct ON ct.cdregv = ta.cdregv
      INNER JOIN Go2B\Models\Octest ot ON ot.cdcata = ct.cdcata
      INNER JOIN Go2B\Models\Occorp oc ON oc.nuordc = ot.nuordc
      WHERE oc.nurorc = :nurorc: AND ta.flbloc = 0 AND ta.cdvari = :cdvari:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdvari' => $cdvari, 'nurorc' => $nurorc));
    return count($result) > 0 ? $result[0] : null;
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewCustom($cdregv, $tpvari, $cdvari, $dsvari, $seqrap, $prezzo, $flgene, $flbloc, $ntvari, $flimag) {
    $params = array(
      'cdregv' => $cdregv,
      'tpvari' => $tpvari,
      'cdvari' => $cdvari,
      'dsvari' => $dsvari,
      'seqrap' => $seqrap,
      'prezzo' => $prezzo,
      'flgene' => $flgene,
      'flbloc' => $flbloc,
      'ntvari' => $ntvari,
      'flimag' => $flimag
    );
    $query = 'INSERT INTO tabvar (cdregv, cdvari, dsvari, seqrap, tpvari, prezzo, flgene, flbloc, ntvari, flimag)
      VALUES (:cdregv, :cdvari, :dsvari, :seqrap, :tpvari, :prezzo, :flgene, :flbloc, :ntvari, :flimag)';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateCustom($cdregv, $tpvari, $cdvari, $dsvari, $seqrap, $prezzo, $flgene, $flbloc, $ntvari, $flimag) {
    $params = array(
      'cdregv' => $cdregv,
      'tpvari' => $tpvari,
      'cdvari' => $cdvari,
      'dsvari' => $dsvari,
      'seqrap' => $seqrap,
      'prezzo' => $prezzo,
      'flgene' => $flgene,
      'flbloc' => $flbloc,
      'ntvari' => $ntvari,
      'flimag' => $flimag
    );
    $query = 'UPDATE tabvar t
      SET t.dsvari = :dsvari, t.seqrap = :seqrap, t.tpvari = :tpvari, t.prezzo = :prezzo, t.flgene = :flgene, t.flbloc = :flbloc, t.ntvari = :ntvari, t.flimag = :flimag
      WHERE t.cdregv = :cdregv AND t.cdvari = :cdvari';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregv($cdregv) {
    $query = 'DELETE t
      FROM tabvar t
      WHERE t.cdregv = :cdregv';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregvAndTpvari($cdregv, $tpvari) {
    $query = 'DELETE t
      FROM tabvar t
      WHERE t.cdregv = :cdregv AND t.tpvari = :tpvari';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'tpvari' => $tpvari));
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllRecordsForCdregvTpvariCdvari($cdregv, $tpvari, $cdvari) {
    $query = 'DELETE t
      FROM tabvar t
      WHERE t.cdregv = :cdregv AND t.tpvari = :tpvari AND t.cdvari = :cdvari';
    Di::getDefault()->get('db')->query($query, array('cdregv' => $cdregv, 'tpvari' => $tpvari, 'cdvari' => $cdvari));
  }
  //endregion
}
