<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Svtest extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $idtest;

  /**
   *
   * @var string
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $numero;

  /**
   *
   * @var string
   * @Column(type="string", length=12, nullable=false)
   */
  public $numrem;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $datord;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdagen;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tipana;

  /**
   *
   * @var integer
   * @Column(type="integer", length=11, nullable=false)
   */
  public $codana;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $tporto;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $pagame;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $agente;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $tipord;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $sganag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('svtest');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'idtest' => isset($rec->idtest) && (string)$rec->idtest !== '' ? (string)$rec->idtest : 0,
      'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
      'numero' => isset($rec->numero) && (string)$rec->numero !== '' ? (string)$rec->numero : 0,
      'numrem' => isset($rec->numrem) && (string)$rec->numrem !== '' ? (string)$rec->numrem : new RawValue('""'),
      'datord' => isset($rec->datord) && (string)$rec->datord !== '' ? (string)$rec->datord : '0000-00-00',
      'cdagen' => isset($rec->cdagen) && (string)$rec->cdagen !== '' ? (string)$rec->cdagen : 0,
      'tipana' => isset($rec->tipana) && (string)$rec->tipana !== '' ? (string)$rec->tipana : new RawValue('""'),
      'codana' => isset($rec->codana) && (string)$rec->codana !== '' ? (string)$rec->codana : 0,
      'tporto' => isset($rec->tporto) && (string)$rec->tporto !== '' ? (string)$rec->tporto : new RawValue('""'),
      'pagame' => isset($rec->pagame) && (string)$rec->pagame !== '' ? (string)$rec->pagame : new RawValue('""'),
      'agente' => isset($rec->agente) && (string)$rec->agente !== '' ? (string)$rec->agente : new RawValue('""'),
      'tipord' => isset($rec->tipord) && (string)$rec->tipord !== '' ? (string)$rec->tipord : new RawValue('""'),
      'sganag' => isset($rec->sganag) && (string)$rec->sganag !== '' ? (string)$rec->sganag : new RawValue('""')
    );

    $query  = 'idtest = :idtest:';
    $params = array(
      'idtest' => $values['idtest']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }

  /**
   * Delete all stats for season
   */
  public static function deleteSeason($seasons) {
    $cdstag = explode('#', $seasons);
    $svtest = self::find(array(
      'conditions' => "cdstag IN ({cdstag:array})",
      'bind' => array('cdstag' => $cdstag)
    ));
    if (count($svtest) > 0) {
      $idtest = array();
      foreach ($svtest as $el) {
        $idtest[] = $el->idtest;
      }
      $svtest->delete();

      $svcorp = Svcorp::find(array(
        'conditions' => "idtest IN ({idtest:array})",
        'bind' => array('idtest' => $idtest)
      ));
      $svcorp->delete();
    }
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Svtest objects
   */
  public static function getQuantityTrend($cdstag, $id_usr, $where, $params) {
    $params['cdstag'] = $cdstag;
    $params['id_usr'] = $id_usr;
    $query = "SELECT t.datord, SUM(c.qtatot) AS tot_qty
      FROM Go2B\Models\Svtest t
      INNER JOIN Go2B\Models\Svcorp c ON t.idtest = c.idtest
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = t.cdagen
      WHERE t.cdstag = :cdstag: AND u.id_usr = :id_usr: $where
      GROUP BY t.datord
      ORDER BY t.datord";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svtest objects
   */
  public static function getValueTrend($cdstag, $id_usr, $where, $params) {
    $params['cdstag'] = $cdstag;
    $params['id_usr'] = $id_usr;
    $query = "SELECT t.datord, SUM(c.impnet) AS tot_val
      FROM Go2B\Models\Svtest t
      INNER JOIN Go2B\Models\Svcorp c ON t.idtest = c.idtest
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = t.cdagen
      WHERE t.cdstag = :cdstag: AND u.id_usr = :id_usr: $where
      GROUP BY t.datord
      ORDER BY t.datord";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svtest objects
   */
  public static function getStatsOrderTypes($where, $params) {
    $query = "SELECT DISTINCT s.tipord
      FROM Go2B\Models\Svtest s
      WHERE $where
      ORDER BY s.tipord";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Svtest objects
   */
  public static function getStatsSeasons($where, $params) {
    $query = "SELECT DISTINCT s.cdstag
      FROM Go2B\Models\Svtest s
      WHERE $where
      ORDER BY s.cdstag";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getOrdersCount($cdstag, $id_usr, $where, $params) {
    $params['cdstag'] = $cdstag;
    $params['id_usr'] = $id_usr;
    $query = "SELECT COUNT(t.idtest) AS tot_ord
      FROM Go2B\Models\Svtest t
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = t.cdagen
      WHERE t.cdstag = :cdstag: AND u.id_usr = :id_usr: $where";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0]->tot_ord;
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE svtest";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
