<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Svarti extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdstag;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=20, nullable=false)
   */
  public $codart;

  /**
   *
   * @var string
   * @Column(type="string", length=40, nullable=false)
   */
  public $desart;

  /**
   *
   * @var string
   * @Column(type="string", length=18, nullable=false)
   */
  public $codneu;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $codcol;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('svarti');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdstag' => isset($rec->cdstag) && (string)$rec->cdstag !== '' ? (string)$rec->cdstag : new RawValue('""'),
      'codart' => isset($rec->codart) && (string)$rec->codart !== '' ? (string)$rec->codart : new RawValue('""'),
      'desart' => isset($rec->desart) && (string)$rec->desart !== '' ? (string)$rec->desart : new RawValue('""'),
      'codneu' => isset($rec->codneu) && (string)$rec->codneu !== '' ? (string)$rec->codneu : new RawValue('""'),
      'codcol' => isset($rec->codcol) && (string)$rec->codcol !== '' ? (string)$rec->codcol : new RawValue('""')
    );

    $query  = 'cdstag = :cdstag: AND codart = :codart:';
    $params = array(
      'cdstag' => $values['cdstag'],
      'codart' => $values['codart']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }

  /**
   * Delete all stats for season
   */
  public static function deleteSeason($seasons) {
    $cdstag = explode('#', $seasons);
    $svarti = self::find(array(
      'conditions' => "cdstag IN ({cdstag:array})",
      'bind' => array('cdstag'=> $cdstag)
    ));
    $svarti->delete();
  }
  //endregion

  //region Custom queries
  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE svarti";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
