<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Stoord extends Model
{
    //region Fields
    /**
     *
     * @var int
     * @Primary
     * @Column(type="int", length=11, nullable=false)
     */
    public $idrord;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $tipmov;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $tipdoc;

    /**
     *
     * @var string
     * @Column(type="string", length=20, nullable=false)
     */
    public $numdoc;

    /**
     *
     * @var string
     * @Column(type="string", length=20, nullable=false)
     */
    public $doccol;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $datdoc;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $datspe;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=false)
     */
    public $tpanag;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $cdanag;

    /**
     *
     * @var string
     * @Column(type="string", length=80, nullable=false)
     */
    public $ragsoc;

    /**
     *
     * @var string
     * @Column(type="string", length=30, nullable=false)
     */
    public $codart;

    /**
     *
     * @var string
     * @Column(type="string", length=50, nullable=false)
     */
    public $desart;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $unimis;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $qtaord;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $qtafat;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $qtaspe;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $qtadaf;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $qtadas;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $prezzo;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $scont1;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $scont2;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $scont3;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $prenet;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $impord;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $impfat;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $impspe;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $impdaf;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $impdas;
    //endregion

    //region Default functions
    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('stoord');
    }
    //endregion

    //region Custom queries

    /**
     * Query:   SELECT
     * Return:  Array of Stoord objects
     */
    public static function getFilteredHistory($user, $tipdoc, $filters = null)
    {
        $params = array();
        $params['tpanag'] = '';
        $params['cdanag'] = '';
        $params['tipdoc'] = '';
        $andWhere = '';
        $lnJoinAnagra = '';

        // Default filters
        if (!empty($user)) {
            // TODO Devo assolutamente conoscere Bogdan per fargli i complimenti
//            if ($user['type'] == 'AG') {
//                $lnJoinAnagra .= "LEFT JOIN anagra a ON s.cdanag = a.cdanag";
//                $andWhere .= " AND a.cdagen = :cdanag";
//            } else if ($user['type'] == 'CL') {
                $andWhere .= " AND s.cdanag = :cdanag";
//            }
            $params['tpanag'] = 'CL';
            // Trasformiamo qualsiasi codice alfanumerico in solo numeri
            // dato che abbiamo il solo codice numerico in questa tabella.
//            $params['cdanag'] = $user['code'];
            $params['cdanag'] = intval(preg_replace('/[^\d]/i', '', $user['code']));
        }
        if (!empty($tipdoc)) {
            $params['tipdoc'] = $tipdoc;
        }

        // Custom filters
        if (!empty($filters)) {
            foreach ($filters as $filter => $value) {
                switch ($filter) {
//                    case 'date_start':
//                        $andWhere .= " AND s.datdoc >= :date_start";
//                        $params['date_start'] = $value;
//                        break;
//                    case 'date_end':
//                        $andWhere .= " AND s.datdoc <= :date_end";
//                        $params['date_end'] = $value;
//                        break;
                    case 'search':
                        $andWhere .= " AND (
                s.numdoc LIKE :search OR 
                s.cdanag LIKE :search OR 
                s.ragsoc LIKE :search OR 
                s.codart LIKE :search OR 
                s.desart LIKE :search)";
                        $params['search'] = '%' . $value . '%';
                        break;
                }
            }
        }

        $query = " SELECT 
          s.tipdoc, s.numdoc, s.datdoc, s.datspe, s.tpanag, s.cdanag, s.ragsoc,
          tot.qtaord, tot.qtafat, tot.qtadaf, tot.qtaspe, tot.qtadas, tot.impord,
          tot.impfat, tot.impdaf, tot.impspe, tot.impdas
      FROM
          stoord s 
          $lnJoinAnagra
          INNER JOIN (
            SELECT s2.numdoc,		
              COALESCE ( SUM( s2.qtaord ), 0 ) AS qtaord,
              COALESCE ( SUM( s2.qtafat ), 0 ) AS qtafat,
              COALESCE ( SUM( s2.qtadaf ), 0 ) AS qtadaf,
              COALESCE ( SUM( s2.qtaspe ), 0 ) AS qtaspe,
              COALESCE ( SUM( s2.qtadas ), 0 ) AS qtadas,
              COALESCE ( SUM( s2.impord ), 0 ) AS impord,
              COALESCE ( SUM( s2.impfat ), 0 ) AS impfat,
              COALESCE ( SUM( s2.impdaf ), 0 ) AS impdaf,
              COALESCE ( SUM( s2.impspe ), 0 ) AS impspe,
              COALESCE ( SUM( s2.impdas ), 0 ) AS impdas
            FROM 
              stoord s2
            WHERE 
              s2.tpanag = :tpanag
            GROUP BY 
              s2.numdoc
          ) as tot ON tot.numdoc = s.numdoc
      WHERE
          s.tipdoc = :tipdoc AND s.tpanag = :tpanag $andWhere
      GROUP BY 
          s.tipdoc, s.numdoc, s.datdoc, s.tpanag, s.cdanag
      ORDER BY 
          s.datdoc DESC, s.numdoc DESC";

        // Di::getDefault()->get('logger')->warning($query."\n".print_r($params, true));
        $result = Di::getDefault()->get('db')->query($query, $params)->fetchAll();
        // Di::getDefault()->get('logger')->warning(print_r($result, true));
        return $result;
    }

    /**
     * Query:   SELECT
     * Return:  Array of Stoord objects
     */
    public static function getFilteredHistoryRows($numdoc, $tipdoc)
    {
        $params = array();
        $params['numdoc'] = '';
        $params['tipdoc'] = '';
        $andWhere = '';

        // Default filters
        if (!empty($numdoc)) {
            $params['numdoc'] = $numdoc;
        }
        if (!empty($tipdoc)) {
            $params['tipdoc'] = $tipdoc;
        }

        $query = "SELECT s.tipdoc, s.numdoc, s.datdoc, s.datspe, s.tpanag, s.cdanag, s.ragsoc, s.codart, s.desart,
          COALESCE ( s.qtaord, 0 ) AS qtaord, COALESCE ( s.qtafat, 0 ) AS qtafat,
          COALESCE ( s.qtadaf, 0 ) AS qtadaf, COALESCE ( s.qtaspe, 0 ) AS qtaspe,
          COALESCE ( s.qtadas, 0 ) AS qtadas, COALESCE ( s.impord, 0 ) AS impord,
          COALESCE ( s.impfat, 0 ) AS impfat, COALESCE ( s.impdaf, 0 ) AS impdaf,
          COALESCE ( s.impspe, 0 ) AS impspe, COALESCE ( s.impdas, 0 ) AS impdas 
      FROM
        Go2B\Models\Stoord s 
      WHERE
        s.numdoc = :numdoc: AND s.tipdoc = :tipdoc:
        $andWhere";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return $result;
    }

    /**
     * Query:   TRUNCATE
     * Return:  void
     */
    public static function emptyTable()
    {
        $query = "TRUNCATE stoord";
        Di::getDefault()->get('db')->query($query);
    }

    public static function saveRecord($rec, $tipoagg)
    {
        $values = [
            'idrord' => isset($rec->idrord) && (string)$rec->idrord !== '' ? (string)$rec->idrord : new RawValue('""'),
            'tipmov' => isset($rec->tipmov) && (string)$rec->tipmov !== '' ? (string)$rec->tipmov : new RawValue('""'),
            'tipdoc' => isset($rec->tipdoc) && (string)$rec->tipdoc !== '' ? (string)$rec->tipdoc : new RawValue('""'),
            'numdoc' => isset($rec->numdoc) && (string)$rec->numdoc !== '' ? (string)$rec->numdoc : new RawValue('""'),
            'doccol' => isset($rec->doccol) && (string)$rec->doccol !== '' ? (string)$rec->doccol : new RawValue('""'),
            'datdoc' => isset($rec->datdoc) && (string)$rec->datdoc !== '' ? (string)$rec->datdoc : new RawValue('""'),
            'datspe' => isset($rec->datspe) && (string)$rec->datspe !== '' ? (string)$rec->datspe : new RawValue('""'),
            'tpanag' => isset($rec->tpanag) && (string)$rec->tpanag !== '' ? (string)$rec->tpanag : new RawValue('""'),
            'cdanag' => isset($rec->cdanag) && (string)$rec->cdanag !== '' ? (string)$rec->cdanag : new RawValue('""'),
            'ragsoc' => isset($rec->ragsoc) && (string)$rec->ragsoc !== '' ? (string)$rec->ragsoc : new RawValue('""'),
            'codart' => isset($rec->codart) && (string)$rec->codart !== '' ? (string)$rec->codart : new RawValue('""'),
            'desart' => isset($rec->desart) && (string)$rec->desart !== '' ? (string)$rec->desart : new RawValue('""'),
            'unimis' => isset($rec->unimis) && (string)$rec->unimis !== '' ? (string)$rec->unimis : new RawValue('""'),
            'qtaord' => isset($rec->qtaord) && (string)$rec->qtaord !== '' ? (string)$rec->qtaord : 0,
            'qtafat' => isset($rec->qtafat) && (string)$rec->qtafat !== '' ? (string)$rec->qtafat : 0,
            'qtaspe' => isset($rec->qtaspe) && (string)$rec->qtaspe !== '' ? (string)$rec->qtaspe : 0,
            'qtadaf' => isset($rec->qtadaf) && (string)$rec->qtadaf !== '' ? (string)$rec->qtadaf : 0,
            'qtadas' => isset($rec->qtadas) && (string)$rec->qtadas !== '' ? (string)$rec->qtadas : 0,
            'prezzo' => isset($rec->prezzo) && (string)$rec->prezzo !== '' ? (string)$rec->prezzo : 0,
            'scont1' => isset($rec->scont1) && (string)$rec->scont1 !== '' ? (string)$rec->scont1 : new RawValue('""'),
            'scont2' => isset($rec->scont2) && (string)$rec->scont2 !== '' ? (string)$rec->scont2 : new RawValue('""'),
            'scont3' => isset($rec->scont3) && (string)$rec->scont3 !== '' ? (string)$rec->scont3 : new RawValue('""'),
            'prenet' => isset($rec->prenet) && (string)$rec->prenet !== '' ? (string)$rec->prenet : new RawValue('""'),
            'impord' => isset($rec->impord) && (string)$rec->impord !== '' ? (string)$rec->impord : 0,
            'impfat' => isset($rec->impfat) && (string)$rec->impfat !== '' ? (string)$rec->impfat : 0,
            'impspe' => isset($rec->impspe) && (string)$rec->impspe !== '' ? (string)$rec->impspe : 0,
            'impdaf' => isset($rec->impdaf) && (string)$rec->impdaf !== '' ? (string)$rec->impdaf : 0,
            'impdas' => isset($rec->impdas) && (string)$rec->impdas !== '' ? (string)$rec->impdas : 0,
        ];

        if (empty($values['idrord']) || empty($values['cdanag'])) {
            echo "Impossibile inserire un ordine nello storico senza identificativo e codice anagrafica\n";
//            echo json_encode($rec) . PHP_EOL;
        }

        $query = 'idrord = :idrord:';
        $params = array(
            'idrord' => $values['idrord']
        );

        if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
            $row = new self();
        }

        if (!$row->save($values)) {
            echo "Errore nel salvataggio del record {$row->idrord}\n";
            foreach ($row->getMessages() as $message) {
                echo "\t$message\n";
            }
        }
    }
    //endregion
}
