<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Sparti extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $tpcomp;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $valore;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('sparti');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'tpcomp' => isset($rec->tpcomp) && (string)$rec->tpcomp !== '' ? (string)$rec->tpcomp : new RawValue('""'),
      'valore' => isset($rec->valore) && (string)$rec->valore !== '' ? (string)$rec->valore : new RawValue('""')
    );

    $query  = 'cdarti = :cdarti: AND tpcomp = :tpcomp:';
    $params = array(
      'cdarti' => $values['cdarti'],
      'tpcomp' => $values['tpcomp']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Sparti objects
   */
  public static function getAllFeatures($cdarti) {
    $params = array('cdarti' => $cdarti);
    $query = "SELECT sa.tpcomp, tc.dscomp, sa.valore
      FROM Go2B\Models\Sparti sa
      INNER JOIN Go2B\Models\Tpcomp tc ON sa.tpcomp = tc.tpcomp
      WHERE sa.cdarti = :cdarti:
      GROUP BY sa.tpcomp
      ORDER BY tc.seqrap, sa.tpcomp";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }
  /**
   * Query:   SELECT
   * Return:  Array of Sparti objects
   */
  public static function getAllFeaturesForCsv($cdarti) {
    $params = array('cdarti' => $cdarti);
    $query = "SELECT tc.tpcomp, tc.dscomp, COALESCE(sa.valore,'') AS valore
      FROM Go2B\Models\Tpcomp tc
      LEFT JOIN Go2B\Models\Sparti sa ON sa.tpcomp = tc.tpcomp AND sa.cdarti = :cdarti:
      ORDER BY tc.seqrap, tc.tpcomp";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function createNewFeature($cdarti, $tpcomp, $valore) {
    $params = array(
      'cdarti' => $cdarti,
      'tpcomp' => $tpcomp,
      'valore' => $valore
    );

    $query = "INSERT INTO sparti (cdarti, tpcomp, valore)
      VALUES (:cdarti, :tpcomp, :valore)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteFeaturesForCustomVariant($cdarti) {
    $params = array('cdarti' => $cdarti);
    $query = "DELETE s.*
      FROM sparti s
      INNER JOIN anaart a ON a.cdarti = s.cdarti
      WHERE a.cdarti = :cdarti AND a.tpvend = 'CUSTOM' ";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllFeaturesOfCustomArticlesForOrder($nuordc) {
    $params = array('nuordc' => $nuordc);
    $query = "DELETE s.*
      FROM sparti s
      INNER JOIN anaart a ON a.cdarti = s.cdarti
      INNER JOIN occorp o ON o.cdarti = a.cdarti
      WHERE a.tpvend = 'CUSTOM' AND o.nuordc = :nuordc ";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE sparti";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
