<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Sermod extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdlinm;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdserm;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsserm;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('sermod');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdlinm' => isset($rec->cdlinm) && (string)$rec->cdlinm !== '' ? (string)$rec->cdlinm : new RawValue('""'),
      'cdserm' => isset($rec->cdserm) && (string)$rec->cdserm !== '' ? (string)$rec->cdserm : new RawValue('""'),
      'dsserm' => isset($rec->dsserm) && (string)$rec->dsserm !== '' ? (string)$rec->dsserm : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'flimag' => isset($rec->flimag) && (string)$rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""')
    );

    $query  = 'cdlinm = :cdlinm: AND cdserm = :cdserm:';
    $params = array(
      'cdlinm' => $values['cdlinm'],
      'cdserm' => $values['cdserm']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getAllSeries($orderByCode = false) {
    $orderBy = 'ORDER BY ' . ($orderByCode ? 'lm.dslinm, sm.dsserm' : 'lm.cdlinm, sm.cdserm');
    $query = "SELECT tl.cdtitl, tl.dstitl, sm.cdlinm, lm.dslinm, sm.cdserm, sm.dsserm,
      sm.cdlinm AS lineCode, lm.dslinm AS lineDescription,
      sm.cdserm AS seriesCode, sm.dsserm AS seriesDescription
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = sm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      $orderBy";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getAllSeriesWithLanguageDescriptions() {
    $query = "SELECT sm.cdlinm, lm.dslinm, sm.cdserm, sm.dsserm,
      lm.cdtitl, COALESCE(tl.dstitl, '') AS dstitl, COALESCE(den.descri,'') AS des_en,
      COALESCE(des.descri,'') AS des_es, COALESCE(dfr.descri,'') AS des_fr,
      COALESCE(dde.descri,'') AS des_de
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = sm.cdlinm
      LEFT JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Deslin den ON den.tpdato = 'dsserm' AND den.codic1 = sm.cdlinm AND den.codic2 = sm.cdserm AND den.idlang = 'EN'
      LEFT JOIN Go2B\Models\Deslin des ON des.tpdato = 'dsserm' AND des.codic1 = sm.cdlinm AND des.codic2 = sm.cdserm AND des.idlang = 'ES'
      LEFT JOIN Go2B\Models\Deslin dfr ON dfr.tpdato = 'dsserm' AND dfr.codic1 = sm.cdlinm AND dfr.codic2 = sm.cdserm AND dfr.idlang = 'FR'
      LEFT JOIN Go2B\Models\Deslin dde ON dde.tpdato = 'dsserm' AND dde.codic1 = sm.cdlinm AND dde.codic2 = sm.cdserm AND dde.idlang = 'DE'
      ORDER BY lm.dslinm, sm.dsserm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getSeriesForLocalization() {
    $query = "SELECT sm.cdserm AS code, sm.dsserm AS description, sm.cdlinm, lm.dslinm,
      COALESCE(it.valore,'') AS des_it, COALESCE(en.valore,'') AS des_en,
      COALESCE(es.valore,'') AS des_es, COALESCE(fr.valore,'') AS des_fr,
      COALESCE(de.valore,'') AS des_de
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = sm.cdlinm
      LEFT JOIN Go2B\Models\B2bAddinf it ON it.tabell = 'sermod' AND it.codic1 = sm.cdserm AND it.codic2 = sm.cdlinm AND it.tpdato = 'des_it'
      LEFT JOIN Go2B\Models\B2bAddinf en ON en.tabell = 'sermod' AND en.codic1 = sm.cdserm AND en.codic2 = sm.cdlinm AND en.tpdato = 'des_en'
      LEFT JOIN Go2B\Models\B2bAddinf es ON es.tabell = 'sermod' AND es.codic1 = sm.cdserm AND es.codic2 = sm.cdlinm AND es.tpdato = 'des_es'
      LEFT JOIN Go2B\Models\B2bAddinf fr ON fr.tabell = 'sermod' AND fr.codic1 = sm.cdserm AND fr.codic2 = sm.cdlinm AND fr.tpdato = 'des_fr'
      LEFT JOIN Go2B\Models\B2bAddinf de ON de.tabell = 'sermod' AND de.codic1 = sm.cdserm AND de.codic2 = sm.cdlinm AND de.tpdato = 'des_de'
      ORDER BY lm.dslinm, sm.dsserm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getSeriesFromCatalog($cdcata) {
    $query = 'SELECT sm.cdlinm, lm.dslinm, sm.cdserm, sm.dsserm, tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = sm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      WHERE ca.cdcata = :cdcata:
      GROUP BY tl.cdtitl, lm.cdlinm, sm.cdserm
      ORDER BY tl.dstitl, lm.dslinm, sm.dsserm';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getSeriesFilteredByGenreAndLineFromCatalog($cdcata, $tpgene, $cdlinm) {
    $params = array('cdcata' => $cdcata, 'tpgene' => $tpgene, 'cdlinm' => $cdlinm);
    $query = 'SELECT sm.cdlinm, lm.dslinm, sm.cdserm, sm.dsserm, tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = sm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      WHERE ca.cdcata = :cdcata: AND tp.tpgene = :tpgene: AND sm.cdlinm = :cdlinm:
      GROUP BY tl.dstitl, lm.dslinm, sm.dsserm';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getSeriesFilteredByModelTypeAndLineFromCatalog($cdcata, $tpmode, $cdlinm) {
    $params = array('cdcata' => $cdcata, 'tpmode' => $tpmode, 'cdlinm' => $cdlinm);
    $query = 'SELECT sm.cdlinm, lm.dslinm, sm.cdserm, sm.dsserm, tl.cdtitl, tl.dstitl
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = sm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata: AND tp.tpmode = :tpmode: AND sm.cdlinm = :cdlinm:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,"2000-01-01") <= CURRENT_DATE() AND IFNULL(ba.dtfine,"2200-01-01") >= CURRENT_DATE()
      GROUP BY tl.dstitl, lm.dslinm, sm.dsserm';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getAllSeriesFromLine($cdcata, $cdlinm) {
    $query = "SELECT sm.cdlinm, sm.cdserm, sm.dsserm
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = sm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata: AND tp.cdlinm = :cdlinm:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY sm.cdserm, sm.cdlinm
      ORDER BY sm.seqrap, sm.dsserm, sm.cdserm, lm.dslinm, sm.cdlinm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata, 'cdlinm' => $cdlinm));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getSeriesWithDiscountFromCatalogs($whereCatalogs, $params) {
    $query = "SELECT DISTINCT sm.cdlinm, lm.dslinm, sm.cdserm, sm.dsserm, COALESCE(cb.sconto,0) AS sconto
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      INNER JOIN Go2B\Models\Linmod lm ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bDisbdy cb ON cb.cdlinm = sm.cdlinm AND cb.cdserm = sm.cdserm AND cb.cdserm != '' AND cb.numdis = :numdis:
      WHERE ca.cdcata IN ($whereCatalogs)";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getSeriesFromCatalogAndLineWithConditions($cdcata, $cdlinm, $idlang = 'IT') {
    $params = array('cdcata' => $cdcata, 'cdlinm' => $cdlinm, 'tpdato' => 'des_' . strtolower($idlang));
    $ljoin  = "LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'sermod' AND ai.codic1 = sm.cdserm AND ai.codic2 = sm.cdlinm AND ai.tpdato = :tpdato: ";

    if ($idlang != 'IT') {
      $dsserm = 'COALESCE(ai.valore,d1.descri,sm.dsserm)';
      $ljoin .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsserm' AND d1.codic1 = sm.dsserm AND d1.idlang = :idlang: ";
      $params['idlang'] = $idlang;
    } else {
      $dsserm = 'COALESCE(ai.valore,sm.dsserm)';
    }

    $query = "SELECT sm.cdlinm, sm.cdserm, $dsserm AS dsserm, sm.seqrap, sm.flimag
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Tipolo tp ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $ljoin
      WHERE ca.cdcata = :cdcata: AND tp.cdlinm = :cdlinm:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY dsserm
      ORDER BY sm.seqrap, dsserm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getAllSeriesWithBanner() {
    $query = "SELECT sm.cdlinm AS code1, sm.cdserm AS code2, CONCAT(lm.dslinm, ' - ', sm.dsserm) AS description, COALESCE(ai.valore,'') AS banner
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = sm.cdlinm
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'sermod' AND ai.codic1 = sm.cdlinm AND ai.codic2 = sm.cdserm AND ai.tpdato = 'banner'
      ORDER BY lm.dslinm, sm.dsserm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Sermod objects
   */
  public static function getAllSeriesForPromo($cdprom) {
    if (!empty($cdprom)) {
      $presPvcorp = 'COALESCE((SELECT COUNT(c.cdserm) FROM Go2B\Models\Pvcorp c WHERE c.cdlinm = s.cdlinm AND c.cdserm = s.cdserm AND c.cdprom = :cdprom:), 0) AS presPvcorp';
      $presPvgrup = 'COALESCE((SELECT COUNT(g.cdserm) FROM Go2B\Models\Pvgrup g WHERE g.cdlinm = s.cdlinm AND g.cdserm = s.cdserm AND g.cdprom = :cdprom:), 0) AS presPvgrup';
      $params = array('cdprom' => $cdprom);
    } else {
      $presPvcorp = '0 AS presPvcorp';
      $presPvgrup = '0 AS presPvgrup';
      $params = array();
    }
    $query = "SELECT s.cdserm, s.dsserm, l.cdlinm, l.dslinm, $presPvcorp, $presPvgrup
      FROM Go2B\Models\Sermod s
      INNER JOIN Go2B\Models\Linmod l ON l.cdlinm = s.cdlinm
      ORDER BY s.cdlinm, s.cdserm";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return   string
   */
  public static function getFullDescriptionSeries($cdlinm, $cdserm) {
    $query = "SELECT CONCAT(tl.dstitl, ' - ', lm.dslinm, ' - ', sm.dsserm) AS description
      FROM Go2B\Models\Sermod sm
      INNER JOIN Go2B\Models\Linmod lm ON sm.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      WHERE sm.cdlinm = :cdlinm: AND sm.cdserm = :cdserm:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlinm' => $cdlinm, 'cdserm' => $cdserm));
    return count($result) == 1 ? $result[0]->description : '';
  }
  
  /**
   * Query:   SELECT
   * Return   string
   */
  public static function getFirstCdlinmFromCdserm($cdserm) {
    $query = "SELECT sm.cdlinm AS codlin
      FROM Go2B\Models\Sermod sm
      WHERE sm.cdserm = :cdserm: 
      ORDER BY sm.cdlinm 
      LIMIT 1";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdserm' => $cdserm));
    return count($result) > 0 ? $result[0]->codlin : '';
  }
  //endregion
}
