<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Mvc\Model;

class Sctest extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $nuscon;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsscon;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpapps;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('sctest');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'nuscon' => isset($rec->nuscon) && (string)$rec->nuscon !== '' ? (string)$rec->nuscon : 0,
      'dsscon' => isset($rec->dsscon) && (string)$rec->dsscon !== '' ? (string)$rec->dsscon : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'tpapps' => isset($rec->tpapps) && (string)$rec->tpapps !== '' ? (string)$rec->tpapps : new RawValue('""')
    );

    $query  = 'nuscon = :nuscon:';
    $params = array(
      'nuscon' => $values['nuscon']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
