<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Scmcon extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdcata;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdlinm;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdserm;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmini;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmaxi;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $dtmcli;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsscad;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('scmcon');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdcata' => isset($rec->cdcata) && (string)$rec->cdcata !== '' ? (string)$rec->cdcata : new RawValue('""'),
      'cdlinm' => isset($rec->cdlinm) && (string)$rec->cdlinm !== '' ? (string)$rec->cdlinm : new RawValue('""'),
      'cdserm' => isset($rec->cdserm) && (string)$rec->cdserm !== '' ? (string)$rec->cdserm : new RawValue('""'),
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? (string)$rec->cdartn : new RawValue('""'),
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'dtmini' => isset($rec->dtmini) && (string)$rec->dtmini !== '' ? (string)$rec->dtmini : '0000-00-00',
      'dtmaxi' => isset($rec->dtmaxi) && (string)$rec->dtmaxi !== '' ? (string)$rec->dtmaxi : '0000-00-00',
      'dtmcli' => isset($rec->dtmcli) && (string)$rec->dtmcli !== '' ? (string)$rec->dtmcli : '0000-00-00',
      'dsscad' => isset($rec->dsscad) && (string)$rec->dsscad !== '' ? (string)$rec->dsscad : new RawValue('""'),
    );

    $query  = 'cdcata = :cdcata: AND cdlinm = :cdlinm: AND cdserm = :cdserm: AND cdartn = :cdartn: AND cdarti = :cdarti:';
    $params = array(
      'cdcata' => $values['cdcata'],
      'cdlinm' => $values['cdlinm'],
      'cdserm' => $values['cdserm'],
      'cdartn' => $values['cdartn'],
      'cdarti' => $values['cdarti']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Scacon objects
   */
  public static function getDatesFromCatalog($cdcata) {
    $query = "SELECT s.cdcata, s.cdlinm, s.cdserm, s.cdartn, s.cdarti, s.seqrap, s.dsscad,
      s.dtmini AS raw_dtmini, DATE_FORMAT(s.dtmini, '%d/%m/%Y') AS dtmini,
      s.dtmaxi AS raw_dtmaxi, DATE_FORMAT(s.dtmaxi, '%d/%m/%Y') AS dtmaxi,
      s.dtmcli AS raw_dtmcli, DATE_FORMAT(s.dtmcli, '%d/%m/%Y') AS dtmcli,
      COALESCE(lm.dslinm,'') AS dslinm, COALESCE(sm.dsserm,'') AS dsserm,
      COALESCE(tp.dsartn,'') AS dsartn, COALESCE(aa.dsarti,'') AS dsarti
      FROM Go2B\Models\Scmcon s
      LEFT JOIN Go2B\Models\Linmod lm ON s.cdlinm = lm.cdlinm
      LEFT JOIN Go2B\Models\Sermod sm ON s.cdlinm = lm.cdlinm AND s.cdserm = sm.cdserm
      LEFT JOIN Go2B\Models\Tipolo tp ON s.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\Anaart aa ON s.cdarti = aa.cdarti
      WHERE s.cdcata = :cdcata:
      ORDER BY s.seqrap";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }
  
  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getMaxSeqrap($cdcata) {
    $query = "SELECT COALESCE(MAX(s.seqrap), 0) AS seqrap
      FROM Go2B\Models\Scmcon s
      WHERE s.cdcata = :cdcata:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
    return $result[0]->seqrap;
  }
  
  /**
   * Query:   SELECT
   * Return:  Array of Scmcon objects
   */
  public static function getPeriodsForCatArti($cdcata, $cdarti) {
    $periods = self::find(
      array('cdcata = :cdcata: AND cdarti = :cdarti: AND dtmini <= :dtoggi: AND dtmaxi >= :dtoggi:',
            'bind' => array('cdcata' => $cdcata, 'cdarti' => $cdarti, 'dtoggi' => date('Y-m-d'))));
    return count($periods) > 0 ? $periods : array();
  }
  
  /**
   * Query:   SELECT
   * Return:  Array of Scmcon objects
   * (TODO) can add prices, models, etc.,
   */
  public static function getSubtotalsForOrderPdf($nuordc){
    $params = array('nuordc' => $nuordc);
    $query = "
      SELECT
        sc.dsscad,
        SUM( oc.quanti ) AS quantity
      FROM
        Go2B\Models\Scmcon sc
        LEFT JOIN Go2B\Models\Occorp oc ON sc.cdarti = oc.cdarti 
        AND sc.cdcata = oc.cdcata 
        AND sc.dtmcli = oc.dtmcli 
      WHERE
        oc.nuordc = :nuordc: 
      GROUP BY
        sc.dsscad";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertExpiration($cdcata, $cdlinm, $cdserm, $cdartn, $cdarti, $seqrap, $dtmini, $dtmaxi, $dtmcli, $dsscad) {
    $params = array('cdcata' => $cdcata, 'cdlinm' => $cdlinm, 'cdserm' => $cdserm,
      'cdartn' => $cdartn, 'cdarti' => $cdarti, 'seqrap' => $seqrap, 'dtmini' => $dtmini,
      'dtmaxi' => $dtmaxi, 'dtmcli' => $dtmcli, 'dsscad' => $dsscad);
    $query = "INSERT INTO Go2B\Models\Scmcon (cdcata, cdlinm, cdserm, cdartn, cdarti, seqrap,
      dtmini, dtmaxi, dtmcli, dsscad)
      VALUES (:cdcata:, :cdlinm:, :cdserm:, :cdartn:, :cdarti, :seqrap:, :dtmini:,
      :dtmaxi:, :dtmcli:, :dsscad:)";
    Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateExpiration($cdcata, $cdlinm, $cdserm, $cdartn, $cdarti, $seqrap, $dtmini, $dtmaxi, $dtmcli, $dsscad) {
    $params = array('cdcata' => $cdcata, 'cdlinm' => $cdlinm, 'cdserm' => $cdserm,
      'cdartn' => $cdartn, 'cdarti' => $cdarti, 'seqrap' => $seqrap, 'dtmini' => $dtmini,
      'dtmaxi' => $dtmaxi, 'dtmcli' => $dtmcli, 'dsscad' => $dsscad);
    $query = "UPDATE Go2B\Models\Scmcon s SET s.dtmini = :dtmini:, s.dtmaxi = :dtmaxi:,
      s.dtmcli = :dtmcli:, s.dsscad = :dsscad:
      WHERE s.cdcata = :cdcata: AND s.cdlinm = :cdlinm: AND s.cdserm = :cdserm:
      AND s.cdartn = :cdartn: AND s.cdarti = :cdarti: AND s.seqrap = :seqrap:";
    Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteSpecialExpiration($cdcata, $cdlinm, $cdserm, $cdartn, $cdarti, $seqrap) {
    $params = array('cdcata' => $cdcata, 'cdlinm' => $cdlinm, 'cdserm' => $cdserm, 'cdartn' => $cdartn, 'cdarti' => $cdarti, 'seqrap' => $seqrap);
    $query = "DELETE s.*
      FROM scmcon s
      WHERE s.cdcata = :cdcata AND s.cdlinm = :cdlinm AND s.cdserm = :cdserm
      AND s.cdartn = :cdartn AND s.cdarti = :cdarti AND s.seqrap = :seqrap";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE scmcon";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
